<?php

	class anniversaryModel extends anniversary {
	
		function init(){
		}
		
		
		function getTodayAnniversary($module_srl){
			$args = new stdClass();
			$args->nowdate = date('Ymd');
			$args->nowdate_y = substr($args->nowdate, 4);
			$args->nowdate_m = substr($args->nowdate, 6);
			$args->target_modules = ','.$module_srl.',';
			
			return executeQueryArray('anniversary.getTodayAnniversary', $args);
		}
		
		function checkTodayGivepointHistory($anniversary_srl, $member_srl){
			$args = new stdClass();
			$args->anniversary_srl = $anniversary_srl;
			$args->member_srl = $member_srl;
			$args->givedate = date('Ymd');
			
			return executeQuery('anniversary.checkTodayGivepointHistory', $args);
		}
		
		function checkGivepointHistory($anniversary_srl, $member_srl){
			$args = new stdClass();
			$args->anniversary_srl = $anniversary_srl;
			$args->member_srl = $member_srl;
			
			return executeQuery('anniversary.checkGivepointHistory', $args);
		}
		
		function formatDate($date){
			global $lang;
			
			$date = $this->splitDate($date);
			
			$output = $date['day'].$lang->unit_day;
			if($date['month'] != 0) $output = $date['month'].$lang->unit_month.' '.$output;
			if($date['year'] != 0) $output = $date['year'].$lang->unit_year.' '.$output;
			
			return $output;
		}
		
		function getStatus($enable, $repeat, $start, $end){
			if($enable != 'Y') return 'N';
			
			$nowdate = '';
			switch($repeat){
				case 'N': $nowdate .= date('Y'); // Ymd
				case 'Y': $nowdate .= date('m'); // md
				case 'M': $nowdate .= date('d'); // d
			}
			
			if($start <= $nowdate && $nowdate <= $end) return 'A';
			
			return 'W';
		}
		
		function splitDate($date){
			$date = sprintf("%08s", (string) $date);
			$len = strlen($date);
			
			$output = array();
			$output['year'] = (int) substr($date, $len-8, 4);
			$output['month'] = (int) substr($date, $len-4, 2);
			$output['day'] = (int) substr($date, $len-2);
			
			return $output;
		}
	}