<?php

	class anniversaryController extends anniversary {
		private $today_anniversary;
		
		function init(){
		}
		
		function triggerAfterModuleHandlerProc(&$oModule){
			// 기념일 모듈 사용 안함
			if($this->config->use_anniversary == 'N') return;
			
			// 관리페이지 제외
			if(strpos($oModule->act, 'Admin') != false) return;
			if(strtolower($oModule->module) == 'admin') return;
			
			// HTML 모드에서만
			if(Context::getResponseMethod() != 'HTML') return;
			
			// 팝업창
			if($oModule->getLayoutFile() == 'popup_layout.html' || $oModule->getLayoutFile() == 'default_layout.html') return;
			
			$logged_info = Context::get('logged_info');
			
			$oPointController = &getController('point');
			$oAnniversaryModel = &getModel('anniversary');
			
			$output = $oAnniversaryModel->getTodayAnniversary($oModule->module_info->module_srl);
			if(!$output->toBool()){
				$this->errorLog($output);
				return;
			}
			
			$this->today_anniversary = $output->data;
			
			// CSS, JS 직접 입력한 내용 추가
			$text_css = '';
			$text_js = '';
			foreach($this->today_anniversary as $anniv){
				$text_css .= $anniv->text_css;
				$text_js .= $anniv->text_js;
				Context::addHtmlFooter($anniv->text_html);
			}
			
			$text_css = '<style type="text/css">'.$text_css.'</style>';
			$text_js = '<script type="text/javascript">'.$text_js.'</script>';
			if($text_css != '') Context::addHtmlHeader($text_css);
			if($text_js != '') Context::addHtmlHeader($text_js);
			
			/*
				기념일에 맞게 레이아웃 변경
			*/
			foreach($this->today_anniversary as $anniv){
				if($anniv->layout_change != 0){
					$oModule->module_info->layout_srl = $anniv->layout_change;
					break;
				}
			}
			
			/*
				기념일에 맞게 포인트 지급
			*/
			
			// 로그인은 필수
			if($logged_info && $logged_info->member_srl){
				$member_srl = $logged_info->member_srl;
				
				foreach($this->today_anniversary as $anniv){
					// 접속 포인트가 0이면 패스
					if($anniv->give_point == 0){
						continue;
					}
					
					$output = $oAnniversaryModel->checkGivepointHistory($anniv->anniversary_srl, $member_srl);
					if(!$output->toBool()){
						// 오류기록 + 패스
						$this->errorLog($output);
						continue;
					}
					$total = $output->data->count;
					
					$output = $oAnniversaryModel->checkTodayGivepointHistory($anniv->anniversary_srl, $member_srl);
					if(!$output->toBool()){
						// 오류기록 + 패스
						$this->errorLog($output);
						continue;
					}
					$today = $output->data->count;
					
					if(
						// 이미 받은 경우 패스
						$today >= 1 ||
						
						// 중복 수령 불가 + 한번이라도 받은 경우 패스
						$anniv->give_point_again != 'Y' && $total >= 1
					){
						continue;
					}
					
					else {
						// 포인트 지급 및 기록
						$args = new stdClass();
						$args->anniversary_srl = $anniv->anniversary_srl;
						$args->member_srl = $member_srl;
						$args->givedate = date('Ymd');
						
						$output = executeQuery('anniversary.insertGivepointHistory', $args);
						if(!$output->toBool()){
							// 오류기록 + 패스
							$this->errorLog($output);
							continue;
						}
						
						// 포인트 지급
						$oPointController->setPoint($member_srl, $anniv->give_point, 'add');
					}
				}
			}
		}
	}