<?php
	class anniversaryAdminView extends anniversary {
		function init(){
			Context::set('config', $this->config);
			
			$this->setTemplatePath($this->module_path.'tpl');
		}
		
		function dispAnniversaryAdminConfig(){
			$this->setTemplateFile('config');
		}
		
		function dispAnniversaryAdminAnniversaryList(){
			$search_keyword = Context::get('search_keyword');
			$page = Context::get('page');
			
			$oAnniversaryAdminModel = &getAdminModel('anniversary');
			$output = $oAnniversaryAdminModel->getAnniversaryList($page, $search_keyword);
			if(!$output->toBool()){
				$this->errorLog($output);
				return $output;
			}
			
			//Context::set('search_keyword', $search_keyword);
			Context::set('total_count', $output->total_count);
			Context::set('total_page', $output->total_page);
			Context::set('page', $output->page);
			Context::set('anniversary_list', $output->data);
			Context::set('page_navigation', $output->page_navigation);
			
			$this->setTemplateFile('list');
		}
		
		function dispAnniversaryAdminAnniversaryInsert(){
			$oAnniversaryAdminModel = &getAdminModel('anniversary');
			$anniversary_srl = Context::get('anniversary_srl');
			
			if($anniversary_srl){
				$output = $oAnniversaryAdminModel->getAnniversaryBySrl($anniversary_srl);
				
				if(!$output->toBool()){
					$this->errorLog($output);
					return $output;
				}
				
				Context::set('anniversary', $output->data);
			}
			
			// 레이아웃 목록
			$oLayoutModel = &getModel('layout');
			$layout_list = $oLayoutModel->getLayoutList();
			Context::set('layout_list', $layout_list);
			
			// 모듈 목록
			$oModuleModel = &getModel('module');
			$mid_list = $oModuleModel->getMidList(null, array('module_srl', 'mid', 'browser_title', 'module'));
			Context::set('mid_list', $mid_list);
			
			$this->setTemplateFile('insert');
		}
		
		function dispAnniversaryAdminAnniversaryCopy(){
			$oAnniversaryAdminModel = &getAdminModel('anniversary');
			$anniversary_srl = Context::get('anniversary_srl');
			
			$output = $oAnniversaryAdminModel->getAnniversaryBySrl($anniversary_srl);
			
			if(!$output->toBool()){
				$this->errorLog($output);
				return $output;
			}
			
			Context::set('anniversary', $output->data);
			
			$this->setTemplateFile('copy');
		}
		
		function dispAnniversaryAdminAnniversaryDelete(){
			$oAnniversaryAdminModel = &getAdminModel('anniversary');
			$anniversary_srl = Context::get('anniversary_srl');
			
			$output = $oAnniversaryAdminModel->getAnniversaryBySrl($anniversary_srl);
			
			if(!$output->toBool()){
				$this->errorLog($output);
				return $output;
			}
			
			Context::set('anniversary', $output->data);
			
			$this->setTemplateFile('delete');
		}
	}