<?php

	class anniversary extends ModuleObject {
		private $triggers = array(
			array('moduleHandler.proc', 'anniversary', 'controller', 'triggerAfterModuleHandlerProc', 'after'),
		);
		
		protected $config;
		
		function anniversary(){
			$oModuleModel = getModel('module');
			$this->config = $oModuleModel->getModuleConfig('anniversary');
		}
		
		function moduleInstall(){
			return new Object();
		}

		function checkUpdate(){
			$oModuleModel = &getModel('module');
			$oDB = &DB::getInstance();

			foreach($this->triggers as $trigger){
				if(!$oModuleModel->getTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4])) return true;
			}

			return false;
		}

		function moduleUpdate(){
			$oModuleModel = &getModel('module');
			$oModuleController = &getController('module');
			$oDB = &DB::getInstance();

			foreach($this->triggers as $trigger){
				if(!$oModuleModel->getTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4])){
					$oModuleController->insertTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4]);
				}
			}

			return new Object(0, 'success_updated');
		}

		function recompileCache(){
			return new Object();
		}

		function moduleUninstall(){
			$oModuleController = &getController('module');

			foreach($this->triggers as $trigger){
				$oModuleController->deleteTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4]);
			}
			return new Object();
		}
		
		
		// 에러 로그 찍기 (Based on debugPrint in XE)
		function errorLog($debug_output){
			$path = $this->module_path.'/log/error_log.txt';
			$bt = debug_backtrace();
			
			$bt_debug_print = array_shift($bt);
			$bt_called_function = array_shift($bt);

			$type = gettype($debug_output);			
			$file_name = str_replace(_XE_PATH_, '', $bt_debug_print['file']);
			$line_num = $bt_debug_print['line'];
			$function = $bt_called_function['class'] . $bt_called_function['type'] . $bt_called_function['function'];

			$print = array();
			$print[] = sprintf("[%s %s:%d] %s()", date('Y-m-d H:i:s'), $file_name, $line_num, $function);

			if( !in_array($type, array('array', 'object', 'resource')) ){
				$print[] = $type.'('.var_export($debug_output, TRUE).')';
				$print[] = PHP_EOL.PHP_EOL;
			}
			else {
				$print[] = print_r($debug_output, TRUE);
				$print[] = PHP_EOL;
			}

			@file_put_contents($path, implode(PHP_EOL, $print), FILE_APPEND|LOCK_EX);
		}
	}