<?php
	class anniversaryAdminController extends anniversary {
		
		function init(){
		}
		
		/*
			기념일 모듈 설정
		*/
		function procAnniversaryAdminConfig(){
			$config = new stdClass();
			
			// 기념일 모듈 사용 (Y/N)
			$config->use_anniversary = Context::get('use_anniversary');
			
			// 설정 저장
			$oModuleController = &getController('module');
			$oModuleController->updateModuleConfig('anniversary', $config);
			
			// 성공 메세지
			$this->setMessage('success_updated');
			
			// Redirect
			$returnUrl = Context::get('success_return_url') ? Context::get('success_return_url') : getNotEncodedUrl('', 'module', 'admin', 'act', 'dispAnniversaryAdminConfig');
			$this->setRedirectUrl($returnUrl);
		}
		
		/*
			기념일 수정/등록 처리
		*/
		function procAnniversaryAdminAnniversaryInsert(){
			$args = new stdClass();
			
			// [기본 설정] 기념일 사용 (Y/N)
			$args->enable = Context::get('enable');
			
			// [기본 설정] 기념일 이름
			$args->anniversary_name = Context::get('anniversary_name');
			
			// [대상 모듈 설정] 작동 방식
			$args->target_modules_type = Context::get('target_modules_type');
			
			// [대상 모듈 설정] 대상 모듈
			$args->target_modules = Context::get('target_modules');
			if(!$args->target_modules || !is_array($args->target_modules)){
				$args->target_modules = array();
			}
			$args->target_modules = ','.implode(',', $args->target_modules).',';
			
			// [날짜 설정] 기념일 반복
			$args->repeat = Context::get('repeat');
			
			// [날짜 설정] 기념일 시작/종료일
			$args->startdate = '';
			$args->enddate = '';
			switch($args->repeat){
				case 'N':
					$args->startdate = sprintf("%04s", Context::get('startdate_year'));
					$args->enddate = sprintf("%04s", Context::get('enddate_year'));
				case 'Y':
					$args->startdate .= sprintf("%02s", Context::get('startdate_month'));
					$args->enddate .= sprintf("%02s", Context::get('enddate_month'));
				case 'M':
					$args->startdate .= sprintf("%02s", Context::get('startdate_day'));
					$args->enddate .= sprintf("%02s", Context::get('enddate_day'));
			}
			if($args->startdate > $args->enddate){
				return new Object(-1, 'msg_startdate_must_less_than_enddate');
			}
			
			// [디자인 설정] 레이아웃 변경
			$args->layout_change = Context::get('layout_change');
			
			// [디자인 설정] 자바스크립트, CSS 불러오기
			$args->file_load = Context::get('file_load');
			if(!$args->file_load) $args->file_load = '';
			
			// [디자인 설정] CSS 직접 입력
			$args->text_css = Context::get('text_css');
			if(!$args->text_css) $args->text_css = '';
			
			// [디자인 설정] 자바스크립트 직접 입력
			$args->text_js = Context::get('text_js');
			if(!$args->text_js) $args->text_js = '';
			
			// [디자인 설정] HTML 직접 입력
			$args->text_html = Context::get('text_html');
			if(!$args->text_html) $args->text_html = '';
			
			// [포인트 설정] 포인트 부여
			$args->give_point = Context::get('give_point');
			
			// [포인트 설정] 중복 수령
			$args->give_point_again = Context::get('give_point_again');
			
			// [포인트 설정] 중복 수령 최대치
			$args->give_point_again_max = Context::get('give_point_again_max');
			if($args->give_point_again_max < 0){
				$args->give_point_again_max = 0;
			}
			
			// 기념일Srl이 있는 경우 수정으로 처리
			$anniversary_srl = Context::get('anniversary_srl');
			
			if($anniversary_srl){
				$args->anniversary_srl = $anniversary_srl;
				$queryID = 'anniversary.updateAnniversary';
			}
			else {
				$queryID = 'anniversary.insertAnniversary';
			}
			
			// DB처리 실행
			$output = executeQuery($queryID, $args);
			if(!$output->toBool()){
				// 오류 기록
				$this->errorLog($output);
				//return $output;
			}
			
			// 성공 메세지
			if($anniversary_srl){
				$this->setMessage('success_updated');
			}
			else {
				$this->setMessage('success_registed');
			}
			
			// Redirect
			$returnUrl = Context::get('success_return_url') ? Context::get('success_return_url') : getNotEncodedUrl('', 'module', 'admin', 'act', 'dispAnniversaryAdminAnniversaryList');
			$this->setRedirectUrl($returnUrl);
		}
		
		/*
			기념일 복사 처리
		*/
		function procAnniversaryAdminAnniversaryCopy(){
			$args = new stdClass();
			$args->anniversary_srl = Context::get('anniversary_srl');
			
			// DB처리 실행
			$output = executeQuery('anniversary.getAnniversaryBySrl', $args);
			if(!$output->toBool()){
				// 오류 기록
				$this->errorLog($output);
				return $output;
			}
			
			$anniv = $output->data;
			
			$args = new stdClass();
			
			// [기본 설정] 기념일 사용 (Y/N)
			$args->enable = Context::get('enable');
			
			// [기본 설정] 기념일 이름
			$args->anniversary_name = Context::get('anniversary_name');
			
			// 요놈들은 동일하게 설정
			$args->target_modules_type = $anniv->target_modules_type;
			$args->target_modules = $anniv->target_modules;
			
			// [날짜 설정] 기념일 반복
			$args->repeat = Context::get('repeat');
			
			// [날짜 설정] 기념일 시작/종료일
			$args->startdate = '';
			$args->enddate = '';
			switch($args->repeat){
				case 'N':
					$args->startdate = sprintf("%04s", Context::get('startdate_year'));
					$args->enddate = sprintf("%04s", Context::get('enddate_year'));
				case 'Y':
					$args->startdate .= sprintf("%02s", Context::get('startdate_month'));
					$args->enddate .= sprintf("%02s", Context::get('enddate_month'));
				case 'M':
					$args->startdate .= sprintf("%02s", Context::get('startdate_day'));
					$args->enddate .= sprintf("%02s", Context::get('enddate_day'));
			}
			
			if($args->startdate > $args->enddate){
				return new Object(-1, 'msg_startdate_must_less_than_enddate');
			}
			
			// 나머진 동일하게 설정
			$args->layout_change = $anniv->layout_change;
			$args->file_load = $anniv->file_load;
			$args->text_css = $anniv->text_css;
			$args->text_js = $anniv->text_js;
			$args->text_html = $anniv->text_html;
			$args->give_point = $anniv->give_point;
			$args->give_point_again = $anniv->give_point_again;
			$args->give_point_again_max = $anniv->give_point_again_max;
			
			// DB처리 실행
			$output = executeQuery('anniversary.insertAnniversary', $args);
			if(!$output->toBool()){
				$this->errorLog($output);
				return $output;
			}
			
			$this->setMessage('success_registed');
			
			// Redirect
			$returnUrl = Context::get('success_return_url') ? Context::get('success_return_url') : getNotEncodedUrl('', 'module', 'admin', 'act', 'dispAnniversaryAdminAnniversaryList');
			$this->setRedirectUrl($returnUrl);
		}
		
		/*
			기념일 삭제 처리
		*/
		function procAnniversaryAdminAnniversaryDelete(){
			$args = new stdClass();
			$args->anniversary_srl = Context::get('anniversary_srl');
			
			// DB처리 실행
			$output = executeQuery('anniversary.deleteAnniversaryBySrl', $args);
			if(!$output->toBool()){
				// 오류 기록
				$this->errorLog($output);
				return $output;
			}
			
			// 성공 메세지
			$this->setMessage('success_deleted');
			
			// Redirect
			$returnUrl = Context::get('success_return_url') ? Context::get('success_return_url') : getNotEncodedUrl('', 'module', 'admin', 'act', 'dispAnniversaryAdminAnniversaryList');
			$this->setRedirectUrl($returnUrl);
		}
	}