function Animator(a){this.setOptions(a);var b=this;this.timerDelegate=function(){b.onTimerEvent()};this.subjects=[];this.subjectScopes=[];this.target=0;this.state=0;this.lastTime=null}Animator.prototype={setOptions:function(a){this.options=Animator.applyDefaults({interval:20,duration:400,onComplete:function(){},onStep:function(){},transition:Animator.tx.easeInOut},a)},seekTo:function(a){this.seekFromTo(this.state,a)},seekFromTo:function(b,a){this.target=Math.max(0,Math.min(1,a));this.state=Math.max(0,Math.min(1,b));this.lastTime=new Date().getTime();if(!this.intervalId){this.intervalId=window.setInterval(this.timerDelegate,this.options.interval)}},jumpTo:function(a){this.target=this.state=Math.max(0,Math.min(1,a));this.propagate()},toggle:function(){this.seekTo(1-this.target)},addSubject:function(a,b){this.subjects[this.subjects.length]=a;this.subjectScopes[this.subjectScopes.length]=b;return this},clearSubjects:function(){this.subjects=[];this.subjectScopes=[]},propagate:function(){var b=this.options.transition(this.state);for(var a=0;a<this.subjects.length;a++){if(this.subjects[a].setState){this.subjects[a].setState(b)}else{this.subjects[a].apply(this.subjectScopes[a],[b])}}},onTimerEvent:function(){var c=new Date().getTime();var a=c-this.lastTime;this.lastTime=c;var b=(a/this.options.duration)*(this.state<this.target?1:-1);if(Math.abs(b)>=Math.abs(this.state-this.target)){this.state=this.target}else{this.state+=b}try{this.propagate()}finally{this.options.onStep.call(this);if(this.target==this.state){window.clearInterval(this.intervalId);this.intervalId=null;this.options.onComplete.call(this)}}},play:function(){this.seekFromTo(0,1)},reverse:function(){this.seekFromTo(1,0)},inspect:function(){var b="#<Animator:\n";for(var a=0;a<this.subjects.length;a++){b+=this.subjects[a].inspect()}b+=">";return b}};Animator.applyDefaults=function(c,b){b=b||{};var d,a={};for(d in c){a[d]=b[d]!==undefined?b[d]:c[d]}return a};Animator.makeArray=function(c){if(c==null){return[]}if(!c.length){return[c]}var a=[];for(var b=0;b<c.length;b++){a[b]=c[b]}return a};Animator.camelize=function(c){var e=c.split("-");if(e.length==1){return e[0]}var b=c.indexOf("-")==0?e[0].charAt(0).toUpperCase()+e[0].substring(1):e[0];for(var d=1,a=e.length;d<a;d++){var f=e[d];b+=f.charAt(0).toUpperCase()+f.substring(1)}return b};Animator.apply=function(c,b,a){if(b instanceof Array){return new Animator(a).addSubject(new CSSStyleSubject(c,b[0],b[1]))}return new Animator(a).addSubject(new CSSStyleSubject(c,b))};Animator.makeEaseIn=function(b){return function(a){return Math.pow(a,b*2)}};Animator.makeEaseOut=function(b){return function(a){return 1-Math.pow(1-a,b*2)}};Animator.makeElastic=function(a){return function(b){b=Animator.tx.easeInOut(b);return((1-Math.cos(b*Math.PI*a))*(1-b))+b}};Animator.makeADSR=function(d,b,c,a){if(a==null){a=0.5}return function(e){if(e<d){return e/d}if(e<b){return 1-((e-d)/(b-d)*(1-a))}if(e<c){return a}return a*(1-((e-c)/(1-c)))}};Animator.makeBounce=function(a){var b=Animator.makeElastic(a);return function(c){c=b(c);return c<=1?c:2-c}};Animator.tx={easeInOut:function(a){return((-Math.cos(a*Math.PI)/2)+0.5)},linear:function(a){return a},easeIn:Animator.makeEaseIn(1.5),easeOut:Animator.makeEaseOut(1.5),strongEaseIn:Animator.makeEaseIn(2.5),strongEaseOut:Animator.makeEaseOut(2.5),elastic:Animator.makeElastic(1),veryElastic:Animator.makeElastic(3),bouncy:Animator.makeBounce(1),veryBouncy:Animator.makeBounce(3)};function NumericalStyleSubject(b,c,e,d,a){this.els=Animator.makeArray(b);if(c=="opacity"&&window.ActiveXObject){this.property="filter"}else{this.property=Animator.camelize(c)}this.from=parseFloat(e);this.to=parseFloat(d);this.units=a!=null?a:"px"}NumericalStyleSubject.prototype={setState:function(f){var d=this.getStyle(f);var a=(this.property=="opacity"&&f==0)?"hidden":"";var b=0;for(var c=0;c<this.els.length;c++){try{this.els[c].style[this.property]=d}catch(g){if(this.property!="fontWeight"){throw g}}if(b++>20){return}}},getStyle:function(a){a=this.from+((this.to-this.from)*a);if(this.property=="filter"){return"alpha(opacity="+Math.round(a*100)+")"}if(this.property=="opacity"){return a}return Math.round(a)+this.units},inspect:function(){return"\t"+this.property+"("+this.from+this.units+" to "+this.to+this.units+")\n"}};function ColorStyleSubject(a,b,d,c){this.els=Animator.makeArray(a);this.property=Animator.camelize(b);this.to=this.expandColor(c);this.from=this.expandColor(d);this.origFrom=d;this.origTo=c}ColorStyleSubject.prototype={expandColor:function(b){var c,e,d,a;c=ColorStyleSubject.parseColor(b);if(c){e=parseInt(c.slice(1,3),16);d=parseInt(c.slice(3,5),16);a=parseInt(c.slice(5,7),16);return[e,d,a]}if(window.DEBUG){alert("Invalid colour: '"+b+"'")}},getValueForState:function(a,b){return Math.round(this.from[a]+((this.to[a]-this.from[a])*b))},setState:function(c){var a="#"+ColorStyleSubject.toColorPart(this.getValueForState(0,c))+ColorStyleSubject.toColorPart(this.getValueForState(1,c))+ColorStyleSubject.toColorPart(this.getValueForState(2,c));for(var b=0;b<this.els.length;b++){this.els[b].style[this.property]=a}},inspect:function(){return"\t"+this.property+"("+this.origFrom+" to "+this.origTo+")\n"}};ColorStyleSubject.parseColor=function(d){var a="#",c;if(c=ColorStyleSubject.parseColor.rgbRe.exec(d)){var b;for(var e=1;e<=3;e++){b=Math.max(0,Math.min(255,parseInt(c[e])));a+=ColorStyleSubject.toColorPart(b)}return a}if(c=ColorStyleSubject.parseColor.hexRe.exec(d)){if(c[1].length==3){for(var e=0;e<3;e++){a+=c[1].charAt(e)+c[1].charAt(e)}return a}return"#"+c[1]}return false};ColorStyleSubject.toColorPart=function(a){if(a>255){a=255}var b=a.toString(16);if(a<16){return"0"+b}return b};ColorStyleSubject.parseColor.rgbRe=/^rgb\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*\)$/i;ColorStyleSubject.parseColor.hexRe=/^\#([0-9a-fA-F]{3}|[0-9a-fA-F]{6})$/;function DiscreteStyleSubject(b,c,e,d,a){this.els=Animator.makeArray(b);this.property=Animator.camelize(c);this.from=e;this.to=d;this.threshold=a||0.5}DiscreteStyleSubject.prototype={setState:function(c){var a=0;for(var b=0;b<this.els.length;b++){this.els[b].style[this.property]=c<=this.threshold?this.from:this.to}},inspect:function(){return"\t"+this.property+"("+this.from+" to "+this.to+" @ "+this.threshold+")\n"}};function CSSStyleSubject(d,m,j){d=Animator.makeArray(d);this.subjects=[];if(d.length==0){return}var a,n,b;if(j){b=this.parseStyle(m,d[0]);n=this.parseStyle(j,d[0])}else{n=this.parseStyle(m,d[0]);b={};for(a in n){b[a]=CSSStyleSubject.getStyle(d[0],a)}}var a;for(a in b){if(b[a]==n[a]){delete b[a];delete n[a]}}var a,h,e,i,l,k;for(a in b){var g=String(b[a]);var c=String(n[a]);if(n[a]==null){if(window.DEBUG){alert("No to style provided for '"+a+'"')}continue}if(l=ColorStyleSubject.parseColor(g)){k=ColorStyleSubject.parseColor(c);i=ColorStyleSubject}else{if(g.match(CSSStyleSubject.numericalRe)&&c.match(CSSStyleSubject.numericalRe)){l=parseFloat(g);k=parseFloat(c);i=NumericalStyleSubject;e=CSSStyleSubject.numericalRe.exec(g);var f=CSSStyleSubject.numericalRe.exec(c);if(e[1]!=null){h=e[1]}else{if(f[1]!=null){h=f[1]}else{h=f}}}else{if(g.match(CSSStyleSubject.discreteRe)&&c.match(CSSStyleSubject.discreteRe)){l=g;k=c;i=DiscreteStyleSubject;h=0}else{if(window.DEBUG){alert("Unrecognised format for value of "+a+": '"+b[a]+"'")}continue}}}this.subjects[this.subjects.length]=new i(d,a,l,k,h)}}CSSStyleSubject.prototype={parseStyle:function(b,c){var g={};if(b.indexOf(":")!=-1){var j=b.split(";");for(var e=0;e<j.length;e++){var d=CSSStyleSubject.ruleRe.exec(j[e]);if(d){g[d[1]]=d[2]}}}else{var a,h,f;f=c.className;c.className=b;for(var e=0;e<CSSStyleSubject.cssProperties.length;e++){a=CSSStyleSubject.cssProperties[e];h=CSSStyleSubject.getStyle(c,a);if(h!=null){g[a]=h}}c.className=f}return g},setState:function(b){for(var a=0;a<this.subjects.length;a++){this.subjects[a].setState(b)}},inspect:function(){var b="";for(var a=0;a<this.subjects.length;a++){b+=this.subjects[a].inspect()}return b}};CSSStyleSubject.getStyle=function(b,c){var a;if(document.defaultView&&document.defaultView.getComputedStyle){a=document.defaultView.getComputedStyle(b,"").getPropertyValue(c);if(a){return a}}c=Animator.camelize(c);if(b.currentStyle){a=b.currentStyle[c]}return a||b.style[c]};CSSStyleSubject.ruleRe=/^\s*([a-zA-Z\-]+)\s*:\s*(\S(.+\S)?)\s*$/;CSSStyleSubject.numericalRe=/^-?\d+(?:\.\d+)?(%|[a-zA-Z]{2})?$/;CSSStyleSubject.discreteRe=/^\w+$/;CSSStyleSubject.cssProperties=["azimuth","background","background-attachment","background-color","background-image","background-position","background-repeat","border-collapse","border-color","border-spacing","border-style","border-top","border-top-color","border-right-color","border-bottom-color","border-left-color","border-top-style","border-right-style","border-bottom-style","border-left-style","border-top-width","border-right-width","border-bottom-width","border-left-width","border-width","bottom","clear","clip","color","content","cursor","direction","display","elevation","empty-cells","css-float","font","font-family","font-size","font-size-adjust","font-stretch","font-style","font-variant","font-weight","height","left","letter-spacing","line-height","list-style","list-style-image","list-style-position","list-style-type","margin","margin-top","margin-right","margin-bottom","margin-left","max-height","max-width","min-height","min-width","orphans","outline","outline-color","outline-style","outline-width","overflow","padding","padding-top","padding-right","padding-bottom","padding-left","pause","position","right","size","table-layout","text-align","text-decoration","text-indent","text-shadow","text-transform","top","vertical-align","visibility","white-space","width","word-spacing","z-index","opacity","outline-offset","overflow-x","overflow-y"];function AnimatorChain(c,a){this.animators=c;this.setOptions(a);for(var b=0;b<this.animators.length;b++){this.listenTo(this.animators[b])}this.forwards=false;this.current=0}AnimatorChain.prototype={setOptions:function(a){this.options=Animator.applyDefaults({resetOnPlay:true},a)},play:function(){this.forwards=true;this.current=-1;if(this.options.resetOnPlay){for(var a=0;a<this.animators.length;a++){this.animators[a].jumpTo(0)}}this.advance()},reverse:function(){this.forwards=false;this.current=this.animators.length;if(this.options.resetOnPlay){for(var a=0;a<this.animators.length;a++){this.animators[a].jumpTo(1)}}this.advance()},toggle:function(){if(this.forwards){this.seekTo(0)}else{this.seekTo(1)}},listenTo:function(a){var b=a.options.onComplete;var c=this;a.options.onComplete=function(){if(b){b.call(a)}c.advance()}},advance:function(){if(this.forwards){if(this.animators[this.current+1]==null){return}this.current++;this.animators[this.current].play()}else{if(this.animators[this.current-1]==null){return}this.current--;this.animators[this.current].reverse()}},seekTo:function(a){if(a<=0){this.forwards=false;this.animators[this.current].seekTo(0)}else{this.forwards=true;this.animators[this.current].seekTo(1)}}};function Accordion(k){this.setOptions(k);var b=this.options.initialSection,g;if(this.options.rememberance){g=document.location.hash.substring(1)}this.rememberanceTexts=[];this.ans=[];var f=this;for(var c=0;c<this.options.sections.length;c++){var a=this.options.sections[c];var d=new Animator(this.options.animatorOptions);var j=this.options.from+(this.options.shift*c);var h=this.options.to+(this.options.shift*c);d.addSubject(new NumericalStyleSubject(a,this.options.property,j,h,this.options.units));d.jumpTo(0);var e=this.options.getActivator(a);e.index=c;e.onclick=function(){f.show(this.index)};this.ans[this.ans.length]=d;this.rememberanceTexts[c]=e.innerHTML.replace(/\s/g,"");if(this.rememberanceTexts[c]===g){b=c}}this.show(b)}Accordion.prototype={setOptions:function(a){this.options=Object.extend({sections:null,getActivator:function(b){return document.getElementById(b.getAttribute("activator"))},shift:0,initialSection:0,rememberance:true,animatorOptions:{}},a||{})},show:function(b){for(var a=0;a<this.ans.length;a++){this.ans[a].seekTo(a>b?1:0)}if(this.options.rememberance){document.location.hash=this.rememberanceTexts[b]}}};
(function(c,d){if(!c||!c.document){throw new Error("SoundManager requires a browser with window and document objects.")}var b=null;function a(a0,ai){this.setupOptions={url:(a0||null),flashVersion:8,debugMode:true,debugFlash:false,useConsole:true,consoleOnly:true,waitForWindowLoad:false,bgColor:"#ffffff",useHighPerformance:false,flashPollingInterval:null,html5PollingInterval:null,flashLoadTimeout:1000,wmode:null,allowScriptAccess:"always",useFlashBlock:false,useHTML5Audio:true,html5Test:/^(probably|maybe)$/i,preferFlash:false,noSWFCache:false,idPrefix:"sound"};this.defaultOptions={autoLoad:false,autoPlay:false,from:null,loops:1,onid3:null,onload:null,whileloading:null,onplay:null,onpause:null,onresume:null,whileplaying:null,onposition:null,onstop:null,onfailure:null,onfinish:null,multiShot:true,multiShotEvents:false,position:null,pan:0,stream:true,to:null,type:null,usePolicyFile:false,volume:100};this.flash9Options={isMovieStar:null,usePeakData:false,useWaveformData:false,useEQData:false,onbufferchange:null,ondataerror:null};this.movieStarOptions={bufferTime:3,serverURL:null,onconnect:null,duration:null};this.audioFormats={mp3:{type:['audio/mpeg; codecs="mp3"',"audio/mpeg","audio/mp3","audio/MPA","audio/mpa-robust"],required:true},mp4:{related:["aac","m4a","m4b"],type:['audio/mp4; codecs="mp4a.40.2"',"audio/aac","audio/x-m4a","audio/MP4A-LATM","audio/mpeg4-generic"],required:false},ogg:{type:["audio/ogg; codecs=vorbis"],required:false},opus:{type:["audio/ogg; codecs=opus","audio/opus"],required:false},wav:{type:['audio/wav; codecs="1"',"audio/wav","audio/wave","audio/x-wav"],required:false}};this.movieID="sm2-container";this.id=(ai||"sm2movie");this.debugID="soundmanager-debug";this.debugURLParam=/([#?&])debug=1/i;this.versionNumber="V2.97a.20140901";this.version=null;this.movieURL=null;this.altURL=null;this.swfLoaded=false;this.enabled=false;this.oMC=null;this.sounds={};this.soundIDs=[];this.muted=false;this.didFlashBlock=false;this.filePattern=null;this.filePatterns={flash8:/\.mp3(\?.*)?$/i,flash9:/\.mp3(\?.*)?$/i};this.features={buffering:false,peakData:false,waveformData:false,eqData:false,movieStar:false};this.sandbox={type:null,types:{remote:"remote (domain-based) rules",localWithFile:"local with file access (no internet access)",localWithNetwork:"local with network (internet access only, no local access)",localTrusted:"local, trusted (local+internet access)"},description:null,noRemote:null,noLocal:null};this.html5={usingFlash:null};this.flash={};this.html5Only=false;this.ignoreFlash=false;var ak,ao=this,a8=null,ad=null,aX="soundManager",F=aX+": ",a4="HTML5::",an,au=navigator.userAgent,x=c.location.href.toString(),Z=document,T,z,aJ,bh,v=[],bg=true,M,ap=false,aU=false,ax=false,a1=false,bb=false,V,aw=0,w,a2,a6,a3,Y,aR,s,y,bc,ac,aV,t,e,j,aD,L,bj,p,bf,H,aa,l,D,aH=["log","info","warn","error"],X=8,W,r,az,aK=null,aj=null,be,aA,m,E,aC,A,o,ar,I,aQ=false,aI=false,aO,N,ae,K=0,bd=null,ab,aq=[],af,B=null,S,ba,am,aL,g,O,aN,al,R=Array.prototype.slice,aZ=false,k,at,Q,C,i,aF,P,aE,ag=0,aW=au.match(/(ipad|iphone|ipod)/i),av=au.match(/android/i),a7=au.match(/msie/i),aG=au.match(/webkit/i),aY=(au.match(/safari/i)&&!au.match(/chrome/i)),u=(au.match(/opera/i)),aT=(au.match(/(mobile|pre\/|xoom)/i)||aW||av),a5=(!x.match(/usehtml5audio/i)&&!x.match(/sm2\-ignorebadua/i)&&aY&&!au.match(/silk/i)&&au.match(/OS X 10_6_([3-7])/i)),J=(c.console!==d&&console.log!==d),aB=(Z.hasFocus!==d?Z.hasFocus():null),a9=(aY&&(Z.hasFocus===d||!Z.hasFocus())),ay=!a9,q=/(mp3|mp4|mpa|m4a|m4b)/i,h=1000,n="about:blank",aS="data:audio/wave;base64,/UklGRiYAAABXQVZFZm10IBAAAAABAAEARKwAAIhYAQACABAAZGF0YQIAAAD//w==",G=(Z.location?Z.location.protocol.match(/http/i):null),aM=(!G?"http://":""),f=/^\s*audio\/(?:x-)?(?:mpeg4|aac|flv|mov|mp4||m4v|m4a|m4b|mp4v|3gp|3g2)\s*(?:$|;)/i,U=["mpeg4","aac","flv","mov","mp4","m4v","f4v","m4a","m4b","mp4v","3gp","3g2"],ah=new RegExp("\\.("+U.join("|")+")(\\?.*)?$","i");this.mimePattern=/^\s*audio\/(?:x-)?(?:mp(?:eg|3))\s*(?:$|;)/i;this.useAltURL=!G;E={swfBox:"sm2-object-box",swfDefault:"movieContainer",swfError:"swf_error",swfTimedout:"swf_timedout",swfLoaded:"swf_loaded",swfUnblocked:"swf_unblocked",sm2Debug:"sm2_debug",highPerf:"high_performance",flashDebug:"flash_debug"};this.hasHTML5=(function(){try{return(Audio!==d&&(u&&opera!==d&&opera.version()<10?new Audio(null):new Audio()).canPlayType!==d)}catch(bk){return false}}());this.setup=function(bk){var bl=(!ao.url);if(bk!==d&&ax&&B&&ao.ok()&&(bk.flashVersion!==d||bk.url!==d||bk.html5Test!==d)){ar(be("setupLate"))}a6(bk);if(bk){if(bl&&p&&bk.url!==d){ao.beginDelayedInit()}if(!p&&bk.url!==d&&Z.readyState==="complete"){setTimeout(L,1)}}return ao};this.ok=function(){return(B?(ax&&!a1):(ao.useHTML5Audio&&ao.hasHTML5))};this.supported=this.ok;this.getMovie=function(bk){return an(bk)||Z[bk]||c[bk]};this.createSound=function(bm,bo){var bp,bq,bl,bn=null;bp=aX+".createSound(): ";bq=bp+be(!ax?"notReady":"notOK");if(!ax||!ao.ok()){ar(bq);return false}if(bo!==d){bm={id:bm,url:bo}}bl=a2(bm);bl.url=ab(bl.url);if(bl.id===undefined){bl.id=ao.setupOptions.idPrefix+(ag++)}if(bl.id.toString().charAt(0).match(/^[0-9]$/)){ao._wD(bp+be("badID",bl.id),2)}ao._wD(bp+bl.id+(bl.url?" ("+bl.url+")":""),1);if(I(bl.id,true)){ao._wD(bp+bl.id+" exists",1);return ao.sounds[bl.id]}function bk(){bl=A(bl);ao.sounds[bl.id]=new ak(bl);ao.soundIDs.push(bl.id);return ao.sounds[bl.id]}if(ba(bl)){bn=bk();ao._wD(bl.id+": Using HTML5");bn._setup_html5(bl)}else{if(ao.html5Only){ao._wD(bl.id+": No HTML5 support for this sound, and no Flash. Exiting.");return bk()}if(ao.html5.usingFlash&&bl.url&&bl.url.match(/data\:/i)){ao._wD(bl.id+": data: URIs not supported via Flash. Exiting.");return bk()}if(bh>8){if(bl.isMovieStar===null){bl.isMovieStar=!!(bl.serverURL||(bl.type?bl.type.match(f):false)||(bl.url&&bl.url.match(ah)))}if(bl.isMovieStar){ao._wD(bp+"using MovieStar handling");if(bl.loops>1){V("noNSLoop")}}}bl=o(bl,bp);bn=bk();if(bh===8){ad._createSound(bl.id,bl.loops||1,bl.usePolicyFile)}else{ad._createSound(bl.id,bl.url,bl.usePeakData,bl.useWaveformData,bl.useEQData,bl.isMovieStar,(bl.isMovieStar?bl.bufferTime:false),bl.loops||1,bl.serverURL,bl.duration||null,bl.autoPlay,true,bl.autoLoad,bl.usePolicyFile);if(!bl.serverURL){bn.connected=true;if(bl.onconnect){bl.onconnect.apply(bn)}}}if(!bl.serverURL&&(bl.autoLoad||bl.autoPlay)){bn.load(bl)}}if(!bl.serverURL&&bl.autoPlay){bn.play()}return bn};this.destroySound=function(bk,bn){if(!I(bk)){return false}var bm=ao.sounds[bk],bl;bm._iO={};bm.stop();bm.unload();for(bl=0;bl<ao.soundIDs.length;bl++){if(ao.soundIDs[bl]===bk){ao.soundIDs.splice(bl,1);break}}if(!bn){bm.destruct(true)}bm=null;delete ao.sounds[bk];return true};this.load=function(bk,bl){if(!I(bk)){return false}return ao.sounds[bk].load(bl)};this.unload=function(bk){if(!I(bk)){return false}return ao.sounds[bk].unload()};this.onPosition=function(bn,bm,bl,bk){if(!I(bn)){return false}return ao.sounds[bn].onposition(bm,bl,bk)};this.onposition=this.onPosition;this.clearOnPosition=function(bm,bl,bk){if(!I(bm)){return false}return ao.sounds[bm].clearOnPosition(bl,bk)};this.play=function(bm,bn){var bk=null,bl=(bn&&!(bn instanceof Object));if(!ax||!ao.ok()){ar(aX+".play(): "+be(!ax?"notReady":"notOK"));return false}if(!I(bm,bl)){if(!bl){return false}if(bl){bn={url:bn}}if(bn&&bn.url){ao._wD(aX+'.play(): Attempting to create "'+bm+'"',1);bn.id=bm;bk=ao.createSound(bn).play()}}else{if(bl){bn={url:bn}}}if(bk===null){bk=ao.sounds[bm].play(bn)}return bk};this.start=this.play;this.setPosition=function(bk,bl){if(!I(bk)){return false}return ao.sounds[bk].setPosition(bl)};this.stop=function(bk){if(!I(bk)){return false}ao._wD(aX+".stop("+bk+")",1);return ao.sounds[bk].stop()};this.stopAll=function(){var bk;ao._wD(aX+".stopAll()",1);for(bk in ao.sounds){if(ao.sounds.hasOwnProperty(bk)){ao.sounds[bk].stop()}}};this.pause=function(bk){if(!I(bk)){return false}return ao.sounds[bk].pause()};this.pauseAll=function(){var bk;for(bk=ao.soundIDs.length-1;bk>=0;bk--){ao.sounds[ao.soundIDs[bk]].pause()}};this.resume=function(bk){if(!I(bk)){return false}return ao.sounds[bk].resume()};this.resumeAll=function(){var bk;for(bk=ao.soundIDs.length-1;bk>=0;bk--){ao.sounds[ao.soundIDs[bk]].resume()}};this.togglePause=function(bk){if(!I(bk)){return false}return ao.sounds[bk].togglePause()};this.setPan=function(bk,bl){if(!I(bk)){return false}return ao.sounds[bk].setPan(bl)};this.setVolume=function(bl,bk){if(!I(bl)){return false}return ao.sounds[bl].setVolume(bk)};this.mute=function(bk){var bl=0;if(bk instanceof String){bk=null}if(!bk){ao._wD(aX+".mute(): Muting all sounds");for(bl=ao.soundIDs.length-1;bl>=0;bl--){ao.sounds[ao.soundIDs[bl]].mute()}ao.muted=true}else{if(!I(bk)){return false}ao._wD(aX+'.mute(): Muting "'+bk+'"');return ao.sounds[bk].mute()}return true};this.muteAll=function(){ao.mute()};this.unmute=function(bk){var bl;if(bk instanceof String){bk=null}if(!bk){ao._wD(aX+".unmute(): Unmuting all sounds");for(bl=ao.soundIDs.length-1;bl>=0;bl--){ao.sounds[ao.soundIDs[bl]].unmute()}ao.muted=false}else{if(!I(bk)){return false}ao._wD(aX+'.unmute(): Unmuting "'+bk+'"');return ao.sounds[bk].unmute()}return true};this.unmuteAll=function(){ao.unmute()};this.toggleMute=function(bk){if(!I(bk)){return false}return ao.sounds[bk].toggleMute()};this.getMemoryUse=function(){var bk=0;if(ad&&bh!==8){bk=parseInt(ad._getMemoryUse(),10)}return bk};this.disable=function(bl){var bk;if(bl===d){bl=false}if(a1){return false}a1=true;V("shutdown",1);for(bk=ao.soundIDs.length-1;bk>=0;bk--){W(ao.sounds[ao.soundIDs[bk]])}w(bl);al.remove(c,"load",s);return true};this.canPlayMIME=function(bl){var bk;if(ao.hasHTML5){bk=am({type:bl})}if(!bk&&B){bk=(bl&&ao.ok()?!!((bh>8?bl.match(f):null)||bl.match(ao.mimePattern)):null)}return bk};this.canPlayURL=function(bl){var bk;if(ao.hasHTML5){bk=am({url:bl})}if(!bk&&B){bk=(bl&&ao.ok()?!!(bl.match(ao.filePattern)):null)}return bk};this.canPlayLink=function(bk){if(bk.type!==d&&bk.type){if(ao.canPlayMIME(bk.type)){return true}}return ao.canPlayURL(bk.href)};this.getSoundById=function(bl,bm){if(!bl){return null}var bk=ao.sounds[bl];if(!bk&&!bm){ao._wD(aX+'.getSoundById(): Sound "'+bl+'" not found.',2)}return bk};this.onready=function(bm,bl){var bn="onready",bk=false;if(typeof bm==="function"){if(ax){ao._wD(be("queue",bn))}if(!bl){bl=c}Y(bn,bm,bl);aR();bk=true}else{throw be("needFunction",bn)}return bk};this.ontimeout=function(bm,bl){var bn="ontimeout",bk=false;if(typeof bm==="function"){if(ax){ao._wD(be("queue",bn))}if(!bl){bl=c}Y(bn,bm,bl);aR({type:bn});bk=true}else{throw be("needFunction",bn)}return bk};this._writeDebug=function(bl,bk){var bo="soundmanager-debug",bn,bm;if(!ao.debugMode){return false}if(J&&ao.useConsole){if(bk&&typeof bk==="object"){console.log(bl,bk)}else{if(aH[bk]!==d){console[aH[bk]](bl)}else{console.log(bl)}}if(ao.consoleOnly){return true}}bn=an(bo);if(!bn){return false}bm=Z.createElement("div");if(++aw%2===0){bm.className="sm2-alt"}if(bk===d){bk=0}else{bk=parseInt(bk,10)}bm.appendChild(Z.createTextNode(bl));if(bk){if(bk>=2){bm.style.fontWeight="bold"}if(bk===3){bm.style.color="#ff3333"}}bn.insertBefore(bm,bn.firstChild);bn=null;return true};if(x.indexOf("sm2-debug=alert")!==-1){this._writeDebug=function(bk){c.alert(bk)}}this._wD=this._writeDebug;this._debug=function(){var bl,bk;V("currentObj",1);for(bl=0,bk=ao.soundIDs.length;bl<bk;bl++){ao.sounds[ao.soundIDs[bl]]._debug()}};this.reboot=function(bo,bn){if(ao.soundIDs.length){ao._wD("Destroying "+ao.soundIDs.length+" SMSound object"+(ao.soundIDs.length!==1?"s":"")+"...")}var bm,bl,bk;for(bm=ao.soundIDs.length-1;bm>=0;bm--){ao.sounds[ao.soundIDs[bm]].destruct()}if(ad){try{if(a7){aj=ad.innerHTML}aK=ad.parentNode.removeChild(ad)}catch(bp){V("badRemove",2)}}aj=aK=B=ad=null;ao.enabled=p=ax=aQ=aI=ap=aU=a1=aZ=ao.swfLoaded=false;ao.soundIDs=[];ao.sounds={};ag=0;if(!bo){for(bm in v){if(v.hasOwnProperty(bm)){for(bl=0,bk=v[bm].length;bl<bk;bl++){v[bm][bl].fired=false}}}}else{v=[]}if(!bn){ao._wD(aX+": Rebooting...")}ao.html5={usingFlash:null};ao.flash={};ao.html5Only=false;ao.ignoreFlash=false;c.setTimeout(function(){aD();if(!bn){ao.beginDelayedInit()}},20);return ao};this.reset=function(){V("reset");return ao.reboot(true,true)};this.getMoviePercent=function(){return(ad&&"PercentLoaded" in ad?ad.PercentLoaded():null)};this.beginDelayedInit=function(){bb=true;L();setTimeout(function(){if(aI){return false}H();j();aI=true;return true},20);y()};this.destruct=function(){ao._wD(aX+".destruct()");ao.disable(true)};ak=function(by){var bz=this,bk,bv,bs,bl,bp,bq,bm=false,bo=[],bw=0,bn,br,bt=null,bu,bx;bu={duration:null,time:null};this.id=by.id;this.sID=this.id;this.url=by.url;this.options=a2(by);this.instanceOptions=this.options;this._iO=this.instanceOptions;this.pan=this.options.pan;this.volume=this.options.volume;this.isHTML5=false;this._a=null;bx=(this.url?false:true);this.id3={};this._debug=function(){ao._wD(bz.id+": Merged options:",bz.options)};this.load=function(bA){var bB=null,bC;if(bA!==d){bz._iO=a2(bA,bz.options)}else{bA=bz.options;bz._iO=bA;if(bt&&bt!==bz.url){V("manURL");bz._iO.url=bz.url;bz.url=null}}if(!bz._iO.url){bz._iO.url=bz.url}bz._iO.url=ab(bz._iO.url);bz.instanceOptions=bz._iO;bC=bz._iO;ao._wD(bz.id+": load ("+bC.url+")");if(!bC.url&&!bz.url){ao._wD(bz.id+": load(): url is unassigned. Exiting.",2);return bz}if(!bz.isHTML5&&bh===8&&!bz.url&&!bC.autoPlay){ao._wD(bz.id+": Flash 8 load() limitation: Wait for onload() before calling play().",1)}if(bC.url===bz.url&&bz.readyState!==0&&bz.readyState!==2){V("onURL",1);if(bz.readyState===3&&bC.onload){aE(bz,function(){bC.onload.apply(bz,[(!!bz.duration)])})}return bz}bz.loaded=false;bz.readyState=1;bz.playState=0;bz.id3={};if(ba(bC)){bB=bz._setup_html5(bC);if(!bB._called_load){bz._html5_canplay=false;if(bz.url!==bC.url){ao._wD(V("manURL")+": "+bC.url);bz._a.src=bC.url;bz.setPosition(0)}bz._a.autobuffer="auto";bz._a.preload="auto";bz._a._called_load=true}else{ao._wD(bz.id+": Ignoring request to load again")}}else{if(ao.html5Only){ao._wD(bz.id+": No flash support. Exiting.");return bz}if(bz._iO.url&&bz._iO.url.match(/data\:/i)){ao._wD(bz.id+": data: URIs not supported via Flash. Exiting.");return bz}try{bz.isHTML5=false;bz._iO=o(A(bC));if(bz._iO.autoPlay&&(bz._iO.position||bz._iO.from)){ao._wD(bz.id+": Disabling autoPlay because of non-zero offset case");bz._iO.autoPlay=false}bC=bz._iO;if(bh===8){ad._load(bz.id,bC.url,bC.stream,bC.autoPlay,bC.usePolicyFile)}else{ad._load(bz.id,bC.url,!!(bC.stream),!!(bC.autoPlay),bC.loops||1,!!(bC.autoLoad),bC.usePolicyFile)}}catch(bD){V("smError",2);M("onload",false);aa({type:"SMSOUND_LOAD_JS_EXCEPTION",fatal:true})}}bz.url=bC.url;return bz};this.unload=function(){if(bz.readyState!==0){ao._wD(bz.id+": unload()");if(!bz.isHTML5){if(bh===8){ad._unload(bz.id,n)}else{ad._unload(bz.id)}}else{bl();if(bz._a){bz._a.pause();bt=g(bz._a)}}bk()}return bz};this.destruct=function(bA){ao._wD(bz.id+": Destruct");if(!bz.isHTML5){bz._iO.onfailure=null;ad._destroySound(bz.id)}else{bl();if(bz._a){bz._a.pause();g(bz._a);if(!aZ){bs()}bz._a._s=null;bz._a=null}}if(!bA){ao.destroySound(bz.id,true)}};this.play=function(bG,bC){var bA,bD,bJ,bI,bK,bH,bF,bE=true,bB=null;bA=bz.id+": play(): ";bC=(bC===d?true:bC);if(!bG){bG={}}if(bz.url){bz._iO.url=bz.url}bz._iO=a2(bz._iO,bz.options);bz._iO=a2(bG,bz._iO);bz._iO.url=ab(bz._iO.url);bz.instanceOptions=bz._iO;if(!bz.isHTML5&&bz._iO.serverURL&&!bz.connected){if(!bz.getAutoPlay()){ao._wD(bA+" Netstream not connected yet - setting autoPlay");bz.setAutoPlay(true)}return bz}if(ba(bz._iO)){bz._setup_html5(bz._iO);bp()}if(bz.playState===1&&!bz.paused){bD=bz._iO.multiShot;if(!bD){ao._wD(bA+"Already playing (one-shot)",1);if(bz.isHTML5){bz.setPosition(bz._iO.position)}bB=bz}else{ao._wD(bA+"Already playing (multi-shot)",1)}}if(bB!==null){return bB}if(bG.url&&bG.url!==bz.url){if(!bz.readyState&&!bz.isHTML5&&bh===8&&bx){bx=false}else{bz.load(bz._iO)}}if(!bz.loaded){if(bz.readyState===0){ao._wD(bA+"Attempting to load");if(!bz.isHTML5&&!ao.html5Only){bz._iO.autoPlay=true;bz.load(bz._iO)}else{if(bz.isHTML5){bz.load(bz._iO)}else{ao._wD(bA+"Unsupported type. Exiting.");bB=bz}}bz.instanceOptions=bz._iO}else{if(bz.readyState===2){ao._wD(bA+"Could not load - exiting",2);bB=bz}else{ao._wD(bA+"Loading - attempting to play...")}}}else{ao._wD(bA.substr(0,bA.lastIndexOf(":")))}if(bB!==null){return bB}if(!bz.isHTML5&&bh===9&&bz.position>0&&bz.position===bz.duration){ao._wD(bA+"Sound at end, resetting to position:0");bG.position=0}if(bz.paused&&bz.position>=0&&(!bz._iO.serverURL||bz.position>0)){ao._wD(bA+"Resuming from paused state",1);bz.resume()}else{bz._iO=a2(bG,bz._iO);if(((!bz.isHTML5&&bz._iO.position!==null&&bz._iO.position>0)||(bz._iO.from!==null&&bz._iO.from>0)||bz._iO.to!==null)&&bz.instanceCount===0&&bz.playState===0&&!bz._iO.serverURL){bI=function(){bz._iO=a2(bG,bz._iO);bz.play(bz._iO)};if(bz.isHTML5&&!bz._html5_canplay){ao._wD(bA+"Beginning load for non-zero offset case");bz.load({_oncanplay:bI});bB=false}else{if(!bz.isHTML5&&!bz.loaded&&(!bz.readyState||bz.readyState!==2)){ao._wD(bA+"Preloading for non-zero offset case");bz.load({onload:bI});bB=false}}if(bB!==null){return bB}bz._iO=br()}if(!bz.instanceCount||bz._iO.multiShotEvents||(bz.isHTML5&&bz._iO.multiShot&&!aZ)||(!bz.isHTML5&&bh>8&&!bz.getAutoPlay())){bz.instanceCount++}if(bz._iO.onposition&&bz.playState===0){bq(bz)}bz.playState=1;bz.paused=false;bz.position=(bz._iO.position!==d&&!isNaN(bz._iO.position)?bz._iO.position:0);if(!bz.isHTML5){bz._iO=o(A(bz._iO))}if(bz._iO.onplay&&bC){bz._iO.onplay.apply(bz);bm=true}bz.setVolume(bz._iO.volume,true);bz.setPan(bz._iO.pan,true);if(!bz.isHTML5){bE=ad._start(bz.id,bz._iO.loops||1,(bh===9?bz.position:bz.position/h),bz._iO.multiShot||false);if(bh===9&&!bE){ao._wD(bA+"No sound hardware, or 32-sound ceiling hit",2);if(bz._iO.onplayerror){bz._iO.onplayerror.apply(bz)}}}else{if(bz.instanceCount<2){bp();bJ=bz._setup_html5();bz.setPosition(bz._iO.position);bJ.play()}else{ao._wD(bz.id+": Cloning Audio() for instance #"+bz.instanceCount+"...");bK=new Audio(bz._iO.url);bH=function(){al.remove(bK,"ended",bH);bz._onfinish(bz);g(bK);bK=null};bF=function(){al.remove(bK,"canplay",bF);try{bK.currentTime=bz._iO.position/h}catch(bL){ar(bz.id+": multiShot play() failed to apply position of "+(bz._iO.position/h))}bK.play()};al.add(bK,"ended",bH);if(bz._iO.volume!==undefined){bK.volume=Math.max(0,Math.min(1,bz._iO.volume/100))}if(bz.muted){bK.muted=true}if(bz._iO.position){al.add(bK,"canplay",bF)}else{bK.play()}}}}return bz};this.start=this.play;this.stop=function(bA){var bC=bz._iO,bB;if(bz.playState===1){ao._wD(bz.id+": stop()");bz._onbufferchange(0);bz._resetOnPosition(0);bz.paused=false;if(!bz.isHTML5){bz.playState=0}bn();if(bC.to){bz.clearOnPosition(bC.to)}if(!bz.isHTML5){ad._stop(bz.id,bA);if(bC.serverURL){bz.unload()}}else{if(bz._a){bB=bz.position;bz.setPosition(0);bz.position=bB;bz._a.pause();bz.playState=0;bz._onTimer();bl()}}bz.instanceCount=0;bz._iO={};if(bC.onstop){bC.onstop.apply(bz)}}return bz};this.setAutoPlay=function(bA){ao._wD(bz.id+": Autoplay turned "+(bA?"on":"off"));bz._iO.autoPlay=bA;if(!bz.isHTML5){ad._setAutoPlay(bz.id,bA);if(bA){if(!bz.instanceCount&&bz.readyState===1){bz.instanceCount++;ao._wD(bz.id+": Incremented instance count to "+bz.instanceCount)}}}};this.getAutoPlay=function(){return bz._iO.autoPlay};this.setPosition=function(bC){if(bC===d){bC=0}var bA,bB,bE=(bz.isHTML5?Math.max(bC,0):Math.min(bz.duration||bz._iO.duration,Math.max(bC,0)));bz.position=bE;bB=bz.position/h;bz._resetOnPosition(bz.position);bz._iO.position=bE;if(!bz.isHTML5){bA=(bh===9?bz.position:bB);if(bz.readyState&&bz.readyState!==2){ad._setPosition(bz.id,bA,(bz.paused||!bz.playState),bz._iO.multiShot)}}else{if(bz._a){if(bz._html5_canplay){if(bz._a.currentTime!==bB){ao._wD(bz.id+": setPosition("+bB+")");try{bz._a.currentTime=bB;if(bz.playState===0||bz.paused){bz._a.pause()}}catch(bD){ao._wD(bz.id+": setPosition("+bB+") failed: "+bD.message,2)}}}else{if(bB){ao._wD(bz.id+": setPosition("+bB+"): Cannot seek yet, sound not ready",2);return bz}}if(bz.paused){bz._onTimer(true)}}}return bz};this.pause=function(bA){if(bz.paused||(bz.playState===0&&bz.readyState!==1)){return bz}ao._wD(bz.id+": pause()");bz.paused=true;if(!bz.isHTML5){if(bA||bA===d){ad._pause(bz.id,bz._iO.multiShot)}}else{bz._setup_html5().pause();bl()}if(bz._iO.onpause){bz._iO.onpause.apply(bz)}return bz};this.resume=function(){var bA=bz._iO;if(!bz.paused){return bz}ao._wD(bz.id+": resume()");bz.paused=false;bz.playState=1;if(!bz.isHTML5){if(bA.isMovieStar&&!bA.serverURL){bz.setPosition(bz.position)}ad._pause(bz.id,bA.multiShot)}else{bz._setup_html5().play();bp()}if(!bm&&bA.onplay){bA.onplay.apply(bz);bm=true}else{if(bA.onresume){bA.onresume.apply(bz)}}return bz};this.togglePause=function(){ao._wD(bz.id+": togglePause()");if(bz.playState===0){bz.play({position:(bh===9&&!bz.isHTML5?bz.position:bz.position/h)});return bz}if(bz.paused){bz.resume()}else{bz.pause()}return bz};this.setPan=function(bB,bA){if(bB===d){bB=0}if(bA===d){bA=false}if(!bz.isHTML5){ad._setPan(bz.id,bB)}bz._iO.pan=bB;if(!bA){bz.pan=bB;bz.options.pan=bB}return bz};this.setVolume=function(bA,bB){if(bA===d){bA=100}if(bB===d){bB=false}if(!bz.isHTML5){ad._setVolume(bz.id,(ao.muted&&!bz.muted)||bz.muted?0:bA)}else{if(bz._a){if(ao.muted&&!bz.muted){bz.muted=true;bz._a.muted=true}bz._a.volume=Math.max(0,Math.min(1,bA/100))}}bz._iO.volume=bA;if(!bB){bz.volume=bA;bz.options.volume=bA}return bz};this.mute=function(){bz.muted=true;if(!bz.isHTML5){ad._setVolume(bz.id,0)}else{if(bz._a){bz._a.muted=true}}return bz};this.unmute=function(){bz.muted=false;var bA=(bz._iO.volume!==d);if(!bz.isHTML5){ad._setVolume(bz.id,bA?bz._iO.volume:bz.options.volume)}else{if(bz._a){bz._a.muted=false}}return bz};this.toggleMute=function(){return(bz.muted?bz.unmute():bz.mute())};this.onPosition=function(bC,bB,bA){bo.push({position:parseInt(bC,10),method:bB,scope:(bA!==d?bA:bz),fired:false});return bz};this.onposition=this.onPosition;this.clearOnPosition=function(bB,bA){var bC;bB=parseInt(bB,10);if(isNaN(bB)){return false}for(bC=0;bC<bo.length;bC++){if(bB===bo[bC].position){if(!bA||(bA===bo[bC].method)){if(bo[bC].fired){bw--}bo.splice(bC,1)}}}};this._processOnPosition=function(){var bB,bC,bA=bo.length;if(!bA||!bz.playState||bw>=bA){return false}for(bB=bA-1;bB>=0;bB--){bC=bo[bB];if(!bC.fired&&bz.position>=bC.position){bC.fired=true;bw++;bC.method.apply(bC.scope,[bC.position]);bA=bo.length}}return true};this._resetOnPosition=function(bA){var bC,bD,bB=bo.length;if(!bB){return false}for(bC=bB-1;bC>=0;bC--){bD=bo[bC];if(bD.fired&&bA<=bD.position){bD.fired=false;bw--}}return true};br=function(){var bD=bz._iO,bC=bD.from,bB=bD.to,bE,bA;bA=function(){ao._wD(bz.id+': "To" time of '+bB+" reached.");bz.clearOnPosition(bB,bA);bz.stop()};bE=function(){ao._wD(bz.id+': Playing "from" '+bC);if(bB!==null&&!isNaN(bB)){bz.onPosition(bB,bA)}};if(bC!==null&&!isNaN(bC)){bD.position=bC;bD.multiShot=false;bE()}return bD};bq=function(){var bA,bB=bz._iO.onposition;if(bB){for(bA in bB){if(bB.hasOwnProperty(bA)){bz.onPosition(parseInt(bA,10),bB[bA])}}}};bn=function(){var bA,bB=bz._iO.onposition;if(bB){for(bA in bB){if(bB.hasOwnProperty(bA)){bz.clearOnPosition(parseInt(bA,10))}}}};bp=function(){if(bz.isHTML5){aO(bz)}};bl=function(){if(bz.isHTML5){N(bz)}};bk=function(bA){if(!bA){bo=[];bw=0}bm=false;bz._hasTimer=null;bz._a=null;bz._html5_canplay=false;bz.bytesLoaded=null;bz.bytesTotal=null;bz.duration=(bz._iO&&bz._iO.duration?bz._iO.duration:null);bz.durationEstimate=null;bz.buffered=[];bz.eqData=[];bz.eqData.left=[];bz.eqData.right=[];bz.failures=0;bz.isBuffering=false;bz.instanceOptions={};bz.instanceCount=0;bz.loaded=false;bz.metadata={};bz.readyState=0;bz.muted=false;bz.paused=false;bz.peakData={left:0,right:0};bz.waveformData={left:[],right:[]};bz.playState=0;bz.position=null;bz.id3={}};bk();this._onTimer=function(bC){var bE,bB=false,bD,bA={};if(bz._hasTimer||bC){if(bz._a&&(bC||((bz.playState>0||bz.readyState===1)&&!bz.paused))){bE=bz._get_html5_duration();if(bE!==bu.duration){bu.duration=bE;bz.duration=bE;bB=true}bz.durationEstimate=bz.duration;bD=(bz._a.currentTime*h||0);if(bD!==bu.time){bu.time=bD;bB=true}if(bB||bC){bz._whileplaying(bD,bA,bA,bA,bA)}}return bB}};this._get_html5_duration=function(){var bB=bz._iO,bC=(bz._a&&bz._a.duration?bz._a.duration*h:(bB&&bB.duration?bB.duration:null)),bA=(bC&&!isNaN(bC)&&bC!==Infinity?bC:null);return bA};this._apply_loop=function(bA,bB){if(!bA.loop&&bB>1){ao._wD("Note: Native HTML5 looping is infinite.",1)}bA.loop=(bB>1?"loop":"")};this._setup_html5=function(bB){var bC=a2(bz._iO,bB),bA=aZ?a8:bz._a,bE=decodeURI(bC.url),bD;if(aZ){if(bE===decodeURI(k)){bD=true}}else{if(bE===decodeURI(bt)){bD=true}}if(bA){if(bA._s){if(aZ){if(bA._s&&bA._s.playState&&!bD){bA._s.stop()}}else{if(!aZ&&bE===decodeURI(bt)){bz._apply_loop(bA,bC.loops);return bA}}}if(!bD){if(bt){bk(false)}bA.src=bC.url;bz.url=bC.url;bt=bC.url;k=bC.url;bA._called_load=false}}else{if(bC.autoLoad||bC.autoPlay){bz._a=new Audio(bC.url);bz._a.load()}else{bz._a=(u&&opera.version()<10?new Audio(null):new Audio())}bA=bz._a;bA._called_load=false;if(aZ){a8=bA}}bz.isHTML5=true;bz._a=bA;bA._s=bz;bv();bz._apply_loop(bA,bC.loops);if(bC.autoLoad||bC.autoPlay){bz.load()}else{bA.autobuffer=false;bA.preload="auto"}return bA};bv=function(){if(bz._a._added_events){return false}var bA;function bB(bD,bC,bE){return bz._a?bz._a.addEventListener(bD,bC,bE||false):null}bz._a._added_events=true;for(bA in i){if(i.hasOwnProperty(bA)){bB(bA,i[bA])}}return true};bs=function(){var bB;function bA(bD,bC,bE){return(bz._a?bz._a.removeEventListener(bD,bC,bE||false):null)}ao._wD(bz.id+": Removing event listeners");bz._a._added_events=false;for(bB in i){if(i.hasOwnProperty(bB)){bA(bB,i[bB])}}};this._onload=function(bC){var bA,bB=!!bC||(!bz.isHTML5&&bh===8&&bz.duration);bA=bz.id+": ";ao._wD(bA+(bB?"onload()":"Failed to load / invalid sound?"+(!bz.duration?" Zero-length duration reported.":" -")+" ("+bz.url+")"),(bB?1:2));if(!bB&&!bz.isHTML5){if(ao.sandbox.noRemote===true){ao._wD(bA+be("noNet"),1)}if(ao.sandbox.noLocal===true){ao._wD(bA+be("noLocal"),1)}}bz.loaded=bB;bz.readyState=bB?3:2;bz._onbufferchange(0);if(bz._iO.onload){aE(bz,function(){bz._iO.onload.apply(bz,[bB])})}return true};this._onbufferchange=function(bA){if(bz.playState===0){return false}if((bA&&bz.isBuffering)||(!bA&&!bz.isBuffering)){return false}bz.isBuffering=(bA===1);if(bz._iO.onbufferchange){ao._wD(bz.id+": Buffer state change: "+bA);bz._iO.onbufferchange.apply(bz,[bA])}return true};this._onsuspend=function(){if(bz._iO.onsuspend){ao._wD(bz.id+": Playback suspended");bz._iO.onsuspend.apply(bz)}return true};this._onfailure=function(bB,bC,bA){bz.failures++;ao._wD(bz.id+": Failure ("+bz.failures+"): "+bB);if(bz._iO.onfailure&&bz.failures===1){bz._iO.onfailure(bB,bC,bA)}else{ao._wD(bz.id+": Ignoring failure")}};this._onwarning=function(bB,bC,bA){if(bz._iO.onwarning){bz._iO.onwarning(bB,bC,bA)}};this._onfinish=function(){var bA=bz._iO.onfinish;bz._onbufferchange(0);bz._resetOnPosition(0);if(bz.instanceCount){bz.instanceCount--;if(!bz.instanceCount){bn();bz.playState=0;bz.paused=false;bz.instanceCount=0;bz.instanceOptions={};bz._iO={};bl();if(bz.isHTML5){bz.position=0}}if(!bz.instanceCount||bz._iO.multiShotEvents){if(bA){ao._wD(bz.id+": onfinish()");aE(bz,function(){bA.apply(bz)})}}}};this._whileloading=function(bA,bB,bE,bD){var bC=bz._iO;bz.bytesLoaded=bA;bz.bytesTotal=bB;bz.duration=Math.floor(bE);bz.bufferLength=bD;if(!bz.isHTML5&&!bC.isMovieStar){if(bC.duration){bz.durationEstimate=(bz.duration>bC.duration)?bz.duration:bC.duration}else{bz.durationEstimate=parseInt((bz.bytesTotal/bz.bytesLoaded)*bz.duration,10)}}else{bz.durationEstimate=bz.duration}if(!bz.isHTML5){bz.buffered=[{start:0,end:bz.duration}]}if((bz.readyState!==3||bz.isHTML5)&&bC.whileloading){bC.whileloading.apply(bz)}};this._whileplaying=function(bC,bD,bG,bB,bF){var bE=bz._iO,bA;if(isNaN(bC)||bC===null){return false}bz.position=Math.max(0,bC);bz._processOnPosition();if(!bz.isHTML5&&bh>8){if(bE.usePeakData&&bD!==d&&bD){bz.peakData={left:bD.leftPeak,right:bD.rightPeak}}if(bE.useWaveformData&&bG!==d&&bG){bz.waveformData={left:bG.split(","),right:bB.split(",")}}if(bE.useEQData){if(bF!==d&&bF&&bF.leftEQ){bA=bF.leftEQ.split(",");bz.eqData=bA;bz.eqData.left=bA;if(bF.rightEQ!==d&&bF.rightEQ){bz.eqData.right=bF.rightEQ.split(",")}}}}if(bz.playState===1){if(!bz.isHTML5&&bh===8&&!bz.position&&bz.isBuffering){bz._onbufferchange(0)}if(bE.whileplaying){bE.whileplaying.apply(bz)}}return true};this._oncaptiondata=function(bA){ao._wD(bz.id+": Caption data received.");bz.captiondata=bA;if(bz._iO.oncaptiondata){bz._iO.oncaptiondata.apply(bz,[bA])}};this._onmetadata=function(bD,bA){ao._wD(bz.id+": Metadata received.");var bE={},bC,bB;for(bC=0,bB=bD.length;bC<bB;bC++){bE[bD[bC]]=bA[bC]}bz.metadata=bE;console.log("updated metadata",bz.metadata);if(bz._iO.onmetadata){bz._iO.onmetadata.call(bz,bz.metadata)}};this._onid3=function(bD,bA){ao._wD(bz.id+": ID3 data received.");var bE=[],bC,bB;for(bC=0,bB=bD.length;bC<bB;bC++){bE[bD[bC]]=bA[bC]}bz.id3=a2(bz.id3,bE);if(bz._iO.onid3){bz._iO.onid3.apply(bz)}};this._onconnect=function(bA){bA=(bA===1);ao._wD(bz.id+": "+(bA?"Connected.":"Failed to connect? - "+bz.url),(bA?1:2));bz.connected=bA;if(bA){bz.failures=0;if(I(bz.id)){if(bz.getAutoPlay()){bz.play(d,bz.getAutoPlay())}else{if(bz._iO.autoLoad){bz.load()}}}if(bz._iO.onconnect){bz._iO.onconnect.apply(bz,[bA])}}};this._ondataerror=function(bA){if(bz.playState>0){ao._wD(bz.id+": Data error: "+bA);if(bz._iO.ondataerror){bz._iO.ondataerror.apply(bz)}}};this._debug()};bf=function(){return(Z.body||Z.getElementsByTagName("div")[0])};an=function(bk){return Z.getElementById(bk)};a2=function(bl,bk){var bn=(bl||{}),bm,bo;bm=(bk===d?ao.defaultOptions:bk);for(bo in bm){if(bm.hasOwnProperty(bo)&&bn[bo]===d){if(typeof bm[bo]!=="object"||bm[bo]===null){bn[bo]=bm[bo]}else{bn[bo]=a2(bn[bo],bm[bo])}}}return bn};aE=function(bk,bl){if(!bk.isHTML5&&bh===8){c.setTimeout(bl,0)}else{bl()}};a3={onready:1,ontimeout:1,defaultOptions:1,flash9Options:1,movieStarOptions:1};a6=function(bq,bp){var bo,bl=true,bk=(bp!==d),bn=ao.setupOptions,bm=a3;if(bq===d){bl=[];for(bo in bn){if(bn.hasOwnProperty(bo)){bl.push(bo)}}for(bo in bm){if(bm.hasOwnProperty(bo)){if(typeof ao[bo]==="object"){bl.push(bo+": {...}")}else{if(ao[bo] instanceof Function){bl.push(bo+": function() {...}")}else{bl.push(bo)}}}}ao._wD(be("setup",bl.join(", ")));return false}for(bo in bq){if(bq.hasOwnProperty(bo)){if(typeof bq[bo]!=="object"||bq[bo]===null||bq[bo] instanceof Array||bq[bo] instanceof RegExp){if(bk&&bm[bp]!==d){ao[bp][bo]=bq[bo]}else{if(bn[bo]!==d){ao.setupOptions[bo]=bq[bo];ao[bo]=bq[bo]}else{if(bm[bo]===d){ar(be((ao[bo]===d?"setupUndef":"setupError"),bo),2);bl=false}else{if(ao[bo] instanceof Function){ao[bo].apply(ao,(bq[bo] instanceof Array?bq[bo]:[bq[bo]]))}else{ao[bo]=bq[bo]}}}}}else{if(bm[bo]===d){ar(be((ao[bo]===d?"setupUndef":"setupError"),bo),2);bl=false}else{return a6(bq[bo],bo)}}}}return bl};function bi(bk){return(ao.preferFlash&&at&&!ao.ignoreFlash&&(ao.flash[bk]!==d&&ao.flash[bk]))}al=(function(){var bm=(c.attachEvent),bl={add:(bm?"attachEvent":"addEventListener"),remove:(bm?"detachEvent":"removeEventListener")};function bo(bs){var br=R.call(bs),bq=br.length;if(bm){br[1]="on"+br[1];if(bq>3){br.pop()}}else{if(bq===3){br.push(false)}}return br}function bn(bq,bt){var br=bq.shift(),bs=[bl[bt]];if(bm){br[bs](bq[0],bq[1])}else{br[bs].apply(br,bq)}}function bp(){bn(bo(arguments),"add")}function bk(){bn(bo(arguments),"remove")}return{add:bp,remove:bk}}());function aP(bk){return function(bn){var bm=this._s,bl;if(!bm||!bm._a){if(bm&&bm.id){ao._wD(bm.id+": Ignoring "+bn.type)}else{ao._wD(a4+"Ignoring "+bn.type)}bl=null}else{bl=bk.call(this,bn)}return bl}}i={abort:aP(function(){ao._wD(this._s.id+": abort")}),canplay:aP(function(){var bm=this._s,bl;if(bm._html5_canplay){return true}bm._html5_canplay=true;ao._wD(bm.id+": canplay");bm._onbufferchange(0);bl=(bm._iO.position!==d&&!isNaN(bm._iO.position)?bm._iO.position/h:null);if(this.currentTime!==bl){ao._wD(bm.id+": canplay: Setting position to "+bl);try{this.currentTime=bl}catch(bk){ao._wD(bm.id+": canplay: Setting position of "+bl+" failed: "+bk.message,2)}}if(bm._iO._oncanplay){bm._iO._oncanplay()}}),canplaythrough:aP(function(){var bk=this._s;if(!bk.loaded){bk._onbufferchange(0);bk._whileloading(bk.bytesLoaded,bk.bytesTotal,bk._get_html5_duration());bk._onload(true)}}),durationchange:aP(function(){var bk=this._s,bl;bl=bk._get_html5_duration();if(!isNaN(bl)&&bl!==bk.duration){ao._wD(this._s.id+": durationchange ("+bl+")"+(bk.duration?", previously "+bk.duration:""));bk.durationEstimate=bk.duration=bl}}),ended:aP(function(){var bk=this._s;ao._wD(bk.id+": ended");bk._onfinish()}),error:aP(function(){ao._wD(this._s.id+": HTML5 error, code "+this.error.code);this._s._onload(false)}),loadeddata:aP(function(){var bk=this._s;ao._wD(bk.id+": loadeddata");if(!bk._loaded&&!aY){bk.duration=bk._get_html5_duration()}}),loadedmetadata:aP(function(){ao._wD(this._s.id+": loadedmetadata")}),loadstart:aP(function(){ao._wD(this._s.id+": loadstart");this._s._onbufferchange(1)}),play:aP(function(){this._s._onbufferchange(0)}),playing:aP(function(){ao._wD(this._s.id+": playing "+String.fromCharCode(9835));this._s._onbufferchange(0)}),progress:aP(function(bp){var bt=this._s,bo,bm,bs,bl=0,br=(bp.type==="progress"),bk=bp.target.buffered,bn=(bp.loaded||0),bq=(bp.total||1);bt.buffered=[];if(bk&&bk.length){for(bo=0,bm=bk.length;bo<bm;bo++){bt.buffered.push({start:bk.start(bo)*h,end:bk.end(bo)*h})}bl=(bk.end(0)-bk.start(0))*h;bn=Math.min(1,bl/(bp.target.duration*h));if(br&&bk.length>1){bs=[];bm=bk.length;for(bo=0;bo<bm;bo++){bs.push(bp.target.buffered.start(bo)*h+"-"+bp.target.buffered.end(bo)*h)}ao._wD(this._s.id+": progress, timeRanges: "+bs.join(", "))}if(br&&!isNaN(bn)){ao._wD(this._s.id+": progress, "+Math.floor(bn*100)+"% loaded")}}if(!isNaN(bn)){bt._whileloading(bn,bq,bt._get_html5_duration());if(bn&&bq&&bn===bq){i.canplaythrough.call(this,bp)}}}),ratechange:aP(function(){ao._wD(this._s.id+": ratechange")}),suspend:aP(function(bl){var bk=this._s;ao._wD(this._s.id+": suspend");i.progress.call(this,bl);bk._onsuspend()}),stalled:aP(function(){ao._wD(this._s.id+": stalled")}),timeupdate:aP(function(){this._s._onTimer()}),waiting:aP(function(){var bk=this._s;ao._wD(this._s.id+": waiting");bk._onbufferchange(1)})};ba=function(bl){var bk;if(!bl||(!bl.type&&!bl.url&&!bl.serverURL)){bk=false}else{if(bl.serverURL||(bl.type&&bi(bl.type))){bk=false}else{bk=((bl.type?am({type:bl.type}):am({url:bl.url})||ao.html5Only||bl.url.match(/data\:/i)))}}return bk};g=function(bk){var bl;if(bk){bl=(aY?n:(ao.html5.canPlayType("audio/wav")?aS:n));bk.src=bl;if(bk._called_unload!==undefined){bk._called_load=false}}if(aZ){k=null}return bl};am=function(br){if(!ao.useHTML5Audio||!ao.hasHTML5){return false}var bn=(br.url||null),bp=(br.type||null),bl=ao.audioFormats,bk,bq,bm,bo;if(bp&&ao.html5[bp]!==d){return(ao.html5[bp]&&!bi(bp))}if(!aL){aL=[];for(bo in bl){if(bl.hasOwnProperty(bo)){aL.push(bo);if(bl[bo].related){aL=aL.concat(bl[bo].related)}}}aL=new RegExp("\\.("+aL.join("|")+")(\\?.*)?$","i")}bm=(bn?bn.toLowerCase().match(aL):null);if(!bm||!bm.length){if(!bp){bk=false}else{bq=bp.indexOf(";");bm=(bq!==-1?bp.substr(0,bq):bp).substr(6)}}else{bm=bm[1]}if(bm&&ao.html5[bm]!==d){bk=(ao.html5[bm]&&!bi(bm))}else{bp="audio/"+bm;bk=ao.html5.canPlayType({type:bp});ao.html5[bm]=bk;bk=(bk&&ao.html5[bp]&&!bi(bp))}return bk};aN=function(){if(!ao.useHTML5Audio||!ao.hasHTML5){ao.html5.usingFlash=true;B=true;return false}var bk=(Audio!==d?(u&&opera.version()<10?new Audio(null):new Audio()):null),bo,bq,bn={},bl,bm;function bp(bt){var bv,bu,bs=false,br=false;if(!bk||typeof bk.canPlayType!=="function"){return bs}if(bt instanceof Array){for(bm=0,bu=bt.length;bm<bu;bm++){if(ao.html5[bt[bm]]||bk.canPlayType(bt[bm]).match(ao.html5Test)){br=true;ao.html5[bt[bm]]=true;ao.flash[bt[bm]]=!!(bt[bm].match(q))}}bs=br}else{bv=(bk&&typeof bk.canPlayType==="function"?bk.canPlayType(bt):false);bs=!!(bv&&(bv.match(ao.html5Test)))}return bs}bl=ao.audioFormats;for(bo in bl){if(bl.hasOwnProperty(bo)){bq="audio/"+bo;bn[bo]=bp(bl[bo].type);bn[bq]=bn[bo];if(bo.match(q)){ao.flash[bo]=true;ao.flash[bq]=true}else{ao.flash[bo]=false;ao.flash[bq]=false}if(bl[bo]&&bl[bo].related){for(bm=bl[bo].related.length-1;bm>=0;bm--){bn["audio/"+bl[bo].related[bm]]=bn[bo];ao.html5[bl[bo].related[bm]]=bn[bo];ao.flash[bl[bo].related[bm]]=bn[bo]}}}}bn.canPlayType=(bk?bp:null);ao.html5=a2(ao.html5,bn);ao.html5.usingFlash=S();B=ao.html5.usingFlash;return true};e={notReady:"Unavailable - wait until onready() has fired.",notOK:"Audio support is not available.",domError:aX+"exception caught while appending SWF to DOM.",spcWmode:"Removing wmode, preventing known SWF loading issue(s)",swf404:F+"Verify that %s is a valid path.",tryDebug:"Try "+aX+".debugFlash = true for more security details (output goes to SWF.)",checkSWF:"See SWF output for more debug info.",localFail:F+"Non-HTTP page ("+Z.location.protocol+" URL?) Review Flash player security settings for this special case:\nhttp://www.macromedia.com/support/documentation/en/flashplayer/help/settings_manager04.html\nMay need to add/allow path, eg. c:/sm2/ or /users/me/sm2/",waitFocus:F+"Special case: Waiting for SWF to load with window focus...",waitForever:F+"Waiting indefinitely for Flash (will recover if unblocked)...",waitSWF:F+"Waiting for 100% SWF load...",needFunction:F+"Function object expected for %s",badID:'Sound ID "%s" should be a string, starting with a non-numeric character',currentObj:F+"_debug(): Current sound objects",waitOnload:F+"Waiting for window.onload()",docLoaded:F+"Document already loaded",onload:F+"initComplete(): calling soundManager.onload()",onloadOK:aX+".onload() complete",didInit:F+"init(): Already called?",secNote:"Flash security note: Network/internet URLs will not load due to security restrictions. Access can be configured via Flash Player Global Security Settings Page: http://www.macromedia.com/support/documentation/en/flashplayer/help/settings_manager04.html",badRemove:F+"Failed to remove Flash node.",shutdown:aX+".disable(): Shutting down",queue:F+"Queueing %s handler",smError:"SMSound.load(): Exception: JS-Flash communication failed, or JS error.",fbTimeout:"No flash response, applying ."+E.swfTimedout+" CSS...",fbLoaded:"Flash loaded",fbHandler:F+"flashBlockHandler()",manURL:"SMSound.load(): Using manually-assigned URL",onURL:aX+".load(): current URL already assigned.",badFV:aX+'.flashVersion must be 8 or 9. "%s" is invalid. Reverting to %s.',as2loop:"Note: Setting stream:false so looping can work (flash 8 limitation)",noNSLoop:"Note: Looping not implemented for MovieStar formats",needfl9:"Note: Switching to flash 9, required for MP4 formats.",mfTimeout:"Setting flashLoadTimeout = 0 (infinite) for off-screen, mobile flash case",needFlash:F+"Fatal error: Flash is needed to play some required formats, but is not available.",gotFocus:F+"Got window focus.",policy:"Enabling usePolicyFile for data access",setup:aX+".setup(): allowed parameters: %s",setupError:aX+'.setup(): "%s" cannot be assigned with this method.',setupUndef:aX+'.setup(): Could not find option "%s"',setupLate:aX+".setup(): url, flashVersion and html5Test property changes will not take effect until reboot().",noURL:F+"Flash URL required. Call soundManager.setup({url:...}) to get started.",sm2Loaded:"SoundManager 2: Ready. "+String.fromCharCode(10003),reset:aX+".reset(): Removing event callbacks",mobileUA:"Mobile UA detected, preferring HTML5 by default.",globalHTML5:"Using singleton HTML5 Audio() pattern for this device."};be=function(){var bl,bm,bk,bo,bn;bl=R.call(arguments);bo=bl.shift();bn=(e&&e[bo]?e[bo]:"");if(bn&&bl&&bl.length){for(bm=0,bk=bl.length;bm<bk;bm++){bn=bn.replace("%s",bl[bm])}}return bn};A=function(bk){if(bh===8&&bk.loops>1&&bk.stream){V("as2loop");bk.stream=false}return bk};o=function(bl,bk){if(bl&&!bl.usePolicyFile&&(bl.onid3||bl.usePeakData||bl.useWaveformData||bl.useEQData)){ao._wD((bk||"")+be("policy"));bl.usePolicyFile=true}return bl};ar=function(bk){if(J&&console.warn!==d){console.warn(bk)}else{ao._wD(bk)}};T=function(){return false};W=function(bl){var bk;for(bk in bl){if(bl.hasOwnProperty(bk)&&typeof bl[bk]==="function"){bl[bk]=T}}bk=null};r=function(bk){if(bk===d){bk=false}if(a1||bk){ao.disable(bk)}};az=function(bk){var bl=null,bm;if(bk){if(bk.match(/\.swf(\?.*)?$/i)){bl=bk.substr(bk.toLowerCase().lastIndexOf(".swf?")+4);if(bl){return bk}}else{if(bk.lastIndexOf("/")!==bk.length-1){bk+="/"}}}bm=(bk&&bk.lastIndexOf("/")!==-1?bk.substr(0,bk.lastIndexOf("/")+1):"./")+ao.movieURL;if(ao.noSWFCache){bm+=("?ts="+new Date().getTime())}return bm};aV=function(){bh=parseInt(ao.flashVersion,10);if(bh!==8&&bh!==9){ao._wD(be("badFV",bh,X));ao.flashVersion=bh=X}var bk=(ao.debugMode||ao.debugFlash?"_debug.swf":".swf");if(ao.useHTML5Audio&&!ao.html5Only&&ao.audioFormats.mp4.required&&bh<9){ao._wD(be("needfl9"));ao.flashVersion=bh=9}ao.version=ao.versionNumber+(ao.html5Only?" (HTML5-only mode)":(bh===9?" (AS3/Flash 9)":" (AS2/Flash 8)"));if(bh>8){ao.defaultOptions=a2(ao.defaultOptions,ao.flash9Options);ao.features.buffering=true;ao.defaultOptions=a2(ao.defaultOptions,ao.movieStarOptions);ao.filePatterns.flash9=new RegExp("\\.(mp3|"+U.join("|")+")(\\?.*)?$","i");ao.features.movieStar=true}else{ao.features.movieStar=false}ao.filePattern=ao.filePatterns[(bh!==8?"flash9":"flash8")];ao.movieURL=(bh===8?"soundmanager2.swf":"soundmanager2_flash9.swf").replace(".swf",bk);ao.features.peakData=ao.features.waveformData=ao.features.eqData=(bh>8)};l=function(bk,bl){if(!ad){return false}ad._setPolling(bk,bl)};D=function(){if(ao.debugURLParam.test(x)){ao.debugMode=true}if(an(ao.debugID)){return false}var bp,bo,bk,bm,bl;if(ao.debugMode&&!an(ao.debugID)&&(!J||!ao.useConsole||!ao.consoleOnly)){bp=Z.createElement("div");bp.id=ao.debugID+"-toggle";bm={position:"fixed",bottom:"0px",right:"0px",width:"1.2em",height:"1.2em",lineHeight:"1.2em",margin:"2px",textAlign:"center",border:"1px solid #999",cursor:"pointer",background:"#fff",color:"#333",zIndex:10001};bp.appendChild(Z.createTextNode("-"));bp.onclick=aC;bp.title="Toggle SM2 debug console";if(au.match(/msie 6/i)){bp.style.position="absolute";bp.style.cursor="hand"}for(bl in bm){if(bm.hasOwnProperty(bl)){bp.style[bl]=bm[bl]}}bo=Z.createElement("div");bo.id=ao.debugID;bo.style.display=(ao.debugMode?"block":"none");if(ao.debugMode&&!an(bp.id)){try{bk=bf();bk.appendChild(bp)}catch(bn){throw new Error(be("domError")+" \n"+bn.toString())}bk.appendChild(bo)}}bk=null};I=this.getSoundById;V=function(bl,bk){return(!bl?"":ao._wD(be(bl),bk))};aC=function(){var bl=an(ao.debugID),bk=an(ao.debugID+"-toggle");if(!bl){return false}if(bg){bk.innerHTML="+";bl.style.display="none"}else{bk.innerHTML="-";bl.style.display="block"}bg=!bg};M=function(bn,bk,bl){if(c.sm2Debugger!==d){try{sm2Debugger.handleEvent(bn,bk,bl)}catch(bm){return false}}return true};m=function(){var bk=[];if(ao.debugMode){bk.push(E.sm2Debug)}if(ao.debugFlash){bk.push(E.flashDebug)}if(ao.useHighPerformance){bk.push(E.highPerf)}return bk.join(" ")};aA=function(){var bl=be("fbHandler"),bn=ao.getMoviePercent(),bm=E,bk={type:"FLASHBLOCK"};if(ao.html5Only){return false}if(!ao.ok()){if(B){ao.oMC.className=m()+" "+bm.swfDefault+" "+(bn===null?bm.swfTimedout:bm.swfError);ao._wD(bl+": "+be("fbTimeout")+(bn?" ("+be("fbLoaded")+")":""))}ao.didFlashBlock=true;aR({type:"ontimeout",ignoreInit:true,error:bk});aa(bk)}else{if(ao.didFlashBlock){ao._wD(bl+": Unblocked")}if(ao.oMC){ao.oMC.className=[m(),bm.swfDefault,bm.swfLoaded+(ao.didFlashBlock?" "+bm.swfUnblocked:"")].join(" ")}}};Y=function(bm,bl,bk){if(v[bm]===d){v[bm]=[]}v[bm].push({method:bl,scope:(bk||null),fired:false})};aR=function(bq){if(!bq){bq={type:(ao.ok()?"onready":"ontimeout")}}if(!ax&&bq&&!bq.ignoreInit){return false}if(bq.type==="ontimeout"&&(ao.ok()||(a1&&!bq.ignoreInit))){return false}var bm={success:(bq&&bq.ignoreInit?ao.ok():!a1)},bl=(bq&&bq.type?v[bq.type]||[]:[]),bk=[],br,bp,bo=[bm],bn=(B&&!ao.ok());if(bq.error){bo[0].error=bq.error}for(br=0,bp=bl.length;br<bp;br++){if(bl[br].fired!==true){bk.push(bl[br])}}if(bk.length){for(br=0,bp=bk.length;br<bp;br++){if(bk[br].scope){bk[br].method.apply(bk[br].scope,bo)}else{bk[br].method.apply(this,bo)}if(!bn){bk[br].fired=true}}}return true};s=function(){c.setTimeout(function(){if(ao.useFlashBlock){aA()}aR();if(typeof ao.onload==="function"){V("onload",1);ao.onload.apply(c);V("onloadOK",1)}if(ao.waitForWindowLoad){al.add(c,"load",s)}},1)};Q=function(){if(at!==d){return at}var bk=false,br=navigator,bn=br.plugins,bq,bm,bl,bp=c.ActiveXObject;if(bn&&bn.length){bm="application/x-shockwave-flash";bl=br.mimeTypes;if(bl&&bl[bm]&&bl[bm].enabledPlugin&&bl[bm].enabledPlugin.description){bk=true}}else{if(bp!==d&&!au.match(/MSAppHost/i)){try{bq=new bp("ShockwaveFlash.ShockwaveFlash")}catch(bo){bq=null}bk=(!!bq);bq=null}}at=bk;return bk};S=function(){var bl,bn,bk=ao.audioFormats,bm=(aW&&!!(au.match(/os (1|2|3_0|3_1)\s/i)));if(bm){ao.hasHTML5=false;ao.html5Only=true;if(ao.oMC){ao.oMC.style.display="none"}}else{if(ao.useHTML5Audio){if(!ao.html5||!ao.html5.canPlayType){ao._wD("SoundManager: No HTML5 Audio() support detected.");ao.hasHTML5=false}if(a5){ao._wD(F+"Note: Buggy HTML5 Audio in Safari on this OS X release, see https://bugs.webkit.org/show_bug.cgi?id=32159 - "+(!at?" would use flash fallback for MP3/MP4, but none detected.":"will use flash fallback for MP3/MP4, if available"),1)}}}if(ao.useHTML5Audio&&ao.hasHTML5){af=true;for(bn in bk){if(bk.hasOwnProperty(bn)){if(bk[bn].required){if(!ao.html5.canPlayType(bk[bn].type)){af=false;bl=true}else{if(ao.preferFlash&&(ao.flash[bn]||ao.flash[bk[bn].type])){bl=true}}}}}}if(ao.ignoreFlash){bl=false;af=true}ao.html5Only=(ao.hasHTML5&&ao.useHTML5Audio&&!bl);return(!ao.html5Only)};ab=function(bm){var bo,bl,bn=0,bk;if(bm instanceof Array){for(bo=0,bl=bm.length;bo<bl;bo++){if(bm[bo] instanceof Object){if(ao.canPlayMIME(bm[bo].type)){bn=bo;break}}else{if(ao.canPlayURL(bm[bo])){bn=bo;break}}}if(bm[bn].url){bm[bn]=bm[bn].url}bk=bm[bn]}else{bk=bm}return bk};aO=function(bk){if(!bk._hasTimer){bk._hasTimer=true;if(!aT&&ao.html5PollingInterval){if(bd===null&&K===0){bd=setInterval(ae,ao.html5PollingInterval)}K++}}};N=function(bk){if(bk._hasTimer){bk._hasTimer=false;if(!aT&&ao.html5PollingInterval){K--}}};ae=function(){var bk;if(bd!==null&&!K){clearInterval(bd);bd=null;return false}for(bk=ao.soundIDs.length-1;bk>=0;bk--){if(ao.sounds[ao.soundIDs[bk]].isHTML5&&ao.sounds[ao.soundIDs[bk]]._hasTimer){ao.sounds[ao.soundIDs[bk]]._onTimer()}}};aa=function(bk){bk=(bk!==d?bk:{});if(typeof ao.onerror==="function"){ao.onerror.apply(c,[{type:(bk.type!==d?bk.type:null)}])}if(bk.fatal!==d&&bk.fatal){ao.disable()}};C=function(){if(!a5||!Q()){return false}var bk=ao.audioFormats,bl,bm;for(bm in bk){if(bk.hasOwnProperty(bm)){if(bm==="mp3"||bm==="mp4"){ao._wD(aX+": Using flash fallback for "+bm+" format");ao.html5[bm]=false;if(bk[bm]&&bk[bm].related){for(bl=bk[bm].related.length-1;bl>=0;bl--){ao.html5[bk[bm].related[bl]]=false}}}}}};this._setSandboxType=function(bk){var bl=ao.sandbox;bl.type=bk;bl.description=bl.types[(bl.types[bk]!==d?bk:"unknown")];if(bl.type==="localWithFile"){bl.noRemote=true;bl.noLocal=false;V("secNote",2)}else{if(bl.type==="localWithNetwork"){bl.noRemote=false;bl.noLocal=true}else{if(bl.type==="localTrusted"){bl.noRemote=false;bl.noLocal=false}}}};this._externalInterfaceOK=function(bl){if(ao.swfLoaded){return false}var bm;M("swf",true);M("flashtojs",true);ao.swfLoaded=true;a9=false;if(a5){C()}if(!bl||bl.replace(/\+dev/i,"")!==ao.versionNumber.replace(/\+dev/i,"")){bm=aX+': Fatal: JavaScript file build "'+ao.versionNumber+'" does not match Flash SWF build "'+bl+'" at '+ao.url+". Ensure both are up-to-date.";setTimeout(function bk(){throw new Error(bm)},0);return false}setTimeout(aJ,a7?100:1)};H=function(bx,bo){if(ap&&aU){return false}function bz(){var bF=[],bH,bG=[],bE=" + ";bH="SoundManager "+ao.version+(!ao.html5Only&&ao.useHTML5Audio?(ao.hasHTML5?" + HTML5 audio":", no HTML5 audio support"):"");if(!ao.html5Only){if(ao.preferFlash){bF.push("preferFlash")}if(ao.useHighPerformance){bF.push("useHighPerformance")}if(ao.flashPollingInterval){bF.push("flashPollingInterval ("+ao.flashPollingInterval+"ms)")}if(ao.html5PollingInterval){bF.push("html5PollingInterval ("+ao.html5PollingInterval+"ms)")}if(ao.wmode){bF.push("wmode ("+ao.wmode+")")}if(ao.debugFlash){bF.push("debugFlash")}if(ao.useFlashBlock){bF.push("flashBlock")}}else{if(ao.html5PollingInterval){bF.push("html5PollingInterval ("+ao.html5PollingInterval+"ms)")}}if(bF.length){bG=bG.concat([bF.join(bE)])}ao._wD(bH+(bG.length?bE+bG.join(", "):""),1);aF()}if(ao.html5Only){aV();bz();ao.oMC=an(ao.movieID);aJ();ap=true;aU=true;return false}var bw=(bo||ao.url),bs=(ao.altURL||bw),bD="JS/Flash audio component (SoundManager 2)",bv=bf(),bu=m(),bk=null,bn=Z.getElementsByTagName("html")[0],bA,bp,bB,bt,br,bq,bm,bC;bk=(bn&&bn.dir&&bn.dir.match(/rtl/i));bx=(bx===d?ao.id:bx);function bl(bE,bF){return'<param name="'+bE+'" value="'+bF+'" />'}aV();ao.url=az(G?bw:bs);bo=ao.url;ao.wmode=(!ao.wmode&&ao.useHighPerformance?"transparent":ao.wmode);if(ao.wmode!==null&&(au.match(/msie 8/i)||(!a7&&!ao.useHighPerformance))&&navigator.platform.match(/win32|win64/i)){aq.push(e.spcWmode);ao.wmode=null}bA={name:bx,id:bx,src:bo,quality:"high",allowScriptAccess:ao.allowScriptAccess,bgcolor:ao.bgColor,pluginspage:aM+"www.macromedia.com/go/getflashplayer",title:bD,type:"application/x-shockwave-flash",wmode:ao.wmode,hasPriority:"true"};if(ao.debugFlash){bA.FlashVars="debug=1"}if(!ao.wmode){delete bA.wmode}if(a7){bp=Z.createElement("div");bt=['<object id="'+bx+'" data="'+bo+'" type="'+bA.type+'" title="'+bA.title+'" classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" codebase="'+aM+'download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,40,0">',bl("movie",bo),bl("AllowScriptAccess",ao.allowScriptAccess),bl("quality",bA.quality),(ao.wmode?bl("wmode",ao.wmode):""),bl("bgcolor",ao.bgColor),bl("hasPriority","true"),(ao.debugFlash?bl("FlashVars",bA.FlashVars):""),"</object>"].join("")}else{bp=Z.createElement("embed");for(bB in bA){if(bA.hasOwnProperty(bB)){bp.setAttribute(bB,bA[bB])}}}D();bu=m();bv=bf();if(bv){ao.oMC=(an(ao.movieID)||Z.createElement("div"));if(!ao.oMC.id){ao.oMC.id=ao.movieID;ao.oMC.className=E.swfDefault+" "+bu;bq=null;br=null;if(!ao.useFlashBlock){if(ao.useHighPerformance){bq={position:"fixed",width:"8px",height:"8px",bottom:"0px",left:"0px",overflow:"hidden"}}else{bq={position:"absolute",width:"6px",height:"6px",top:"-9999px",left:"-9999px"};if(bk){bq.left=Math.abs(parseInt(bq.left,10))+"px"}}}if(aG){ao.oMC.style.zIndex=10000}if(!ao.debugFlash){for(bm in bq){if(bq.hasOwnProperty(bm)){ao.oMC.style[bm]=bq[bm]}}}try{if(!a7){ao.oMC.appendChild(bp)}bv.appendChild(ao.oMC);if(a7){br=ao.oMC.appendChild(Z.createElement("div"));br.className=E.swfBox;br.innerHTML=bt}aU=true}catch(by){throw new Error(be("domError")+" \n"+by.toString())}}else{bC=ao.oMC.className;ao.oMC.className=(bC?bC+" ":E.swfDefault)+(bu?" "+bu:"");ao.oMC.appendChild(bp);if(a7){br=ao.oMC.appendChild(Z.createElement("div"));br.className=E.swfBox;br.innerHTML=bt}aU=true}}ap=true;bz();return true};j=function(){if(ao.html5Only){H();return false}if(ad){return false}if(!ao.url){V("noURL");return false}ad=ao.getMovie(ao.id);if(!ad){if(!aK){H(ao.id,ao.url)}else{if(!a7){ao.oMC.appendChild(aK)}else{ao.oMC.innerHTML=aj}aK=null;ap=true}ad=ao.getMovie(ao.id)}if(typeof ao.oninitmovie==="function"){setTimeout(ao.oninitmovie,1)}P();return true};y=function(){setTimeout(bc,1000)};ac=function(){c.setTimeout(function(){ar(F+"useFlashBlock is false, 100% HTML5 mode is possible. Rebooting with preferFlash: false...");ao.setup({preferFlash:false}).reboot();ao.didFlashBlock=true;ao.beginDelayedInit()},1)};bc=function(){var bl,bk=false;if(!ao.url){return false}if(aQ){return false}aQ=true;al.remove(c,"load",y);if(at&&a9&&!aB){V("waitFocus");return false}if(!ax){bl=ao.getMoviePercent();if(bl>0&&bl<100){bk=true}}setTimeout(function(){bl=ao.getMoviePercent();if(bk){aQ=false;ao._wD(be("waitSWF"));c.setTimeout(y,1);return false}if(!ax){ao._wD(aX+": No Flash response within expected time. Likely causes: "+(bl===0?"SWF load failed, ":"")+"Flash blocked or JS-Flash security error."+(ao.debugFlash?" "+be("checkSWF"):""),2);if(!G&&bl){V("localFail",2);if(!ao.debugFlash){V("tryDebug",2)}}if(bl===0){ao._wD(be("swf404",ao.url),1)}M("flashtojs",false,": Timed out"+G?" (Check flash security or flash blockers)":" (No plugin/missing SWF?)")}if(!ax&&ay){if(bl===null){if(ao.useFlashBlock||ao.flashLoadTimeout===0){if(ao.useFlashBlock){aA()}V("waitForever")}else{if(!ao.useFlashBlock&&af){ac()}else{V("waitForever");aR({type:"ontimeout",ignoreInit:true,error:{type:"INIT_FLASHBLOCK"}})}}}else{if(ao.flashLoadTimeout===0){V("waitForever")}else{if(!ao.useFlashBlock&&af){ac()}else{r(true)}}}}},ao.flashLoadTimeout)};t=function(){function bk(){al.remove(c,"focus",t)}if(aB||!a9){bk();return true}ay=true;aB=true;V("gotFocus");aQ=false;y();bk();return true};P=function(){if(aq.length){ao._wD("SoundManager 2: "+aq.join(" "),1);aq=[]}};aF=function(){P();var bl,bk=[];if(ao.useHTML5Audio&&ao.hasHTML5){for(bl in ao.audioFormats){if(ao.audioFormats.hasOwnProperty(bl)){bk.push(bl+" = "+ao.html5[bl]+(!ao.html5[bl]&&B&&ao.flash[bl]?" (using flash)":(ao.preferFlash&&ao.flash[bl]&&B?" (preferring flash)":(!ao.html5[bl]?" ("+(ao.audioFormats[bl].required?"required, ":"")+"and no flash support)":""))))}}ao._wD("SoundManager 2 HTML5 support: "+bk.join(", "),1)}};w=function(bn){if(ax){return false}if(ao.html5Only){V("sm2Loaded",1);ax=true;s();M("onload",true);return true}var bl=(ao.useFlashBlock&&ao.flashLoadTimeout&&!ao.getMoviePercent()),bk=true,bm;if(!bl){ax=true}bm={type:(!at&&B?"NO_FLASH":"INIT_TIMEOUT")};ao._wD("SoundManager 2 "+(a1?"failed to load":"loaded")+" ("+(a1?"Flash security/load error":"OK")+") "+String.fromCharCode(a1?10006:10003),a1?2:1);if(a1||bn){if(ao.useFlashBlock&&ao.oMC){ao.oMC.className=m()+" "+(ao.getMoviePercent()===null?E.swfTimedout:E.swfError)}aR({type:"ontimeout",error:bm,ignoreInit:true});M("onload",false);aa(bm);bk=false}else{M("onload",true)}if(!a1){if(ao.waitForWindowLoad&&!bb){V("waitOnload");al.add(c,"load",s)}else{if(ao.waitForWindowLoad&&bb){V("docLoaded")}s()}}return bk};z=function(){var bk,bl=ao.setupOptions;for(bk in bl){if(bl.hasOwnProperty(bk)){if(ao[bk]===d){ao[bk]=bl[bk]}else{if(ao[bk]!==bl[bk]){ao.setupOptions[bk]=ao[bk]}}}}};aJ=function(){if(ax){V("didInit");return false}function bk(){al.remove(c,"load",ao.beginDelayedInit)}if(ao.html5Only){if(!ax){bk();ao.enabled=true;w()}return true}j();try{ad._externalInterfaceTest(false);l(true,(ao.flashPollingInterval||(ao.useHighPerformance?10:50)));if(!ao.debugMode){ad._disableDebug()}ao.enabled=true;M("jstoflash",true);if(!ao.html5Only){al.add(c,"unload",T)}}catch(bl){ao._wD("js/flash exception: "+bl.toString());M("jstoflash",false);aa({type:"JS_TO_FLASH_EXCEPTION",fatal:true});r(true);w();return false}w();bk();return true};L=function(){if(p){return false}p=true;z();D();(function(){var bn="sm2-usehtml5audio=",bl="sm2-preferflash=",bk=null,bo=null,bm=x.toLowerCase();if(bm.indexOf(bn)!==-1){bk=(bm.charAt(bm.indexOf(bn)+bn.length)==="1");if(J){console.log((bk?"Enabling ":"Disabling ")+"useHTML5Audio via URL parameter")}ao.setup({useHTML5Audio:bk})}if(bm.indexOf(bl)!==-1){bo=(bm.charAt(bm.indexOf(bl)+bl.length)==="1");if(J){console.log((bo?"Enabling ":"Disabling ")+"preferFlash via URL parameter")}ao.setup({preferFlash:bo})}}());if(!at&&ao.hasHTML5){ao._wD("SoundManager 2: No Flash detected"+(!ao.useHTML5Audio?", enabling HTML5.":". Trying HTML5-only mode."),1);ao.setup({useHTML5Audio:true,preferFlash:false})}aN();if(!at&&B){aq.push(e.needFlash);ao.setup({flashLoadTimeout:1})}if(Z.removeEventListener){Z.removeEventListener("DOMContentLoaded",L,false)}j();return true};O=function(){if(Z.readyState==="complete"){L();Z.detachEvent("onreadystatechange",O)}return true};bj=function(){bb=true;L();al.remove(c,"load",bj)};aD=function(){if(aT){if(!ao.setupOptions.useHTML5Audio||ao.setupOptions.preferFlash){aq.push(e.mobileUA)}ao.setupOptions.useHTML5Audio=true;ao.setupOptions.preferFlash=false;if(aW||(av&&!au.match(/android\s2\.3/i))){aq.push(e.globalHTML5);if(aW){ao.ignoreFlash=true}aZ=true}}};aD();Q();al.add(c,"focus",t);al.add(c,"load",y);al.add(c,"load",bj);if(Z.addEventListener){Z.addEventListener("DOMContentLoaded",L,false)}else{if(Z.attachEvent){Z.attachEvent("onreadystatechange",O)}else{M("onload",false);aa({type:"NO_DOM2_EVENTS",fatal:true})}}}if(c.SM2_DEFER===undefined||!SM2_DEFER){b=new a()}if(typeof module==="object"&&module&&typeof module.exports==="object"){c.soundManager=b;module.exports.SoundManager=a;module.exports.soundManager=b}else{if(typeof define==="function"&&define.amd){define("SoundManager",[],function(){return{SoundManager:a,soundManager:b}})}else{c.SoundManager=a;c.soundManager=b}}}(window));
var threeSixtyPlayer,ThreeSixtyPlayer;(function(b){function a(){var o=this,i=this,g=soundManager,j=navigator.userAgent,f=(j.match(/msie/i)),e=(j.match(/opera/i)),k=(j.match(/safari/i)),c=(j.match(/chrome/i)),d=(j.match(/firefox/i)),h=(j.match(/ipad|iphone/i)),l=(typeof b.G_vmlCanvasManager==="undefined"&&typeof document.createElement("canvas").getContext("2d")!=="undefined"),n=(e||c?359.9:360),m=(navigator.userAgent.match(/msie [678]/i)?1:2);this.excludeClass="threesixty-exclude";this.links=[];this.sounds=[];this.soundsByURL=[];this.indexByURL=[];this.lastSound=null;this.lastTouchedSound=null;this.soundCount=0;this.oUITemplate=null;this.oUIImageMap=null;this.vuMeter=null;this.callbackCount=0;this.peakDataHistory=[];this.config={playNext:false,autoPlay:false,allowMultiple:false,loadRingColor:"#ccc",playRingColor:"#000",backgroundRingColor:"#eee",segmentRingColor:"rgba(255,255,255,0.33)",segmentRingColorAlt:"rgba(0,0,0,0.1)",loadRingColorMetadata:"#ddd",playRingColorMetadata:"rgba(128,192,256,0.9)",circleDiameter:null,circleRadius:null,animDuration:500,animTransition:b.Animator.tx.bouncy,showHMSTime:false,scaleFont:true,useWaveformData:false,waveformDataColor:"#0099ff",waveformDataDownsample:3,waveformDataOutside:false,waveformDataConstrain:false,waveformDataLineRatio:0.64,useEQData:false,eqDataColor:"#339933",eqDataDownsample:4,eqDataOutside:true,eqDataLineRatio:0.54,usePeakData:true,peakDataColor:"#ff33ff",peakDataOutside:true,peakDataLineRatio:0.5,useAmplifier:true,fontSizeMax:null,scaleArcWidth:1,useFavIcon:false};this.css={sDefault:"sm2_link",sBuffering:"sm2_buffering",sPlaying:"sm2_playing",sPaused:"sm2_paused"};this.addEventHandler=(typeof b.addEventListener!=="undefined"?function(r,q,p){return r.addEventListener(q,p,false)}:function(r,q,p){r.attachEvent("on"+q,p)});this.removeEventHandler=(typeof b.removeEventListener!=="undefined"?function(r,q,p){return r.removeEventListener(q,p,false)}:function(r,q,p){return r.detachEvent("on"+q,p)});this.hasClass=function(q,p){return typeof(q.className)!=="undefined"?q.className.match(new RegExp("(\\s|^)"+p+"(\\s|$)")):false};this.addClass=function(q,p){if(!q||!p||o.hasClass(q,p)){return false}q.className=(q.className?q.className+" ":"")+p};this.removeClass=function(q,p){if(!q||!p||!o.hasClass(q,p)){return false}q.className=q.className.replace(new RegExp("( "+p+")|("+p+")","g"),"")};this.getElementsByClassName=function(t,p,w){var v=(w||document),u=[],s,r,q=[];if(typeof p!=="undefined"&&typeof p!=="string"){for(s=p.length;s--;){if(!q||!q[p[s]]){q[p[s]]=v.getElementsByTagName(p[s])}}}else{if(p){q=v.getElementsByTagName(p)}else{q=v.all||v.getElementsByTagName("*")}}if(typeof(p)!=="string"){for(s=p.length;s--;){for(r=q[p[s]].length;r--;){if(o.hasClass(q[p[s]][r],t)){u.push(q[p[s]][r])}}}}else{for(s=0;s<q.length;s++){if(o.hasClass(q[s],t)){u.push(q[s])}}}return u};this.getParentByNodeName=function(q,p){if(!q||!p){return false}p=p.toLowerCase();while(q.parentNode&&p!==q.parentNode.nodeName.toLowerCase()){q=q.parentNode}return(q.parentNode&&p===q.parentNode.nodeName.toLowerCase()?q.parentNode:null)};this.getParentByClassName=function(q,p){if(!q||!p){return false}while(q.parentNode&&!o.hasClass(q.parentNode,p)){q=q.parentNode}return(q.parentNode&&o.hasClass(q.parentNode,p)?q.parentNode:null)};this.getSoundByURL=function(p){return(typeof o.soundsByURL[p]!=="undefined"?o.soundsByURL[p]:null)};this.isChildOfNode=function(q,p){if(!q||!q.parentNode){return false}p=p.toLowerCase();do{q=q.parentNode}while(q&&q.parentNode&&q.nodeName.toLowerCase()!==p);return(q&&q.nodeName.toLowerCase()===p?q:null)};this.isChildOfClass=function(q,p){if(!q||!p){return false}while(q.parentNode&&!o.hasClass(q,p)){q=o.findParent(q)}return(o.hasClass(q,p))};this.findParent=function(p){if(!p||!p.parentNode){return false}p=p.parentNode;if(p.nodeType===2){while(p&&p.parentNode&&p.parentNode.nodeType===2){p=p.parentNode}}return p};this.getStyle=function(r,p){try{if(r.currentStyle){return r.currentStyle[p]}else{if(b.getComputedStyle){return document.defaultView.getComputedStyle(r,null).getPropertyValue(p)}}}catch(q){}return null};this.findXY=function(q){var r=0,p=0;do{r+=q.offsetLeft;p+=q.offsetTop}while(!!(q=q.offsetParent));return[r,p]};this.getMouseXY=function(p){p=p?p:b.event;if(h&&p.touches){p=p.touches[0]}if(p.pageX||p.pageY){return[p.pageX,p.pageY]}else{if(p.clientX||p.clientY){return[p.clientX+o.getScrollLeft(),p.clientY+o.getScrollTop()]}}};this.getScrollLeft=function(){return(document.body.scrollLeft+document.documentElement.scrollLeft)};this.getScrollTop=function(){return(document.body.scrollTop+document.documentElement.scrollTop)};this.events={play:function(){i.removeClass(this._360data.oUIBox,this._360data.className);this._360data.className=i.css.sPlaying;i.addClass(this._360data.oUIBox,this._360data.className);o.fanOut(this)},stop:function(){i.removeClass(this._360data.oUIBox,this._360data.className);this._360data.className="";o.fanIn(this)},pause:function(){i.removeClass(this._360data.oUIBox,this._360data.className);this._360data.className=i.css.sPaused;i.addClass(this._360data.oUIBox,this._360data.className)},resume:function(){i.removeClass(this._360data.oUIBox,this._360data.className);this._360data.className=i.css.sPlaying;i.addClass(this._360data.oUIBox,this._360data.className)},finish:function(){var p;i.removeClass(this._360data.oUIBox,this._360data.className);this._360data.className="";this._360data.didFinish=true;o.fanIn(this);if(i.config.playNext){p=(i.indexByURL[this._360data.oLink.href]+1);if(p<i.links.length){i.handleClick({target:i.links[p]})}}},whileloading:function(){if(this.paused){o.updatePlaying.apply(this)}},whileplaying:function(){o.updatePlaying.apply(this);this._360data.fps++},bufferchange:function(){if(this.isBuffering){i.addClass(this._360data.oUIBox,i.css.sBuffering)}else{i.removeClass(this._360data.oUIBox,i.css.sBuffering)}}};this.stopEvent=function(p){if(typeof p!=="undefined"&&typeof p.preventDefault!=="undefined"){p.preventDefault()}else{if(typeof b.event!=="undefined"&&typeof b.event.returnValue!=="undefined"){b.event.returnValue=false}}return false};this.getTheDamnLink=(f)?function(p){return(p&&p.target?p.target:b.event.srcElement)}:function(p){return p.target};this.handleClick=function(u){if(u.button>1){return true}var p=o.getTheDamnLink(u),q,v,s,r,w,t,x;if(p.nodeName.toLowerCase()!=="a"){p=o.isChildOfNode(p,"a");if(!p){return true}}if(!o.isChildOfClass(p,"ui360")){return true}v=p.getAttribute("href");if(!p.href||!g.canPlayLink(p)||o.hasClass(p,o.excludeClass)){return true}g._writeDebug("handleClick()");s=(p.href);r=o.getSoundByURL(s);if(r){if(r===o.lastSound){r.togglePause()}else{r.togglePause();g._writeDebug("sound different than last sound: "+o.lastSound.id);if(!o.config.allowMultiple&&o.lastSound){o.stopSound(o.lastSound)}}}else{w=p.parentNode;t=(o.getElementsByClassName("ui360-vis","div",w.parentNode).length);r=g.createSound({id:"ui360Sound"+(o.soundCount++),url:s,onplay:o.events.play,onstop:o.events.stop,onpause:o.events.pause,onresume:o.events.resume,onfinish:o.events.finish,onbufferchange:o.events.bufferchange,type:(p.type||null),whileloading:o.events.whileloading,whileplaying:o.events.whileplaying,useWaveformData:(t&&o.config.useWaveformData),useEQData:(t&&o.config.useEQData),usePeakData:(t&&o.config.usePeakData)});x=parseInt(o.getElementsByClassName("sm2-360ui","div",w)[0].offsetWidth*m,10);q=o.getElementsByClassName("sm2-canvas","canvas",w),r._360data={oUI360:o.getParentByClassName(p,"ui360"),oLink:p,className:o.css.sPlaying,oUIBox:o.getElementsByClassName("sm2-360ui","div",w)[0],oCanvas:q[q.length-1],oButton:o.getElementsByClassName("sm2-360btn","span",w)[0],oTiming:o.getElementsByClassName("sm2-timing","div",w)[0],oCover:o.getElementsByClassName("sm2-cover","div",w)[0],circleDiameter:x,circleRadius:x/2,lastTime:null,didFinish:null,pauseCount:0,radius:0,fontSize:1,fontSizeMax:o.config.fontSizeMax,scaleFont:(t&&o.config.scaleFont),showHMSTime:t,amplifier:(t&&o.config.usePeakData?0.9:1),radiusMax:x*0.175,width:0,widthMax:x*0.4,lastValues:{bytesLoaded:0,bytesTotal:0,position:0,durationEstimate:0},animating:false,oAnim:new b.Animator({duration:o.config.animDuration,transition:o.config.animTransition,onComplete:function(){}}),oAnimProgress:function(z){var y=this;y._360data.radius=parseInt(y._360data.radiusMax*y._360data.amplifier*z,10);y._360data.width=parseInt(y._360data.widthMax*y._360data.amplifier*z,10);if(y._360data.scaleFont&&y._360data.fontSizeMax!==null){y._360data.oTiming.style.fontSize=parseInt(Math.max(1,y._360data.fontSizeMax*z),10)+"px";y._360data.oTiming.style.opacity=z}if(y.paused||y.playState===0||y._360data.lastValues.bytesLoaded===0||y._360data.lastValues.position===0){o.updatePlaying.apply(y)}},fps:0};if(typeof o.Metadata!=="undefined"&&o.getElementsByClassName("metadata","div",r._360data.oUI360).length){r._360data.metadata=new o.Metadata(r,o)}if(r._360data.scaleFont&&r._360data.fontSizeMax!==null){r._360data.oTiming.style.fontSize="1px"}r._360data.oAnim.addSubject(r._360data.oAnimProgress,r);o.refreshCoords(r);o.updatePlaying.apply(r);o.soundsByURL[s]=r;o.sounds.push(r);if(!o.config.allowMultiple&&o.lastSound){o.stopSound(o.lastSound)}r.play()}o.lastSound=r;if(typeof u!=="undefined"&&typeof u.preventDefault!=="undefined"){u.preventDefault()}else{if(typeof b.event!=="undefined"){b.event.returnValue=false}}return false};this.fanOut=function(q){var p=q;if(p._360data.animating===1){return false}p._360data.animating=0;soundManager._writeDebug("fanOut: "+p.id+": "+p._360data.oLink.href);p._360data.oAnim.seekTo(1);b.setTimeout(function(){p._360data.animating=0},o.config.animDuration+20)};this.fanIn=function(q){var p=q;if(p._360data.animating===-1){return false}p._360data.animating=-1;soundManager._writeDebug("fanIn: "+p.id+": "+p._360data.oLink.href);p._360data.oAnim.seekTo(0);b.setTimeout(function(){p._360data.didFinish=false;p._360data.animating=0;o.resetLastValues(p)},o.config.animDuration+20)};this.resetLastValues=function(p){p._360data.lastValues.position=0};this.refreshCoords=function(p){p._360data.canvasXY=o.findXY(p._360data.oCanvas);p._360data.canvasMid=[p._360data.circleRadius,p._360data.circleRadius];p._360data.canvasMidXY=[p._360data.canvasXY[0]+p._360data.canvasMid[0],p._360data.canvasXY[1]+p._360data.canvasMid[1]]};this.stopSound=function(p){soundManager._writeDebug("stopSound: "+p.id);soundManager.stop(p.id);if(!h){soundManager.unload(p.id)}};this.buttonClick=function(p){var q=p?(p.target?p.target:p.srcElement):b.event.srcElement;o.handleClick({target:o.getParentByClassName(q,"sm2-360ui").nextSibling});return false};this.buttonMouseDown=function(p){if(!h){document.onmousemove=function(q){o.mouseDown(q)}}else{o.addEventHandler(document,"touchmove",o.mouseDown)}o.stopEvent(p);return false};this.mouseDown=function(s){if(!h&&s.button>1){return true}if(!o.lastSound){o.stopEvent(s);return false}var p=s?s:b.event,r,q,t;if(h&&p.touches){p=p.touches[0]}r=(p.target||p.srcElement);q=o.getSoundByURL(o.getElementsByClassName("sm2_link","a",o.getParentByClassName(r,"ui360"))[0].href);o.lastTouchedSound=q;o.refreshCoords(q);t=q._360data;o.addClass(t.oUIBox,"sm2_dragging");t.pauseCount=(o.lastTouchedSound.paused?1:0);o.mmh(s?s:b.event);if(h){o.removeEventHandler(document,"touchmove",o.mouseDown);o.addEventHandler(document,"touchmove",o.mmh);o.addEventHandler(document,"touchend",o.mouseUp)}else{document.onmousemove=o.mmh;document.onmouseup=o.mouseUp}o.stopEvent(s);return false};this.mouseUp=function(p){var q=o.lastTouchedSound._360data;o.removeClass(q.oUIBox,"sm2_dragging");if(q.pauseCount===0){o.lastTouchedSound.resume()}if(!h){document.onmousemove=null;document.onmouseup=null}else{o.removeEventHandler(document,"touchmove",o.mmh);o.removeEventHandler(document,"touchend",o.mouseUP)}};this.mmh=function(u){if(typeof u==="undefined"){u=b.event}var s=o.lastTouchedSound,t=o.getMouseXY(u),q=t[0],w=t[1],r=q-s._360data.canvasMidXY[0],p=w-s._360data.canvasMidXY[1],v=Math.floor(n-(o.rad2deg(Math.atan2(r,p))+180));s.setPosition(s.durationEstimate*(v/n));o.stopEvent(u);return false};this.drawSolidArc=function(u,t,v,p,s,w,D){var C=v,B=v,r=u,E,z,q,A;if(r.getContext){E=r.getContext("2d")}u=E;if(!D){o.clearCanvas(r)}if(t){E.fillStyle=t}u.beginPath();if(isNaN(s)){s=0}z=v-p;q=(e||k);if(!q||(q&&v>0)){u.arc(0,0,v,w,s,false);A=o.getArcEndpointCoords(z,s);u.lineTo(A.x,A.y);u.arc(0,0,z,s,w,true);u.closePath();u.fill()}};this.getArcEndpointCoords=function(p,q){return{x:p*Math.cos(q),y:p*Math.sin(q)}};this.deg2rad=function(p){return(p*Math.PI/180)};this.rad2deg=function(p){return(p*180/Math.PI)};this.getTime=function(q,r){var p=Math.floor(q/1000),s=Math.floor(p/60),t=p-(s*60);return(r?(s+":"+(t<10?"0"+t:t)):{min:s,sec:t})};this.clearCanvas=function(t){var r=t,q=null,s,p;if(r.getContext){q=r.getContext("2d")}if(q){s=r.offsetWidth;p=r.offsetHeight;q.clearRect(-(s/2),-(p/2),s,p)}};this.updatePlaying=function(){var p=(this._360data.showHMSTime?o.getTime(this.position,true):parseInt(this.position/1000,10));var q=o.config.scaleArcWidth;if(this.bytesLoaded){this._360data.lastValues.bytesLoaded=this.bytesLoaded;this._360data.lastValues.bytesTotal=this.bytesTotal}if(this.position){this._360data.lastValues.position=this.position}if(this.durationEstimate){this._360data.lastValues.durationEstimate=this.durationEstimate}o.drawSolidArc(this._360data.oCanvas,o.config.backgroundRingColor,this._360data.width,this._360data.radius*q,o.deg2rad(n),false);o.drawSolidArc(this._360data.oCanvas,(this._360data.metadata?o.config.loadRingColorMetadata:o.config.loadRingColor),this._360data.width,this._360data.radius*q,o.deg2rad(n*(this._360data.lastValues.bytesLoaded/this._360data.lastValues.bytesTotal)),0,true);if(this._360data.lastValues.position!==0){o.drawSolidArc(this._360data.oCanvas,(this._360data.metadata?o.config.playRingColorMetadata:o.config.playRingColor),this._360data.width,this._360data.radius*q,o.deg2rad((this._360data.didFinish===1?n:n*(this._360data.lastValues.position/this._360data.lastValues.durationEstimate))),0,true)}if(this._360data.metadata){this._360data.metadata.events.whileplaying()}if(p!==this._360data.lastTime){this._360data.lastTime=p;this._360data.oTiming.innerHTML=p}if((this.instanceOptions.useWaveformData||this.instanceOptions.useEQData)&&l){o.updateWaveform(this)}if(o.config.useFavIcon&&o.vuMeter){o.vuMeter.updateVU(this)}};this.updateWaveform=function(x){if((!o.config.useWaveformData&&!o.config.useEQData)||(!g.features.waveformData&&!g.features.eqData)){return false}if(!x.waveformData.left.length&&!x.eqData.length&&!x.peakData.left){return false}var z=x._360data.oCanvas.getContext("2d"),J=0,I=parseInt(x._360data.circleDiameter/2,10),M=I/2,p=1,q=1,w=0,s=I,G,F,L,K,u,A,E,D,r,t,H,y,C,N,B,v;if(o.config.useWaveformData){K=o.config.waveformDataDownsample;K=Math.max(1,K);u=256;A=(u/K);E=0;D=0;r=null;t=(o.config.waveformDataOutside?1:(o.config.waveformDataConstrain?0.5:0.565));M=(o.config.waveformDataOutside?0.7:0.75);H=o.deg2rad((360/A)*o.config.waveformDataLineRatio);for(G=0;G<u;G+=K){E=o.deg2rad(360*(G/(A)*1/K));D=E+H;r=x.waveformData.left[G];if(r<0&&o.config.waveformDataConstrain){r=Math.abs(r)}o.drawSolidArc(x._360data.oCanvas,o.config.waveformDataColor,x._360data.width*t*(2-o.config.scaleArcWidth),x._360data.radius*M*1.25*r,D,E,true)}}if(o.config.useEQData){K=o.config.eqDataDownsample;y=0;K=Math.max(1,K);C=192;A=(C/K);t=(o.config.eqDataOutside?1:0.565);L=(o.config.eqDataOutside?-1:1);M=(o.config.eqDataOutside?0.5:0.75);E=0;D=0;H=o.deg2rad((360/A)*o.config.eqDataLineRatio);N=o.deg2rad((x._360data.didFinish===1?360:360*(x._360data.lastValues.position/x._360data.lastValues.durationEstimate)));F=0;B=0;for(G=0;G<C;G+=K){E=o.deg2rad(360*(G/C));D=E+H;o.drawSolidArc(x._360data.oCanvas,(D>N?o.config.eqDataColor:o.config.playRingColor),x._360data.width*t,x._360data.radius*M*(x.eqData.left[G]*L),D,E,true)}}if(o.config.usePeakData){if(!x._360data.animating){v=(x.peakData.left||x.peakData.right);C=3;for(G=0;G<C;G++){v=(v||x.eqData[G])}x._360data.amplifier=(o.config.useAmplifier?(0.9+(v*0.1)):1);x._360data.radiusMax=x._360data.circleDiameter*0.175*x._360data.amplifier;x._360data.widthMax=x._360data.circleDiameter*0.4*x._360data.amplifier;x._360data.radius=parseInt(x._360data.radiusMax*x._360data.amplifier,10);x._360data.width=parseInt(x._360data.widthMax*x._360data.amplifier,10)}}};this.getUIHTML=function(p){return['<canvas class="sm2-canvas" width="'+p+'" height="'+p+'"></canvas>',' <span class="sm2-360btn sm2-360btn-default"></span>',' <div class="sm2-timing'+(navigator.userAgent.match(/safari/i)?" alignTweak":"")+'"></div>',' <div class="sm2-cover"></div>']};this.uiTest=function(q){var t=document.createElement("div"),r,x,v,s,p,y,z,w,u;t.className="sm2-360ui";r=document.createElement("div");r.className="ui360"+(q?" "+q:"");x=r.appendChild(t.cloneNode(true));r.style.position="absolute";r.style.left="-9999px";v=document.body.appendChild(r);s=x.offsetWidth*m;p=o.getUIHTML(s);x.innerHTML=p[1]+p[2]+p[3];y=parseInt(s,10);z=parseInt(y/2,10);u=o.getElementsByClassName("sm2-timing","div",v)[0];w=parseInt(o.getStyle(u,"font-size"),10);if(isNaN(w)){w=null}r.parentNode.removeChild(r);p=r=x=v=null;return{circleDiameter:y,circleRadius:z,fontSizeMax:w}};this.init=function(){g._writeDebug("threeSixtyPlayer.init()");var u=o.getElementsByClassName("ui360","div"),D,C,H=[],x=false,w=0,G,v,r,B,t,q,s,y,E,p,z,A,F;for(D=0,C=u.length;D<C;D++){H.push(u[D].getElementsByTagName("a")[0]);u[D].style.backgroundImage="none"}o.oUITemplate=document.createElement("div");o.oUITemplate.className="sm2-360ui";o.oUITemplateVis=document.createElement("div");o.oUITemplateVis.className="sm2-360ui";s=o.uiTest();o.config.circleDiameter=s.circleDiameter;o.config.circleRadius=s.circleRadius;y=o.uiTest("ui360-vis");o.config.fontSizeMax=y.fontSizeMax;o.oUITemplate.innerHTML=o.getUIHTML(o.config.circleDiameter).join("");o.oUITemplateVis.innerHTML=o.getUIHTML(y.circleDiameter).join("");for(D=0,C=H.length;D<C;D++){if(g.canPlayLink(H[D])&&!o.hasClass(H[D],o.excludeClass)&&!o.hasClass(H[D],o.css.sDefault)){o.addClass(H[D],o.css.sDefault);o.links[w]=(H[D]);o.indexByURL[H[D].href]=w;w++;x=o.hasClass(H[D].parentNode,"ui360-vis");t=(x?y:s).circleDiameter;q=(x?y:s).circleRadius;E=H[D].parentNode.insertBefore((x?o.oUITemplateVis:o.oUITemplate).cloneNode(true),H[D]);if(f&&typeof b.G_vmlCanvasManager!=="undefined"){z=H[D].parentNode;A=document.createElement("canvas");A.className="sm2-canvas";F="sm2_canvas_"+D+(new Date().getTime());A.id=F;A.width=t;A.height=t;E.appendChild(A);b.G_vmlCanvasManager.initElement(A);v=document.getElementById(F);G=v.parentNode.getElementsByTagName("canvas");if(G.length>1){v=G[G.length-1]}}else{v=H[D].parentNode.getElementsByTagName("canvas")[0]}if(m>1){o.addClass(v,"hi-dpi")}B=o.getElementsByClassName("sm2-cover","div",H[D].parentNode)[0];p=H[D].parentNode.getElementsByTagName("span")[0];o.addEventHandler(p,"click",o.buttonClick);if(!h){o.addEventHandler(B,"mousedown",o.mouseDown)}else{o.addEventHandler(B,"touchstart",o.mouseDown)}r=v.getContext("2d");r.translate(q,q);r.rotate(o.deg2rad(-90))}}if(w>0){o.addEventHandler(document,"click",o.handleClick);if(o.config.autoPlay){o.handleClick({target:o.links[0],preventDefault:function(){}})}}g._writeDebug("threeSixtyPlayer.init(): Found "+w+" relevant items.");if(o.config.useFavIcon&&typeof this.VUMeter!=="undefined"){this.vuMeter=new this.VUMeter(this)}}}a.prototype.VUMeter=function(g){var d=g,f=this,c=document.getElementsByTagName("head")[0],e=(navigator.userAgent.match(/opera/i)),h=(navigator.userAgent.match(/firefox/i));this.vuMeterData=[];this.vuDataCanvas=null;this.setPageIcon=function(j){if(!d.config.useFavIcon||!d.config.usePeakData||!j){return false}var i=document.getElementById("sm2-favicon");if(i){c.removeChild(i);i=null}if(!i){i=document.createElement("link");i.id="sm2-favicon";i.rel="shortcut icon";i.type="image/png";i.href=j;document.getElementsByTagName("head")[0].appendChild(i)}};this.resetPageIcon=function(){if(!d.config.useFavIcon){return false}var i=document.getElementById("favicon");if(i){i.href="/favicon.ico"}};this.updateVU=function(i){if(soundManager.flashVersion>=9&&d.config.useFavIcon&&d.config.usePeakData){f.setPageIcon(f.vuMeterData[parseInt(16*i.peakData.left,10)][parseInt(16*i.peakData.right,10)])}};this.createVUData=function(){var n=0,m=0,l=f.vuDataCanvas.getContext("2d"),p=l.createLinearGradient(0,16,0,0),k=l.createLinearGradient(0,16,0,0),o="rgba(0,0,0,0.2)";p.addColorStop(0,"rgb(0,192,0)");p.addColorStop(0.3,"rgb(0,255,0)");p.addColorStop(0.625,"rgb(255,255,0)");p.addColorStop(0.85,"rgb(255,0,0)");k.addColorStop(0,o);k.addColorStop(1,"rgba(0,0,0,0.5)");for(n=0;n<16;n++){f.vuMeterData[n]=[]}for(n=0;n<16;n++){for(m=0;m<16;m++){f.vuDataCanvas.setAttribute("width",16);f.vuDataCanvas.setAttribute("height",16);l.fillStyle=k;l.fillRect(0,0,7,15);l.fillRect(8,0,7,15);l.fillStyle=p;l.fillRect(0,15-n,7,16-(16-n));l.fillRect(8,15-m,7,16-(16-m));l.clearRect(0,3,16,1);l.clearRect(0,7,16,1);l.clearRect(0,11,16,1);f.vuMeterData[n][m]=f.vuDataCanvas.toDataURL("image/png")}}};this.testCanvas=function(){var l=document.createElement("canvas"),i=null,j;if(!l||typeof l.getContext==="undefined"){return null}i=l.getContext("2d");if(!i||typeof l.toDataURL!=="function"){return null}try{j=l.toDataURL("image/png")}catch(k){return null}return l};this.init=function(){if(d.config.useFavIcon){f.vuDataCanvas=f.testCanvas();if(f.vuDataCanvas&&(h||e)){f.createVUData()}else{d.config.useFavIcon=false}}};this.init()};a.prototype.Metadata=function(l,d){soundManager._wD("Metadata()");var k=this,j=l._360data.oUI360,e=j.getElementsByTagName("ul")[0],h=e.getElementsByTagName("li"),c=(navigator.userAgent.match(/firefox/i)),f=false,g,m;this.lastWPExec=0;this.refreshInterval=250;this.totalTime=0;this.events={whileplaying:function(){var r=l._360data.width,n=l._360data.radius,s=(l.durationEstimate||(k.totalTime*1000)),p=null,q,o,t;for(q=0,o=k.data.length;q<o;q++){p=(q%2===0);d.drawSolidArc(l._360data.oCanvas,(p?d.config.segmentRingColorAlt:d.config.segmentRingColor),p?r:r,p?n/2:n/2,d.deg2rad(360*(k.data[q].endTimeMS/s)),d.deg2rad(360*((k.data[q].startTimeMS||1)/s)),true)}t=new Date();if(t-k.lastWPExec>k.refreshInterval){k.refresh();k.lastWPExec=t}}};this.refresh=function(){var r,p,o=null,n=l.position,q=l._360data.metadata.data;for(r=0,p=q.length;r<p;r++){if(n>=q[r].startTimeMS&&n<=q[r].endTimeMS){o=r;break}}if(o!==q.currentItem&&o<q.length){l._360data.oLink.innerHTML=q.mainTitle+' <span class="metadata"><span class="sm2_divider"> | </span><span class="sm2_metadata">'+q[o].title+"</span></span>";q.currentItem=o}};this.strToTime=function(n){var o=n.split(":"),q=0,p;for(p=o.length;p--;){q+=parseInt(o[p],10)*Math.pow(60,o.length-1-p)}return q};this.data=[];this.data.givenDuration=null;this.data.currentItem=null;this.data.mainTitle=l._360data.oLink.innerHTML;for(g=0;g<h.length;g++){this.data[g]={o:null,title:h[g].getElementsByTagName("p")[0].innerHTML,startTime:h[g].getElementsByTagName("span")[0].innerHTML,startSeconds:k.strToTime(h[g].getElementsByTagName("span")[0].innerHTML.replace(/[()]/g,"")),duration:0,durationMS:null,startTimeMS:null,endTimeMS:null,oNote:null}}m=d.getElementsByClassName("duration","div",j);this.data.givenDuration=(m.length?k.strToTime(m[0].innerHTML)*1000:0);for(g=0;g<this.data.length;g++){this.data[g].duration=parseInt(this.data[g+1]?this.data[g+1].startSeconds:(k.data.givenDuration?k.data.givenDuration:l.durationEstimate)/1000,10)-this.data[g].startSeconds;this.data[g].startTimeMS=this.data[g].startSeconds*1000;this.data[g].durationMS=this.data[g].duration*1000;this.data[g].endTimeMS=this.data[g].startTimeMS+this.data[g].durationMS;this.totalTime+=this.data[g].duration}};if(navigator.userAgent.match(/webkit/i)&&navigator.userAgent.match(/mobile/i)){soundManager.setup({useHTML5Audio:true})}soundManager.setup({html5PollingInterval:50,debugMode:(b.location.href.match(/debug=1/i)),consoleOnly:true,flashVersion:9,useHighPerformance:true});if(soundManager.debugMode){b.setInterval(function(){var c=b.threeSixtyPlayer;if(c&&c.lastSound&&c.lastSound._360data.fps&&typeof b.isHome==="undefined"){soundManager._writeDebug("fps: ~"+c.lastSound._360data.fps);c.lastSound._360data.fps=0}},1000)}b.ThreeSixtyPlayer=a}(window));threeSixtyPlayer=new ThreeSixtyPlayer();soundManager.onready(threeSixtyPlayer.init);