// forked from cx20's "켫?? for jsdo.it ver 0.03" http://jsdo.it/cx20/3JTG
// forked from cx20's "켫?? for jsdo.it ver 0.02" http://jsdo.it/cx20/lLfQ
// forked from cx20's "켫?? for jsdo.it ver 0.01" http://jsdo.it/cx20/ggp0
// forked from cx20's "2013-03-31 3rd" http://jsdo.it/cx20/s0Et

function convJapaneseToSoramimiEnglish() {
    convKanjiToHiragana( "txtJapanese", "txtEnglish" );
}

function speakSoramimiEnglish(){
    var text = document.getElementById("txtEnglish").value;
    speak(text);
}

function speakSoramimiEnglishByGoogleTTS(){
    var text = document.getElementById("txtEnglish").value;
    tts(text);
}

function tts(text) {
    var lang = 'en';
    var tts_url = 'http://translate.google.com/translate_tts?tl=' + lang + '&q=';
    var tts_utterance = text;
    tts_utterance = encodeURIComponent(tts_utterance);
    tts_url += tts_utterance;
    var inner_html = '<iframe src="' + tts_url + '" style="display:none;"></iframe>';
    document.getElementById("audio_google_tts").innerHTML = inner_html;
}

var global = this;
var DEFAULT_TIMEOUT = 10 * 1000; //10 seconds
var YQL_URL = "http://query.yahooapis.com/v1/public/yql";
var API_URL = "http://jlp.yahooapis.jp/FuriganaService/V1/furigana";
var appid = "dj0zaiZpPVZHWXJyYm1pbjNqYSZkPVlXazlkbUUzUmtrek5tc21jR285TUEtLSZzPWNvbnN1bWVyc2VjcmV0Jng9NTA-";    // Fork ϫ׫꫱?ID ?ڪêު
var img;

function convKanjiToHiragana( jp, en ) {
    var result = "";
    var script = getScriptTag();
    var i, len, attr;
    var filter, timeout;
    var requestFunc;
    var params = {};
    var yqlparams = {format:'json'};

    var attrs = {};
    attrs['data-url'] = API_URL;
    attrs['data-p-appid'] = appid;
    attrs['data-p-sentence'] = document.getElementById(jp).value;

    img = document.createElement('div');
    img.setAttribute('id', "placeFolder" );

    params.appid = attrs['data-p-appid'];
    params.sentence = attrs['data-p-sentence'];

    var url=false, yql=false, table = 'xml';
    url = attrs['data-url'];
    url += '?' + buildQuery(params);
    yqlparams.q = 'SELECT * FROM ' + table + ' WHERE url="' + url + '"';

    //script.parentNode.replaceChild(img, script);
    script.parentNode.appendChild( img );
    var request = function(){
        requestJSONP(YQL_URL, yqlparams, timeout, function(data){
            var box, credit = '';

            var strHiragana = "";
            for (var i = 0, len = data.query.results.ResultSet.Result.WordList.Word.length; i < len; i++) {
                var word = data.query.results.ResultSet.Result.WordList.Word[i];
                if ( typeof word.Furigana === "undefined" )
                {
                    strHiragana += word.Surface;
                }
                else
                {
                    strHiragana += word.Furigana;
                }
            }

            var soramimi = new SoramimiMaker();
            soramimi.ConvertJapaneseToEnglish( strHiragana );
            document.getElementById(en).value = soramimi.English;
        });
    };

    //APIꫯ
    request();
}

function getScriptTag() {
    var scripts = document.getElementsByTagName('script');
    var i = scripts.length - 1;
    return scripts[i];
}

function requestJSONP(url, params, timeout, callback) {
    var callbackName = 'yj_callback' + (+new Date()) + ((Math.random() * 100)|0);
    var req = document.createElement('script');
    var timerId;
    
    if (!timeout) timeout = DEFAULT_TIMEOUT;

    params.callback = callbackName;
    req.type = 'text/javascript';
    req.src = url + '?' + buildQuery(params);

    global[callbackName] = function(data) {
        clearTimeout(timerId);
        req.parentNode.removeChild(req);
        global[callbackName] = null;
        return callback(data);
    };

    timerId = setTimeout(function(){
        callback({YahooApiError:true});
    }, timeout);

    img.parentNode.insertBefore(req, img.nextSibling);
}

function buildQuery(hash) {
    var queries = [], key, encode = global.encodeURIComponent;
    for (key in hash) if (hash.hasOwnProperty(key)) {
        queries.push(encode(key) + '=' + encode(hash[key]));
    }
    return queries.join('&');
}

String.prototype.trim = function() {
    return this.replace(/^[ ]+|[ ]+$/g, '');
};

var SoramimiMaker = function() {
    var dic = [];
    this.AppendDic = function(strDic) {
        var strItems = strDic.split(";");
        for (var i = 0; i < strItems.length; i++) {
            var strItem = strItems[i];
            var strKeyValueArray = strItem.split("=");
            var strKey = strKeyValueArray[0].trim();
            var strValue = strKeyValueArray[1].trim();
            dic[strKey] = strValue; // dic[""] = "are";
        }
    };
    this.AppendDic("   = are;     = e;       = woo;     = eh;      = o");
    this.AppendDic("   = car;     = key;     = coo;     = kay;     = coe");
    this.AppendDic("   = saw;     = she;     = su;      = set;     = so");
    this.AppendDic("   = ta;      = chee;    = two;     = tegh;    = toe");
    this.AppendDic("   = nar;     = knee;    = new;     = nay;     = noe");
    this.AppendDic("   = ha;      = he;      = foo;     = hey;     = ho");
    this.AppendDic("   = maw;     = me;      = moo;     = may;     = moe");
    this.AppendDic("   = yah;                  = you;                  = yeo");
    this.AppendDic("   = law;     = lee;     = rue;     = ray;     = roe");
    this.AppendDic("   = wor;     = we;                   = way;     = wo");
    this.AppendDic("   = n");
    this.AppendDic("   = gaw;     = gae;     = goo;     = get;     = go");
    this.AppendDic("   = zar;     = ji;      = zoo;     = zee;     = zlo");
    this.AppendDic("   = duh;     = gee;     = zu;      = day;     = doe");
    this.AppendDic("   = baw;     = be;      = boo;     = beh;     = bo");
    this.AppendDic("   = pa;      = p;       = phu;     = pet;     = pop");

    this.AppendDic(" = cat;                = que;                = kyo");
    this.AppendDic(" = sha;                = shoe;               = show");
    this.AppendDic(" = cha;                = chew;               = cho");
    this.AppendDic("˪ = nier;              ˪ = nue;               ˪ = gno");
    this.AppendDic("Ҫ = hya ;              Ҫ = hue;               Ҫ = heo");
    this.AppendDic("ߪ = mya;               ߪ = mew;               ߪ = mio");
    this.AppendDic(" = lya;                = lue;                = low");
    this.AppendDic(" = gap;                = gue;                = gheo");
    this.AppendDic(" = jar;                = jew;                = jo");
    this.AppendDic("Ӫ = v'ya;              Ӫ = view;              Ӫ = b'yo");
    this.AppendDic("Ԫ = pyat;              Ԫ = pew;               Ԫ = p'yo");

    this.AppendDic(" = are;   = e;     = woo;   = eh;    = o");
    this.AppendDic(" = car;   = key;   = cool;  = k;     = coe");
    this.AppendDic(" = sar;   = see;   = su;    = set;   = so");
    this.AppendDic(" = tar;   = cheer; Ī = two;  ƪ = tait; Ȫ = toe");
    this.AppendDic("ʪ = nah;  ˪ = knee; ̪ = new;  ͪ = nay;  Ϊ = noe");
    this.AppendDic("Ϫ = her;  Ҫ = he;   ժ = foo;  ت = hey;  ۪ = ho");
    this.AppendDic("ު = mar;  ߪ = me;   દ = moo;  ᪨ = mair; ⪪ = moe");
    this.AppendDic("䪢 = yah;               檦 = you;               說 = yor");
    this.AppendDic("骢 = rah;  ꪤ = lee;  몦 = rue;  쪨 = ray;   = row");
    this.AppendDic("甆 = war;   = we;                 = way;   = wo");
    this.AppendDic(" = gar;   = geek;  = goo;   = gay;   = goh");
    this.AppendDic(" = zar;   = zee;   = zoo;   = they;  = soh");
    this.AppendDic(" = dah;  ª = dee;  Ū = zu;   Ǫ = day;  ɪ = doh");
    this.AppendDic("Ъ = bar;  Ӫ = bee;  ֪ = boo;  ٪ = bay;  ܪ = boh");
    this.AppendDic("Ѫ = per;  Ԫ = pee;  ת = poor; ڪ = pay;  ݪ = poh");

    this.AppendDic("? = are;  ? = e;    ? = woo;  ? = eh;   ? = oh");
    this.AppendDic("? = car;  ? = key;  ? = coo;  ? = k;    ? = coe");
    this.AppendDic("? = sar;  ? = see;  ? = su;   ? = set;  ? = soe");
    this.AppendDic("? = tar;  ? = cheer;? = two;  ? = tait; ? = toe");
    this.AppendDic("? = nah;  ? = knee; ? = new;  ? = nae;  ? = noe");
    this.AppendDic("? = her;  ? = he;   ? = foo;  ? = hey;  ? = hoe");
    this.AppendDic("? = mar;  ? = me;   ? = moo;  ? = mair; ? = moe");
    this.AppendDic("? = yah;               ? = you;               ? = yor");
    this.AppendDic("? = rah;  ? = lee;  ? = rue;  ? = ray;  ? = row");
    this.AppendDic("? = war;  ? = we;                ? = way;  ? = woe");
    this.AppendDic("? = gar;  ? = geek; ? = goo;  ? = gay;  ? = goh");
    this.AppendDic("? = zar;  ? = zee;  ? = zoo;  ? = they; ? = soh");
    this.AppendDic("? = dah;  ? = dee;  ? = zu;   ? = day;  ? = doh");
    this.AppendDic("? = bar;  ? = bee;  ? = boo;  ? = bay;  ? = boh");
    this.AppendDic("? = per;  ? = pee;  ? = poor; ? = pay;  ? = poh");

    this.AppendDic(" = i;                  = we;    = eh;    = oh");
    this.AppendDic(" = kite;               = cui;   = k;     = coe");
    this.AppendDic(" = sigh;               = swee;  = say;   = soe");
    this.AppendDic(" = tai;               Ī = twit; ƪ = take; Ȫ = toe");
    this.AppendDic("ʪ = nigh;              ̪ = nui;  ͪ = nay;  Ϊ = noe");
    this.AppendDic("Ϫ = high;              ժ = hui;  ت = hey;  ۪ = hoe");
    this.AppendDic("ު = mai;               ત = mui;  ᪤ = may;  ⪦ = moe");
    this.AppendDic("䪤 = yawi;              檤 = youy;              誦 = yeo");
    this.AppendDic("骤 = rye;               몤 = louie;쪤 = ray;   = row");
    this.AppendDic("瘝 = y;                               = way;   = woe");
    this.AppendDic(" = guy;                = gui;   = gay;   = goe");
    this.AppendDic(" = zai;                = zy;    = they;  = zoe");
    this.AppendDic(" = die;               Ū = zooy; Ǫ = day;  ɪ = doe");
    this.AppendDic("Ъ = buy;               ֪ = buoy; ٪ = bay;  ܪ = boe");
    this.AppendDic("Ѫ = pai;               ת = puy;  ڪ = pay;  ݪ = poe");

    this.AppendDic(" = archa; = icker; = wooca; = ecker; = walker");
    this.AppendDic(" = kaka;  = kicker;= cooca; = kekka; = coca");
    this.AppendDic(" = sucker;= sicker;= sooca; = seca;  = soca");
    this.AppendDic(" = tucker;= ticker;Ī= tooca;ƪ = teca; Ȫ = talker");
    this.AppendDic("ʪ = knucker;˪=nicker;̪= nuca; ͪ = necker;Ϊ= noka");
    this.AppendDic("Ϫ = hacker;Ҫ= hicker;ժ= hooca;ت = hecker;۪= hoka");
    this.AppendDic("ު = macca; ߪ= mika; ફ = mooka;᪫ = meca; ⪫ = moca");
    this.AppendDic("䪫 = yacker;            檫 = youka;             誫 = yoca");
    this.AppendDic("骫 = rucker;ꪫ= rika; 몫 = luca; 쪫 = recker;= loca");
    this.AppendDic("磌 = wacker;= wicker;             = weca;  = walker");
    this.AppendDic(" = zacca; = jicker;= zooka; = zeca;  = zoca");
    this.AppendDic(" = gucker;= ghika; = gooka; = geca;  = goca");
    this.AppendDic(" = ducker;ª= zika; Ū = zooka;Ǫ = decker;ɪ= doca");
    this.AppendDic("Ъ = backer;Ӫ= beaker;֪= booka;٪ = beca; ܪ = boca");
    this.AppendDic("Ѫ = parker;Ԫ= picker;ת= pooca;ڪ = pecker;ݪ= poker");

    this.AppendDic(" = aki;   = iki;   = uki;   = ecky;  = okie");
    this.AppendDic(" = kakee; = kiki;  =cookie; = cake;  = cokie");
    this.AppendDic(" = sucky; = sicky; = ski;   = secky; = socky");
    this.AppendDic(" = tucky; = ticky;Ī = tooki;ƪ = tecky;Ȫ = talky");
    this.AppendDic("ʪ = knacky;˪= nicky;̪ = nuki; ͪ = necky;Ϊ = nokie");
    this.AppendDic("Ϫ = hackie;Ҫ= hicky;ժ = whoky;ت = hecky;۪ = hockey");
    this.AppendDic("ު = marquee;ߪ=mickey;ભ= muki; ᪭ = mecky;⪭ = mocky");
    this.AppendDic("䪭 = yacky;             檭 = youky;             読 = yocky");
    this.AppendDic("骭 = lucky;ꪭ = lucky;몭 =lookie;쪭 = recky; = rocky");
    this.AppendDic("節 = wacky; = wicky;              = wecky; = walky");
    this.AppendDic(" = zacky; = jicky; = zooky; = zecky; = zocky");
    this.AppendDic(" = gucky; = ghiky; = gooky; = gekky; = gocky");
    this.AppendDic(" = ducky;ª = dicky;Ū = zooky;Ǫ =decking;ɪ= docky");
    this.AppendDic("Ъ = backy;Ӫ = beaky;֪ = booky;٪ = becky;ܪ = bocky");
    this.AppendDic("Ѫ = packy;Ԫ = picky;ת = pooky;ڪ = pecky;ݪ = pocky");

    this.AppendDic(" = ass;   = ist;   = woos;  = s;     = woss");
    this.AppendDic(" = kass;  = kiss;  = couss; = kess;  = koss");
    this.AppendDic(" = sass;  = sis;   = souss; = sess;  = soss");
    this.AppendDic(" = tass;  = cheess;Ī= tooss;ƪ = tess; Ȫ = toss");
    this.AppendDic("ʪ = nass; ˪ = neess;̪ = nooss;ͪ = ness; Ϊ = noss");
    this.AppendDic("Ϫ = hass; Ҫ = hiss; ժ = hooss;ت = hess; ۪ = hoss");
    this.AppendDic("ު = mass; ߪ = miss; હ = mooss;᪹ = mess; ⪹ = moss");
    this.AppendDic("䪹 = yass;              檹 = youss;             誹 = yoss");
    this.AppendDic("骹 = las;  ꪹ = liss; 몹 = looss;쪹 = less;  = loss");
    this.AppendDic("調 = wass;  = wiss;               = wess;  = woss");
    this.AppendDic(" = gas;   = giss;  = gooss; = gess;  = goss");
    this.AppendDic(" = zass;  = jiss;  = zooss; = zes;   = zoss");
    this.AppendDic(" = dass; ª = diss; Ū = dooss;Ǫ = death;ɪ = doss");
    this.AppendDic("Ъ = bus;  Ӫ = bis;  ֪ = booss;٪ = bess; ܪ = boss");
    this.AppendDic("Ѫ = pass; Ԫ = piss; ת = pooss;ڪ = pess; ݪ = poss");

    this.AppendDic(" = as;    = is;    = woods; = aids;  = woes");
    this.AppendDic(" = kads;  = kids;  = koods; = keds;  = koes");
    this.AppendDic(" = sads;  = seas;  = soods; = seds;  = soes");
    this.AppendDic(" = tads;  = chees;Ī = toods;ƪ = teds; Ȫ = toes");
    this.AppendDic("ʪ = nads; ˪ = needs;̪ = noods;ͪ = neds; Ϊ = noes");
    this.AppendDic("Ϫ = hads; Ҫ = hids; ժ = hoods;ت = heds; ۪ = hoes");
    this.AppendDic("ު = mads; ߪ = mids; ઺ = moods;᪺ = meds; ⪺ = moes");
    this.AppendDic("䪺 = yads;              檺 = youds;             誺 = yoes");
    this.AppendDic("諸 = wads;  = wids;               = weds;  = woes");
    this.AppendDic(" = gads;  = gids;  = goods; = geds;  = goes");
    this.AppendDic(" = zads;  = jids;  = zoods; = zeds;  = zoz");
    this.AppendDic(" = dads; ª = dids; Ū = doods;Ǫ = dez;  ɪ = does");
    this.AppendDic("Ъ = bads; Ӫ = bids; ֪ = boods;٪ = beds; ܪ = boes");
    this.AppendDic("Ѫ = pads; Ԫ = piz;  ת = poods;ڪ = peds; ݪ = poes");

    this.AppendDic(" = artar; = ita;   = wooter;= aiter; = otac");
    this.AppendDic(" = cutter;= kita;  = coota; = keter; = cota");
    this.AppendDic(" = sutter;= seater;= soota; = seter; = sota");
    this.AppendDic(" = tutter;= chita;Ī = toota;ƪ = tetar;Ȫ = tota");
    this.AppendDic("ʪ = nutter;˪= nita; ̪ = noota;ͪ = neter;Ϊ = nota");
    this.AppendDic("Ϫ = hutter;Ҫ= hita; ժ = hoota;ت = heter;۪ = hota");
    this.AppendDic("ު = mutter;ߪ= mita; િ = moota;ᪿ = meta; ⪿ = mota");
    this.AppendDic("䪿 = yotter;            檿 = youta;             調 = yota");
    this.AppendDic("骿 = rutter;꪿= rita; 몿 = loota;쪿 = reta;  = lota");
    this.AppendDic("謹 = wutter;= wita;               = weta;  = wota");
    this.AppendDic(" = zutter;= jita;  = zooter;= zeta;  = zota");
    this.AppendDic(" = gutter;=guitar; = gooter;= geta;  = gota");
    this.AppendDic(" = dutter;ª= zita; Ū = zooter;Ǫ= deta; ɪ = dota");
    this.AppendDic("Ъ = butter;Ӫ= buita;֪ = booter;٪= beta; ܪ = borta");
    this.AppendDic("Ѫ = putter;Ԫ= pita; ת = pooter;ڪ= peta; ݪ = pota");

    this.AppendDic(" = alar;  = era;   = urra;  = error; = orac");
    this.AppendDic(" = color; = kira;  = clack; = keler; = cola");
    this.AppendDic(" = sala;  = seala; = sura;  = cera;  = solar");
    this.AppendDic(" = tala;  = chilla;Ī= tula; ƪ = tera; Ȫ = tora");
    this.AppendDic("ʪ = narra;˪ = nira; ̪ = nura; ͪ = nera; Ϊ = nora");
    this.AppendDic("Ϫ = hara; Ҫ = hira; ժ = hoora;ت = hera; ۪ = horra");
    this.AppendDic("ު = mara; ߪ = mira;  = moora; = mera;  = mora");
    this.AppendDic(" = yara;               = yura;               = yora");
    this.AppendDic(" = lara;  = rira;  = loola; = lehrer;= lora");
    this.AppendDic(" = wara;  = wira;               = wera;  = wora");
    this.AppendDic(" = zara;  = jira;  = zoora; = zera;  = zora");
    this.AppendDic(" = gulla; = ghiler;= goora; = gera;  = gora");
    this.AppendDic(" = dura; ª = ziler;Ū = zoora;Ǫ = dera; ɪ = dora");
    this.AppendDic("Ъ = bara; Ӫ = bila; ֪ = bula; ٪ = bera; ܪ = borla");
    this.AppendDic("Ѫ = para; Ԫ = pira; ת = pula; ڪ = pera; ݪ = polar");

    this.AppendDic(" = arie;  = eley;  = wooly; = elly;  = ollie");
    this.AppendDic(" = cali;  = kili;  = kooly; = kelly; = kollie");
    this.AppendDic(" = sari;  = ciri;  = sooly; = selly; = solly");
    this.AppendDic(" = tally; = chilly;Ī= tooly;ƪ = telly;Ȫ = tolly");
    this.AppendDic("ʪ = nally;˪ = nili; ̪ = nooly;ͪ = nelly;Ϊ = nori");
    this.AppendDic("Ϫ = hally;Ҫ = hilly;ժ = hooly;ت = helly;۪ = hori");
    this.AppendDic("ު = mally;ߪ = milli; = mooly; = melly; = molly");
    this.AppendDic(" = yally;              = yooly;              = yori");
    this.AppendDic(" = rally; = lilly; = looly; = reli;  = loli");
    this.AppendDic(" = wally; = willy;              = welly; = wollie");
    this.AppendDic(" = zally; = jilly; = zree;  = zelly; = zollie");
    this.AppendDic(" = gally; = gilly; = gree;  = gelly; = gori");
    this.AppendDic(" = dally;ª = dilly;Ū = zree; Ǫ = deli; ɪ = dori");
    this.AppendDic("Ъ = bally;Ӫ = billy;֪ = bree; ٪ = belly;ܪ = bori");
    this.AppendDic("Ѫ = pally;Ԫ = pirie;ת = pree; ڪ = pelly;ݪ = pori");

    this.AppendDic(" = aru;   = eylew;= ulu;    = eru;   = all");
    this.AppendDic(" = caru;  = keel; = crue;   = keru;  = call");
    this.AppendDic(" = saru;  = shiel;= through;= cell;  = soll");
    this.AppendDic(" = taru;  = chiel;Ī= true;  ƪ = teru; Ȫ = toll");
    this.AppendDic("ʪ = naru; ˪ = niru ;̪= nuru;  ͪ = neru; Ϊ = knoll");
    this.AppendDic("Ϫ = haru; Ҫ = heel; ժ= fool;  ت = heru; ۪ = holl");
    this.AppendDic("ު = maru; ߪ = miru; = mool;   = meru;  = moru");
    this.AppendDic(" = yaru;              = yuru;                = yoru");
    this.AppendDic(" = raru;  = reel; = rule;   = reru;  = role");
    this.AppendDic(" = walt;  = will;               = weru;  = wole");
    this.AppendDic(" = zaru;  = jill; = zulu;   = zeru;  = zoll");
    this.AppendDic(" = garu;  = ghil; = guru;   =get rue;= goru");
    this.AppendDic(" = darl; ª = dill; Ū= zulu;  Ǫ = deru; ɪ = doll");
    this.AppendDic("Ъ = baru; Ӫ = bill; ֪= buru;  ٪ = bell; ܪ = boru");
    this.AppendDic("Ѫ = paru; Ԫ = pill; ת= pull;  ڪ = peru; ݪ = poru");

    this.AppendDic(" = array; = irre;  = woo're;= elec;  = olay");
    this.AppendDic(" = kaway; = chela; = coo're;= kera;  = colet");
    this.AppendDic(" = sally; = shilla;= slay;  = seile; = solei");
    this.AppendDic(" = telei; = chilei;Ī= too're;ƪ= tella;Ȫ = tolei");
    this.AppendDic("ʪ = nalla;˪ = nalei;̪ = nure; ͪ = nella;Ϊ = nolei");
    this.AppendDic("Ϫ = halle;Ҫ = helei;ժ = hoo're;ت= hella;۪ = holei");
    this.AppendDic("ު = malla;ߪ = milla; = moo're;= mella; = molei");
    this.AppendDic(" = yalla;              = you'lei;            = yolei");
    this.AppendDic(" = ralla; = relay; = roulette;=rella;= lolei");
    this.AppendDic(" = walla; = welei;              = wella; = wolei");
    this.AppendDic(" = zalla; = jilla; = zoo're;= zella; = zolei");
    this.AppendDic(" = galla; = gelei; = goo're;= gera;  = golei");
    this.AppendDic(" = dalla;ª = delei;Ū = zoo're;Ǫ= della;ɪ = dolei");
    this.AppendDic("Ъ = balla;Ӫ = bila; ֪ = boo're;٪= belle;ܪ = bolei");
    this.AppendDic("Ѫ = palla;Ԫ = pelei;ת = poo're;ڪ= pelle;ݪ = polei");

    this.AppendDic(" = alot;  = e-row; = woorow;= ero;   = oro");
    this.AppendDic(" = carro; = kiro;  = coo'ro;= kero;  = koro");
    this.AppendDic(" = saro;  = sherow;= slow;  = sero;  = soro");
    this.AppendDic(" = taro;  = chi'ro;Ī= too'ro;ƪ= terro;Ȫ = toro");
    this.AppendDic("ʪ = nalow;˪ = niro; ̪ = noorow;ͪ= nero; Ϊ = noro");
    this.AppendDic("Ϫ = helo; Ҫ = hero; ժ = flo;  ت = haro; ۪ = horo");
    this.AppendDic("ު = maro; ߪ = miro;  = moo'ro;= mero;  = moro");
    this.AppendDic(" = yaro;               = you'ro;             = yoro");
    this.AppendDic(" = raro;  = riro;  = loo'ro;= rero;  = loro");
    this.AppendDic(" = waro;  = wiro;               = wero;  = woro");
    this.AppendDic(" = zaro;  = jiro; = zoo'ro; = zero;  = zoro");
    this.AppendDic(" = garo;  = giro; = goo'ro; = gero;  = goro");
    this.AppendDic(" = daro; ª = diro; Ū= zoo'ro;Ǫ = dero; ɪ = dolo");
    this.AppendDic("Ъ = baro; Ӫ = biro; ֪= boo'ro;٪ = bero; ܪ = boro");
    this.AppendDic("Ѫ = paro; Ԫ = piro; ת= poo'ro;ڪ = pero; ݪ = polo");

    this.AppendDic(" = ann;   = in;    = unn;   = en;    = on");
    this.AppendDic(" = come;  = kin;   = coon;  = ken;   = kong");
    this.AppendDic(" = sun;   = shin;  = soon;  = senn;  = song");
    this.AppendDic(" = tun;   = chin; Ī = zun;  ƪ = ten;  Ȫ = tong");
    this.AppendDic("ʪ = nan;  ˪ = nin;  ̪ = noon; ͪ = nen;  Ϊ = nong");
    this.AppendDic("Ϫ = han;  Ҫ = hin;  ժ = hoon; ت = hen;  ۪ = hong");
    this.AppendDic("ު = man;  ߪ = minn;  = moon;  = men;   = mong");
    this.AppendDic(" = yan;                = yun;                = yong");
    this.AppendDic(" = run;   = rin;   = roon;  = ren;   = rong");
    this.AppendDic(" = wan;   = win;                = wen;   = wonn");
    this.AppendDic(" = gun;   = ginn;  = goon;  = gann;  = gonn");
    this.AppendDic(" = than;  = jin;   = zun;   = then;  = zonn");
    this.AppendDic(" = dunn; ª = zin;  Ū = zun;  Ǫ = den;  ɪ = donn");
    this.AppendDic("Ъ = ban;  Ӫ = bin;  ֪ = boon; ٪ = ben;  ܪ = bonn");
    this.AppendDic("Ѫ = pahm; Ԫ = pin;  ת = poon; ڪ = pen;  ݪ = ponn");

    this.AppendDic(" = at;    = it;    = woo;   = ewo;   = o'");
    this.AppendDic(" = cut;   = kit;   = coo;   = ket;   = cot");
    this.AppendDic(" = sat;   = sit;   = sook;  = set;   = sot");
    this.AppendDic(" = tat;   = tit;  Ī = took; ƪ = tet;  Ȫ = tot");
    this.AppendDic("ʪ = nat;  ˪ = nit;  ̪ = nook; ͪ = net;  Ϊ = not");
    this.AppendDic("Ϫ = hat;  Ҫ = hit;  ժ = hook; ت = het;  ۪ = hot");
    this.AppendDic("ު = mat;  ߪ = mick;  = mook;  = met;   = mock");
    this.AppendDic(" = yat;                = you;                = yot");
    this.AppendDic(" = rat;   = rick;  = rook;  = reck;  = rot");
    this.AppendDic(" = wat;   = wit;                = wet;   = wot");
    this.AppendDic(" = gat;   = git;   = good;  = get;   = got");
    this.AppendDic(" = zat;   = jit;   = zoot;  = zet;   = zot");
    this.AppendDic(" = dat;  ª = dit;  Ū = zook; Ǫ = det;  ɪ = dot");
    this.AppendDic("Ъ = bat;  Ӫ = bit;  ֪ = book; ٪ = bet;  ܪ = bot");
    this.AppendDic("Ѫ = pat;  Ԫ = pit;  ת = pook; ڪ = pet;  ݪ = pot");

    this.AppendDic("㪦 = kyar;          媦 = qew;             窦 = kiyo");
    this.AppendDic("㪦 = shar;          媦 = shoe;            窦 = show");
    this.AppendDic("㪦 = char;          媦 = chew;            窦 = chalk");
    this.AppendDic("˪㪦 = nier;          ˪媦 = new;             ˪窦 = gno");
    this.AppendDic("Ҫ㪦 = hyar;          Ҫ媦 = huew;            Ҫ窦 = he-yo");
    this.AppendDic("ߪ㪦 = myar;          ߪ媦 = mew;             ߪ窦 = mio");
    this.AppendDic("㪦 = lyar;          媦 = rew;             窦 = low");
    this.AppendDic("㪦 = gear;          媦 = gew;             窦 = gheo");
    this.AppendDic("㪦 = jar;           媦 = jew;             窦 = jo");
    this.AppendDic("Ӫ㪦 = v'yar;         Ӫ媦 = view;            Ӫ窦 = b'yo");
    this.AppendDic("Ԫ㪦 = p'yar;         Ԫ媦 = pew;             Ԫ窦 = p'yo");

    this.AppendDic("? = kyar;          ? = qew;             ? = kiyo");
    this.AppendDic("? = shar;          ? = shoe;            ? = show");
    this.AppendDic("? = char;          ? = chew;            ? = cho");
    this.AppendDic("˪? = nier;          ˪? = new;             ˪? = chalk");
    this.AppendDic("Ҫ? = hyar;          Ҫ? = huew;            Ҫ? = he-yo");
    this.AppendDic("ߪ? = myar;          ߪ? = mew;             ߪ? = mio");
    this.AppendDic("? = lyar;          ? = rew;             ? = low");
    this.AppendDic("? = gear;          ? = gew;             ? = gheo");
    this.AppendDic("? = jar;           ? = jew;             ? = jo");
    this.AppendDic("Ӫ? = v'yar;         Ӫ? = view;            Ӫ? = b'yo");
    this.AppendDic("Ԫ? = p'yar;         Ԫ? = pew;             Ԫ? = p'yo");

    this.AppendDic(" = kyang;          = qewn;             = kiyong");
    this.AppendDic(" = shang;          = shewn;            = shon");
    this.AppendDic(" = chang;          = chewn;            = chon");
    this.AppendDic("˪ = nieng;         ˪ = newn;            ˪ = gnon");
    this.AppendDic("Ҫ = hyang;         Ҫ = huewn;           Ҫ = heon");
    this.AppendDic("ߪ = myang;         ߪ = mewn;            ߪ = mion");
    this.AppendDic(" = lyang;          = lewn;             = lon");
    this.AppendDic(" = geang;          = gewn;             = gheon");
    this.AppendDic(" = jang;           = jewn;             = jon");
    this.AppendDic("Ӫ = v'yang;        Ӫ = viewn;           Ӫ = byung");
    this.AppendDic("Ԫ = p'yang;        Ԫ = pewn;            Ԫ = pyong");
    
    // ԴԳݤ??
    this.AppendDic("ʪ = nagar");
    this.AppendDic(" = oak");
    this.AppendDic(" = cock");
    this.AppendDic(" = kick");
    this.AppendDic(" = cook");
    this.AppendDic(" = keck");
    this.AppendDic(" = kock");
    this.AppendDic(" = suck");
    this.AppendDic(" = sick");
    this.AppendDic(" = seck");
    this.AppendDic(" = sock");
    this.AppendDic(" = tack");
    this.AppendDic(" = tick");
    this.AppendDic("ƪ = tech");
    this.AppendDic("Ȫ = tock");
    this.AppendDic("ʪ = nack");
    this.AppendDic("˪ = nick");
    this.AppendDic("ͪ = neck");
    this.AppendDic("Ϊ = nock");
    this.AppendDic("Ϫ = hack");
    this.AppendDic("ժ = fuku");
    this.AppendDic("ު = mac");
    this.AppendDic("ߪ = mick");
    this.AppendDic("ય = mook");
    this.AppendDic("᪯ = meck");
    this.AppendDic("⪯ = mock");
    this.AppendDic("骯 = luck");
    this.AppendDic(" = rock");
    this.AppendDic(" = cargo");
    this.AppendDic(" = ishi");
    this.AppendDic("Ȫ = torch");
    this.AppendDic(" = gucci");
    this.AppendDic(" = moto");
    this.AppendDic(" = eva");
    this.AppendDic(" = giff");
    this.AppendDic("ߪ = mere");
    this.AppendDic(" = kumar");
    this.AppendDic(" = seama");
    this.AppendDic(" = tama");
    this.AppendDic(" = yahma");
    this.AppendDic(" = cami");
    this.AppendDic(" = gammi");
    this.AppendDic(" = coach");
    
    // ٣
    this.AppendDic(" = order");
    this.AppendDic(" = tower");
    
    // 
    this.AppendDic(" = encore");
    this.AppendDic(" = summer");
    this.AppendDic(" = game");

    this.AppendDic("ժ = far");
    this.AppendDic("ժ = fee");
    this.AppendDic("ժ = faye");
    this.AppendDic("ժ = for");

    this.AppendDic(" = kerner");
    this.AppendDic(" = sana");
    this.AppendDic(" = turner");
    this.AppendDic("ʪ = nana");
    this.AppendDic("Ϫ = herna");
    this.AppendDic("ު = manner");
    this.AppendDic(" = lana");
    this.AppendDic(" = werner");

    this.AppendDic("ʪ = nowar");
    this.AppendDic(" = wait");
    this.AppendDic(" = yatz");

    this.AppendDic("ê = ack");
    this.AppendDic("ê = oak");
    this.AppendDic("ê = cock");
    this.AppendDic("ê = kick");
    this.AppendDic("ê = cook");
    this.AppendDic("ê = keck");
    this.AppendDic("ê = kock");
    this.AppendDic("ê = suck");
    this.AppendDic("ê = sick");
    this.AppendDic("ê = seck");
    this.AppendDic("ê = sock");
    this.AppendDic("ê = tack");
    this.AppendDic("ê = tick");
    this.AppendDic("ƪê = tech");
    this.AppendDic("Ȫê = tock");
    this.AppendDic("ʪê = nack");
    this.AppendDic("˪ê = nick");
    this.AppendDic("ͪê = neck");
    this.AppendDic("Ϊê = nock");
    this.AppendDic("Ϫê = hack");
    this.AppendDic("ժê = hook");
    this.AppendDic("ުê = mac");
    this.AppendDic("ߪê = mick");
    this.AppendDic("ê = mook");
    this.AppendDic("ê = meck");
    this.AppendDic("ê = mock");
    this.AppendDic("ê = luck");
    this.AppendDic("ê = rock");

    this.AppendDic(" = keck");
    this.AppendDic("㪯 = cack");
    this.AppendDic("窯 = shock");
    this.AppendDic("㪯 = chack");
    this.AppendDic(" = check");

    // ת?٣
    this.AppendDic("   = are;     = e;       = woo;     = eh;      = o");
    this.AppendDic("   = yah;                  = you;                  = yeo");

    this.AppendDic("ϡ= war,; ϡ= war.");
    this.AppendDic("ء= e,;   ء= e.");
    this.AppendDic(" = ,; = ,;  = .; ? = -;  = ?;  = !");
    this.AppendDic(" = \";= \"; = \"; = \"; = (;  = )");

    this.m_dic = dic;

    this.ConvertZenkakuToHankaku = function(strZenkaku) {
        var strResult = "";
        for ( var i = 0; i < strZenkaku.length; i++ ) {
            var unicode = strZenkaku.charCodeAt(i);
            if ( ( 0xff0f < unicode ) && ( unicode < 0xff1a ) ) {
                strResult += String.fromCharCode( unicode - 0xfee0 );
            } else if ( ( 0xff20 < unicode ) && ( unicode < 0xff3b ) ) {
                strResult += String.fromCharCode( unicode - 0xfee0 );
            } else if ( ( 0xff40 < unicode ) && ( unicode < 0xff5b ) ) {
                strResult += String.fromCharCode( unicode - 0xfee0 );
            } else {
                strResult += String.fromCharCode( unicode );
            }
        }
        return strResult; /* ?Ϊ */
    };

    this.ConvertKatakanaToHiragana = function(strKatakana)
    {
        var i, c, a = [];
        for( i = strKatakana.length-1; 0 <= i; i-- )
        {
            c = strKatakana.charCodeAt(i);
            a[i] = (0x30A1 <= c && c <= 0x30F6) ? c - 0x0060 : c;
        }
        return String.fromCharCode.apply(null, a);
    };

    this.ConvertJapaneseToEnglish = function(strJapanese) {
        var strResult = "";

        var strLineArray = strJapanese.split("\r\n");
        var strLine;
        for (var i = 0; i < strLineArray.length; i++) {
            strLine = strLineArray[i];
            strLine = this.ConvertKatakanaToHiragana( strLine );
            strLine = this.ConvertZenkakuToHankaku(strLine);
            strResult += this.ConvertJapaneseToEnglishSingleLine(strLine) + "\r\n";
        }
        strResult = strResult.replace(/[\s]+/g, " "); // 驫?
        strResult = strResult.replace(/[\s]+\,/g, ","); // 驫?
        strResult = strResult.replace(/[\s]+\./g, "."); // 驫?

        this.English = strResult;
    };
    this.ConvertJapaneseToEnglishSingleLine = function(strJapanese) {
        var strResult = "";
        var strKey;
        var strValue;
        var bFirst = true;
        for (var i = 0; i < strJapanese.length; i++) {
            if (i === 0) {
                bFirst = true;
            }
            else {
                bFirst = false;
            }
            var strKey3 = strJapanese.substr(i, 3);
            var strKey2 = strJapanese.substr(i, 2);
            var strKey1 = strJapanese.substr(i, 1);
            if (this.m_dic[strKey3]) {
                strKey = strKey3;
                i += 2;
            }
            else if (this.m_dic[strKey2]) {
                strKey = strKey2;
                i += 1;
            }
            else if (this.m_dic[strKey1]) {
                strKey = strKey1;
            }
            else {
                strKey = strKey1;
            }
            if (this.m_dic[strKey]) {
                strValue = this.m_dic[strKey];
                if ( bFirst ) {
                    strResult += strValue;
                }
                else if (strValue == "," || strValue == ".") {
                    // ,.ϫ?ʥ루co.no.ȪʪΪ?
                    strResult += " " + strValue;
                }
                else {
                    // ϫ?ʥ롣
                    strResult += " " + strValue;
                }
            }
            else {
                // ?ʪꪪ򫻫ë
                strResult += strKey;
            }
        }
        return strResult;
    };
};

clippy.BASE_PATH = "http://s3.amazonaws.com/clippy.js/Agents/";
//clippy.load('Merlin', function (agent) {
//clippy.load('Rocky', function (agent) {
clippy.load('Peedy', function (agent) {
    // Do anything with the loaded agent
    agent.show();
    // move to the given point, use animation if available
    agent.moveTo(300, 300);

    $("#speak_by_speakjs").click(function () {
        // Show text balloon
        //agent.speak('When all else fails, bind some paper together. My name is Clippy.');
        convJapaneseToSoramimiEnglish();
        var timerId = setTimeout(function(){
            var text = document.getElementById("txtEnglish").value;
            agent.stop();
            agent.speak(text);
            speak(text);
            agent.animate();
        }, 1000);
    });

    $("#speak_by_googletts").click(function () {
        // Show text balloon
        //agent.speak('When all else fails, bind some paper together. My name is Clippy.');
        convJapaneseToSoramimiEnglish();
        var timerId = setTimeout(function(){
            var text = document.getElementById("txtEnglish").value;
            agent.stop();
            agent.speak(text);
            tts(text);
            agent.animate();
        }, 1000);
    });

});
