<?php
class ExtendHandler
{
	private $act;

	public function __construct($module_info)
	{
		$this->act = $module_info->act;
	}

	public function proc()
	{
		$this->{$act}();
	}

	private function procEasyxePageAuthorize()
	{
		// 페이지 비밀번호
		$page_password = Context::get('page_password');

		// 비밀번호 잠금이면서 비밀번호를 입력하지 않은 경우
		if(!$page_password && $this->module_info->page_lock_type == 'password')
		{
			return new Object(-1, '페이지 비밀번호를 입력해주세요.');
		}

		if(!is_array($_SESSION['XE_PAGE_AUTHORIZED']))
		{
			$_SESSION['XE_PAGE_AUTHORIZED'] = array();
		}

		if(!is_array($_SESSION['XE_PAGE_AUTHORIZED_TIME']))
		{
			$_SESSION['XE_PAGE_AUTHORIZED_TIME'] = array();
		}

		// 비밀번호 잠금이면서 비밀번호가 틀린 경우
		if($this->module_info->page_password != $page_password && $this->module_info->page_lock_type == 'password')
		{
			$_SESSION['XE_PAGE_AUTHORIZED'][$this->module_info->module_srl] = FALSE;
			return new Object(-1, '비밀번호가 틀렸습니다.');
		}

		$logged_info = Context::get('logged_info');

		// 페이지 잠금 해제 방식이 포인트 차감이면서 로그인을 하지 않았을 때
		if($this->module_info->page_lock_type == 'point' && !$logged_info)
		{
			return new Object(-1, 'msg_unlock_login_required');
		}

		$expireTime = $this->module_info->page_auth_expire_time;

		switch($this->module_info->page_auth_expire_time_unit)
		{
			case 'MINUTES':
				$expireTime *= 60;
				break;
			case 'HOURS':
				$expireTime *= 60 * 60;
				break;
			case 'DAYS':
				$expireTime *= 60 * 60 * 24;
				break;
			case 'MONTHS':
				$expireTime *= 60 * 60 * 30;
				break;
		}

		$usePointUnlock = $this->module_info->page_unlock_point > 0 && $this->module_info->page_lock_type == 'point';
		if($this->module_info->page_auth_expire_time > 0 && (!$_SESSION['XE_PAGE_AUTHORIZED_TIME'][$this->module_info->module_srl] || time() <= $_SESSION['XE_PAGE_AUTHORIZED_TIME'][$this->module_info->module_srl] + $expireTime))
		{
			if($usePointUnlock)
			{
				$args = new stdClass;
				$args->module_srl = $this->module_info->module_srl;
				$args->member_srl = $logged_info->member_srl;
				$output = executeQuery('easyxe.getPageAuthorizeLogByMemberSrl', $args);
			}

			$args = new stdClass;
			$args->module_srl = $this->module_info->module_srl;
			$args->member_srl = $logged_info->member_srl;
			$args->ipaddress = $_SERVER['REMOTE_ADDR'];
			$args->time = $expireTime;
			$output = executeQuery('easyxe.insertPageAuthorizeLog', $args);

			if(!$output->toBool())
			{
				return $output;
			}

			$this->module_info->page_unlock_point = (int) $this->module_info->page_unlock_point;

			// 포인트 잠금 해제를 사용할 경우
			if($usePointUnlock)
			{
				// pointController 객체 생성
				$oPointController = getController('point');
				// 포인트 차감
				//$oPointController->setPoint($logged_info->member_srl, $this->module_info->page_unlock_point, 'subtract');
			}

			// 세션에 인증 여부 저장
			$_SESSION['XE_PAGE_AUTHORIZED'][$this->module_info->module_srl] = TRUE;
			// 세션에 인증 시간 저장
			$_SESSION['XE_PAGE_AUTHORIZED_TIME'][$this->module_info->module_srl] = time();
		}

		$returnUrl = Context::get('success_return_url');
		$this->setRedirectUrl($returnUrl);
	}
}