(function($){
	$(function(){
		var addonLoaded = false;

		$('.adminbar>ul>li>a').click(function(){
			$(this).parent().toggleClass('active');
			var menu = $(this).data('menu');
			var listHeight;

			switch(menu)
			{
				case 'addon':
					// 최초 한 번만 불러오도록
					if(!addonLoaded)
					{
						var $this = $(this);
						$('.adminbar-addon>ul>li:eq(0)').show();

						$.exec_json('easyxe.getEasyxeAdminAddonList', { }, function(data){
							$('.adminbar-addon>ul>li:eq(0)').hide();
							var addonCount = data.addon_list.length;
							listHeight = Math.min(38 * 10, 38 * addonCount, $(window).height() - 46);

							for(var i=0; i < addonCount; i++)
							{
								var node = $('<li>');
								var anchor = $('<a>').attr('href' , '#').text(data.addon_list[i].title).data('addon_name', data.addon_list[i].addon_name).data('is_active', data.addon_list[i].is_active);
								var is_active = $('<i>').addClass('fa fa-lg fa-fw');

								if(data.addon_list[i].activated)
								{
									is_active.addClass('fa-check');
								}
								else
								{
									is_active.addClass('fa-times');
								}

								anchor.append(is_active);
								node.append(anchor);
								node.appendTo('.adminbar-addon>ul');
							}

							$this.next().slideToggle(400, function(){
								$('.adminbar-addon>ul').height(listHeight);
							});

						});
						addonLoaded = true;
					}
					else
					{
						$(this).next().slideToggle(400, function(){
							$('.adminbar-addon>ul').height(listHeight);
						});
					}
					return false;
					break;
				default:
					if(menu)
					{
						$(this).next().slideToggle();
						return false;
					}
			}
		});

		$('.panel-tab-square>li>a').click(function(){
			// 각 메뉴의 href 속성은 콘텐츠 ID를 의미함
			var selector = $(this).attr('href');
			if(selector.indexOf('#') === 0)
			{
				// 스퀘어 메뉴를 숨김
				$(this).parent().parent().toggle('left');


				// 스퀘어 메뉴를 클릭했을 때 보여질 콘텐츠
				var tabContent = $(selector);

				var e = {
					square : $(this).parent().parent(),
					panel : tabContent.parent()
				};

				return false;
			}
		});


		/**
		 * 뒤로가기 버튼을 클릭한 경우
		 */
		$('.panel-tab-square-content').on('click', 'input[data-panel-action=back]', function(){
			if($(this).parent().is('form'))
			{
				var panelObj = $(this).parent().parent();
				var squareObj = panelObj.find('.panel-tab-square');
				$(this).parent().toggle('up', function (){
					panelObj.animate({ width : 392, height : 128 });
					panelObj.css('overflow-y', 'visible');

					squareObj.toggle('right', function(){
						panelObj.css('overflow-y', 'auto');
					});
				});
			}
			else
			{
				var panelObj = $(this).parent().parent().parent();
				$(this).parent().parent().height(128).css('overflow-y', 'visible');
				$(this).parent().toggle('up');
				$(this).parent().prev().toggle('right');
				$(this).parent().parent().css('overflow-y', 'hidden');
			}

		});

		$('#memberInsert>form').submit(function(){
			return false;
		});

		$('.panel-tab-square-content').submit(function(){
			// Form
			var $form = $(this);
			var callback = window[$(this).attr('id')];
			console.log(callback);

			callback($form);

			if($form.data('panel-resize') == 'true')
			{
				var form_height = $form.height();
				if(form_height > 120)
				{
					$form.parent().height(form_height / 2);
				}
			}

			return false;
		});

		$(document).on('click', '.adminbar-addon ul li a', function(){
			var $this = $(this);
			$.exec_json('easyxe.procEasyxeAdminToggleAddonActivate', { addon : $(this).data('addon_name') }, function(data) {
				var icon = $this.find('i');

				icon
					.removeClass('fa-check')
					.removeClass('fa-times');

				switch(data.status)
				{
					case 'on':
						icon.addClass('fa-check');
						break;
					case 'off':
						icon.addClass('fa-times');
						break;
				}

			});
			return false;
		});
	});
})(jQuery);