(function($){
	$(function(){
		// 관리자 메뉴 높이
		var adminBarHeight = $('.adminbar').outerHeight();
		// 관리자 메뉴 위치
		var adminBarPosition = $('.adminbar').hasClass('adminbar-bottom') ? 'bottom' : 'top';
		// 관리자 메뉴 객체
		var adminBar = {
			initialized: false,
			// 관리자 메뉴가 열려있는지?
			isOpened: false,
			// 관리자 메뉴가 움직이고 있는지?
			isAnimating: false,

			open: function()
			{
				if(!this.isOpened && !this.isAnimating)
				{
					var margin = get_body_margin(adminBarPosition);
					var new_margin = margin + adminBarHeight;
					this.isOpened = true;
					this.isAnimating = true;

					switch(adminBarPosition)
					{
						case 'top':
							$('body').animate({
								'margin-top' : new_margin
							}, 400);
							break;
						case 'bottom':
							$('body').animate({
								'margin-bottom' : new_margin
							}, 400);
							break;
					}

					$('.adminbar').slideDown(400, function(){
						adminBar.isAnimating = false;
						adjustFixedElements();
					});

					// toggle 버튼 위치 변경
					if(adminBarPosition == 'top')
					{
						$('.nav-toggle').animate( { top : adminBarHeight, duration : 400, 'opacity' : 0.7 } );
					}
					else
					{
						$('.nav-toggle').animate( { bottom : adminBarHeight, duration : 400, 'opacity' : 0.7 } );
					}

					$('.nav-toggle>i')
						.addClass('fa-chevron-up')
						.removeClass('fa-chevron-down');

					// 관리자 메뉴 상태를 쿠키에 저장
					setCookie('easyAdminBar', 'o');
				}
			},
			close: function(){
				if(!this.isAnimating)
				{
					if(this.isOpened)
					{
						this.isOpened = false;
						this.isAnimating = true;

						if(this.initialized)
						{
							var margin = get_body_margin(adminBarPosition);
							var new_margin = margin - adminBarHeight;

							switch(adminBarPosition)
							{
								case 'top':
									$('body').animate({
										'margin-top' : new_margin
									}, 400);
									break;
								case 'bottom':
									$('body').animate({
										'margin-bottom' : new_margin
									}, 400);
									break;
							}
						}

						$('.adminbar').slideUp(400, function(){
							adminBar.isAnimating = false;
							adjustFixedElements();
						});
					}

					if(adminBarPosition == 'top')
					{
						$('.nav-toggle').animate( { top : 0, duration : 400, 'opacity' : 0.5 } );
					}
					else
					{
						$('.nav-toggle').animate( { bottom : 0, duration : 400, 'opacity' : 0.5 } );
					}
					$('.nav-toggle>i')
						.removeClass('fa-chevron-up')
						.addClass('fa-chevron-down');

					setCookie('easyAdminBar', 'x');
				}
			}
		};

		/**
		 * body margin을 구하는 함수
		 */
		function get_body_margin(position){
			var margin = $('body').css('margin-' + position);
			var unit = margin.substr(-2);

			if(unit == 'px'){
				margin = parseInt(margin);
			}else{
				margin = 0;
			}

			return margin;
		}

		/**
		 * 웹 페이지를 열면 관리자 메뉴를 초기화함
		 */
		if(getCookie('easyAdminBar') == 'o') {
			adminBar.open();
		}
		else
		{
			adminBar.close();
		}

		adminBar.initialized = true;

		// 관리자 메뉴 열기/닫기 버튼
		$('.nav-toggle').click(function(){
			if(!adminBar.isOpened)
			{
				adminBar.open();
			}
			else
			{
				adminBar.close();
			}
		});

		/**
		 * 페이지에 fixed 요소가 있을 경우 이를 보정해주는 함수
		 */
		function adjustFixedElements()
		{
			var $fixed_elements = $('*').filter(function(){
				if($(this).get(0) == $('.adminbar').get(0)) return false;
				if($(this).css("position") !== 'fixed') return false;
				if($(this).hasClass('nav-toggle')) return false;
				if($(this).hasClass('x_modal')) return false;

				var invisible = false;
				if(!$(this).is(':visible')){
					invisible = true;
					$(this).show();
				}
				var top = $(this).position().top;
				if(invisible){
					$(this).hide();
				}
				if(top > adminBarHeight) return false;

				if(adminBar.isOpened)
				{
					$(this).css('top', top + adminBarHeight);
				}
				else
				{
					if(adminBar.initialized)
					{
						$(this).css('top', top - adminBarHeight);
					}
					else
					{
						adminBar.initialized = true;
					}
				}
				return true;
			});
		}

		/**
		 * 관리자 메뉴에 마우스를 올릴 경우 서브 메뉴를 보여줌
		 */
		$('.adminbar>.nav-gnb>li').hover(function(){
			$(this).find('ul').slideDown(200);
		}, function(){
			$(this).find('ul').slideUp(200);
		});

		/**
		 * 키보드 접근성 확보를 위함
		 */
		$('.adminbar>.nav-gnb>li>a').focus(function(){
			$(this).parent().find('ul').slideDown(200);
			$('.adminbar .active').find('ul').slideUp();
			$('.adminbar li').removeClass('active');
			$(this).parent().addClass('active');
		});


		var addonLoaded = false;

		$('.adminbar-addon').hover(function(){
			// 최초 한 번만 불러오도록
			if(!addonLoaded)
			{
				$('.adminbar-addon>ul>li:eq(0)').show();

				/**
				 * @TODO: 설치된 애드온을 활성화/비활성화 할 수 있도록
				 */
				$.exec_json('easyxe.getEasyxeAdminAddonList', { }, function(data){
					$('.adminbar-addon>ul>li:eq(0)').hide();
					var addonCount = data.addon_list.length;

					for(var i=0; i < addonCount; i++)
					{
						var node = $('<li>');
						var anchor = $('<a>').attr('href' , '#').text(data.addon_list[i].title).data('addon_name', data.addon_list[i].addon_name).data('is_active', data.addon_list[i].is_active);
						var is_active = $('<i>').addClass('fa fa-lg');

						if(data.addon_list[i].activated)
						{
							is_active.addClass('fa-check-circle');
						}
						else
						{
							is_active.addClass('fa-times');
						}

						anchor.append(is_active);
						node.append(anchor);
						node.appendTo('.adminbar-addon>ul');
					}
				});
				addonLoaded = true;
			}
		});

		$(document).on('click', '.adminbar-addon ul li a', function(){
			var $this = $(this);
			$.exec_json('easyxe.procEasyxeAdminToggleAddonActivate', { addon : $(this).data('addon_name') }, function(data) {
				var icon = $this.find('i');
				console.log(icon);
				icon
					.removeClass('fa-check-circle')
					.removeClass('fa-times');

				switch(data.status)
				{
					case 'on':
						icon.addClass('fa-check-circle');
						break;
					case 'off':
						icon.addClass('fa-times');
						break;
				}

			});
			return false;
		});
	});
})(jQuery);