<?php
/**
 * @class easyxeAdminController
 * @author 퍼니엑스이 (contact@funnyxe.com)
 * @brief easyxe 모듈의 admin controller class
 **/

class easyxeAdminController extends easyxe
{
	public function procEasyxeAdminSaveSetting()
	{
		$oEasyxeModel = getModel('easyxe');

		$config = $oEasyxeModel->getEasyxeConfig();
		$config->enabled = Context::get('enabled');
		$config->position = Context::get('position');
		$config->kakao_rest_api_key = Context::get('kakao_rest_api_key');
		$config->kakao_admin_key = Context::get('kakao_admin_key');

		$oModuleController = getController('module');
		$oModuleController->insertModuleConfig('easyxe', $config);

		$returnUrl = Context::get('success_return_url');
		if(!$returnUrl)
		{
			$returnUrl = getNotEncodedUrl('', 'module', 'admin', 'act', 'dispEasyxeAdminSetting');
		}

		$this->setRedirectUrl($returnUrl);
		$this->setMessage('success_saved');
	}

	public function procEasyxeAdminToggleAddonActivate()
	{
		$addon = Context::get('addon');

		$site_module_info = Context::get('site_module_info');
		// batahom addon values
		$addon = Context::get('addon');
		$type = Context::get('type');
		if(!$type)
		{
			$type = "pc";
		}

		$oAddonController = getAdminController('addon');

		if($addon)
		{
			$oAddonModel = getAdminModel('addon');
			// If enabled Disables
			if($oAddonModel->isActivatedAddon($addon, $site_module_info->site_srl, $type))
			{
				$status = 'off';
				$oAddonController->doDeactivate($addon, $site_module_info->site_srl, $type);
			}
			// If it is disabled Activate
			else
			{
				$status = 'on';
				$oAddonController->doActivate($addon, $site_module_info->site_srl, $type);
			}

			$this->add('status', $status);
		}

		$oAddonController->makeCacheFile($site_module_info->site_srl, $type);
	}

	/**
	 * 카카오톡 로그인 후 호출되는 함수
	 */
	public function procEasyxeAdminKakaoCallback()
	{
		$code = Context::get('code');
		if(!$code)
		{
			return new Object(-1, '카카오톡 로그인에 실패하였습니다.');
		}

		$oEasyxeModel = getModel('easyxe');

		$config = $oEasyxeModel->getEasyxeConfig();

		$ch = curl_init('https://kauth.kakao.com/oauth/token');

		$data = array(
			'grant_type' => 'authorization_code',
			'client_id' => $config->kakao_rest_api_key,
			'redirect_uri' => getFullUrl() . 'modules/easyxe/libs/KakaoCallback.php',
			'code' => $code
		);

		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE); 
		curl_setopt($ch, CURLOPT_POST, TRUE);
		curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));

		$result = curl_exec($ch);
		$result = json_decode($result);


		$config->kakao_authorize_code = $code;
		$config->kakao_access_token = $result->access_token;

		$oModuleController = getController('module');
		$oModuleController->insertModuleConfig('easyxe', $config);

		$returnUrl = getNotEncodedUrl('', 'module', 'admin', 'act', 'dispEasyxeAdminSetting');

		$this->setRedirectUrl($returnUrl);
	}
}