<?php
if(!class_exists('page'))
{
	require(_XE_PATH_ . 'modules/page/page.class.php');
}

if(!class_exists('pageAdminController'))
{
	require(_XE_PATH_ . 'modules/page/page.admin.controller.php');
}

/**
 * @class easyxeAdminController
 * @author 퍼니엑스이 (contact@funnyxe.com)
 * @brief easyxe 모듈의 admin controller class
 **/

class easyxeAdminController extends pageAdminController
{
	public function procPageAdminInsert()
	{
		$page_type = Context::get('page_type');

		// 페이지 타입을 변경하는 경우
		if($page_type)
		{
			Context::set('page_type', $page_type, TRUE);
		}

		parent::procPageAdminUpdate();
	}
	public function procPageAdminUpdate()
	{
		$this->procPageAdminInsert();
	}

	public function procEasyxeAdminSaveSetting()
	{
		$config = Context::gets('enabled', 'position');

		$oModuleController = getController('module');
		$oModuleController->insertModuleConfig('easyxe', $config);

		$returnUrl = Context::get('success_return_url');
		if(!$returnUrl)
		{
			$returnUrl = getNotEncodedUrl('', 'module', 'admin', 'act', 'dispEasyxeAdminSetting');
		}

		$this->setRedirectUrl($returnUrl);
		$this->setMessage('success_saved');
	}

	/**
	 * 엑셀 파일로 다운받기
	 */
	public function procEasyxeAdminDownloadMenuTreeExcel()
	{
		require $this->module_path . 'libs/PHPExcel.php';

		Context::setResponseMethod('XMLRPC');

		$xlsDoc = new PHPExcel();

		/**
		 * @TODO : 메뉴 트리를 엑셀 파일 형태로 변환
		 */

		/**
		 * @TODO : 다운로드용 헤더 추가
		 */
		header();
	}

	public function procEasyxeAdminToggleAddonActivate()
	{
		$addon = Context::get('addon');

		$site_module_info = Context::get('site_module_info');
		// batahom addon values
		$addon = Context::get('addon');
		$type = Context::get('type');
		if(!$type)
		{
			$type = "pc";
		}

		$oAddonController = getAdminController('addon');

		if($addon)
		{
			$oAddonModel = getAdminModel('addon');
			// If enabled Disables
			if($oAddonModel->isActivatedAddon($addon, $site_module_info->site_srl, $type))
			{
				$status = 'off';
				$oAddonController->doDeactivate($addon, $site_module_info->site_srl, $type);
			}
			// If it is disabled Activate
			else
			{
				$status = 'on';
				$oAddonController->doActivate($addon, $site_module_info->site_srl, $type);
			}

			$this->add('status', $status);
		}

		$oAddonController->makeCacheFile($site_module_info->site_srl, $type);
	}
}