<?php
class easyxeController extends easyxe
{
	/**
	 * after_module_proc 시점에 실행되는 trigger
	 */
	public function triggerAfterModuleProc(&$oModule)
	{
		if($oModule->act == 'dispBoardAdminBoardAdditionSetup' && Context::getResponseMethod() == 'HTML')
		{
			Context::addJsFile('./modules/easyxe/tpl/_extends/board/js/addition_setup.js');
		}

		if($oModule->module_info->module_type != 'view')
		{
			return new Object();
		}

		if($oModule->getLayoutPath() == './common/tpl/' || $oModule->getLayoutFile() == 'popup_layout.html')
		{
			return new Object();
		}


		Context::set('easyAdminBar', TRUE);
		Context::set('easyAdminBarStatus', $_COOKIE['easyAdminBar']);

		return new Object();
	}

	public function triggerBeforeDisplayContent(&$output)
	{
		// 모듈 정보를 가져옵니다.
		$module_info = Context::get('current_module_info');

		$easyAdminBar = Context::get('easyAdminBar');
		if(!$easyAdminBar)
		{
			return new Object();
		}

		if(Context::get('act') == 'dispWidgetAdminAddContent')
		{
			$output = str_replace('<div class="editor">', '<!--<button type="button" class="x_btn">HTML 코드 삽입</button><br><br>--><div class="editor">', $output);
		}

		// 제외할 모듈
		$except_module_list = array(
			'comment',
			'document',
			'file',
			'module',
			'widget',
			'editor'
		);

		// 제외할 act
		$except_act_list = array(
			'dispWidgetAdminAddContent',
			'dispLayoutPreviewWithModule',
			'dispEditorPopup',
			'dispEasyxeAdminViewPageSource',
			'dispEasyxeAdminViewMobilePageSource'
		);

		if(in_array($module_info->module, $except_module_list) && !$module_info->mid)
		{
			return new Object();
		}

		if(in_array($module_info->act, $except_act_list))
		{
			return new Object();
		}

		$act = Context::get('act');

		if(in_array($act, $except_act_list))
		{
			return new Object();
		}

		// 로그인 정보
		$logged_info = Context::get('logged_info');

		// 관리자이고 view이고 메인 사이트인 경우
		if($logged_info->is_admin =='Y' && $module_info->module_type == 'view' && $module_info->site_srl == 0)
		{
			/**
			 * view이지만 응답 방식이 HTML이 아닌 경우 실행 종료
			 * ex) rss, ajax request
			 */
			if(Context::getResponseMethod() != 'HTML')
			{
				return new Object();
			}

			// easyxeModel 객체 생성
			$oEasyxeModel = getModel('easyxe');

			// easyxe 모듈 설정
			$easyxeConfig = $oEasyxeModel->getEasyxeConfig();
			if($easyxeConfig->enabled != 'Y')
			{
				return new Object();
			}

			Context::set('easyxeConfig', $easyxeConfig);

			// TemplateHandler 객체 생성
			$oTemplateHandler = TemplateHandler::getInstance();

			$admin_bar_html = $oTemplateHandler->compile($this->module_path .'tpl', 'admin_bar.html');

			// <body> 바로 뒤에 html 추가
			$output = $admin_bar_html . $output;
		}

		return new Object();
	}
}