/**
 * @file   modules/page/js/page_admin.js
 * @author NAVER (developers@xpressengine.com)
 * @brief  page모듈의 관리자용 javascript
 **/

/* 모듈 생성 후 */
function completeInsertPage(ret_obj) {
	var error = ret_obj['error'];
	var message = ret_obj['message'];

	var page = ret_obj['page'];
	var module_srl = ret_obj['module_srl'];

	alert(message);

	var url = '';
	if(location.href.getQuery('module')=='admin') {
		url = current_url.setQuery('module_srl',module_srl).setQuery('act','dispPageAdminInfo');
		if(page) url = url.setQuery('page',page);
	} else {
		url = current_url;
	}

	location.href = url;
}

function completeArticleDocumentInserted(ret_obj){
	var error = ret_obj['error'];
	var message = ret_obj['message'];

	var mid = ret_obj['mid'];
	var is_mobile = ret_obj['is_mobile'];

	alert(message);

	var url = '';
	
	if(is_mobile == 'Y')
		url = current_url.setQuery('act', 'dispPageAdminMobileContent').setQuery('mid', mid);
	else
		url = current_url.setQuery('act', 'dispPageIndex').setQuery('mid', mid);


	location.href = url;
}

/* 내용 저장 후 */
function completeInsertPageContent(ret_obj) {
	var error = ret_obj['error'];
	var message = ret_obj['message'];

	var page = ret_obj['page'];
	var module_srl = ret_obj['module_srl'];
	var mid = ret_obj['mid'];

	location.href = current_url.setQuery('mid',mid).setQuery('act','');
}

function completeInsertMobilePageContent(ret_obj) {
	var error = ret_obj['error'];
	var message = ret_obj['message'];

	var page = ret_obj['page'];
	var module_srl = ret_obj['module_srl'];
	var mid = ret_obj['mid'];

	location.href = current_url.setQuery('mid',mid).setQuery('act','dispPageAdminMobileContent');
}

/* 수정한 페이지 컨텐츠를 저장 */
function doSubmitPageContent(fo_obj) {
	var html = getWidgetContent();
	fo_obj.content.value = html;
	return procFilter(fo_obj, insert_page_content);
}

function doSubmitMPageContent(fo_obj) {
	var html = getWidgetContent();
	fo_obj.content.value = html;
	return procFilter(fo_obj, insert_mpage_content);
}

/* 모듈 삭제 후 */
function completeDeletePage(ret_obj) {
	var error = ret_obj['error'];
	var message = ret_obj['message'];
	var page = ret_obj['page'];
	alert(message);

	var url = current_url.setQuery('act','dispPageAdminContent').setQuery('module_srl','');
	if(page) url = url.setQuery('page',page);

	location.href = url;
}

/* 위젯 재컴파일 */
function doRemoveWidgetCache(module_srl) {
	var params = new Array();
	params["module_srl"] = module_srl;
	exec_xml('page', 'procPageAdminRemoveWidgetCache', params, completeRemoveWidgetCache);
}

function completeRemoveWidgetCache(ret_obj) {
	var message = ret_obj['message'];
	location.reload(); 
}

/* 일괄 설정 */
function doCartSetup(url) {
	var module_srl = new Array();
	jQuery('#fo_list input[name=cart]:checked').each(function() {
		module_srl[module_srl.length] = jQuery(this).val();
	});

	if(module_srl.length<1) return;

	url += "&module_srls="+module_srl.join(',');
	popopen(url,'modulesSetup');
}

jQuery(function($){
	$('#pageBtnArea').delay(1000).show(1);
});

var selectedNode;

// 잘라내기/복사 시 객체가 저장 될 임시저장소
var easyxeClipboard;
var easyxeClipboardType;

(function($){
	$(function(){
		$('#changePageType').click(function(){
			if(confirm('\'주의!\'\n\n페이지 타입 변경 시 기존에 저장되어 있는 페이지가 유실될 수 있으며, 유실에 대한 책임은 사용자에게 있습니다.'))
			{
				$('#page_type').attr('disabled', false);
				$(this).hide();
			}
		});

		$('#zonePageContent').contextmenu({
			delegate: "div.widgetOutput",
			menu: [
				{title: "잘라내기", cmd: "cut", uiIcon: "ui-icon-scissors"},
				{title: "복사", cmd: "copy", uiIcon: "ui-icon-copy"},
				{title: "붙여넣기", cmd: "paste", uiIcon: "ui-icon-clipboard", disabled: true },
				/*{title: "----"},
				{title: "수정", cmd: "edit", uiIcon: "ui-icon-pencil", disabled: false },
				{title: "삭제", cmd: "delete", uiIcon: "ui-icon-trash", disabled: false },
				{title: "위젯 추가", children: [
					{title: "위", cmd: "insert_top"},
					{title: "아래", cmd: "insert_bottom"}
				]}*/
			],
			beforeOpen: function(event, ui) {
				selectedNode = event.currentTarget;
				if(selectedNode.getAttribute('widget') != 'widgetBox')
				{
					$('#zonePageContent').contextmenu('enableEntry', 'paste', false);
				}
			},
			select: function(event, ui) {
				switch(ui.cmd)
				{
					// 잘라내기
					case 'cut':
						// 클립보드에 저장한 뒤에
						easyxeClipboard = selectedNode;
						easyxeClipboardType = 'cut';
						easyxeClipboard.setAttribute('id', idStep-1);
						// 삭제
						selectedNode.parentNode.removeChild(selectedNode);
						// 붙여넣기 메뉴 활성화
						$('#zonePageContent').contextmenu('enableEntry', 'paste', true);
						break;
					// 복사
					case 'copy':
						easyxeClipboard = selectedNode;
						easyxeClipboardType = 'copy';
						easyxeClipboard.setAttribute('id', idStep-1);
						// 붙여넣기 메뉴 활성화
						$('#zonePageContent').contextmenu('enableEntry', 'paste', true);
						break;
					// 붙여넣기
					case 'paste':
						// 클립보드에 요소가 저장되어 있다면
						if(easyxeClipboard)
						{
							var widget = easyxeClipboard.getAttribute('widget');

							// 직접 추가된 내용이라면
							if(widget == 'widgetContent' && easyxeClipboard.getAttribute('document_srl') && easyxeClipboardType == 'copy')
							{
								var response_tags = ['error','message','document_srl'];
								var params = [];
								params.document_srl = easyxeClipboard.getAttribute('document_srl');
								exec_xml('widget','procWidgetCopyDocument', params, completeCopyWidgetContent, response_tags, params, p_obj);
							}
							else
							{
								var dummy = xCreateElement("DIV");
								xInnerHtml(dummy,xInnerHtml(easyxeClipboard));

								dummy.widget_sequence = '';
								dummy.className = "widgetOutput";
								for(var i=0;i<easyxeClipboard.attributes.length;i++) {
									if(!easyxeClipboard.attributes[i].nodeName || !easyxeClipboard.attributes[i].nodeValue) continue;
									var name = easyxeClipboard.attributes[i].nodeName.toLowerCase();

									var value = easyxeClipboard.attributes[i].nodeValue;
									if(!value) continue;

									if(value && typeof(value)=="string") value = value.replace(/\"/ig,'&quot;');

									dummy.setAttribute(name, value);
								}

								if(xIE4Up) dummy.style.cssText = easyxeClipboard.style.cssText;
								$(selectedNode)
									.find('.widgetBoxBorder')
										.find('.nullWidget')
											.append(dummy);
							}
						}
						// 잘라내기 후 붙여넣기를 했다면
						if(easyxeClipboardType != 'copy')
						{
							// 붙여넣기 메뉴 비활성화
							$('#zonePageContent').contextmenu('enableEntry', 'paste', false);
						}
						break;
					// 수정
					case 'edit':
						alert('아직 개발중인 기능입니다.');
						return false;
						/**
						 * @TODO: 위젯인지 직접 추가한 내용인지 판별해서 팝업창 띄우기
						 */
						break;
					case 'insert_top':
						alert('아직 개발중인 기능입니다.');
						return false;
						/**
						 * @TODO: 선택한 위젯 앞에 위젯을 추가할 수 있는 팝업 띄우기
						 */
						break;
					case 'insert_bottom':
						alert('아직 개발중인 기능입니다.');
						return false;
						/**
						 * @TODO: 선택한 위젯 뒤에 위젯을 추가할 수 있는 팝업 띄우기
						 */
						break;
				}
			}
		});
	});
})(jQuery);