<?php
/**
 * @class easyxe
 * @author 퍼니엑스이 (contact@funnyxe.com)
 * @brief easyxe 모듈의 high class
 **/

class easyxe extends ModuleObject
{
	private $triggers = array(

	);

	/**
	 * @brief 모듈 설치
	 **/
	function moduleInstall()
	{
		return new Object();
	}

	/**
	 * @brief 업데이트가 필요한지 확인
	 **/
	function checkUpdate()
	{
		// moduleModel 객체 생성
		$oModuleModel = getModel('module');
		if(!$oModuleModel->getTrigger('module.deleteModule', 'document', 'controller', 'triggerDeleteModuleDocuments', 'after')) return true;

		// after_module_proc 시점의 trigger
		if(!$oModuleModel->getTrigger('moduleObject.proc', 'easyxe', 'controller', 'triggerAfterModuleProc', 'after'))
		{
			return TRUE;
		}

		// before_display_content 시점의 trigger
		if(!$oModuleModel->getTrigger('display', 'easyxe', 'controller', 'triggerBeforeDisplayContent', 'before'))
		{
			return TRUE;
		}

		// page module extend가 등록되어 있지 않은 경우
		if(!$oModuleModel->getModuleExtend('page', 'view'))
		{
			return TRUE;
		}

		if(!$oModuleModel->getModuleExtend('page', 'view', 'admin'))
		{
			return TRUE;
		}

		return FALSE;
	}

	/**
	* @brief 모듈 업데이트
	**/
	function moduleUpdate()
	{
		// moduleModel 객체 생성
		$oModuleModel = getModel('module');
		// moduleController 객체 생성
		$oModuleController = getController('module');

		// after_module_proc 시점의 trigger
		if(!$oModuleModel->getTrigger('moduleObject.proc', 'easyxe', 'controller', 'triggerAfterModuleProc', 'after'))
		{
			$oModuleController->insertTrigger('moduleObject.proc', 'easyxe', 'controller', 'triggerAfterModuleProc', 'after');
		}

		// before_display_content 시점의 trigger
		if(!$oModuleModel->getTrigger('display', 'easyxe', 'controller', 'triggerBeforeDisplayContent', 'before'))
		{
			$oModuleController->insertTrigger('display', 'easyxe', 'controller', 'triggerBeforeDisplayContent', 'before');
		}

		// page module extend가 등록되어 있지 않은 경우
		if(!$oModuleModel->getModuleExtend('page', 'view'))
		{
			$oModuleController->insertModuleExtend('page', 'easyxe', 'view');
		}

		if(!$oModuleModel->getModuleExtend('page', 'view', 'admin'))
		{
			$oModuleController->insertModuleExtend('page', 'easyxe', 'view', 'admin');
		}

		return new Object(0,'success_updated');
	}

	/**
	 * @brief 캐시 파일 재생성
	 **/
	function recompileCache()
	{
	}
}