<?php
if(!class_exists('page'))
{
	require(_XE_PATH_ . 'modules/page/page.class.php');
}

if(!class_exists('pageAdminController'))
{
	require(_XE_PATH_ . 'modules/page/page.admin.controller.php');
}

/**
 * @class easyxeAdminController
 * @author 퍼니엑스이 (contact@funnyxe.com)
 * @brief easyxe 모듈의 admin controller class
 **/

class easyxeAdminController extends pageAdminController
{
	public function procPageAdminUpdate()
	{
		$page_type = Context::get('page_type');

		// 페이지 타입을 변경하는 경우
		if($page_type)
		{
			Context::set('page_type', $page_type, TRUE);
		}

		parent::procPageAdminUpdate();
	}

	public function procEasyxeAdminSaveSetting()
	{
		$config = Context::gets('enabled', 'position');

		$oModuleController = getController('module');
		$oModuleController->insertModuleConfig('easyxe', $config);

		$returnUrl = Context::get('success_return_url');
		if(!$returnUrl)
		{
			$returnUrl = getNotEncodedUrl('', 'module', 'admin', 'act', 'dispEasyxeAdminSetting');
		}

		$this->setRedirectUrl($returnUrl);
		$this->setMessage('success_saved');
	}

	/**
	 * 엑셀 파일로 다운받기
	 */
	public function procEasyxeAdminDownloadMenuTreeExcel()
	{
		require $this->module_path . 'libs/PHPExcel.php';

		Context::setResponseMethod('XMLRPC');

		$xlsDoc = new PHPExcel();

		/**
		 * @TODO : 메뉴 트리를 엑셀 파일 형태로 변환
		 */

		/**
		 * @TODO : 다운로드용 헤더 추가
		 */
		header();
	}
}