/**
 * @file   modules/page/js/page_admin.js
 * @author NAVER (developers@xpressengine.com)
 * @brief  page모듈의 관리자용 javascript
 **/

/* 모듈 생성 후 */
function completeInsertPage(ret_obj) {
	var error = ret_obj['error'];
	var message = ret_obj['message'];

	var page = ret_obj['page'];
	var module_srl = ret_obj['module_srl'];

	alert(message);

	var url = '';
	if(location.href.getQuery('module')=='admin') {
		url = current_url.setQuery('module_srl',module_srl).setQuery('act','dispPageAdminInfo');
		if(page) url = url.setQuery('page',page);
	} else {
		url = current_url;
	}

	location.href = url;
}

function completeArticleDocumentInserted(ret_obj){
	var error = ret_obj['error'];
	var message = ret_obj['message'];

	var mid = ret_obj['mid'];
	var is_mobile = ret_obj['is_mobile'];

	alert(message);

	var url = '';
	
	if(is_mobile == 'Y')
		url = current_url.setQuery('act', 'dispPageAdminMobileContent').setQuery('mid', mid);
	else
		url = current_url.setQuery('act', 'dispPageIndex').setQuery('mid', mid);


	location.href = url;
}

/* 내용 저장 후 */
function completeInsertPageContent(ret_obj) {
	var error = ret_obj['error'];
	var message = ret_obj['message'];

	var page = ret_obj['page'];
	var module_srl = ret_obj['module_srl'];
	var mid = ret_obj['mid'];

	location.href = current_url.setQuery('mid',mid).setQuery('act','');
}

function completeInsertMobilePageContent(ret_obj) {
	var error = ret_obj['error'];
	var message = ret_obj['message'];

	var page = ret_obj['page'];
	var module_srl = ret_obj['module_srl'];
	var mid = ret_obj['mid'];

	location.href = current_url.setQuery('mid',mid).setQuery('act','dispPageAdminMobileContent');
}

/* 수정한 페이지 컨텐츠를 저장 */
function doSubmitPageContent(fo_obj) {
	var html = getWidgetContent();
	fo_obj.content.value = html;
	return procFilter(fo_obj, insert_page_content);
}

function doSubmitMPageContent(fo_obj) {
	var html = getWidgetContent();
	fo_obj.content.value = html;
	return procFilter(fo_obj, insert_mpage_content);
}

/* 모듈 삭제 후 */
function completeDeletePage(ret_obj) {
	var error = ret_obj['error'];
	var message = ret_obj['message'];
	var page = ret_obj['page'];
	alert(message);

	var url = current_url.setQuery('act','dispPageAdminContent').setQuery('module_srl','');
	if(page) url = url.setQuery('page',page);

	location.href = url;
}

/* 위젯 재컴파일 */
function doRemoveWidgetCache(module_srl) {
	var params = new Array();
	params["module_srl"] = module_srl;
	exec_xml('page', 'procPageAdminRemoveWidgetCache', params, completeRemoveWidgetCache);
}

function completeRemoveWidgetCache(ret_obj) {
	var message = ret_obj['message'];
	location.reload(); 
}

/* 일괄 설정 */
function doCartSetup(url) {
	var module_srl = new Array();
	jQuery('#fo_list input[name=cart]:checked').each(function() {
		module_srl[module_srl.length] = jQuery(this).val();
	});

	if(module_srl.length<1) return;

	url += "&module_srls="+module_srl.join(',');
	popopen(url,'modulesSetup');
}

jQuery(function($){
	$('#pageBtnArea').delay(1000).show(1);
});

var selectedNode;

// 잘라내기/복사 시 객체가 저장 될 임시저장소
var easyxeClipboard;

(function($){
	$(function(){
		$('#changePageType').click(function(){
			if(confirm('\'주의!\'\n\n페이지 타입 변경 시 기존에 저장되어 있는 페이지가 유실될 수 있으며, 유실에 대한 책임은 사용자에게 있습니다.'))
			{
				$('#page_type').attr('disabled', false);
				$(this).hide();
			}
		});

		$('#zonePageContent').contextmenu({
			delegate: "div.widgetOutput",
			menu: [
				{title: "잘라내기", cmd: "cut", uiIcon: "ui-icon-scissors"},
				{title: "복사", cmd: "copy", uiIcon: "ui-icon-copy"},
				{title: "붙여넣기", cmd: "paste", uiIcon: "ui-icon-clipboard", disabled: true },
				{title: "----"},
				{title: "수정", cmd: "edit", uiIcon: "ui-icon-pencil", disabled: false },
				{title: "삭제", cmd: "delete", uiIcon: "ui-icon-trash", disabled: false },
				{title: "위젯 추가", children: [
					{title: "위", cmd: "insert_top"},
					{title: "아래", cmd: "insert_bottom"}
				]}
			],
			beforeOpen: function(event, ui) {
				selectedNode = event.currentTarget;
			},
			select: function(event, ui) {
				switch(ui.cmd)
				{
					// 잘라내기
					case 'cut':
						alert('아직 개발중인 기능입니다.');
						return false;
						// 클립보드에 저장한 뒤에
						easyxeClipboard = selectedNode;
						// 삭제
						selectedNode.parentNode.removeChild(selectedNode);
						$('#zonePageContent').contextmenu('enableEntry', 'paste', true);
						break;
					// 복사
					case 'copy':
						alert('아직 개발중인 기능입니다.');
						return false;
						easyxeClipboard = selectedNode;
						$('#zonePageContent').contextmenu('enableEntry', 'paste', true);
						break;
					// 붙여넣기
					case 'paste':
						alert('아직 개발중인 기능입니다.');
						return false;
						/**
						 * @TODO : 클립보드에 저장된 위젯의 코드를 다시 생성해서 삽입
						 * widget.generateCode
						 */

						// 클립보드에 요소가 저장되어 있다면
						if(easyxeClipboard)
						{
							var widget = easyxeClipboard.getAttribute('widget');
							// 직접 추가된 내용이라면
							if(widget == 'widgetContent')
							{
							}
							/**
							 * @TODO 위젯이라면 widget.procWidgetGenerateCodeInPage에 요청을 보내서 code를 다시 받아온다
							 */
							else
							{
							}
						}
						$('#zonePageContent').contextmenu('enableEntry', 'paste', false);
						break;
					// 수정
					case 'edit':
						alert('아직 개발중인 기능입니다.');
						return false;
						/**
						 * @TODO: 위젯인지 직접 추가한 내용인지 판별해서 팝업창 띄우기
						 */
						break;
					case 'insert_top':
						alert('아직 개발중인 기능입니다.');
						return false;
						/**
						 * @TODO: 선택한 위젯 앞에 위젯을 추가할 수 있는 팝업 띄우기
						 */
						break;
					case 'insert_bottom':
						alert('아직 개발중인 기능입니다.');
						return false;
						/**
						 * @TODO: 선택한 위젯 뒤에 위젯을 추가할 수 있는 팝업 띄우기
						 */
						break;
				}
			}
		});
	});
})(jQuery);