<?php
if(!class_exists('page'))
{
	require(_XE_PATH_ . 'modules/page/page.class.php');
}

if(!class_exists('pageView'))
{
	require(_XE_PATH_ . 'modules/page/page.view.php');
}

class easyxeView extends pageView
{
	public function dispPageIndex()
	{
		parent::init();
		parent::dispPageIndex();

		$this->setTemplatePath('./modules/page/tpl/');
	}

	function _getArticleContent()
	{
		$oTemplate = TemplateHandler::getInstance();

		$oDocumentModel = getModel('document');
		$oDocument = $oDocumentModel->getDocument(0, true);

		if($this->module_info->document_srl)
		{
			$document_srl = $this->module_info->document_srl;
			$oDocument->setDocument($document_srl);
			Context::set('document_srl', $document_srl);
		}
		Context::set('oDocument', $oDocument);

		if ($this->module_info->skin)
		{
			$templatePath = (sprintf('./modules/page/skins/%s', $this->module_info->skin));
		}
		else
		{
			$templatePath = ('./modules/page/skins/default');
		}

		$page_content = $oTemplate->compile($templatePath, 'content');

		return $page_content;
	}
}