(function($){
	$(function(){
		// 관리자 메뉴 높이
		var adminBarHeight = $('.adminbar').outerHeight();
		// 관리자 메뉴 위치
		var adminBarPosition = $('.adminbar').hasClass('adminbar-bottom') ? 'bottom' : 'top';
		// 관리자 메뉴 객체
		var adminBar = {
			initialized: false,
			// 관리자 메뉴가 열려있는지?
			isOpened: false,
			// 관리자 메뉴가 움직이고 있는지?
			isAnimating: false,

			open: function()
			{
				if(!this.isOpened && !this.isAnimating)
				{
					var margin = get_body_margin(adminBarPosition);
					var new_margin = margin + adminBarHeight;
					this.isOpened = true;
					this.isAnimating = true;

					switch(adminBarPosition)
					{
						case 'top':
							$('body').animate({
								'margin-top' : new_margin
							}, 400);
							break;
						case 'bottom':
							$('body').animate({
								'margin-bottom' : new_margin
							}, 400);
							break;
					}

					$('.adminbar').slideDown(400, function(){
						adminBar.isAnimating = false;
						adjustFixedElements();
					});

					// toggle 버튼 위치 변경
					if(adminBarPosition == 'top')
					{
						$('.nav-toggle').animate( { top : adminBarHeight, duration : 400, 'opacity' : 1 } );
					}
					else
					{
						$('.nav-toggle').animate( { bottom : adminBarHeight, duration : 400, 'opacity' : 1 } );
					}

					$('.nav-toggle>i')
						.addClass('fa-chevron-up')
						.removeClass('fa-chevron-down');

					// 관리자 메뉴 상태를 쿠키에 저장
					setCookie('easyAdminBar', 'o');
				}
			},
			close: function(){
				if(!this.isAnimating)
				{
					if(this.isOpened)
					{
						this.isOpened = false;
						this.isAnimating = true;

						if(this.initialized)
						{
							var margin = get_body_margin(adminBarPosition);
							var new_margin = margin - adminBarHeight;

							switch(adminBarPosition)
							{
								case 'top':
									$('body').animate({
										'margin-top' : new_margin
									}, 400);
									break;
								case 'bottom':
									$('body').animate({
										'margin-bottom' : new_margin
									}, 400);
									break;
							}
						}

						$('.adminbar').slideUp(400, function(){
							adminBar.isAnimating = false;
							adjustFixedElements();
						});
					}

					if(adminBarPosition == 'top')
					{
						$('.nav-toggle').animate( { top : 0, duration : 400, 'opacity' : 0.5 } );
					}
					else
					{
						$('.nav-toggle').animate( { bottom : 0, duration : 400, 'opacity' : 0.5 } );
					}
					$('.nav-toggle>i')
						.removeClass('fa-chevron-up')
						.addClass('fa-chevron-down');

					setCookie('easyAdminBar', 'x');
				}
			}
		};

		function get_body_margin(position){
			var margin = $('body').css('margin-' + position);
			var unit = margin.substr(-2);

			if(unit == 'px'){
				margin = parseInt(margin);
			}else{
				margin = 0;
			}

			return margin;
		}

		if(getCookie('easyAdminBar') == 'o') {
			adminBar.open();
		}
		else
		{
			adminBar.close();
		}

		adminBar.initialized = true;

		$('.nav-toggle').click(function(){
			if(!adminBar.isOpened)
			{
				adminBar.open();
			}
			else
			{
				adminBar.close();
			}
		});

		function adjustFixedElements()
		{
			var $fixed_elements = $('*').filter(function(){
				if($(this).get(0) == $('.adminbar').get(0)) return false;
				if($(this).css("position") !== 'fixed') return false;
				if($(this).hasClass('nav-toggle')) return false;

				var invisible = false;
				if(!$(this).is(':visible')){
					invisible = true;
					$(this).show();
				}
				var top = $(this).position().top;
				if(invisible){
					$(this).hide();
				}
				if(top > adminBarHeight) return false;

				if(adminBar.isOpened)
				{
					$(this).css('top', top + adminBarHeight);
				}
				else
				{
					if(adminBar.initialized)
					{
						$(this).css('top', top - adminBarHeight);
					}
					else
					{
						adminBar.initialized = true;
					}
				}
				return true;
			});
		}

		$('.adminbar>.nav-gnb>li').hover(function(){
			$(this).find('ul').slideDown(200);
		}, function(){
			$(this).find('ul').slideUp(200);
		});

		$('.adminbar>.nav-gnb>li>a').focus(function(){
			$(this).parent().find('ul').slideDown(200);
			$('.adminbar .active').find('ul').slideUp();
			$('.adminbar li').removeClass('active');
			$(this).parent().addClass('active');
		});
	});
})(jQuery);