<?php
if(!class_exists('page'))
{
	require(_XE_PATH_ . 'modules/page/page.class.php');
}

if(!class_exists('pageAdminView'))
{
	require(_XE_PATH_ . 'modules/page/page.admin.view.php');
}

/**
 * @class easyxeAdminView
 * @author 퍼니엑스이 (contact@funnyxe.com)
 * @brief 퍼니엑스이 모듈의 admin view class
 **/

class easyxeAdminView extends pageAdminView
{

	/**
	 * @brief 초기화
	 **/
	function init()
	{
		parent::init();

		$this->setTemplatePath('./modules/page/tpl/');
	}

	/**
	 * 모듈 확장 시 반드시 호출되어야 하는 코드
	 */
	private function _prepareExtend($module)
	{
		$this->setTemplatePath('./modules/easyxe/tpl/_extends/' . $module);
	}

	private function _setTemplatePath($module)
	{
		$this->setTemplatePath('./modules/' . $module . '/tpl/');
	}

	/**
	 * Menu depth arrange
	 * @return void
	 */
	function straightenMenu($menu_item, $depth)
	{
		if(!$menu_item['link']) return;
		$obj = new stdClass;
		$obj->href = $menu_item['href'];
		$obj->depth = $depth;
		$obj->text = $menu_item['text'];
		$this->result[] = $obj;
		if(!$menu_item['list']) return;
		foreach($menu_item['list'] as $item)
		{
			$this->straightenMenu($item, $depth+1);
		}
	}

	public function dispPageAdminContent()
	{
		return parent::dispPageAdminContent();
	}

	/**
	 * 페이지 정보 수정
	 */
	function dispPageAdminInfo()
	{
		$output = parent::dispPageAdminInfo();
		if(is_object($output) && !$output->toBool())
		{
			return $output;
		}

		$oEasyxeModel = getModel('easyxe');
		$easyxe_config = $oEasyxeModel->getEasyxeConfig();

		if($easyxe_config->enabled == 'Y')
		{
			$this->_prepareExtend('page');
		}
		else
		{
			$this->_setTemplatePath('page');
		}
	}

	public function dispPageAdminContentModify()
	{
		return parent::dispPageAdminContentModify();
	}

	public function dispPageAdminPageAdditionSetup()
	{
		return parent::dispPageAdminPageAdditionSetup();
	}

	public function dispPageAdminGrantInfo()
	{
		return parent::dispPageAdminGrantInfo();
	}

	public function dispEasyxeAdminSetting()
	{
		$oEasyxeModel = getModel('easyxe');
		$config = $oEasyxeModel->getEasyxeConfig();

		Context::set('config', $config);

		$this->_setTemplatePath('easyxe');
		$this->setTemplateFile('setting');
	}

	public function dispEasyxeAdminMenuTree()
	{
		$oMenuAdminModel = getAdminModel('menu');

		$menu_srl = Context::get('menu_srl');

		$menu_info = $oMenuAdminModel->getMenu($menu_srl);

		if(!$menu_srl)
		{
			$oMenuAdminController = getAdminController('menu');
			$homeMenuCacheFile = $oMenuAdminController->getHomeMenuCacheFile();

			if(file_exists($homeMenuCacheFile))
			{
				@include($homeMenuCacheFile);
			}
			$menu_info->php_file = './files/cache/menu/'.$homeMenuSrl.'.php';
		}

		if(file_exists($menu_info->php_file)) @include($menu_info->php_file);
		if(is_array($menu->list))
		{
			foreach($menu->list as $menu_item)
			{
				$this->straightenMenu($menu_item, 0);
			}
		}

		$menu_list = $oMenuAdminModel->getMenus();

		Context::set('menu_list', $menu_list);

		Context::set('menu_item_list', $this->result);

		$this->_setTemplatePath('easyxe');
		$this->setTemplateFile('menu');
	}

	public function dispEasyxeAdminCurrentPageDesign()
	{
		$oLayoutModel = getModel('layout');
		$layout_list = $oLayoutModel->getLayoutList(0);

		Context::set('layout_list', $layout_list);

		/**
		 * @TODO : init 에서 처리하도록
		 */
		$this->_setTemplatePath('easyxe');
		$this->setTemplateFile('currentPageDesign');
	}

	public function dispEasyxeAdminViewPageSource()
	{
		$module_info = Context::get('module_info');
		if($module_info->module != 'page')
		{
			return new Object(-1, '사용할 수 없는 기능입니다.');
		}

		if($module_info->page_type != 'OUTSIDE')
		{
			return new Object(-1, '사용할 수 없는 기능입니다.');
		}

		if(!$module_info->path)
		{
			return new Object(-1, '외부 파일 경로를 입력한 뒤에 다시 시도해주세요.');
		}

		$page_content = htmlspecialchars(FileHandler::readFile($module_info->path));

		Context::set('page_source', $page_content);

		$this->setLayoutPath('./common/tpl/');
		$this->setLayoutFile('popup_layout');

		$this->_setTemplatePath('easyxe');
		$this->setTemplateFile('viewPageSource');
	}

	/**
	 * 모바일 페이지 소스 보기
	 */
	public function dispEasyxeAdminViewMobilePageSource()
	{
		$module_info = Context::get('module_info');
		if($module_info->module != 'page')
		{
			return new Object(-1, '사용할 수 없는 기능입니다.');
		}

		if($module_info->page_type != 'OUTSIDE')
		{
			return new Object(-1, '사용할 수 없는 기능입니다.');
		}

		if(!$module_info->mpath)
		{
			return new Object(-1, '외부 파일 경로를 입력한 뒤에 다시 시도해주세요.');
		}

		$page_content = htmlspecialchars(FileHandler::readFile($module_info->mpath));

		Context::set('page_source', $page_content);

		$this->setLayoutPath('./common/tpl/');
		$this->setLayoutFile('popup_layout');

		$this->_setTemplatePath('easyxe');
		$this->setTemplateFile('viewPageSource');
	}
}