<?php
class easyxeController extends easyxe
{
	/**
	 * after_module_proc 시점에 실행되는 trigger
	 */
	public function triggerAfterModuleProc(&$oModule)
	{
		// 모듈 정보를 가져옵니다.
		$logged_info = Context::get('logged_info');

		Context::set('easyAdminBar', TRUE);
		Context::set('easyAdminBarStatus', $_COOKIE['easyAdminBar']);

		if($oModule->getLayoutPath() == './common/tpl/' || $oModule->getLayoutFile() == 'popup_layout.html')
		{
			Context::set('easyAdminBar', FALSE);
		}

		return new Object();
	}

	public function triggerBeforeDisplayContent(&$output)
	{
		// 모듈 정보를 가져옵니다.
		$module_info = Context::get('current_module_info');

		$easyAdminBar = Context::get('easyAdminBar');
		if(!$easyAdminBar)
		{
			return new Object();
		}

		$except_module_list = array(
			'comment',
			'document',
			'file',
			'module',
			'widget',
			'editor'
		);

		$except_act_list = array(
			'dispWidgetAdminAddContent',
			'dispLayoutPreviewWithModule',
			'dispEditorPopup'
		);

		if(in_array($module_info->module, $except_module_list) && !$module_info->mid)
		{
			return new Object();
		}

		if(in_array($module_info->act, $except_act_list))
		{
			return new Object();
		}

		if(in_array(Context::get('act'), $except_act_list))
		{
			return new Object();
		}


		$logged_info = Context::get('logged_info');
		if($logged_info->is_admin =='Y' && $module_info->module_type == 'view' && $module_info->site_srl == 0)
		{
			if(Context::getResponseMethod() != 'HTML')
			{
				return new Object();
			}

			$layout_info = Context::get('layout_info');
			$layout_path = $layout_info->path . 'layout.html';

			$layout_content = file_get_contents($layout_path);

			$menus = &$layout_info->menu;
			foreach($menus as $menu_name => $menu)
			{
				$menu_var = '$' . $menu_name .  '->list';
				debugPrint($menu_var);
				debugPrint(strstr($layout_content, $menu_var));
			}
			Context::set('adminBar', $adminBar);

			// templateHandler 객체 생성
			$oTemplateHandler = TemplateHandler::getInstance();

			$admin_bar_html = $oTemplateHandler->compile($this->module_path .'tpl', 'admin_bar.html');
			$admin_bar_script_html = $oTemplateHandler->compile($this->module_path .'tpl', 'admin_bar.script.html');
			$output = $admin_bar_html . $output . $admin_bar_script_html;
		}
	}
}