<?php
if(!class_exists('page'))
{
	require(_XE_PATH_ . 'modules/page/page.class.php');
}

if(!class_exists('pageAdminView'))
{
	require(_XE_PATH_ . 'modules/page/page.admin.view.php');
}

/**
 * @class easyxeAdminView
 * @author 퍼니엑스이 (contact@funnyxe.com)
 * @brief 퍼니엑스이 모듈의 admin view class
 **/

class easyxeAdminView extends pageAdminView
{

	/**
	 * @brief 초기화
	 **/
	function init()
	{
		parent::init();

		/**
		 * @TODO : init 에서 처리하도록
		 */
		if(substr_compare(__METHOD__, 'dispEasyxe', 0, 10) == 0)
		{
			$this->_setTemplatePath('easyxe');
		}
		else
		{
			$this->setTemplatePath('./modules/page/tpl/');
		}
	}

	/**
	 * 모듈 확장 시 반드시 호출되어야 하는 코드
	 */
	private function _prepareExtend($module)
	{
		$this->setTemplatePath('./modules/easyxe/tpl/_extends/' . $module);
	}

	private function _setTemplatePath($module)
	{
		$this->setTemplatePath('./modules/' . $module . '/tpl/');
	}

	public function dispPageAdminContent()
	{
		parent::dispPageAdminContent();
	}

	/**
	 * 페이지 정보 수정
	 */
	function dispPageAdminInfo()
	{
		parent::dispPageAdminInfo();

		$this->_prepareExtend('page');
	}

	public function dispPageAdminContentModify()
	{
		parent::dispPageAdminContentModify();
	}

	public function dispPageAdminPageAdditionSetup()
	{
		parent::dispPageAdminPageAdditionSetup();
	}

	public function dispPageAdminGrantInfo()
	{
		parent::dispPageAdminGrantInfo();
	}

	public function dispEasyxeAdminMenuTree()
	{
		$this->_setTemplatePath('easyxe');
		$this->setTemplateFile('menu');
	}

	public function dispEasyxeAdminCurrentPageDesign()
	{
		$oLayoutModel = getModel('layout');
		$layout_list = $oLayoutModel->getLayoutList(0);

		Context::set('layout_list', $layout_list);

		/**
		 * @TODO : init 에서 처리하도록
		 */
		$this->_setTemplatePath('easyxe');
		$this->setTemplateFile('currentPageDesign');
	}

	public function dispEasyxeAdminViewPageSource()
	{
		$module_info = Context::get('module_info');
		if($module_info->module != 'page')
		{
			return new Object(-1, '사용할 수 없는 기능입니다.');
		}

		if($module_info->page_type != 'OUTSIDE')
		{
			return new Object(-1, '사용할 수 없는 기능입니다.');
		}

		$page_content = htmlspecialchars(FileHandler::readFile($module_info->path));

		Context::set('page_source', $page_content);

		$this->setLayoutPath('./common/tpl/');
		$this->setLayoutFile('popup_layout');

		$this->_setTemplatePath('easyxe');
		$this->setTemplateFile('viewPageSource');
	}
}