<?php
    /**
     * @class tocplus
     * @author pocorall (pocorall@gmail.com)
     * @version 0.3
     * @brief 톡플러스 실시간 상담
     *
     * 
     **/

    class tocplus extends WidgetHandler {
        /**
         * @brief 위젯의 실행 부분
         * ./widgets/tocplus/conf/info.xml에 선언한 extra_vars를 args로 받는다
         * 결과를 만든후 print가 아니라 return 해주어야 한다
         **/
        function proc($args) {
            // 템플릿의 스킨 경로를 지정 (skin, colorset에 따른 값을 설정)
            $tpl_path = sprintf('%sskins/%s', $this->widget_path, $args->skin);
            Context::set('colorset', $args->colorset);
			
			$vars = Context::getRequestVars();

			if(Context::get('is_logged'))  {
				$oModuleModel = &getModel('module');
				$this->member_config = $oModuleModel->getModuleConfig('member');
				$logged_info = Context::get('logged_info');
				//Context::set('member_config', $this->member_config);
				switch($args->user_name) {
				case 'nick':
					$userName = $logged_info->nick_name;
					break;
				case 'id':
					$userName = $logged_info->user_id;
					break;
				default:
					$userName = $logged_info->nick_name."[".$logged_info->user_id."]";
					break;
				}
			} else {
			    if (strlen($args->guest_name) > 0) {
				    $userName = $args->guest_name;
                } else {
                    $userName = 'Guest';
                }
			}

			Context::set('userName', $userName);
			$chatTop = strlen($args->chat_top) > 0 ? $args->chat_top : 150;
			Context::set('chatTop', $chatTop);
			$chatLeft = strlen($args->chat_left) > 0 ? $args->chat_left : 5;
			Context::set('chatLeft', $chatLeft);
			Context::set('hAlign', $args->h_align);
			$chatHeight = strlen($args->chat_height) > 1 ? $args->chat_height : 200;
			Context::set('chatHeight', $chatHeight);
			$chatWidth = strlen($args->chat_width) > 1 ? $args->chat_width : 180;
			Context::set('chatWidth', $chatWidth);
			Context::set('frameColor', $args->frame_color);
			$userId = strlen($args->user_id) >2 ? $args->user_id : "test_xengine";
			Context::set('userId', $userId);
			
			$tpl_file = 'tocplusTemplate';
			
            // 템플릿 파일을 지정
            /*
            if(Context::get('is_logged')) $tpl_file = 'login_info';
            else $tpl_file = 'login_form';
            // 회원 관리 정보를 받음
            $oModuleModel = &getModel('module');
            $this->member_config = $oModuleModel->getModuleConfig('member');
            Context::set('member_config', $this->member_config);
            */

            // 템플릿 컴파일
            $oTemplate = &TemplateHandler::getInstance();
            return $oTemplate->compile($tpl_path, $tpl_file);
        }


    }
?>
