<?php
    /**
     * @class sejin7940_navermap
     * @author sejin7940@nate.com
     * @version 0.1
     **/

    class sejin7940_navermap extends WidgetHandler {

        /**
         * @brief
         * ./widgets/naver_map/conf/info.xml read extra_vars's args         
		 **/

        function proc($args) {

            // (skin, colorset)						
            $tpl_path = sprintf('%sskins/%s', $this->widget_path, $args->skin);
            $colorset = $args->colorset;

            //template file
            $tpl_file = 'naver_map';

			$naver_api_key = $args->naver_api_key;
			if(!$naver_api_key) return new Object(-1,'네이버맵 API Key 를 반드시 넣어주세요');

            $map_width = $args->map_width;
            if(!$map_width) $map_width = 300;

            $map_height = $args->map_height;
            if(!$map_height) $map_height = 300;

			$address_vars = $args->address_vars;
			if(!$address_vars) $address_vars = 'text';

			if($address_vars=='text') {
				$address = $args->address_text;
				$address_array = explode('(',$address);
				$address = $address_array[0];  // 도로명 주소의 경우, 뒤에 ( ) 가 붙는 경우가 있는데 이 부분이 검색이 안 되기에..
			}
			elseif($address_vars=='extra_text') {
				$document_srl = $args->document_srl;
				if(!$document_srl) $document_srl = Context::get('document_srl');
				if($document_srl && $args->address_eid)  {
					$oDocumentModel = &getModel('document');
					$oDocument = $oDocumentModel->getDocument($document_srl);
					$address = $oDocument->getExtraEidValue($args->address_eid);
				}
				$address_array = explode('(',$address);
				$address = $address_array[0];  // 도로명 주소의 경우, 뒤에 ( ) 가 붙는 경우가 있는데 이 부분이 검색이 안 되기에..
			}
			elseif($address_vars=='extra_address') {
				$document_srl = $args->document_srl;
				if(!$document_srl) $document_srl = Context::get('document_srl');
				if($document_srl && $args->address_eid)  {
					$oDocumentModel = &getModel('document');
					$oDocument = $oDocumentModel->getDocument($document_srl);
					$address = $oDocument->getExtraEidValue($args->address_eid);
				}
				$address_temp = explode('|@|',$address);
				$address_num = substr(trim($address_temp[0]),-8,-1);
				$address = trim(str_replace($address_num,'',$address_temp[0])." ".$address_temp[1]);  // 우편번호 제거 위해서

				$address_array = explode('(',$address);
				$address = $address_array[0];  // 도로명 주소의 경우, 뒤에 ( ) 가 붙는 경우가 있는데 이 부분이 검색이 안 되기에..
			}
			
			if(!$address) $address='서울';


			$latlng = $this->search_address_naver($naver_api_key,$address);
			$latlng_array = explode(',',$latlng);
		
			$args->lat = $latlng_array[0];
			$args->lon = $latlng_array[1];


			$zoom_size = $args->zoom_size;
            if(!$zoom_size) $zoom_size = '9';

			$display_zoom = $args->display_zoom;
			if(!$display_zoom) $display_zoom = 'Y';

			$display_viewtype = $args->display_viewtype;
			if(!$display_viewtype) $display_viewtype = 'N';

			$information_window = $args->information_window;
            if(!$information_window) $information_window = '';

			$circle_overlay = $args->circle_overlay;
            if(!$circle_overlay) $circle_overlay = 'false';


			$inforwindow_display = $args->inforwindow_display;
            if(!$inforwindow_display) $inforwindow_display = 'false';

			$inforwindow_content = $args->inforwindow_content;
            if(!$inforwindow_content) $inforwindow_content = 'address_info';

			$earth_display = $args->earth_display;
            if(!$earth_display) $earth_display = 'simple_level';

			$earth_nav_control = $args->earth_nav_control;
            if(!$earth_nav_control) $earth_nav_control = 'auto';

			$ballnoon_display = $args->ballnoon_display;
            if(!$ballnoon_display) $ballnoon_display = 'directly_display';

			$ballnoon_content = $args->ballnoon_content;
            if(!$ballnoon_content) $ballnoon_content = 'address_info';

			$custom_ballnoon = $args->custom_ballnoon;
            if(!$custom_ballnoon) $custom_ballnoon = '';

			$ballnoon_video = $args->ballnoon_video;
            if(!$ballnoon_video) $ballnoon_video = '';

            $widget_info->map_width = $map_width;
            $widget_info->map_width = $map_width;
            $widget_info->map_height = $map_height;

			$widget_info->address_type = $args->address_type;
			$widget_info->lat = $args->lat;
			$widget_info->lon = $args->lon;

			$widget_info->naver_api_key = $naver_api_key;
			$widget_info->search_display = $search_display;
			$widget_info->map_type = $map_type;


			$widget_info->zoom_size = $zoom_size;
			$widget_info->display_zoom = $display_zoom;
			$widget_info->display_viewtype = $display_viewtype;

			$widget_info->icon_display = $icon_display;
			$widget_info->information_window = $information_window;
			$widget_info->circle_overlay = $circle_overlay;

			$widget_info->inforwindow_display = $inforwindow_display;
			$widget_info->inforwindow_content = $inforwindow_content;
			$widget_info->earth_display = $earth_display;
			$widget_info->earth_nav_control = $earth_nav_control;
			$widget_info->ballnoon_display = $ballnoon_display;
			$widget_info->ballnoon_content = $ballnoon_content;
			$widget_info->custom_ballnoon = $custom_ballnoon;
			$widget_info->ballnoon_video = $ballnoon_video;

            //$widget_info->src = sprintf("%s%s/%s/clock.swf", Context::getRequestUri(), $tpl_path, $colorset);

            Context::set('widget_info', $widget_info);

			//Compile
            $oTemplate = &TemplateHandler::getInstance();
            return $oTemplate->compile($tpl_path, $tpl_file);
        }




	

        /**
         * @brief naver map open api에서 주소를 좌표값으로 바꾸는 함수
		 * 도로명주소도 제대로 적용되도록 보완한 소스
         **/
        function search_address_naver($api_key, $address=null,$coord='latlng') {
			if(!$address) $address = Context::get('address');
			if(!$address) {
				// 에러 메세지 출력
			}
            else {
				// 지정된 서버에 요청을 시도한다
				$address = urlencode(iconv("UTF-8","EUC-KR",$address));
				$query_string = sprintf('/api/geocode?key=%s&coord=%s&encoding=euc-kr&query=%s', $api_key, $coord, $address);
				
				// 요청변수 :  coord - 출력좌표체계  (latlng,  tm128 두가지 지원)

				$fp = fsockopen('maps.naver.com', 80, $errno, $errstr);
				if(!$fp) return new Object(-1, 'msg_fail_to_socket_open');

				fputs($fp, "GET {$query_string} HTTP/1.0\r\n");
				fputs($fp, "Host: maps.naver.com\r\n\r\n");

				$buff = '';
				while(!feof($fp)) {
					$str = fgets($fp, 1024);
					if(trim($str)=='') $start = true;
					if($start) $buff .= trim($str);
				}

				fclose($fp);

				$buff = trim(iconv("EUC-KR", "UTF-8", $buff));
				$buff = str_replace('<?xml version="1.0" encoding="EUC-KR"?>', '', $buff);

				$oXmlParser = new XmlParser();
				$xml_doc = $oXmlParser->parse($buff);

				//If a Naver OpenApi Error message exists.
				if($xml_doc->error->error_code->body || $xml_doc->error->message->body) {
					echo 'NAVER OpenAPI Error'."\n".'Code : '.$xml_doc->error->error_code->body."\n".'Message : '.$xml_doc->error->message->body;
//					return new Object(-1, 'NAVER OpenAPI Error'."\n".'Code : '.$xml_doc->error->error_code->body."\n".'Message : '.$xml_doc->error->message->body);
				}


				if($xml_doc->geocode->result->total->body) {
					$addrs = $xml_doc->geocode->result->items->item;   // 전체 주소 목록에 포함되는 개별 주소를 포함하는 컨테이너입니다.

					if(!is_array($addrs)) {
						$addrs = array($addrs);
					}
					$addrs_count = count($addrs);
//echo "hi".$xml_doc->geocode->result->items->item->address->body;
					$address_list = array();

					for($i=0;$i<$addrs_count;$i++) {

						$item = $addrs[$i];

						// 출력결과필드 - point->x (x좌표-경도) , point->y (y좌표-위도),  address (주소 전체) 
						// 구주소 체계시 => addrdetail->sido  (특별시/광역시/도),  addrdetail->sigugum (시구군) ,  addrdetail->dongmyun (동면),  addrdetail->rest (나머지 주소)
						if($coord=='latlng') $address_list[] = sprintf("%s,%s,%s", $item->point->y->body, $item->point->x->body, $item->address->body);
						else $address_list[] = sprintf("%s,%s,%s", $item->point->x->body, $item->point->y->body, $item->address->body);

//						echo sprintf("%s,%s,%s", $item->point->x->body, $item->point->y->body, $item->address->body);
					}
				}
				else {
					// 주소에 에러 존재
				}

				return $address_list[0];
	//			return implode("\n", $address_list); 
	//          $this->add("address_list", implode("\n", $address_list));
			}
        }




        /**
         * @brief naver map open api에서 주소를 좌표값으로 바꾸는 함수
		 * http://blog.daum.net/haha25/5390560 참조 하면 도움이 됨
         **/
        function search_address_naver_bk($api_key, $address=null,$coord='latlng') {
			if(!$address) $address = Context::get('address');
			if(!$address) {
				// 에러 메세지 출력
			}
            else {
				// 지정된 서버에 요청을 시도한다
				$address = urlencode(iconv("UTF-8","EUC-KR",$address));
				$query_string = sprintf('/api/geocode.php?key=%s&query=%s&coord=%s', $api_key, $address, $coord);
				// 요청변수 :  coord - 출력좌표체계  (latlng,  tm128 두가지 지원)


				$fp = fsockopen('maps.naver.com', 80, $errno, $errstr);
				if(!$fp) return new Object(-1, 'msg_fail_to_socket_open');

				fputs($fp, "GET {$query_string} HTTP/1.0\r\n");
				fputs($fp, "Host: maps.naver.com\r\n\r\n");

				$buff = '';
				while(!feof($fp)) {
					$str = fgets($fp, 1024);
					if(trim($str)=='') $start = true;
					if($start) $buff .= trim($str);
				}

				fclose($fp);

				$buff = trim(iconv("EUC-KR", "UTF-8", $buff));
				$buff = str_replace('<?xml version="1.0" encoding="euc-kr" ?>', '', $buff);

				$oXmlParser = new XmlParser();
				$xml_doc = $oXmlParser->parse($buff);

				//If a Naver OpenApi Error message exists.
				if($xml_doc->error->error_code->body || $xml_doc->error->message->body) {
					echo 'NAVER OpenAPI Error'."\n".'Code : '.$xml_doc->error->error_code->body."<br>".'Message : '.$xml_doc->error->message->body;
//					return new Object(-1, 'NAVER OpenAPI Error'."\n".'Code : '.$xml_doc->error->error_code->body."\n".'Message : '.$xml_doc->error->message->body);
				}

				if($xml_doc->geocode->total->body) {
					$addrs = $xml_doc->geocode->item;   // 전체 주소 목록에 포함되는 개별 주소를 포함하는 컨테이너입니다.
					if(!is_array($addrs)) $addrs = array($addrs);
					$addrs_count = count($addrs);

					$address_list = array();
					for($i=0;$i<$addrs_count;$i++) {
						$item = $addrs[$i];
						// 출력결과필드 - point->x (x좌표-경도) , point->y (y좌표-위도),  address (주소 전체)  addrdetail->sido  (특별시/광역시/도),  addrdetail->sigugum (시구군) ,  addrdetail->dongmyun (동면),  addrdetail->rest (나머지 주소)
						if($coord=='latlng') $address_list[] = sprintf("%s,%s,%s", $item->point->y->body, $item->point->x->body, $item->address->body);
						else $address_list[] = sprintf("%s,%s,%s", $item->point->x->body, $item->point->y->body, $item->address->body);

					}
				}
				else {
					// 주소에 에러 존재
				}

				return $address_list[0];
	//			return implode("\n", $address_list); 
	//          $this->add("address_list", implode("\n", $address_list));
			}
        }

    }
?>
