<?php
	/**
	 * @class  pointhistory
     * @author CONORY (http://www.conory.com)
	 * @brief The parent class of the pointhistory module
	 */
	
	define('__pointhistory_Module_Version__', '0.1.3');
	
	class pointhistory extends ModuleObject
	{
		var $triggers = array(
			array('moduleHandler.init', 'pointhistory', 'controller', 'triggerModuleHandler', 'after'),
			array('moduleObject.proc', 'pointhistory', 'controller', 'triggerBeforeModuleObject', 'before'),
			array('moduleObject.proc', 'pointhistory', 'controller', 'triggerAfterModuleObject', 'after'),
			array('file.downloadFile', 'pointhistory', 'controller', 'triggerDownloadFile', 'after'),
			array('point.setPoint', 'pointhistory', 'controller', 'triggerSetPoint', 'after'),
			array('member.deleteMember', 'pointhistory', 'controller', 'triggerDeleteMember', 'after')
		);
		
		/**
		 * @brief  ġ
		 */
		function moduleInstall()
		{
            $oModuleModel = &getModel('module');
            $oModuleController = &getController('module');
			
			return new Object();
		}

		/**
		 * @brief Ʈ üũ
		 */
		function checkUpdate()
		{
            $oDB = &DB::getInstance();
            $oModuleModel = &getModel('module');
			
			//ƮĿ ġ
			foreach($this->triggers as $trigger)
			{
				if(!$oModuleModel->getTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4])) return true;
			}
			
			//module_srl ʵ ߰ V0.1.3
			if(!$oDB->isColumnExists("pointhistory", "module_srl")) return true;
			
			return false;
		}

		/**
		 * @brief Ʈ
		 */
		function moduleUpdate()
		{
            $oDB = &DB::getInstance();
            $oModuleModel = &getModel('module');
            $oModuleController = &getController('module');
			
			//ƮĿ ġ
			foreach($this->triggers as $trigger)
			{
				if(!$oModuleModel->getTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4]))
				{
					$oModuleController->insertTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4]);
				}
			}
			
			//module_srl ʵ ߰ V0.1.3
			if(!$oDB->isColumnExists("pointhistory", "module_srl")) $oDB->addColumn("pointhistory", "module_srl", "number",11,0,true);
			
			return new Object(0, 'success_updated');
		}
	
		/**
		 * @brief 
		 */
		function moduleUninstall()
		{
			$oDB = &DB::getInstance();		
			$oModuleModel = &getModel('module');
			$oModuleController = &getController('module');
			
			//ƮĿ 
			foreach($this->triggers as $trigger)
			{
				if($oModuleModel->getTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4]))
				{
					$oModuleController->deleteTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4]);
				}
			}
			
			return new Object();
		}
		
		/**
		 * @brief ĳ 
		 */
		function recompileCache()
		{
		}
	}