<?php
	/**
	 * @class  pointhistoryAdminView
     * @author CONORY (http://www.conory.com)
	 * @brief The admin view class of the pointhistory module
	 */
	 
	class pointhistoryAdminView extends pointhistory
	{
		/**
		 * @brief Initialization
		 */
		function init()
		{
			$oPointhistoryModel = &getModel('pointhistory');
			$this->module_config = $oPointhistoryModel->getModuleConfig();
			Context::set('module_config', $this->module_config);
			
			$this->setTemplatePath($this->module_path.'tpl');
		}

		/**
		 * @brief ȯ漳
		 */
		function dispPointhistoryAdminSetting()
		{
		    $oModuleModel = &getModel('module');	
	
			// Ų 
            $skin_list = $oModuleModel->getSkins($this->module_path);
            Context::set('skin_list',$skin_list);
			
			//
			$mskin_list = $oModuleModel->getSkins($this->module_path, "m.skins");
			Context::set('mskin_list', $mskin_list);
			
			$this->setTemplateFile('setting');
		}		

		/**
		 * @brief 丮 
		 */
		function dispPointhistoryAdminList()
		{
			$oMemberModel = &getModel('member');
			$oModuleModel = &getModel('module');
			$member_config = $oModuleModel->getModuleConfig('member');
			
            //˻ɼ
			if($member_config->identifier == 'user_id') $search_option = array('nick_name','user_id');
            else $search_option = array('nick_name','email');
            Context::set('search_option', $search_option);
			
			$args = new stdClass();
			$search_keyword = Context::get('search_keyword');
			$search_target = Context::get('search_target');			
            if($search_target && $search_keyword) {
				if($search_target == 'user_id' && $member_config->identifier == 'user_id') {
					$args->member_srl = $oMemberModel->getMemberSrlByUserID($search_keyword);
					if(!$args->member_srl) $args->member_srl = 0;
				}elseif($search_target == 'email') {
					$args->member_srl = $oMemberModel->getMemberSrlByEmailAddress($search_keyword);
					if(!$args->member_srl) $args->member_srl = 0;
				}elseif($search_target == 'nick_name') {
					$args->member_srl = $oMemberModel->getMemberSrlByNickName($search_keyword);
					if(!$args->member_srl) $args->member_srl = 0;	
				}
            }
			
			$args->htype = Context::get('htype');
		    $args->page = Context::get('page');
            $output = executeQuery('pointhistory.getPointhistoryList',$args);
			if($output->data){
				foreach($output->data as $key=> $val){	
					$member_info = $oMemberModel->getMemberInfoByMemberSrl($val->member_srl);
					$val->nick_name = $member_info->nick_name;				
					$output->data[$key] = $val;	
				}
			}
			
            Context::set('total_count', $output->page_navigation->total_count);
            Context::set('total_page', $output->page_navigation->total_page);
            Context::set('page', $output->page);
            Context::set('pointhistory_list', $output->data);
            Context::set('page_navigation', $output->page_navigation);	
			
			$this->setTemplateFile('list');
		}
		
	}