<?php
	/**
	 * @class  pointhistoryModel
	 * @author CONORY (http://www.conory.com)
	 * @brief The model class fo the pointhistory module
	 */
	class pointhistoryModel extends pointhistory
	{
		/**
		 * @brief Initialization
		 */
		function init()
		{
		}
		
 		/**
		 *@brief 모듈설정
		 **/
        function getModuleConfig() 
		{
			$oModuleModel = &getModel('module');	
			$module_config = $oModuleModel->getModuleConfig('pointhistory');
			if(!$module_config->point_record_way){
				if(version_compare(__ZBXE_VERSION__, '1.7.4', '<')){
					$module_config->point_record_way = 'realtime';
				}else{
					$module_config->point_record_way = 'trigger';
				}
			}
			if(!isset($module_config->member_menu_name)){
				$module_config->member_menu_name = Context::getLang('pointhistory_list');
			}
			if(!$module_config->point_unit_char){
				$module_config->point_unit_char = 'P';
			}
			
            return $module_config;
        }	
		
 		/**
		 *@brief 포인트 히스토리 동작
		 **/
        function actionPointhistory($obj,$type)
		{
			$logged_info = Context::get('logged_info');	
			
			if($type=='Before'){
				$oPointModel = &getModel('point');			
			
				//아직 실행되지 않은 로그인을 위해 미리 member_srl구해서 포인트 임시저장
				if($obj->act=='procMemberLogin'){
					$user_id = trim(Context::get('user_id'));
					$password = trim(Context::get('password'));
					if(!$user_id || !$password) return;
					$oMemberModel = &getModel('member');
					$config = $oMemberModel->getMemberConfig();
					if($config->identifier == 'email_address') $member_info = $oMemberModel->getMemberInfoByEmailAddress($user_id);
					else $member_info = $oMemberModel->getMemberInfoByUserID($user_id);
					if(!$oMemberModel->isValidPassword($member_info->password, $password, $member_info->member_srl)) return;					
					$my_point = $oPointModel->getPoint($member_info->member_srl, true);
					$GLOBALS['PH_point'][$member_info->member_srl] = $my_point;
					$inMember[] = $member_info->member_srl;
				}
			
				if(!$logged_info) return;
				
				//포인트 변동체크를 위해 현재 포인트 임시저장
				if($obj->act=='dispMemberLogout'||$obj->act=='procMemberLogin'||$obj->act=='procMemberLeave'||$obj->act=='dispLayoutPreviewWithModule') return;
				$my_point = $oPointModel->getPoint($logged_info->member_srl, true);
				$GLOBALS['PH_point'][$logged_info->member_srl] = $my_point;	
				$inMember[] = $logged_info->member_srl;
				
				$member_srl = Context::get('member_srl');
				if($member_srl && $logged_info->member_srl!=$member_srl){
					$my_point = $oPointModel->getPoint($member_srl, true);
					$GLOBALS['PH_point'][$member_srl] = $my_point;	
					$inMember[] = $member_srl;
				}
				
				if($obj->act=='procDocumentVoteUp'||$obj->act=='procDocumentVoteDown') $document_srl = Context::get('target_srl');
				else $document_srl = Context::get('document_srl');
				if($document_srl){
					$oDocumentModel = &getModel('document');
					$oDocument = $oDocumentModel->getDocument($document_srl, false, false);
					if($oDocument->get('member_srl') && $oDocument->get('member_srl')!=$logged_info->member_srl && $oDocument->get('member_srl')!=$member_srl){
						$my_point = $oPointModel->getPoint($oDocument->get('member_srl'), true);
						$GLOBALS['PH_point'][$oDocument->get('member_srl')] = $my_point;
						$inMember[] = $oDocument->get('member_srl');
					}
				}
				
			}elseif($type=='After'){
				if(!$logged_info) return;
				
				//포인트 변동이 있으면 포인트 히스토리에 기록
				if($obj->act=='dispMemberLogout'||$obj->act=='procMemberLeave'||$obj->act=='dispLayoutPreviewWithModule'||$obj->act=='procFileDownload') return;
				
				$this->recordPointhistory($obj,$logged_info->member_srl);
				$inMember[] = $logged_info->member_srl;
		
				$member_srl = Context::get('member_srl');
				if($member_srl && $logged_info->member_srl!=$member_srl){
					$this->recordPointhistory($obj,$member_srl);
					$inMember[] = $member_srl;
				}
				
				if($obj->act=='procDocumentVoteUp'||$obj->act=='procDocumentVoteDown') $document_srl = Context::get('target_srl');
				else $document_srl = Context::get('document_srl');
				if($document_srl){
					$oDocumentModel = &getModel('document');
					$oDocument = $oDocumentModel->getDocument($document_srl, false, false);
					if($oDocument->get('member_srl') && $oDocument->get('member_srl')!=$logged_info->member_srl && $oDocument->get('member_srl')!=$member_srl)
					{
						$this->recordPointhistory($obj,$oDocument->get('member_srl'));
						$inMember[] = $oDocument->get('member_srl');
					}
				}
				
				$__PHC_Member__ = Context::get('__PHC_Member__');
				foreach($__PHC_Member__ as $key=> $val){
					if(!in_array($val,$inMember)){
						$this->recordPointhistory($obj,$val);
						$inMember[] = $val;
					}
				}
			}
        }
		
 		/**
		 *@brief 포인트 히스토리 기록
		 **/
        function recordPointhistory($obj,$member_srl)
		{
			$oPointModel = &getModel('point');
			$my_point = $oPointModel->getPoint($member_srl, true);
			if($GLOBALS['PH_point'][$member_srl] == $my_point && $GLOBALS['PH_point'][$member_srl]) return;
			if($GLOBALS['PH_point'][$member_srl]){
				$ct_point = abs($GLOBALS['PH_point'][$member_srl]-$my_point);
			}
			
			$__PHC__ = Context::get('__PHC'.$member_srl.'__');	
			if($__PHC__){
				foreach($__PHC__ as $key=> $val){
					$plspoint = abs($val[1]);
					if(!$plspoint) continue;
					$phc_point += $plspoint;
					
					$history = new stdClass();
					if(($GLOBALS['PH_point'][$member_srl] && $GLOBALS['PH_point'][$member_srl]>$my_point && !$val[2]) || ($val[2]=='minus' && $val[2])){
						$history->htype = 'M';	
					}else{
						$history->htype = 'A';
					}
					$history->point = $plspoint;
					$history->member_srl = $member_srl;
					$history->content = $this->getPointhistoryContent($obj,$history,$key);
					$history->act = $obj->act;
					$output = executeQuery('pointhistory.insertPointhistory', $history);
				}
				
				if($phc_point < $ct_point && $GLOBALS['PH_point'][$member_srl]){
					$history = new stdClass();
					if($GLOBALS['PH_point'][$member_srl]>$my_point){
						$history->htype = 'M';
					}else{
						$history->htype = 'A';
					}
					$history->point = $ct_point-$phc_point;
					$history->member_srl = $member_srl;
					$history->content = $this->getPointhistoryContent($obj,$history);
					$history->act = $obj->act;
					$output = executeQuery('pointhistory.insertPointhistory', $history);
				}
				
			}elseif($GLOBALS['PH_point'][$member_srl]){
				$history = new stdClass();
				if($GLOBALS['PH_point'][$member_srl]>$my_point){
					$history->htype = 'M';	
				}else{
					$history->htype = 'A';
				}
				$history->point = $ct_point;				
				$history->member_srl = $member_srl;
				$history->content = $this->getPointhistoryContent($obj,$history);
				$history->act = $obj->act;
				$output = executeQuery('pointhistory.insertPointhistory', $history);
			}
        }	
		
 		/**
		 *@brief 포인트 히스토리 내용
		 **/
        function getPointhistoryContent($obj,$history = null,$pkey = null)
		{
			$__PHC__ = Context::get('__PHC'.$history->member_srl.'__');	
			if($__PHC__){
				if(!$pkey && $pkey!==0) $pkey = count($__PHC__)-1;
				return $__PHC__[$pkey][0];
			}
			
			if($obj->module_srl){
				$oModuleModel = &getModel('module');	
				$module_info = $oModuleModel->getModuleInfoByModuleSrl($obj->module_srl);
			}
			
			//게시글 열람
			$act = Context::get('act');
			if($obj->act=='procDocumentVoteUp'||$obj->act=='procDocumentVoteDown') $document_srl = Context::get('target_srl');
			else $document_srl = Context::get('document_srl');
			if($document_srl){
				$oDocumentModel = &getModel('document');
				$oDocument = $oDocumentModel->getDocument($document_srl);
				if(!$act){
					$hcontent = sprintf(Context::getLang('PHC_read_document'), $module_info->browser_title,getUrl('','document_srl',$document_srl),cut_str($oDocument->get('title'), 30));
					return $hcontent;
				}
			}
			
			switch($obj->act)
			{
				case 'procMemberLogin' :
					$hcontent = Context::getLang('PHC_member_login');
					break;
				case 'procMemberInsert' :
					$hcontent = Context::getLang('PHC_member_join');
					break;
				case 'procBoardInsertDocument' :			
					$hcontent = sprintf(Context::getLang('PHC_insert_document'),$module_info->browser_title,cut_str(Context::get('title'), 30));
					break;
				case 'procBoardDeleteDocument' :			
					$hcontent = sprintf(Context::getLang('PHC_delete_document'),$module_info->browser_title);
					break;
				case 'procBoardInsertComment' :
					$hcontent = sprintf(Context::getLang('PHC_insert_comment'),$module_info->browser_title);
					break;
				case 'procBoardDeleteComment' :			
					$hcontent = sprintf(Context::getLang('PHC_delete_comment'),$module_info->browser_title);
					break;
				case 'procFileDownload' :
					$args = new stdClass();
					$args->file_srl = Context::get('file_srl');
					$output = executeQuery('file.getFile', $args);
					$file = $output->data;
					
					$oFileModel = getModel('file');
					$file->download_url = $oFileModel->getDownloadUrl($file->file_srl, $file->sid, $file->module_srl);
					$obj->module_srl = $file->module_srl;
					
					$oModuleModel = &getModel('module');	
					$module_info = $oModuleModel->getModuleInfoByModuleSrl($obj->module_srl);
					$hcontent = sprintf(Context::getLang('PHC_download_file'),$module_info->browser_title,$file->download_url,stripslashes($file->source_filename));
					break;
				case 'procFileDelete' :		
					$hcontent = Context::getLang('PHC_delete_file');
					break;
				case 'procPointAdminUpdatePoint' :
					if($history->htype == 'M') $hcontent = Context::getLang('PHC_minus_admin');
					else $hcontent = Context::getLang('PHC_add_admin');
					break;
				case 'procDocumentVoteUp' :
					$hcontent = sprintf(Context::getLang('PHC_document_vote_up'),$module_info->browser_title,getUrl('','document_srl',$document_srl),cut_str($oDocument->get('title'), 30));
					break;
				case 'procDocumentVoteDown' :
					$hcontent = sprintf(Context::getLang('PHC_document_vote_down'),$module_info->browser_title,getUrl('','document_srl',$document_srl),cut_str($oDocument->get('title'), 30));
					break;
				case 'procDocumentManageCheckedDocument' :
					$hcontent = Context::getLang('PHC_delete_document_manage');
					break;
			}
			
			if(!$hcontent){
				if($obj->module_srl){
					$module_title = $module_info->browser_title;
				}else{
					$oModuleModel = &getModel('module');
					$module_info = $oModuleModel->getModuleInfoXml($obj->module);
					$module_title = $module_info->title;
				}
				
				//자동로그인
				if(!$module_title && $_COOKIE['xeak']){
					$oMemberModel = &getModel('member');
					$member_info = $oMemberModel->getMemberInfoByMemberSrl($history->member_srl);
					if($member_info->last_login > date('YmdHis', strtotime('-1 minute'))){
						$hcontent = Context::getLang('PHC_member_login_auto');
						return $hcontent;
					}
				}
				if(!$module_title) $module_title = Context::getLang('PHC_unknown');
				
				if($history->htype == 'M'){
					$hcontent = sprintf(Context::getLang('PHC_content_minus'),$module_title);
				}else{
					$hcontent = sprintf(Context::getLang('PHC_content_add'), $module_title);
				}
			}
			
            return $hcontent;		
        }
		
	}