<?php
	/**
	 * @class  pointhistoryController
     * @author CONORY (http://www.conory.com)
	 * @brief Controller class of pointhistory modules
	 */
	class pointhistoryController extends pointhistory
	{
		/**
		 * @brief Initialization
		 */
		function init()
		{
		}
		
 		/**
		 *@brief module Handler Ʈ
		 **/		
        function triggerModuleHandler(&$obj) {
            if(!Context::get('is_logged')) return new Object();
			$oPointhistoryModel = &getModel('pointhistory');
			$module_config = $oPointhistoryModel->getModuleConfig();
			

			//ȸ޴ ߰
			if($module_config->member_menu_name){			
				$oMemberController = &getController('member');
				$oMemberController->addMemberMenu('dispPointhistoryList', $module_config->member_menu_name);
			}

            return new Object();
        }
		
 		/**
		 *@brief   ƮĿ
		 **/
        function triggerBeforeModuleObject($obj)
		{
			$oPointhistoryModel = &getModel('pointhistory');
			
			//ǽð Ʈ  Before
			$module_config = $oPointhistoryModel->getModuleConfig();
			if($module_config->point_record_way == 'realtime'){
				$oPointhistoryModel->actionPointhistory($obj,'Before');
			}
			
			//
			if(version_compare(__ZBXE_VERSION__, '1.7.4', '>=')){
				$GLOBALS['__module_info__']['module_srl'] = $obj->module_srl;
				$GLOBALS['__module_info__']['module'] = $obj->module;
			}
			
			return new Object();
        }	
		
 		/**
		 *@brief   ƮĿ
		 **/
        function triggerAfterModuleObject($obj)
		{
			$oPointhistoryModel = &getModel('pointhistory');
			
			//ǽð Ʈ  After
			$module_config = $oPointhistoryModel->getModuleConfig();
			if($module_config->point_record_way == 'realtime'){
				$oPointhistoryModel->actionPointhistory($obj,'After');
			}
			return new Object();
        }
		
 		/**
		 *@brief ٿε ƮĿ
		 **/
        function triggerDownloadFile($obj)
		{
			$logged_info = Context::get('logged_info');	
			if(!$logged_info) return new Object();
			
			$oPointhistoryModel = &getModel('pointhistory');
			$module_config = $oPointhistoryModel->getModuleConfig();
			if($module_config->point_record_way != 'realtime') return new Object();
			
			//ǽð Ʈ  (ٿε Ʈ  ó)
			$obj->act = 'procFileDownload';
			$oPointhistoryModel = &getModel('pointhistory');
			$oPointhistoryModel->recordPointhistory($obj,$logged_info->member_srl);
			
			return new Object();
        }
		
 		/**
		 *@brief Ʈ  ƮĿ (XE 1.7.4 ̻ )
		 **/
        function triggerSetPoint($obj)
		{
			$oPointhistoryModel = &getModel('pointhistory');
			$module_config = $oPointhistoryModel->getModuleConfig();
			if($module_config->point_record_way != 'trigger') return new Object();
			
			if($obj->current_point==$obj->set_point) return new Object();
			$oPointhistoryModel = &getModel('pointhistory');
			$minfo = Context::getRequestVars();
			$minfo->module = $GLOBALS['__module_info__']['module'];
			$minfo->module_srl = $GLOBALS['__module_info__']['module_srl'];			
			
			$history = new stdClass();
			if($obj->current_point>$obj->set_point){
				$history->htype = 'M';		
			}else{
				$history->htype = 'A';	
			}
			$history->point = abs($obj->current_point-$obj->set_point);
			$history->member_srl = $obj->member_srl;	
			$history->content = $oPointhistoryModel->getPointhistoryContent($minfo,$history);
			$history->act = $minfo->act;		
			executeQuery('pointhistory.insertPointhistory', $history);
			
			return new Object();
        }
		
 		/**
		 *@brief ȸ Ʈ
		 **/
        function triggerDeleteMember($obj) {
		
			//ȸ Ʈ 丮 		
            $output = executeQuery('pointhistory.deletePointhistory', $obj);		
            if(!$output->toBool()) return $output;
			
			return new Object();
		}
		
	}