
Postcodify XE 모듈
==================

[Postcodify](http://postcodify.poesis.kr/) 새주소 우편번호 검색 프로그램을
XE에서 사용할 수 있도록 만든 모듈입니다.

XE의 공식 `krzip` 모듈은 2015년 4월에 [서비스를 종료할 예정](http://www.xpressengine.com/devlog/22923430)이라고 합니다.
Postcodify로 전환하면 XE로 만든 사이트에서도 우편번호 검색 기능을 계속 사용할 수 있습니다.


장점
----

Postcodify는 XE에서 제공하는 `krzip` 공식 모듈에 비해 아래와 같은 장점이 있습니다.

- 지역을 별도로 선택하지 않아도 검색이 가능합니다.
- 2015년 8월부터 시행되는 새 우편번호 (기초구역번호) 입력이 가능합니다.
- 도로명주소, 상세주소, 참고항목, 우편번호를 분리 저장하여 정부에서 권고하는 표기 형식에 맞추고,
  관리 및 변환이 편리합니다.


설치 방법
---------

1. 기존에 사용하던 `krzip` 모듈을 삭제하고, 관리 모듈에서 캐시를 재생성합니다.
2. 이 모듈의 `krzip` 폴더를 XE의 모듈 폴더로 복사합니다.
3. 회원가입 또는 회원정보 변경 페이지에서 평소처럼 우편번호 검색을 하시면 됩니다.
4. 모듈 설정 화면에서 검색서버의 주소, 지도 링크, 우편번호 표시 형태 (6자리 기존 방식 또는 5자리 새 방식),
   지번주소 표시 여부 등을 선택할 수 있습니다.


데이터 포맷
-----------

이 모듈을 사용하여 주소를 입력받으면 `member` 테이블의 `extra_vars` 필드 중 사용자가 지정한 속성에
아래와 같은 포맷으로 데이터가 저장됩니다.

    Array
    (
        [0] => 우편번호
        [1] => 도로명주소
        [2] => 상세주소
        [3] => (부가정보)
    )

위의 포맷은 앞으로 계속 유지할 예정이나, 4번 이후에 다른 데이터가 추가될 수도 있으니
데이터 출력시에는 0번의 우편번호와 1~3번의 도로명주소 구성요소만 추출하여 사용하시기 바랍니다.

참고로 이 모듈의 구버전(~1.2)에서는 아래와 같은 포맷을 사용하였고,

    Array
    (
        [0] => 도로명주소
        [1] => 상세주소
        [2] => (부가정보)
        [3] => 우편번호
    )

기존의 `krzip` 공식 모듈은 버전에 따라 아래와 같은 포맷을 사용했습니다.

2014년 11월 이전:

    Array
    (
        [0] => 도로명주소 (부가정보) (우편번호)
        [1] => 상세주소
    )

2014년 12월 이후:

    Array
    (
        [0] => 도로명주소
        [1] => 상세주소
        [2] => (부가정보) (우편번호)
    )

구버전 또는 기존 모듈의 포맷으로 저장된 데이터가 많이 쌓여 있는 경우
다른 프로그램과의 연동에 지장이 있을 수 있으니, 사용시 변환하거나 일괄 변환을 해주셔야 합니다.
이 모듈은 기존의 어떤 포맷으로 저장된 주소라도 쉽게 최신 포맷으로 변환할 수 있도록
`getKrzipStandardFormat()` 메소드를 제공합니다.

    // 회원의 주소 정보가 $address에 저장되어 있다고 가정
    $oKrzipModel = getModel('krzip');
    $address = $oKrzipModel->getKrzipStandardFormat($address);


라이센스
--------

이 모듈은 XE의 `krzip` 공식 모듈을 바탕으로 작성하였으므로,
공식 모듈과 같이 LGPL 라이센스를 따릅니다.
