<?php
    /**
     * @class  gigancenterController
     * @author 그냥재미로
     * @brief  gigancenter 모듈의 controller class
     **/
    class gigancenterController extends gigancenter {
    	/**
    	 * @brief Initialization
    	 **/
    	function init() {    		
    	}


        /**
         * @brief 알림 서비스 대상 등록, 수정
         * target Table : gigancenter_notification
         **/
        function procGigancenterInsertDevice()
        {
            debugprint("procGigancenterInsertDevice");


            // 로그인하지 않았다면 에러
            if(!Context::get('is_logged')) return new Object(-1, 'msg_not_permitted');

            $args = Context::getRequestVars();

            // 회원정보 처리
            $logged_info = Context::get("logged_info");

            $args->member_srl = $logged_info->member_srl;
            $args->user_id = $logged_info->user_id;
            $args->user_name = $logged_info->user_name;
            $args->nick_name = $logged_info->nick_name;

            // 디바이스정보 처리
            $deviceInfoArray = explode("@", $args->device_info);
            foreach ($deviceInfoArray as $key => $value) {
                switch ($key) {
                    case 0: $args->brand = $value;
                        break;
                    case 1: $args->model = $value;
                        break;
                    case 2: $args->os_ver = $value;
                        break;
                }
            }

            $oGigancenterModel = &getModel("gigancenter");

            // 알림(모듈)등록 확인
            debugprint("디바이스 등록확인");
            $output = executeQuery('gigancenter.getDeviceInfoByMemberSrl', $args);

            debugprint($output);

            debugprint("output->data->member_srl : ".$output->data->member_srl);

            $args->list_order = -1 * $args->member_srl;
            if($output->data->member_srl){ //업데이트
                debugprint("디바이스 정보 업데이트");
                $output = $oGigancenterModel->upatetDeviceInfo($args);
                debugprint($output);
            }else{ // 인서트
                debugprint("디바이스 정보 인서트");
                $output = $oGigancenterModel->insertDeviceInfo($args);
                debugprint($output);
            }

            $redirectUrl = getNotEncodedUrl('', 'module', '', 'act', 'dispGigancenterRegisterDeviceInfo');
            $this->setRedirectUrl($redirectUrl);
        }

        /**
         * @brief 알림 수신 등록 or 해제
         * @return Object
         */
        function procGigancenterInsertAllow(){

            debugprint("procGigancenterInsertAllow");
            $args = Context::getRequestVars();
            debugprint($args);

            // 회원정보 처리
            $logged_info = Context::get("logged_info");

            // 로그인하지 않았다면 에러
            if(!Context::get('is_logged')) return new Object(-1, 'msg_not_permitted');


            //TODO module_count 만큼 루프롤 돌면서 처리한다.
            $oGigancenterModel = &getModel("gigancenter");

            $module_count =  $args->module_count;

            $dbArgs->member_srl = $logged_info->member_srl;
            for ($i = 0; $i < $module_count; $i++) {
                $dbArgs->target_module_srl = Context::get('target_module_srl'.$i);
                $dbArgs->module = Context::get('module'.$i);
                $dbArgs->browser_title = Context::get('browser_title'.$i);
                $dbArgs->allow_notification = Context::get('allow_notification'.$i);
                $oGigancenterModel->insertGigancenterAllow($dbArgs);
            }

            if(Context::get('success_return_url'))
            {
                $redirectUrl = Context::get('success_return_url');
            }
            else
            {
                $redirectUrl = getNotEncodedUrl('', 'mid', Context::get('mid'), 'act', 'dispGigancenterNotificationConfigure');
            }

            $this->setMessage('success_registed');
            $this->setRedirectUrl($redirectUrl);
        }
        
    	/**
    	 * @brief 문서 트리거
    	 * @param $obj : document object.
    	 * 새글 알림, 새글 모두알림 수신자에게 알림 전송
    	 **/    	 
    	function triggerInsertDocument(&$obj)
    	{
		debugprint("triggerInsertDocument -> execute");
    		$notificationMember = null;
    		$notificationAdmin = null;
    		
    		//환경설정 참조
    		$oGigancenterAdminModel = &getAdminModel('gigancenter');
    		$config = $oGigancenterAdminModel->getConfig();    		
    		
    		// 알림 서비스 사용하지 않는다면, module_srl 없다면 return
    		if($config->use_notification == "N" || $config->use_documentall == "N" || !$obj->module_srl  ) return;
    					
			// 모듈정보 조회
			$args->module_srl = $obj->module_srl;
			$output = executeQuery('module.getMidInfo', $args);

			// 모듈정보가 없다면 return
			if (!$output->toBool() || !$output->data) return;
			$module_info = $output->data;
			
			// 모듈 브라우저 타이틀 다국어처리						
			if(substr($module_info->browser_title,0,12)=='$user_lang->') {
				// 한글만 처리함
				$argsLang->name = str_replace('$user_lang->', '', $module_info->browser_title);
				$argsLang->lang_code = 'ko';				 
				$output = executeQueryArray('gigancenter.getLang', $argsLang);
				$browser_title = $output->data[0]->value;				 
				$module_info->browser_title = $output->data[0]->value;
			}else{
				$browser_title = $module_info->browser_title;
			}

            if($module_info->module == 'board'){
                $browser_title =  $browser_title.' 게시판';
            }else if($module_info->module == 'page'){
                $browser_title = $browser_title.' 페이지';
            }
			
			// 새글알림, 새글알림 3번
			$args->module_srls = ("3,".$args->module_srl );


            if($obj->member_srl) // member_srl 이 있으면면
           {
                $args->member_srl = $obj->member_srl;
            }else{
                $args->member_srl = "0";
            }
			// 모듈 알림을 수신하는 사용자 목록
			$output = executeQuery('gigancenter.getUserNotificationListByModuleSrl', $args);
            debugprint($output);

			// 알림수신자가 없다면 return
			if (!$output->toBool() || !$output->data) return;
			
			if($output->data) $notificationAdmin = $output->data;									
			$notificationSenderDeviceList = $this->mergeNotificationSender($notificationAdmin, $notificationMember);
								
			//알림전송 데이터 정리
			$notificationSenderAndroid->site_name = $config->site_name;
			$notificationSenderAndroid->gcm_api_key = $config->gcm_api_key;
			$notificationSenderAndroid->device_id = $notificationSenderDeviceList;

            $notificationSenderAndroid->title = "새글 알림";
            $notificationSenderAndroid->content = sprintf('%s님이 %s에 새글을 등록했습니다.', $obj->nick_name, $browser_title);

			$notificationSenderAndroid->url = getFullUrl('','document_srl', $obj->document_srl);

			// 알림전송
			$this->sendMessageAndroidByCurl($notificationSenderAndroid);			
    	}
    	

    	/**
    	 * @brief 댓글 트리거
    	 * @param $obj : SendMessage object.
    	 * 원글, 상위 댓글 작성자에게 댓글 알림 전송
    	 **/
    	function triggerInsertComment(&$obj)
    	{
            debugprint("triggerInsertComment == 시작");
    		$notificationMember = null;
    		$notificationAdmin = null;
    		
    		//환경설정 참조    		
    		$oGigancenterAdminModel = &getAdminModel('gigancenter');
    		$config = $oGigancenterAdminModel->getConfig();    		
    		
    		// 알림 서비스 사용하지 않는다면, module_srl 없다면 return
    		if($config->use_notification == "N" || ($config->use_comment == "N" &&  $config->use_commentall == "N")  || !$obj->module_srl  ) return;    		    		

			// 모듈정보 조회
			$args->module_srl = $obj->module_srl;
			$output = executeQuery('module.getMidInfo', $args);
			
			// 모듈정보가 없다면 return
			if (!$output->toBool() || !$output->data) return;
			$module_info = $output->data;
				
			//모듈 브라우저 타이틀 다국어처리
			if(substr($module_info->browser_title,0,12)=='$user_lang->') {
				// 한글만 처리함
				$argsLang->name = str_replace('$user_lang->', '', $module_info->browser_title);
				$argsLang->lang_code = 'ko';
				$output = executeQueryArray('gigancenter.getLang', $argsLang);
				$browser_title = $output->data[0]->value;
				$module_info->browser_title = $output->data[0]->value;
			}else{
				$browser_title = $module_info->browser_title;
			}

            if($module_info->module == 'board'){
                $browser_title =  $browser_title.' 게시판';
            }else if($module_info->module == 'page'){
                $browser_title = $browser_title.' 페이지';
            }

            debugprint("triggerInsertComment == 11");
            debugprint($config);
			// 댓글알림
			if($config->use_comment == "Y"){
                debugprint("triggerInsertComment == 댓글 작성자");

                if($obj->member_srl) // member_srl 이 있으면면
                {
                    $args->member_srl = $obj->member_srl;
                }else{
                    $args->member_srl = "0";
                }

				// 댓글알림 처리 parent_srl 여부에 따라 처리함.
				if($obj->parent_srl)
				{
                    debugprint("parent_srl");
					$args->parent_srl = $obj->parent_srl;
					$output = executeQuery('gigancenter.getMemberSrlByParentSrl', $args);
                    debugprint($output);

					// 오류 or 댓글정보가 없다면 return
					if (!$output->toBool() || !$output->data) return;

                    debugprint("triggerInsertComment == 22");

					//상위 댓글 작성회원 댓글알림 수신여부 확인 ( 댓글알림 2번 ) # 문서와 댓글 작성자가 같다면 패쓰.
					if($obj->member_srl != $output->data->member_srl)
					{
						$args->module_srls = ("2");
						$args->member_srl = $output->data->member_srl;
                        debugprint("triggerInsertComment : 댓글알림 수신 ");
						$output = executeQuery('gigancenter.getAllowNotificationCommentByMemberSrl', $args);
                        debugprint($output);

						if($output->data) $notificationMember = $output->data;
					}				
					
				}
				else
				{
                    debugprint("triggerInsertComment == 문서 작성자");
					//문서 작성자 정보 조회
					$args->document_srl = $obj->document_srl;
					$output = executeQuery('gigancenter.getMemberSrlByDocumentSrl', $args);

                    debugprint($output);

					// 오류 or 문서정보가 없다면 return
					if (!$output->toBool() || !$output->data) return;
					
					//문서 작성회원 댓글알림 수신여부 확인 ( 댓글알림 2번 ) # 문서와 댓글 작성자가 같다면 패쓰.				
					if($obj->member_srl != $output->data->member_srl)
					{
                        debugprint("triggerInsertComment == 문서 작성자 22");
						$args->module_srls = ("2");
						$args->member_srl = $output->data->member_srl;				
						$output = executeQuery('gigancenter.getAllowNotificationCommentInfoByMemberSrl', $args);
                        debugprint($output);

						if($output->data) $notificationMember = $output->data;
					}
									
	    		}
			}
			
    		// 댓글 모두알림
    		if($config->use_commentall == "Y")
    		{
	    		// 댓글모두 알림을 수신하는 관리자 ( 댓글 모두알림 4번 )
	    		$args->module_srls = ("4" );
	    		$output = executeQuery('gigancenter.getUserNotificationListByModuleSrl', $args);
               debugprint($output);

	    		if($output->data) $notificationAdmin = $output->data;	    		   		    		
    		}
    		
    		
    		// 알림수신자가 없다면 return
    		if ($notificationMember == null &&  $notificationAdmin == null) return;
    		 
    		// 알림 수신자 목록 정리
    		// 회원만
    		if($notificationMember != null &&  $notificationAdmin == null)
    		{
    			$notificationSenderDeviceList = array($notificationMember->device_id);
    		}
    		// 회원, 관리자 or 관리자
    		else if( ($notificationMember != null &&  $notificationAdmin != null) || ($notificationMember == null &&  $notificationAdmin != null) )
    		{
    			$notificationSenderDeviceList = $this->mergeNotificationSender($notificationAdmin, $notificationMember);
    		}
    		
    		// 알림전송 데이터 정리
    		$notificationSenderAndroid->site_name = $config->site_name;
    		$notificationSenderAndroid->gcm_api_key = $config->gcm_api_key; 
    		$notificationSenderAndroid->device_id = $notificationSenderDeviceList;

            $notificationSenderAndroid->title = "댓글 알림";
            $notificationSenderAndroid->content = sprintf('%s님이 %s에 댓글을 등록했습니다.', $obj->nick_name, $browser_title);
    		$notificationSenderAndroid->url = getFullUrl('','document_srl', $obj->document_srl);
            $notificationSenderAndroid->url = $notificationSenderAndroid->url.'#comment_'.$obj->comment_srl;
            $notificationSenderAndroid->url = str_replace('&amp;', '&', $notificationSenderAndroid->url);

    		// 알림전송
    		$this->sendMessageAndroidByCurl($notificationSenderAndroid);
    	
    	}
    	
    	/**
    	 * @brief 회원가입 트리거
    	 * @param $obj : member object.
    	 * 회원가입 알림 수신자에게 알림 전송
    	 **/
    	function triggerInsertMember(&$obj)
    	{
            debugprint("triggerInsertMember");
    		//환경설정 참조
    		$oGigancenterAdminModel = &getAdminModel('gigancenter');
    		$config = $oGigancenterAdminModel->getConfig();
    		
    		// 알림 서비스 사용하지 않는다면 return
    		if($config->use_notification == "N" || $config->use_member_signup == "N") return;


    		// 회원가입알림 수신확인 [회원가입 target_module_srl = 5 ]    	
    		$args->module_srls = ("5");
    		$output = executeQuery('gigancenter.getUserNotificationListByModuleSrl', $args);
            debugprint($output);
    		if($output->data) $notificationMember = $output->data;
    		    		
    		// 알림수신자가 없다면 return
    		if ($notificationMember == null) return;    		
    		
    		// 알림 수신자 목록 정리
    		$notificationAdmin = null;
   			$notificationSenderDeviceList = $this->mergeNotificationSender($notificationAdmin, $notificationMember);
   				
   			//알림전송 데이터 정리
   			$notificationSenderAndroid->site_name = $config->site_name;
   			$notificationSenderAndroid->gcm_api_key = $config->gcm_api_key;   			
   			$notificationSenderAndroid->device_id = $notificationSenderDeviceList;
   			$notificationSenderAndroid->title = "회원가입 알림";
            $notificationSenderAndroid->content = sprintf('%s님이 %s 사이트에 회원가입 했습니다.', $obj->nick_name, $config->site_name);
   			$notificationSenderAndroid->url = getFullUrl('','');
   			$this->sendMessageAndroidByCurl($notificationSenderAndroid);
            //$str = sprintf('%s님이 회원님의 %s에 "%s" 댓글을 남겼습니다.', $target_nick_name, $type, $v->target_summary);
    	}
    	
    	/**
    	 * @brief 쪽지 트리거
    	 * @param $obj : SendMessage object.
    	 * 쪽지 수신자에게 알림 전송
    	 **/
    	function triggerCommunicationSendMessage($receiver_args)
    	{
            debugprint("쪽지알림");
    		//환경설정 참조
    		$oGigancenterAdminModel = &getAdminModel('gigancenter');
    		$config = $oGigancenterAdminModel->getConfig();

    		// 알림 서비스 사용하지 않는다면 return
    		if($config->use_notification == "N" || $config->use_message == "N") return;
    		    	    	
    		//쪽지알림 수신확인 [쪽지 target_module_srl = 1 ]
    		$receiver_args->target_module_srl = '1';
    		$output = executeQuery('gigancenter.getUserNotificationMessageByReceiverSrl', $receiver_args);

            debugprint($output);

			// 오류 or 알림정보가 없다면 return
			if (!$output->toBool() || !$output->data) return;
    	
    		// 쪽지 알림을 수신중이라면
    		if($output->data->allow_notification == 'Y')
    		{
    			//sender_srl 로 닉네임 조회
    			$args->member_srl = $receiver_args->sender_srl;
    			$outputNickname = executeQuery('gigancenter.getMemberNicknameByMemberSrl', $args);

                // 닉네임이 있을 때
                if($outputNickname->data->nick_name != ''){
                    $nickName = $outputNickname->data->nick_name.' 님에게';
                }else{
                    $nickName =  $config->site_name.' 사이트 에서';
                }
    			//알림전송 데이터 정리
    			$notificationSenderAndroid->site_name = $config->site_name;
    			$notificationSenderAndroid->gcm_api_key = $config->gcm_api_key;
    			$notificationSenderAndroid->device_id = array($output->data->device_id);
                $notificationSenderAndroid->title = "쪽지 알림";
                $notificationSenderAndroid->content = sprintf('%s 쪽지를 받았습니다.',$nickName);
    			$notificationSenderAndroid->url = getFullUrl('','act','dispCommunicationMessages','message_srl',$receiver_args->message_srl);
    			$notificationSenderAndroid->url = str_replace('&amp;', '&', $notificationSenderAndroid->url);
    			$this->sendMessageAndroidByCurl($notificationSenderAndroid);
    		}
    	
    	}
    	
    	
    	/**
    	 * @brief 알림 수신자 병합 및 중복 제거
    	 * @param $notificationAdmin : admin.
    	 * @param $notificationMember : member.
    	 * @result $device_id : array().
    	 **/
    	function mergeNotificationSender($notificationAdmin, $notificationMember)
    	{    	    		    		
    		$device_id = array();
    		
    		//관리자
    		if( $notificationAdmin != null )
    		{
    			if(count($notificationAdmin) == 1)
    			{
    				foreach ($notificationAdmin as $key => $value)
    				{    						
    					if($key == "device_id" && $value != "" )
    					{
    						if (!in_array($value, $device_id))
    						{
    							array_push($device_id, $value);
    						}
    					}
    				}
    			}
    			else if(count($notificationAdmin) > 1)
    			{
    				foreach ($notificationAdmin as $key => $value)
    				{    			
    					if($value->device_id !=""){
    						if (!in_array($value, $device_id))
    						{
    							array_push($device_id, $value->device_id);
    						}
    					}
    				}
    			}    			
    		}
    		
    		// 회원
    		if( $notificationMember != null )    		
    		{    			
    			if(count($notificationMember) == 1)
    			{
    				foreach ($notificationMember as $key => $value)
    				{    					
    					if($key == "device_id" && $value != "" )
    					{
    						if (!in_array($value, $device_id))
    						{
    							array_push($device_id, $value);
    						}
    					}    				
    				}
    			}
    			else if(count($notificationMember) > 1)
    			{    				    				
    				foreach ($notificationMember as $key => $value)
    				{    				    				
    					if($value->device_id !=""){
    						if (!in_array($value, $device_id))
    						{
    							array_push($device_id, $value->device_id);
    						}
    					}
    				}
    			} 
    			 
    		}
    		return $device_id;    	    	
    	}

    	
    	/** 
    	 * @brief 구글 GCM으로 푸시 알림 요청.
    	 * @param $args : notification data object.
         * android GCM
         * registration_ids [1~1000] 까지가능
         */
    	function sendMessageAndroidByCurl($args) {
		    debugprint("sendMessageAndroidByCurl -> execute" );

    		$apiKey = $args->gcm_api_key;

    		$data = array(
				'registration_ids' => $args->device_id,
				'data' => array('site_name' => $args->site_name, 'title'=>$args->title, 'content'=>$args->content, 'url'=>$args->url)
    		);

            debugprint("GCM data ======================================= start");
            debugprint($data);
            debugprint("GCM data ======================================= end");

    		$headers = array(
    				"Content-Type:application/json",
    				"Authorization:key=".$apiKey
    		);

            debugprint("GCM headers  ======================================= start");
            debugprint($headers);
            debugprint("GCM headers  ======================================= end");

			if(is_callable('curl_init')){ // Curl 사용 가능할 때
				$ch = curl_init();
				curl_setopt($ch, CURLOPT_URL, "https://android.googleapis.com/gcm/send");
				curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
				curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
				curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
				curl_setopt($ch, CURLOPT_POST, true);
				curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode2($data));
				$result = curl_exec($ch);
				curl_close($ch);

				//TODO 알림 메시지 전송결과를 업데이트 해준다. (성공, 실패, 보낸 횟수, 마지막 보낸시간)

				debugprint("GCM Sender Result ======================================= start");
				debugprint($result);
				debugprint("GCM Sender Result ======================================= end");
			}else{
				debugprint("Curl init failed");
			}
    	}
    	    	
    	
    }
?>