<?php
    /**
     * @class  gigancenter
     * @author 그냥재미로
     * @brief  gigancenter 모듈의 high class
     **/

    class gigancenter extends ModuleObject {

        /**
         * @brief 설치시 추가 작업이 필요할시 구현
         **/
        function moduleInstall() {

        	$oModuleController = &getController('module');
        	$oModuleModel = &getModel('module');
        	
        	// Document Insert Trigger
        	$oModuleController->insertTrigger('document.insertDocument', 'gigancenter', 'controller', 'triggerInsertDocument', 'after');
        	
        	// Comment Insert Trigger
        	$oModuleController->insertTrigger('comment.insertComment', 'gigancenter', 'controller', 'triggerInsertComment', 'after');

        	// Member Insert Trigger
        	$oModuleController->insertTrigger('member.insertMember', 'gigancenter', 'controller', 'triggerInsertMember', 'after');
        	
        	// communication sendMessage Trigger (쪽지 알림 기능을 사용하려면 주석을 제거하세요)
        	// XE Core 에는 쪽지 트리거가 없으니 쪽지 알림기능을 사용하려면 트리거를 추가해주세요
        	// ( 파일 :/modules/communication.controller.php )
//         	function sendMessage($sender_srl, $receiver_srl, $title, $content, $sender_log = true) {
// 				...
// 				...
//         		$oDB->commit();        	
//         		// Call a trigger (after) [gigancenter add]
//         		ModuleHandler::triggerCall('communication.sendMessage', 'after', $receiver_args);        	
//         		return new Object(0,'success_sended');
//         	}

        	$oModuleController->insertTrigger('communication.sendMessage', 'gigancenter', 'controller', 'triggerCommunicationSendMessage', 'after');
        	
            return new Object();
        }

        /**
         * @brief 설치가 이상이 없는지 체크하는 method
         **/
        function checkUpdate() {

        	$oDB = &DB::getInstance();
        	$oModuleModel = &getModel('module');
        	$oModuleController = &getController('module');
        
        	// Document Insert Trigger
        	if (!$oModuleModel->getTrigger('document.insertDocument', 'gigancenter', 'controller', 'triggerInsertDocument', 'after'))
        	{
        		return true;
        	}
        	// Comment Insert Trigger
        	if (!$oModuleModel->getTrigger('comment.insertComment', 'gigancenter', 'controller', 'triggerInsertComment', 'after'))
        	{
        		return true;
        	}
        	
        	// Member Insert Trigger
        	if (!$oModuleModel->getTrigger('member.insertMember', 'gigancenter', 'controller', 'triggerInsertMember', 'after'))
        	{
        		return true;
        	}

        	// communication sendMessage Trigger 
        	if (!$oModuleModel->getTrigger('communication.sendMessage', 'gigancenter', 'controller', 'triggerCommunicationSendMessage', 'after'))
        	{
        		return true;
        	}        	
        	return false;
        }

        /**
         * @brief 업데이트 실행
         **/
        function moduleUpdate() {

        	$oDB = &DB::getInstance();
        	$oModuleModel = &getModel('module');
        	$oModuleController = &getController('module');
        	
        	// Document Insert Trigger
        	if (!$oModuleModel->getTrigger('document.insertDocument', 'gigancenter', 'controller', 'triggerInsertDocument', 'after'))
        	{
        		$oModuleController->insertTrigger('document.insertDocument', 'gigancenter', 'controller', 'triggerInsertDocument', 'after');
        	}
        	
        	// Comment Insert Trigger
        	if (!$oModuleModel->getTrigger('comment.insertComment', 'gigancenter', 'controller', 'triggerInsertComment', 'after'))
        	{
        		$oModuleController->insertTrigger('comment.insertComment', 'gigancenter', 'controller', 'triggerInsertComment', 'after');
        	}
        	
        	// Member Insert Trigger
        	if (!$oModuleModel->getTrigger('member.insertMember', 'gigancenter', 'controller', 'triggerInsertMember', 'after'))
        	{
        		$oModuleController->insertTrigger('member.insertMember', 'gigancenter', 'controller', 'triggerInsertMember', 'after');
        	}        	
        	
        	// communication sendMessage Trigger
        	if (!$oModuleModel->getTrigger('communication.sendMessage', 'gigancenter', 'controller', 'triggerCommunicationSendMessage', 'after'))
        	{
        		$oModuleController->insertTrigger('communication.sendMessage', 'gigancenter', 'controller', 'triggerCommunicationSendMessage', 'after');
        	}
        	 
        	 
            return new Object(0, 'success_updated');
        }

        /**
         * @brief 캐시 파일 재생성
         **/
        function recompileCache() {
        }


        /**
         * @brief 모듈 삭제
         **/
        function moduleUninstall() {
            /*
            * select * from xxx_module_trigger where module= 'gigancenter'
            * delete from xxx_module_trigger where module= 'gigancenter'
            * select * from xxx_module_config where module= 'gigancenter'
            * delete from xxx_module_config where module= 'gigancenter'
             */
            $oModuleModel = &getModel('module');
            $oModuleController =& getController('module');

            if($oModuleModel->getTrigger('document.insertDocument', 'gigancenter', 'controller', 'triggerInsertDocument', 'after'))
                $oModuleController->deleteTrigger('document.insertDocument', 'gigancenter', 'controller', 'triggerInsertDocument', 'after');

            if($oModuleModel->getTrigger('comment.insertComment', 'gigancenter', 'controller', 'triggerInsertComment', 'after'))
                $oModuleController->deleteTrigger('comment.insertComment', 'gigancenter', 'controller', 'triggerInsertComment', 'after');

            if($oModuleModel->getTrigger('member.insertMember', 'gigancenter', 'controller', 'triggerInsertMember', 'after'))
                $oModuleController->deleteTrigger('member.insertMember', 'gigancenter', 'controller', 'triggerInsertMember', 'after');

            if($oModuleModel->getTrigger('communication.sendMessage', 'gigancenter', 'controller', 'triggerCommunicationSendMessage', 'after'))
                $oModuleController->deleteTrigger('communication.sendMessage', 'gigancenter', 'controller', 'triggerCommunicationSendMessage', 'after');

            $output = executeQueryArray("gigancenter.getAllGigancenter");
            if(!$output->data) return new Object();

            set_time_limit(0);
            foreach($output->data as $gigancenter)
            {
                $oModuleController->deleteModule($gigancenter->module_srl);
            }

            return new Object();

        }

        
    }
?>
