<?php
    /**
     * @class  gigancenterAdminView
     * @author 그냥재미로
     * @brief  gigancenter 모듈의 admin view class
     **/

    class gigancenterAdminView extends gigancenter {

    	var $group_list;
    	
        /**
         * @brief 초기화
         **/
        function init() {
        	/**/
			$oMemberModel = &getModel('member');
	
			// group 목록 가져오기
			$this->group_list = $oMemberModel->getGroups();
			Context::set('group_list', $this->group_list);
			
			// 관리자 템플릿 파일의 경로 설정 (tpl)
            $template_path = sprintf("%stpl/",$this->module_path);
            $this->setTemplatePath($template_path);
            
            $this->setTemplatePath($this->module_path.'tpl');           
                        
		}

		/**
		 * @brief admin config
		 **/		
		function dispGigancenterAdminConfig()
		{
			$oModuleModel = &getModel('module');
			$oGigancenterAdminModel = &getAdminModel('gigancenter');

			$config = $oGigancenterAdminModel->getConfig();
            Context::set('config', $config);
		
			$skin_list = $oModuleModel->getSkins($this->module_path);
			Context::set('skin_list', $skin_list);
		
			if(!$skin_list[$config->skin]) $config->skin = 'default';
			Context::set('colorset_list', $skin_list[$config->skin]->colorset);

            $security = new Security();
            $security->encodeHTML('config..');
            $security->encodeHTML('skin_list..title');
            $security->encodeHTML('colorset_list..name','colorset_list..title');
            $this->setTemplateFile('config');

		}
		
        /**
         * @brief admin index list
         **/
		function dispGigancenterAdminIndex(){						
			$oGigancenterAdminModel = &getAdminModel('gigancenter');
			$oMemberModel = &getModel('member');			

			$output = $oGigancenterAdminModel->getGigancenterNotificationList();			
			
			$notification_list = array();								
			if ($output->toBool() && $output->data)
			{
				$notification_list = $output->data;
			}
			
			Context::set('list', $notification_list);
			Context::set('total_count', $output->total_count);
			Context::set('total_page', $output->total_page);
			Context::set('page', $output->page);
			Context::set('page_navigation', $output->page_navigation);

            $this->setTemplateFile('index');
			
		}

		/**
		 * @brief admin 알림대상 모듈 추가, 수정
		 **/
		function dispGigancenterAdminInsert(){
			
			$allow_srl = Context::get('allow_srl');

			if($allow_srl){
				$args->allow_srl = $allow_srl;
				$output = executeQuery("gigancenter.getNotificationBySrl", $args);
				$notification = $output->data;
				Context::set('notification', $notification);
			}
						
			Context::set('config', $config);

			//가능 대상 모듈 목록 가져오기
			$oGigancenterModel = &getAdminModel('gigancenter');			
			$args->sort_index = 'mid';			
			$args->module = 'board';
			$target_modules = $oGigancenterModel->getGigancenterMidList($args);

			// 기본모듈 ( 쪽지 1, 댓글 2, 새글모두3 , 댓글모두4, 회원가입 5)
			$gigancenterModule = new stdClass;

			$gigancenterModule->message->module_srl = "1";
			$gigancenterModule->message->module = "message";
			$gigancenterModule->message->browser_title = "쪽지 알림";
			
			$gigancenterModule->comment->module_srl = "2";
			$gigancenterModule->comment->module = "comment";
			$gigancenterModule->comment->browser_title = "댓글 알림";				
			
			$gigancenterModule->documentall->module_srl = "3";
			$gigancenterModule->documentall->module = "board";
			$gigancenterModule->documentall->browser_title = "새글 모두알림";

			$gigancenterModule->commentall->module_srl = "4";
			$gigancenterModule->commentall->module = "board";
			$gigancenterModule->commentall->browser_title = "댓글 모두알림";

			$gigancenterModule->member_signup->module_srl = "5";
			$gigancenterModule->member_signup->module = "member";
			$gigancenterModule->member_signup->browser_title = "회원가입 알림";
			
			$target_modules = (object) array_merge((array)$gigancenterModule, (array)$target_modules);
						
			Context::set('target_modules', $target_modules);

            $this->setTemplateFile('insert');

		}
		
		/**
		 * @brief Select a member
		 **/
		function dispGigancenterAdminMemberSelectList()
		{
			if(!Context::get('is_logged')) return new Object(-1, 'msg_not_permitted');
			
			$oGigancenterAdminModel = &getAdminModel('gigancenter');
			$oMemberModel = &getModel('member');
			$output = $oGigancenterAdminModel->getGigancenterMemberList();

			if($output->data) {
				foreach($output->data as $key => $member)
				{
					$output->data[$key]->group_list = $oMemberModel->getMemberGroups($member->member_srl,0);
				}
			}
			
			$config = $oMemberModel->getMemberConfig();
			$memberIdentifiers = array('user_id'=>'user_id', 'user_name'=>'user_name', 'nick_name'=>'nick_name');
			$usedIdentifiers = array();
			
			if (is_array($config->signupForm)){
				foreach($config->signupForm as $signupItem){
					if (!count($memberIdentifiers)) break;
					if(in_array($signupItem->name, $memberIdentifiers) && ($signupItem->required || $signupItem->isUse)){
						unset($memberIdentifiers[$signupItem->name]);
						$usedIdentifiers[$signupItem->name] = $lang->{$signupItem->name};
					}
				}
			}
			
			Context::set('total_count', $output->total_count);
			Context::set('total_page', $output->total_page);
			Context::set('page', $output->page);
			Context::set('member_list', $output->data);
			Context::set('usedIdentifiers', $usedIdentifiers);
			Context::set('page_navigation', $output->page_navigation);

            $security = new Security();
            $security->encodeHTML('member_list..user_name', 'member_list..nick_name', 'member_list..group_list..');
            $security->encodeHTML('id', 'type');

			$this->setLayoutFile('popup_layout');
            $this->setTemplateFile('member_selector');
		}
		

	}
?>
