<?php
    /**
     * @class  gigancenterAdminController
     * @author 그냥재미로
     * @brief  gigancenter 모듈의 admin controller class
     **/

    class gigancenterAdminController extends gigancenter {

        /**
         * @brief 
         * role : 초기화
         **/
        function init() 
        {
        	
        }

        /**
         * @brief
         * target Table : module_config
         **/
        function procGigancenterAdminInsertConfig()
        {

            $oModuleController = &getController('module');

            // 환경설정에 저장할 args 추출
            $args->site_name = Context::get('site_name');
            $args->use_notification = Context::get('use_notification');
            $args->use_message = Context::get('use_message');
            $args->use_document = Context::get('use_document');
            $args->use_comment = Context::get('use_comment');
            $args->use_documentall = Context::get('use_documentall');
            $args->use_commentall = Context::get('use_commentall');
            $args->use_member_signup = Context::get('use_member_signup');
            $args->google_project_id = Context::get('google_project_id');
            $args->gcm_api_key = Context::get('gcm_api_key');
            $args->android_return_url = Context::get('android_return_url');

            $output = $oModuleController->updateModuleConfig('gigancenter', $args);

            if(!$output->toBool())
            {
                return $output;
            }

            $this->setMessage('success_updated');
            $returnUrl = Context::get('success_return_url') ? Context::get('success_return_url') : getNotEncodedUrl('', 'module', 'admin', 'act', 'dispGigancenterAdminConfig');
            $this->setRedirectUrl($returnUrl);
        }

        /**
         * @brief 알림 서비스 대상 등록, 수정
         * target Table : gigancenter_allow
         **/
        function procGigancenterAdminInsertGigancenterAllow()
        {    
        	debugprint("procGigancenterAdminInsertGigancenterAllow");

        	// reqArgs 추출
        	$reqArgs = Context::gets('allow_srl', 'target_module', 'module','member_srl','allow_notification');

        	$expArray = explode("," , $reqArgs->target_module);
            $reqArgs->target_module_srl = $expArray[0];
            $reqArgs->browser_title = $expArray[1];
        	
        	if($reqArgs->allow_srl){ //업데이트
        		$output = executeQuery('gigancenter.updateGigancenterAllow', $reqArgs);
                debugprint($output);
        		if (!$output->toBool()) return $output;
        		
        	}else{//인서트
                $reqArgs->allow_srl = getNextSequence();
        		$output = executeQuery('gigancenter.insertGigancenterAllow', $reqArgs);
                debugprint($output);
        		if (!$output->toBool()) return $output;
        	}
        	
        	if (!$output->toBool())
        	{
        		return $output;
        	}
        	        	
        	$redirectUrl = getNotEncodedUrl('', 'module', 'admin', 'act', 'dispGigancenterAdminIndex');
        	$this->setRedirectUrl($redirectUrl);
 
        }

        /**
         * procGigancenterAdminDeleteSelectedGigancenterAllow
         * 알림수신정보 삭제
         */
        function procGigancenterAdminDeleteSelectedGigancenterAllow(){

            $reqArgs = Context::getRequestVars();
            $allows = $reqArgs->allow_srls;

            $oDB = &DB::getInstance();
            $oDB->begin();

            $oGigancenterModel = getAdminModel('gigancenter');

            foreach($allows as $key=>$allow_srl)
            {
                $output = $oGigancenterModel->deleteGigancenterAllowByAllowSrl($allow_srl);
                if(!$output->toBool())
                {
                    $oDB->rollback();
                    return $output;
                }
            }

            $this->setMessage('success_deleted');
            $returnUrl = Context::get('success_return_url') ? Context::get('success_return_url') : getNotEncodedUrl('', 'module', 'admin', 'act', 'dispGigancenterAdminIndex');
            $this->setRedirectUrl($returnUrl);

        }

	}
?>