<?php
    /**
     * @class  gigancenterView
     * @author 그냥재미로
     * @brief gigancenter 모듈의 view class
     **/

    class gigancenterView extends gigancenter {

         /**
         * @brief 초기화
         **/
		 function init() {
             debugprint("gigancenterView->init");

             // 스킨 경로 Set
             $template_path = sprintf("%sskins/%s/",$this->module_path, $this->module_info->skin);
             if(!is_dir($template_path)||!$this->module_info->skin) {
                 $this->module_info->skin = 'default';
                 $template_path = sprintf("%sskins/%s/",$this->module_path, $this->module_info->skin);
             }
             $this->setTemplatePath($template_path);

             // module_srl Set
             $module_srl = Context::get('module_srl');
             if(!$module_srl && $this->module_srl) {
                 $module_srl = $this->module_srl;
                 Context::set('module_srl', $module_srl);
             }

             // 모듈 등록정보 Set
             $oModuleModel = &getModel('module');
             if($module_srl) {
                 $module_info = $oModuleModel->getModuleInfoByModuleSrl($module_srl);
                 $this->module_info = $module_info;
                 Context::set('module_info',$module_info);
             }

             debugprint("_SERVER[HTTP_USER_AGENT]====================");
             debugprint($_SERVER['HTTP_USER_AGENT']);

        }


        /**
         * 기가 알림센터 index
         */
        function dispGigancenterIndex(){


            debugprint("_SERVER[HTTP_USER_AGENT]====================");
            debugprint($_SERVER['HTTP_USER_AGENT']);

            // 에이전트 확인
            if(stripos($_SERVER['HTTP_USER_AGENT'], 'Sagiga') !== FALSE)
            {
                debugprint("agent sagiga  있음 " );
            }else{
                debugprint("agent sagiga  없음 " );
            }

            //TODO 기가웹뷰로 접근하지 안았다면 안내 메시지 출력
            $oGigancenterAdminModel = &getAdminModel('gigancenter');

            $config = $oGigancenterAdminModel->getConfig();
            Context::set('config', $config);
            $this->setTemplateFile('index');
        }


        /**
         * 디바이스 등록 확인 페이지
         */
        function dispGigancenterRegisterDevice(){

            debugprint("dispGigancenterRegisterDevice");

            $args = Context::getRequestVars();
            debugprint($args);

            $device_info = null;
            $device_info->platform = $args->platform;
            $device_info->member_srl = $args->member_srl;
            $device_info->platform = $args->platform;
            $device_info->os_ver = $args->os_ver;
            $device_info->device_id = $args->device_id;


            Context::set('device_info', $device_info);

            //TODO 디바이스 종류에 따라 분기
            $this->setTemplateFile('register_device');
        }


        /**
         * 디바이스 등록정보 확인
         * @return Object
         */
        function dispGigancenterRegisterDeviceInfo(){


            debugprint("dispGigancenterRegisterDeviceInfo");
            // 로그인하지 않았다면 에러
            if(!Context::get('is_logged')) return new Object(-1, 'msg_not_permitted');

            // 회원정보 처리
            $logged_info = Context::get("logged_info");
            $args->member_srl = $logged_info->member_srl;

            $oGigancenterModel = &getModel("gigancenter");
            $output = $oGigancenterModel->getMemberDeviceInfo($args);

            debugprint($output);

            Context::set('device_info', $output->data);

            //TODO 디바이스 종류에 따라 분기
            $this->setTemplateFile('device_info');
        }


        /**
         * 알림 수신 설정
         */
        function dispGigancenterNotificationConfigure(){


            debugprint("dispGigancenterNotificationConfigure");
            // 로그인하지 않았다면 에러
            if(!Context::get('is_logged')) return new Object(-1, 'msg_not_permitted');

            $logged_info = Context::get("logged_info");
            $args->member_srl = $logged_info->member_srl;

            //TODO 등록된 디바이스 정보가 없다면 에러
//
//            $oGigancenterModel = &getModel("gigancenter");
//            $output = $oGigancenterModel->getMemberDeviceInfo($args);
//
//            debugprint($output);
//
//            Context::set('device_info', $output->data);

            $oGigancenterModel = &getModel('gigancenter');
            $output = $oGigancenterModel->getGigancenterMemberNotificationList($args);

            Context::addJsFilter($this->module_path.'tpl/filter', 'insert_gigancenter_allow.xml');

            Context::set("notification_list", $output);
            debugprint($output);
            $this->setTemplateFile('notification_configure');
        }

    }