<?php
    /**
     * @class  gigancenterView
     * @author 그냥재미로
     * @brief gigancenter 모듈의 view class
     **/

    class gigancenterView extends gigancenter {

         /**
         * @brief 초기화
         **/
		 function init() {
             debugprint("talkView->init");
             debugprint($this->module_info);
             debugprint($this->grant);

             /**
              * 기본 모듈 정보들 설정 (list_count, page_count는 게시판 모듈 전용 정보이고 기본 값에 대한 처리를 함)
              **/
             if($this->module_info->list_count) $this->list_count = $this->module_info->list_count;
             if($this->module_info->search_list_count) $this->search_list_count = $this->module_info->search_list_count;
             if($this->module_info->page_count) $this->page_count = $this->module_info->page_count;
             $this->except_notice = $this->module_info->except_notice == 'N' ? false : true;


             /**
              * 스킨 경로를 미리 template_path 라는 변수로 설정함
              * 스킨이 존재하지 않는다면 xe_board로 변경
              **/
             $template_path = sprintf("%sskins/%s/",$this->module_path, $this->module_info->skin);
             if(!is_dir($template_path)||!$this->module_info->skin) {
                 $this->module_info->skin = 'default';
                 $template_path = sprintf("%sskins/%s/",$this->module_path, $this->module_info->skin);
             }
             $this->setTemplatePath($template_path);

             /**
              * 게시판 전반적으로 사용되는 javascript, JS 필터 추가
              **/
             Context::addJsFilter($this->module_path.'tpl/filter', 'input_password.xml');
             // Context::addJsFile($this->module_path.'tpl/js/board.js');


             // 목록 수 list_count에 대한 설정
             if($this->module_info->list_count) $this->list_count = $this->module_info->list_count;

             // module_srl이 있으면 미리 체크하여 존재하는 모듈이면 module_info 세팅
             $module_srl = Context::get('module_srl');
             if(!$module_srl && $this->module_srl) {
                 $module_srl = $this->module_srl;
                 Context::set('module_srl', $module_srl);
             }

             // module model 객체 생성
             $oModuleModel = &getModel('module');

             // module_srl이 넘어오면 해당 모듈의 정보를 미리 구해 놓음
             // 모듈의 브라우저 타이틀, 관리자, 레이아웃 등 xe_modules table의 값과 정보
             if($module_srl) {
                 $module_info = $oModuleModel->getModuleInfoByModuleSrl($module_srl);
                 $this->module_info = $module_info;
                 Context::set('module_info',$module_info);
             }

        }


        /**
         * @brief 수신 알림 목록 페이지 and index
         */
        function dispGigancenterIndex(){

            //TODO 환경설정  정보를 참조... PROJECT_ID RETURN_RUL 을 넣어줘야함.

//            $oModuleModel = &getModel('module');
            $oGigancenterAdminModel = &getAdminModel('gigancenter');


            $config = $oGigancenterAdminModel->getConfig();
            Context::set('config', $config);

            $this->setTemplateFile('index');
        }


        function dispGigancenterRegisterDevice(){

            debugprint("dispGigancenterRegisterDevice");

            $args = Context::getRequestVars();
            debugprint($args);

            $device_info = null;
            $device_info->platform = $args->platform;
            $device_info->member_srl = $args->member_srl;
            $device_info->platform = $args->platform;
            $device_info->os_ver = $args->os_ver;
            $device_info->device_id = $args->device_id;


            Context::set('device_info', $device_info);




            //TODO 디바이스 종류에 따라 분리

            $this->setTemplateFile('register_device');
        }


        function dispGigancenterRegisterDeviceInfo(){


            debugprint("dispGigancenterRegisterDeviceInfo");
            // 로그인하지 않았다면 에러
            if(!Context::get('is_logged')) return new Object(-1, 'msg_not_permitted');

            // 회원정보 처리
            $logged_info = Context::get("logged_info");
            $args->member_srl = $logged_info->member_srl;

            $oGigancenterModel = &getModel("gigancenter");
            $output = $oGigancenterModel->getMemberDeviceInfo($args);

            debugprint($output);

            Context::set('device_info', $output->data);

            $this->setTemplateFile('device_info');
        }


        function dispGigancenterNotificationConfigure(){


            debugprint("dispGigancenterNotificationConfigure");
//            // 로그인하지 않았다면 에러
//            if(!Context::get('is_logged')) return new Object(-1, 'msg_not_permitted');
//
//            // 회원정보 처리
            $logged_info = Context::get("logged_info");
            $args->member_srl = $logged_info->member_srl;
//
//            $oGigancenterModel = &getModel("gigancenter");
//            $output = $oGigancenterModel->getMemberDeviceInfo($args);
//
//            debugprint($output);
//
//            Context::set('device_info', $output->data);

            $oGigancenterModel = &getModel('gigancenter');
            $output = $oGigancenterModel->getGigancenterMemberNotificationList($args);

            Context::addJsFilter($this->module_path.'tpl/filter', 'insert_notification_allow.xml');

            Context::set("notification_list", $output);
            debugprint($output);
            $this->setTemplateFile('notification_configure');
        }





    }
?>