<?php
    /**
     * @class  gigancenterModel
     * @author 그냥재미로
     * @brief  gigancenter 모듈의 model class
     **/

    class gigancenterModel extends gigancenter {

	    /**
         * @brief 초기화
         **/
        function init() {
        }


        /**
         * @brief 디바이스 정보 등록
         **/
        function insertDeviceInfo($args) {
            $output = executeQueryArray('gigancenter.insertDeviceInfo', $args);
            return $output;
        }

        /**
         * @brief 디바이스 정보 업데이트
         **/
        function upatetDeviceInfo($args) {
            $output = executeQueryArray('gigancenter.updateDeviceInfo', $args);
            return $output;
        }

        /**
         * @brief 회원 디바이스 정보 조회
         **/
        function getMemberDeviceInfo($args) {
            $output = executeQuery('gigancenter.getDeviceInfoByMemberSrl', $args);
            return $output;
        }




        /**
         * @brief 알림 수신 디바이스 아이디 등록 인서트 or 업데이트
         **/
        function insertGigancenterAllow($args) {

            debugprint("insertGigancenterAllow");
        	// 알림(모듈)등록 확인
        	$output = executeQuery('gigancenter.getGigancenterAllowByArgs', $args);
            debugprint($output);

        	// 등록, 업데이트
        	if($output->data->allow_srl)
        	{
                debugprint("값이 있으면 업데이트");
                $args->allow_srl = $output->data->allow_srl;
        		//업데이트
                $args->update_order = getNextSequence() * -1;
        		$output = executeQueryArray('gigancenter.updateGigancenterAllow', $args);
        	}
        	else
        	{
                debugprint("값이 없으면 인서트");
        		//신규등록
        		$args->allow_srl = getNextSequence();
                $args->list_order = $args->allow_srl * -1;
        		$output = executeQueryArray('gigancenter.insertGigancenterAllow', $args);
        	}

            debugprint($output);

        	return $output;        	
        }

        /**
         * @brief 알림수신 모두해제
         * API
         **/
        function _dispGigancenterUnRegisterAllDeviceAPI($args) {        
        	$output = executeQueryArray('gigancenter.updateGigancenterMemberNotificationAllowRevocation', $args);
        	return $output;
        }
        
        /**
         * 관리권한이 있는 알림목록(모듈)을 구함.
         * @param $obj
         * gigancenter 1.0.0 beta only (삭제 예정)
         */
        function getGigancenterModuleAdmins($obj){
        	        	
        	$args->member_srl = $obj->member_srl;
        	
        	//알림 목록을 담을 배열
        	$userNotifications = array();        	        	
        	
			/*********************************************************************************************
			 * part:1
        	 관리자 권한이 있는 모듈과 알림 권한을 받은 목록을 구한다. ( modules_srl 만 구함 )
			**********************************************************************************************/
        	//TODO 환경설정 고려
        	$args->allow_modules = "'board','member'";
        	
        	//권한이 있는 모듈을 구함      	
        	$output = executeQueryArray('gigancenter.getModuleSrlsByModuleAdmin', $args);

        	if ($output->data) $moduleAdmin_list = $output->data;

        	//알림 수신중인 모듈을 구함
        	$output = executeQueryArray('gigancenter.getModuleSrlsByGigancenterAllow', $args);

        	if($output->data){
        		$moduleUser_list = $output->data;
        	}
        	
        	// 모듈 권한리스트, 수신리스트 병합 후 유니크 모듈 리스트 생성
        	$moduleSrls = array();        	
        	if($moduleAdmin_list){
        		foreach ($moduleAdmin_list as $key => $val) {        			
        			foreach ($val as $key2 => $val2) {
        				array_push($moduleSrls, $val2);        				
        			}
        		}        		
        	}
        	
        	if($moduleUser_list){
        		foreach ($moduleUser_list as $key => $val) {
        			foreach ($val as $key2 => $val2) {
        				array_push($moduleSrls, $val2);
        			}
        		}
        	}
        	
        	//유니크 모듈 시리얼
        	$uModuleSrls = array_unique($moduleSrls);        	
        	$args->module_srls = implode(",",$uModuleSrls);        	
        	
        	/*********************************************************************************************
			* part:2
        	 권한이 있는 Gigancenter 모듈 ( 쪽지 알림, 댓글알림 )  을 구한다. (권한이 있는 모듈과 병합)
        	 모듈번호 : 쪽지[1], 댓글알림[2] 새글모두[3], 댓글모두[4], 회원가입[5]
        	 새글모두, 댓글모두, 회원가입 알림은 관리자 직접 권한 추가  
        	**********************************************************************************************/
        	
			//환경설정 참조
        	$oModuleModel = &getModel('module');
        	$config = $oModuleModel->getModuleConfig('gigancenter');
        	        	
        	// 기본 알림서비스(모든회원대상)
        	$gigancenterModule_list = new stdClass;
        	
			if($config->use_message == 'Y')
			{        
	        	$gigancenterModule_list->message->module_srl = "1";
	        	$gigancenterModule_list->message->module = "message";
	        	$gigancenterModule_list->message->browser_title = "쪽지 알림";
			}
			if($config->use_comment == 'Y')
			{
	        	$gigancenterModule_list->comment->module_srl = "2";
	        	$gigancenterModule_list->comment->module = "comment";
	        	$gigancenterModule_list->comment->browser_title = "댓글 알림";
			}
			
			//알림수신 목록에 새글모두 알림, 댓글 모두 알림이 있다면 추가
			if(in_array("3", $uModuleSrls))
			{
				$gigancenterModule_list->documentall->module_srl = "3";
				$gigancenterModule_list->documentall->module = "documentall";
				$gigancenterModule_list->documentall->browser_title = "새글 모두알림";
			}
			if(in_array("4", $uModuleSrls))
			{
				$gigancenterModule_list->commentall->module_srl = "4";
				$gigancenterModule_list->commentall->module = "commentall";
				$gigancenterModule_list->commentall->browser_title = "댓글 모두알림";
			}
			if(in_array("5", $uModuleSrls))
			{
				$gigancenterModule_list->member_signup->module_srl = "5";
				$gigancenterModule_list->member_signup->module = "member_signup";
				$gigancenterModule_list->member_signup->browser_title = "회원가입 알림";
			}
        	 
        	/*********************************************************************************************
        	 유니크 모듈 리스트로 모듈정보와 알림수신 상태 리스트 생성
        	 part:1 에서 구해둔 $args->module_srls 사용
        	**********************************************************************************************/
        	
        	$module_list = array(); //알림모듈을 담을 배열        	
        	//권한이 있는 XE 모듈 리스트        	
        	if($args->module_srls != ""){
        		$output = executeQueryArray('gigancenter.getModuleAdminByModuleSrls', $args);
        		if($output->data){
        			$xeModule_list = $output->data;
        		}
        		
        	}
        	
        	
         	if($gigancenterModule_list){//Gigancenter 모듈 리스트
         		foreach($gigancenterModule_list as $key=>$val){
					array_push($module_list, $val);
				}         		
         	}

         	if($xeModule_list){ //XE 모듈 리스트
         		foreach($xeModule_list as $key=>$val){
         			array_push($module_list, $val);
         		}
         	}
         	
         	/*********************************************************************************************
         	 회원이 등록한 알림 목록
         	**********************************************************************************************/
         	
        	$output = executeQueryArray('gigancenter.getUserNotificationList', $args);
        	
        	if($output->data){
        		$userNotification_list = $output->data;
        	}
        	      
        	$moduleSrls = array();
        	foreach ($userNotification_list as $key => $val) {
        		foreach ($val as $key2 => $val2) {        			
        			if($key2 == "target_module_srl") $module_srl = $val2;
        			if($key2 == "allow_notification") $allow = $val2;        			
        			if($module_srl !="" && $allow !=""){
        				$moduleSrls[] = array($module_srl => $allow);
        				$module_srl ="";
        				$allow="";
        			} 
        		}
        	}
        	
         	/*********************************************************************************************
         	 수신가능한 모듈과 수신중인 모듈 정보 정리
         	**********************************************************************************************/
        	foreach ($module_list as $key => $val) {
        		foreach ($val as $key2 => $val2) {        					 
        			if($key2 == "module") $module = $val2;
        			
        			//브라우저 타이틀 다국어 처리
        			if($key2 == "browser_title"){
        				
        				if(substr($val2,0,12)=='$user_lang->') {
        					$argsLang->name = str_replace('$user_lang->', '', $val2);
        					$argsLang->lang_code = 'ko';        					
        					$output = executeQueryArray('gigancenter.getLang', $argsLang);
        					$browser_title = $output->data[0]->value;
        					
        				}else{
        					$browser_title = $val2;
        				}
        			}
        			
        			if($key2 == "module_srl"){
        				$module_srl = $val2;
        				// 수신 상태 죄회, 대입
        				$isReg = false;
        				foreach ($moduleSrls as $mKey => $mVal) 
        				{
        					foreach ($mVal as $mKey2 => $mVal2) 
        					{
        						if($val2 == $mKey2 ){        							
        							$allow = $mVal2;
        							$isReg = true;
        						}        					
        					}
        				}
        				if($isReg == false){
        					//등록하지 않은 모듈이라면 N
        					$allow = "N";
        				}
        			}        
        		}        		        		
        		$userNotifications[] = array($module_srl,$module,$browser_title,$allow);
        	}
        	
        	
        	/*********************************************************************************************
        	 정리된 알림 목록을 XML로 생성한다.
        	**********************************************************************************************/
        	foreach($userNotifications as $key => $val)
        	{
        		$result = $result."<module_info>";
        		$result = $result."<module_srl><![CDATA[".$val[0]."]]></module_srl>";
        		$result = $result."<module><![CDATA[".$val[1]."]]></module>";        		
        		$result = $result."<browser_title><![CDATA[".$val[2]."]]></browser_title>";
        		$result = $result."<allow><![CDATA[".$val[3]."]]></allow>";
        		$result = $result."</module_info>";
        	}
        	       	
         	$result = "<?xml version=\"1.0\" encoding=\"utf-8\"?><response><error>0</error><message>success</message></response><modules>".$result."</modules>";
        	
        	return $result;
        	
        }
        
        
        /**
         * 관리권한이 있는 알림목록(모듈)을 구함.
         * @param $obj
         * gigancenter 1.0.1 이상 (XE API 적용)
         */
        function getGigancenterMemberNotificationList($obj){

           debugprint("getGigancenterMemberNotificationList");

        	$args->member_srl = $obj->member_srl;
        	 
        	//알림 목록을 담을 배열
        	$userNotifications = array();
        	 
        	/*********************************************************************************************
        	 * part:1
        	관리자 권한이 있는 모듈과 알림 권한을 받은 목록을 구한다. ( modules_srl 만 구함 )
        	**********************************************************************************************/
        	 // TODO 환경 설정을 사용하는 방향 고려
        	$args->allow_modules = "'board','member'";

        	//권한이 있는 모듈을 구함
        	$output = executeQueryArray('gigancenter.getModuleSrlsByModuleAdmin', $args);
        debugprint($output);
        	if ($output->data) $moduleAdmin_list = $output->data;
        
        	//알림 수신중인 모듈을 구함
        	$output = executeQueryArray('gigancenter.getModuleSrlsByGigancenterAllow', $args);
debugprint($output);
        	if($output->data){
        		$moduleUser_list = $output->data;
        	}
        	 
        	// 모듈 권한리스트, 수신리스트 병합 후 유니크 모듈 리스트 생성
        	$moduleSrls = array();
        	if($moduleAdmin_list){
        		foreach ($moduleAdmin_list as $key => $val) {
        			foreach ($val as $key2 => $val2) {
        				array_push($moduleSrls, $val2);
        			}
        		}
        	}
        	 
        	if($moduleUser_list){
        		foreach ($moduleUser_list as $key => $val) {
        			foreach ($val as $key2 => $val2) {
        				array_push($moduleSrls, $val2);
        			}
        		}
        	}
        	 
        	//유니크 모듈 시리얼
        	$uModuleSrls = array_unique($moduleSrls);
        	$args->module_srls = implode(",",$uModuleSrls);
        	 
        	/*********************************************************************************************
        	 * part:2
        	권한이 있는 Gigancenter 모듈 ( 쪽지 알림, 댓글알림 )  을 구한다. (권한이 있는 모듈과 병합)
        	모듈번호 : 쪽지[1], 댓글알림[2] 새글모두[3], 댓글모두[4], 회원가입[5]
        	새글모두, 댓글모두, 회원가입 알림은 관리자 직접 권한 추가
        	**********************************************************************************************/
        	 
        	//환경설정 참조
        	$oModuleModel = &getModel('module');
        	$config = $oModuleModel->getModuleConfig('gigancenter');
debugprint("환경설정");
debugprint($config);
/*
            stdClass Object
            (
                [site_name] => 
    [use_notification] => Y
    [use_message] => Y
    [use_document] =>
    [use_comment] => Y
    [use_documentall] => Y
    [use_commentall] => Y
    [use_member_signup] => Y
    [gcm_api_key] => apkkey
    [google_project_id] => 767488232487
    [android_return_url] => http://www.userpin.org/gcm.html
)
*/
        	// 기본 알림서비스(모든회원대상)
        	$gigancenterModule_list = new stdClass;
        	 
        	if($config->use_message == 'Y')
        	{
        		$gigancenterModule_list->message->module_srl = "1";
        		$gigancenterModule_list->message->module = "message";
        		$gigancenterModule_list->message->browser_title = "쪽지 알림";
        	}
        	if($config->use_comment == 'Y')
        	{
        		$gigancenterModule_list->comment->module_srl = "2";
        		$gigancenterModule_list->comment->module = "comment";
        		$gigancenterModule_list->comment->browser_title = "댓글 알림";
        	}
        		
        	//알림수신 목록에 새글 모두 알림, 댓글 모두 알림이 있다면 추가 ( 환경설정에서 지정해야함 )
        	if(in_array("3", $uModuleSrls))
        	{
        		$gigancenterModule_list->documentall->module_srl = "3";
        		$gigancenterModule_list->documentall->module = "documentall";
        		$gigancenterModule_list->documentall->browser_title = "새글 모두알림";
        	}
        	if(in_array("4", $uModuleSrls))
        	{
        		$gigancenterModule_list->commentall->module_srl = "4";
        		$gigancenterModule_list->commentall->module = "commentall";
        		$gigancenterModule_list->commentall->browser_title = "댓글 모두알림";
        	}
        	if(in_array("5", $uModuleSrls))
        	{
        		$gigancenterModule_list->member_signup->module_srl = "5";
        		$gigancenterModule_list->member_signup->module = "member_signup";
        		$gigancenterModule_list->member_signup->browser_title = "회원가입 알림";
        	}        	
        
        	/*********************************************************************************************
        	 유니크 모듈 리스트로 모듈정보와 알림수신 상태 리스트 생성
        	part:1 에서 구해둔 $args->module_srls 사용
        	**********************************************************************************************/
        	 
        	$module_list = array(); //알림모듈을 담을 배열
        	//권한이 있는 XE 모듈 리스트
        	if($args->module_srls != ""){
        		$output = executeQueryArray('gigancenter.getModuleAdminByModuleSrls', $args);
        		if($output->data){
        			$xeModule_list = $output->data;
        		}
        
        	}
        	 
        	 
        	if($gigancenterModule_list){//Gigancenter 도듈
        		foreach($gigancenterModule_list as $key=>$val){
        			array_push($module_list, $val);
        		}
        	}
        
        	if($xeModule_list){ //XE 모듈
        		foreach($xeModule_list as $key=>$val){
        			array_push($module_list, $val);
        		}
        	}
        
        	/*********************************************************************************************
        	 회원이 등록한 알림 목록
        	**********************************************************************************************/
        
        	$output = executeQueryArray('gigancenter.getUserNotificationList', $args);
        	 
        	if($output->data){
        		$userNotification_list = $output->data;
        	}
        	 
        	$moduleSrls = array();
        	foreach ($userNotification_list as $key => $val) {
        		foreach ($val as $key2 => $val2) {
        			if($key2 == "target_module_srl") $module_srl = $val2;
        			if($key2 == "allow_notification") $allow = $val2;
        			if($module_srl !="" && $allow !=""){
        				$moduleSrls[] = array($module_srl => $allow);
        				$module_srl ="";
        				$allow="";
        			}
        		}
        	}
        	 
        	/*********************************************************************************************
        	 수신가능한 모듈과 수신중인 모듈 정보 정리
        	**********************************************************************************************/
        	foreach ($module_list as $key => $val) {
        		foreach ($val as $key2 => $val2) {
        			if($key2 == "module") $module = $val2;
        			 
        			//브라우저 타이틀 다국어 처리
        			if($key2 == "browser_title"){
        
        				if(substr($val2,0,12)=='$user_lang->') {
        					$argsLang->name = str_replace('$user_lang->', '', $val2);
        					$argsLang->lang_code = 'ko';
        					$output = executeQueryArray('gigancenter.getLang', $argsLang);
        					$browser_title = $output->data[0]->value;
        					 
        				}else{
        					$browser_title = $val2;
        				}
        			}
        			 
        			if($key2 == "module_srl"){
        				$module_srl = $val2;
        				// 수신 상태 죄회, 대입
        				$isReg = false;
        				foreach ($moduleSrls as $mKey => $mVal)
        				{
        					foreach ($mVal as $mKey2 => $mVal2)
        					{
        						if($val2 == $mKey2 ){
        							$allow = $mVal2;
        							$isReg = true;
        						}
        					}
        				}
        				if($isReg == false){
        					//등록하지 않은 모듈이라면 N
        					$allow = "N";
        				}
        			}
        		}
        		$userNotifications[] = array($module_srl,$module,$browser_title,$allow);
        	}        	         	 
        	 
        	return $userNotifications;
        	 
        }
        
        
   }
?>