<?php
/* Copyright (C) NAVER <http://www.navercorp.com> */
require_once(_XE_PATH_.'modules/gigancenter/gigancenter.view.php');
class gigancenterMobile extends gigancenterView
{
	/**
	 * Support method are 
	 * dispGigancenterInfo, dispGigancenterSignUpForm, dispGigancenterFindAccount, dispGigancenterGetTempPassword, dispGigancenterModifyInfo, dispGigancenterModifyInfoBefore
	 */
	var $gigancenterInfo;

	function init()
	{
		// Get the gigancenter configuration
//		$oGigancenterModel = getModel('gigancenter');

        $oGigancenterAdminModel = &getAdminModel('gigancenter');
        $this->config = $oGigancenterAdminModel->getConfig();
        Context::set('config',$this->config);


		$oSecurity = new Security();
		$oSecurity->encodeHTML('gigancenter_config.signupForm..');


		$mskin = $this->gigancenter_config->mskin;
		// Set the template path
		if(!$mskin)
		{
			$mskin = 'default';
			$template_path = sprintf('%sm.skins/%s', $this->module_path, $mskin);
		}
		else
		{
			$template_path = sprintf('%sm.skins/%s', $this->module_path, $mskin);
		}

		// if gigancenter_srl exists, set gigancenterInfo
		$gigancenter_srl = Context::get('gigancenter_srl');
		if($gigancenter_srl)
		{
			$oGigancenterModel = getModel('gigancenter');
			$this->gigancenterInfo = $oGigancenterModel->getGigancenterInfoByGigancenterSrl($gigancenter_srl);
			if(!$this->gigancenterInfo)
			{
				Context::set('gigancenter_srl','');
			}
			else
			{
				Context::set('gigancenter_info',$this->gigancenterInfo);
			}
		}

		$this->setTemplatePath($template_path);

		$oLayoutModel = getModel('layout');
		$layout_info = $oLayoutModel->getLayout($this->gigancenter_config->mlayout_srl);
		if($layout_info)
		{
			$this->module_info->mlayout_srl = $this->gigancenter_config->mlayout_srl;
			$this->setLayoutPath($layout_info->path);
		}
	}

	function dispGigancenterModifyInfo()
	{
		parent::dispGigancenterModifyInfo();

		if($this->gigancenter_info)
		{
			Context::set('oGigancenterInfo', get_object_vars($this->gigancenter_info));
		}
	}
}
/* End of file gigancenter.mobile.php */
/* Location: ./modules/gigancenter/gigancenter.mobile.php */
