<?php
    /**
     * @class  gigancenterController
     * @author 그냥재미로
     * @brief  gigancenter 모듈의 controller class
     **/

	/**
	 * android GCM
	 * registration_ids [1~1000] 까지가능
	 */	
    class gigancenterController extends gigancenter {
    	/**
    	 * @brief Initialization
    	 **/
    	function init() {    		
    	}


        /**
         * @brief 알림 서비스 대상 등록, 수정
         * target Table : gigancenter_notification
         **/
        function procGigancenterInsertDevice()
        {
            debugprint("procGigancenterInsertDevice");


            // 로그인하지 않았다면 에러
            if(!Context::get('is_logged')) return new Object(-1, 'msg_not_permitted');

            $args = Context::getRequestVars();

            // 회원정보 처리
            $logged_info = Context::get("logged_info");

            $args->member_srl = $logged_info->member_srl;
            $args->user_id = $logged_info->user_id;
            $args->user_name = $logged_info->user_name;
            $args->nick_name = $logged_info->nick_name;

            // 디바이스정보 처리
            $deviceInfoArray = explode("@", $args->device_info);
            foreach ($deviceInfoArray as $key => $value) {
                switch ($key) {
                    case 0: $args->brand = $value;
                        break;
                    case 1: $args->model = $value;
                        break;
                    case 2: $args->os_ver = $value;
                        break;
                }
            }

            debugprint($args);

            $oGigancenterModel = &getModel("gigancenter");


//            if(!$output->data->index_module_srl) {
//                $args->mid = 'board';
//                $args->module = 'board';
//                $args->browser_title = 'XpressEngine';
//                $args->skin = 'default';
//                $args->site_srl = 0;
//                $output = $oModuleController->insertModule($args);
//                if($output->toBool())
//                {
//                    $module_srl = $output->get('module_srl');
//                    $site_args->site_srl = 0;
//                    $site_args->index_module_srl = $module_srl;
//                    $oModuleController = &getController('module');
//                    $oModuleController->updateSite($site_args);
//                }
//            }
            // 알림(모듈)등록 확인
            debugprint("디바이스 등록확인");
            $output = executeQuery('gigancenter.getDeviceInfoByMemberSrl', $args);

            debugprint($output);

            debugprint("output->data->member_srl : ".$output->data->member_srl);

            $args->list_order = -1 * $args->member_srl;
            if($output->data->member_srl){ //업데이트
                debugprint("디바이스 정보 업데이트");
                $output = $oGigancenterModel->upatetDeviceInfo($args);
                debugprint($output);
            }else{ // 인서트
                debugprint("디바이스 정보 인서트");
                $output = $oGigancenterModel->insertDeviceInfo($args);
                debugprint($output);
            }



            //TODO 디바이스 등록처리...
            /*
            $logged_info = Context::get("logged_info");
            if( !$logged_info ) return new Object(-1, 'msg_not_permitted');


            debugprint($args);



            $oGigancenterController = &getController("gigancenter");
            $controller = $oGigancenterController->_dispGigancenterRegisterDeviceAPI($args);
*/

//            // args 추출
//            $args = Context::gets('allow_srl', 'target_module', 'module','member_srl','user_id','user_name','nick_name','platform','os_ver','device_id','allow_notification');
//
//            $expArray = explode("," , $args->target_module);
//            $args->target_module_srl = $expArray[0];
//            $args->browser_title = $expArray[1];
//
//            if($args->allow_srl){ //업데이트
//                $output = executeQuery('gigancenter.updateNotification', $args);
//                if (!$output->toBool()) return $output;
//
//            }else{//인서트
//                $args->allow_srl = getNextSequence();
//                $output = executeQuery('gigancenter.insertNotification', $args);
//                if (!$output->toBool()) return $output;
//            }
//
//            if (!$output->toBool())
//            {
//                return $output;
//            }
//
            $redirectUrl = getNotEncodedUrl('', 'module', '', 'act', 'dispGigancenterRegisterDeviceInfo');
            $this->setRedirectUrl($redirectUrl);

        }

        /**
         * @brief 알림 수신 등록 or 해제
         * @return Object
         */
        function procGigancenterInsertAllow(){

            debugprint("procGigancenterInsertAllow");
            $args = Context::getRequestVars();
            debugprint($args);

            // 로그인하지 않았다면 에러
            if(!Context::get('is_logged')) return new Object(-1, 'msg_not_permitted');


            // 회원정보 처리
            $logged_info = Context::get("logged_info");

            //TODO module_count 만큼 루프롤 돌면서 처리한다.

            $oGigancenterModel = &getModel("gigancenter");

            $module_count =  $args->module_count;

            $nArgs->member_srl = $logged_info->member_srl;
            for ($i = 0; $i < $module_count; $i++) {


//                debugprint("module_srl".$i." : ".$args->module_srl.$i);
//                debugprint("module_name".$i." : ".$args->module_name.$i);
//                debugprint("allow".$i." : ".$args->allow.''.$i);

                $nArgs->target_module_srl = Context::get('target_module_srl'.$i);
                $nArgs->module = Context::get('module'.$i);
                $nArgs->browser_title = Context::get('browser_title'.$i);
                $nArgs->allow_notification = Context::get('allow_notification'.$i);


                $oGigancenterModel->insertGigancenterAllow($nArgs);




            }
/*
(
    [_filter] => insert_notification_allow
    [error_return_url] => /index.php?act=dispGigancenterNotificationConfigure
    [act] => procGigancenterInsertAllow
    [mid] => smalltalk
    [module_count] => 8
    [module_srl0] => 1
    [module_name0] => message
    [allow0] => N
    [module_srl1] => 2
    [module_name1] => comment
    [allow1] => N
    [module_srl2] => 3
    [module_name2] => documentall
    [allow2] => N
    [module_srl3] => 4
    [module_name3] => commentall
    [allow3] => N
    [module_srl4] => 5
    [module_name4] => member_signup
    [allow4] => N
    [module_srl5] => 112
    [module_name5] => board
    [allow5] => N
    [module_srl6] => 193
    [module_name6] => board
    [allow6] => N
    [module_srl7] => 207
    [module_name7] => board
    [allow7] => N
    [module] => gigancenter
 */

            // 로그인하지 않았다면 에러
            if(!Context::get('is_logged')) return new Object(-1, 'msg_not_permitted');


            // 회원정보 처리
            $logged_info = Context::get("logged_info");

            if(Context::get('success_return_url'))
            {
                $redirectUrl = Context::get('success_return_url');
            }
            else
            {
                $redirectUrl = getNotEncodedUrl('', 'mid', Context::get('mid'), 'act', 'dispGigancenterNotificationConfigure');
            }
            $this->setRedirectUrl($redirectUrl);
        }

        /**
    	 * @brief 알림 수신 디바이스 등록. (api) 
    	 * 앱에서 구글 GCM 아이디 등록. [미사용]
    	 **/
		function _dispGigancenterRegisterDeviceAPI($args) {	
			$args->controller = "_dispGigancenterRegisterDeviceAPI";
            return $args;
        }


        /** API
         * @brief 수신가능한 알림목록 반환. (api)
         * 수신가능한 알림목록 반환. [미사용]
         **/
        function _dispGigancenterMemberNotficationListAPI()
        {        	
			$args->controller = "_dispGigancenterMemberNotficationListAPI";
            return $args;
        }
                
        
    	/**
    	 * @brief trigger for document insertion.
    	 * @param $obj : document object.
    	 * 새글 알림 수신자에게 알림 전송
    	 **/    	 
    	function triggerInsertDocument(&$obj)
    	{
		debugprint("triggerInsertDocument -> execute");
    		$notificationMember = null;
    		$notificationAdmin = null;
    		
    		//환경설정 참조
    		$oGigancenterAdminModel = &getAdminModel('gigancenter');
    		$config = $oGigancenterAdminModel->getConfig();    		
    		
    		// 알림 서비스 사용하지 않는다면, module_srl 없다면 return
    		if($config->use_notification == "N" || $config->use_documentall == "N" || !$obj->module_srl  ) return;
    					
			// 모듈정보 조회
			$args->module_srl = $obj->module_srl;
			$output = executeQuery('module.getMidInfo', $args);

			// 모듈정보가 없다면 return
			if (!$output->toBool() || !$output->data) return;
			$module_info = $output->data;
			
			// 모듈 브라우저 타이틀 다국어처리						
			if(substr($module_info->browser_title,0,12)=='$user_lang->') {
				// 한글만 처리함
				$argsLang->name = str_replace('$user_lang->', '', $module_info->browser_title);
				$argsLang->lang_code = 'ko';				 
				$output = executeQueryArray('gigancenter.getLang', $argsLang);
				$browser_title = $output->data[0]->value;				 
				$module_info->browser_title = $output->data[0]->value;
			}else{
				$browser_title = $module_info->browser_title;
			}

            if($module_info->module == 'board'){
                $browser_title =  $browser_title.' 게시판';
            }else if($module_info->module == 'page'){
                $browser_title = $browser_title.' 페이지';
            }
			
			// 새글알림, 새글알림 3번
			$args->module_srls = ("3,".$args->module_srl );
			
			// 모듈 알림을 수신하는 사용자 목록
			$output = executeQuery('gigancenter.getUserNotificationListByModuleSrl', $args);
debugprint($output);
			// 알림수신자가 없다면 return
			if (!$output->toBool() || !$output->data) return;
			
			if($output->data) $notificationAdmin = $output->data;									
			$notificationSenderDeviceList = $this->mergeNotificationSender($notificationAdmin, $notificationMember);
								
			//알림전송 데이터 정리
			$notificationSenderAndroid->site_name = $config->site_name;
			$notificationSenderAndroid->gcm_api_key = $config->gcm_api_key;
			$notificationSenderAndroid->device_id = $notificationSenderDeviceList;
//			$notificationSenderAndroid->type = "document";
//			$notificationSenderAndroid->title = strip_tags($obj->title);
//			$notificationSenderAndroid->content = $obj->content;
//			$notificationSenderAndroid->nick_name = $obj->nick_name;
//			$notificationSenderAndroid->browser_title = $browser_title;

            $notificationSenderAndroid->title = "새글 알림";
            $notificationSenderAndroid->content = sprintf('%s님이 %s에 새글을 등록했습니다.', $obj->nick_name, $browser_title);

			$notificationSenderAndroid->url = getFullUrl('','document_srl', $obj->document_srl);
		debugprint("triggerInsertDocument -> return");						
			// 알림전송
			$this->sendMessageAndroidByCurl($notificationSenderAndroid);			
    	}
    	
    	
    	
    	/**
    	 * @brief trigger for comment insertion.
    	 * @param $obj : SendMessage object.
    	 * 원글, 상위 댓글 작성자에게 댓글 알림 전송
    	 **/
    	function triggerInsertComment(&$obj)
    	{
            debugprint("triggerInsertComment == 시작");
    		$notificationMember = null;
    		$notificationAdmin = null;
    		
    		//환경설정 참조    		
    		$oGigancenterAdminModel = &getAdminModel('gigancenter');
    		$config = $oGigancenterAdminModel->getConfig();    		
    		
    		// 알림 서비스 사용하지 않는다면, module_srl 없다면 return
    		if($config->use_notification == "N" || ($config->use_comment == "N" &&  $config->use_commentall == "N")  || !$obj->module_srl  ) return;    		    		

			// 모듈정보 조회
			$args->module_srl = $obj->module_srl;
			$output = executeQuery('module.getMidInfo', $args);
			
			// 모듈정보가 없다면 return
			if (!$output->toBool() || !$output->data) return;
			$module_info = $output->data;
				
			//모듈 브라우저 타이틀 다국어처리
			if(substr($module_info->browser_title,0,12)=='$user_lang->') {
				// 한글만 처리함
				$argsLang->name = str_replace('$user_lang->', '', $module_info->browser_title);
				$argsLang->lang_code = 'ko';
				$output = executeQueryArray('gigancenter.getLang', $argsLang);
				$browser_title = $output->data[0]->value;
				$module_info->browser_title = $output->data[0]->value;
			}else{
				$browser_title = $module_info->browser_title;
			}

            if($module_info->module == 'board'){
                $browser_title =  $browser_title.' 게시판';
            }else if($module_info->module == 'page'){
                $browser_title = $browser_title.' 페이지';
            }

            debugprint("triggerInsertComment == 11");
            debugprint($config);
			// 댓글알림
			if($config->use_comment == "Y"){
                debugprint("triggerInsertComment == 댓글 작성자");

				// 댓글알림 처리 parent_srl 여부에 따라 처리함.
				if($obj->parent_srl)
				{
                    debugprint("parent_srl");
					$args->parent_srl = $obj->parent_srl;
					$output = executeQuery('gigancenter.getMemberSrlByParentSrl', $args);
                    debugprint($output);

					// 오류 or 댓글정보가 없다면 return
					if (!$output->toBool() || !$output->data) return;

                    debugprint("triggerInsertComment == 22");

					//상위 댓글 작성회원 댓글알림 수신여부 확인 ( 댓글알림 2번 ) # 문서와 댓글 작성자가 같다면 패쓰.
					if($obj->member_srl != $output->data->member_srl)
					{
						$args->module_srls = ("2");
						$args->member_srl = $output->data->member_srl;
                        debugprint("triggerInsertComment : 댓글알림 수신 ");
						$output = executeQuery('gigancenter.getAllowNotificationCommentInfoByMemberSrl', $args);
                        debugprint($output);

						if($output->data) $notificationMember = $output->data;
					}				
					
				}
				else
				{
                    debugprint("triggerInsertComment == 문서 작성자");
					//문서 작성자 정보 조회
					$args->document_srl = $obj->document_srl;
					$output = executeQuery('gigancenter.getMemberSrlByDocumentSrl', $args);

                    debugprint($output);

					// 오류 or 문서정보가 없다면 return
					if (!$output->toBool() || !$output->data) return;
					
					//문서 작성회원 댓글알림 수신여부 확인 ( 댓글알림 2번 ) # 문서와 댓글 작성자가 같다면 패쓰.				
					if($obj->member_srl != $output->data->member_srl)
					{
                        debugprint("triggerInsertComment == 문서 작성자 22");
						$args->module_srls = ("2");
						$args->member_srl = $output->data->member_srl;				
						$output = executeQuery('gigancenter.getAllowNotificationCommentInfoByMemberSrl', $args);
                        debugprint($output);

						if($output->data) $notificationMember = $output->data;
					}
									
	    		}
			}
			
    		// 댓글 모두알림
    		if($config->use_commentall == "Y")
    		{
                debugprint("triggerInsertComment == 댓글 모두 알림 22");
                //TODO 디바이스 ID를 가져와야한다.
	    		// 댓글모두 알림을 수신하는 관리자 ( 댓글 모두알림 4번 )
	    		$args->module_srls = ("4" );
	    		$output = executeQuery('gigancenter.getUserNotificationListByModuleSrl', $args);
               debugprint($output);

	    		if($output->data) $notificationAdmin = $output->data;	    		   		    		
    		}
    		
    		
    		// 알림수신자가 없다면 return
    		if ($notificationMember == null &&  $notificationAdmin == null) return;
    		 
    		// 알림 수신자 목록 정리
    		// 회원만
    		if($notificationMember != null &&  $notificationAdmin == null)
    		{
    			$notificationSenderDeviceList = array($notificationMember->device_id);
    		}
    		// 회원, 관리자 or 관리자
    		else if( ($notificationMember != null &&  $notificationAdmin != null) || ($notificationMember == null &&  $notificationAdmin != null) )
    		{
    			$notificationSenderDeviceList = $this->mergeNotificationSender($notificationAdmin, $notificationMember);
    		}
    		
    		// 알림전송 데이터 정리
    		$notificationSenderAndroid->site_name = $config->site_name;
    		$notificationSenderAndroid->gcm_api_key = $config->gcm_api_key; 
    		$notificationSenderAndroid->device_id = $notificationSenderDeviceList;
//    		$notificationSenderAndroid->type = "comment";
//
//    		//TODO 타이틀 길이를 잘라서 보냄
//    		$notificationSenderAndroid->title = strip_tags($obj->content); //content, html 테그 제거 후 title 에 적용
//    		$notificationSenderAndroid->content = $obj->content;
//    		$notificationSenderAndroid->nick_name = $obj->nick_name;
//    		$notificationSenderAndroid->browser_title = $browser_title;

            $notificationSenderAndroid->title = "댓글 알림";
            $notificationSenderAndroid->content = sprintf('%s님이 %s에 댓글을 등록했습니다.', $obj->nick_name, $browser_title);
    		$notificationSenderAndroid->url = getFullUrl('','document_srl', $obj->document_srl);
            $notificationSenderAndroid->url = $notificationSenderAndroid->url.'#comment_'.$obj->comment_srl;
            $notificationSenderAndroid->url = str_replace('&amp;', '&', $notificationSenderAndroid->url);


    		// 알림전송
    		$this->sendMessageAndroidByCurl($notificationSenderAndroid);
    	
    	}
    	
    	/**
    	 * @brief trigger for member insertion.
    	 * @param $obj : member object.
    	 * 회원가입 알림 수신자에게 알림 전송
    	 **/
    	function triggerInsertMember(&$obj)
    	{
            debugprint("triggerInsertMember");
    		//환경설정 참조
    		$oGigancenterAdminModel = &getAdminModel('gigancenter');
    		$config = $oGigancenterAdminModel->getConfig();
    		
    		// 알림 서비스 사용하지 않는다면 return
    		if($config->use_notification == "N" || $config->use_member_signup == "N") return;


    		// 회원가입알림 수신확인 [회원가입 target_module_srl = 5 ]    	
    		$args->module_srls = ("5");
    		$output = executeQuery('gigancenter.getUserNotificationListByModuleSrl', $args);
            debugprint($output);
    		if($output->data) $notificationMember = $output->data;
    		    		
    		// 알림수신자가 없다면 return
    		if ($notificationMember == null) return;    		
    		
    		// 알림 수신자 목록 정리
    		$notificationAdmin = null;
   			$notificationSenderDeviceList = $this->mergeNotificationSender($notificationAdmin, $notificationMember);
   				
   			//알림전송 데이터 정리
   			$notificationSenderAndroid->site_name = $config->site_name;
   			$notificationSenderAndroid->gcm_api_key = $config->gcm_api_key;   			
   			$notificationSenderAndroid->device_id = $notificationSenderDeviceList;
   			$notificationSenderAndroid->title = "회원가입 알림";
            $notificationSenderAndroid->content = sprintf('%s님이 %s 사이트에 회원가입 했습니다.', $obj->nick_name, $config->site_name);
   			$notificationSenderAndroid->url = getFullUrl('','');
   			$this->sendMessageAndroidByCurl($notificationSenderAndroid);
            //$str = sprintf('%s님이 회원님의 %s에 "%s" 댓글을 남겼습니다.', $target_nick_name, $type, $v->target_summary);
    	}
    	
    	/**
    	 * @brief trigger for Communication SendMessage.
    	 * @param $obj : SendMessage object.
    	 * 쪽지 수신자에게 알림 전송
    	 **/
    	function triggerCommunicationSendMessage($receiver_args)
    	{
            debugprint("쪽지알림");
    		//환경설정 참조
    		$oGigancenterAdminModel = &getAdminModel('gigancenter');
    		$config = $oGigancenterAdminModel->getConfig();

    		// 알림 서비스 사용하지 않는다면 return
    		if($config->use_notification == "N" || $config->use_message == "N") return;
    		    	    	
    		//쪽지알림 수신확인 [쪽지 target_module_srl = 1 ]
    		$receiver_args->target_module_srl = '1';
    		$output = executeQuery('gigancenter.getUserNotificationMessageByReceiverSrl', $receiver_args);

            debugprint($output);

			// 오류 or 알림정보가 없다면 return
			if (!$output->toBool() || !$output->data) return;
    	
    		// 쪽지 알림을 수신중이라면
    		if($output->data->allow_notification == 'Y')
    		{
    			//sender_srl 로 닉네임 조회
    			$args->member_srl = $receiver_args->sender_srl;
    			$outputNickname = executeQuery('gigancenter.getMemberNicknameByMemberSrl', $args);

                // 닉네임이 있을 때
                if($outputNickname->data->nick_name != ''){
                    $nickName = $outputNickname->data->nick_name.' 님에게';
                }else{
                    $nickName =  $config->site_name.' 사이트 에서';
                }
    			//알림전송 데이터 정리
    			$notificationSenderAndroid->site_name = $config->site_name;
    			$notificationSenderAndroid->gcm_api_key = $config->gcm_api_key;
    			$notificationSenderAndroid->device_id = array($output->data->device_id);
                $notificationSenderAndroid->title = "쪽지 알림";
                $notificationSenderAndroid->content = sprintf('%s 쪽지를 받았습니다.',$nickName);
    			$notificationSenderAndroid->url = getFullUrl('','act','dispCommunicationMessages','message_srl',$receiver_args->message_srl);
    			$notificationSenderAndroid->url = str_replace('&amp;', '&', $notificationSenderAndroid->url);
    			$this->sendMessageAndroidByCurl($notificationSenderAndroid);
    		}
    	
    	}
    	
    	
    	/**
    	 * @brief notification sender device id check and merge.
    	 * @param $notificationAdmin : admin.
    	 * @param $notificationMember : member.
    	 * @result $device_id : array().
    	 * 알림 수진자 중복 체크 및 병합
    	 **/
    	function mergeNotificationSender($notificationAdmin, $notificationMember)
    	{    	    		    		
    		$device_id = array();
    		
    		//관리자
    		if( $notificationAdmin != null )
    		{
    			if(count($notificationAdmin) == 1)
    			{
    				foreach ($notificationAdmin as $key => $value)
    				{    						
    					if($key == "device_id" && $value != "" )
    					{
    						if (!in_array($value, $device_id))
    						{
    							array_push($device_id, $value);
    						}
    					}
    				}
    			}
    			else if(count($notificationAdmin) > 1)
    			{
    				foreach ($notificationAdmin as $key => $value)
    				{    			
    					if($value->device_id !=""){
    						if (!in_array($value, $device_id))
    						{
    							array_push($device_id, $value->device_id);
    						}
    					}
    				}
    			}    			
    		}
    		
    		// 회원
    		if( $notificationMember != null )    		
    		{    			
    			if(count($notificationMember) == 1)
    			{
    				foreach ($notificationMember as $key => $value)
    				{    					
    					if($key == "device_id" && $value != "" )
    					{
    						if (!in_array($value, $device_id))
    						{
    							array_push($device_id, $value);
    						}
    					}    				
    				}
    			}
    			else if(count($notificationMember) > 1)
    			{    				    				
    				foreach ($notificationMember as $key => $value)
    				{    				    				
    					if($value->device_id !=""){
    						if (!in_array($value, $device_id))
    						{
    							array_push($device_id, $value->device_id);
    						}
    					}
    				}
    			} 
    			 
    		}
    		return $device_id;    	    	
    	}

    	
    	/** 
    	 * @brief Google GCM Sender
    	 * @param $args : notification data object.
    	 * 구글 GCM으로 알림전송.
    	 **/
    	function sendMessageAndroidByCurl($args) {
		debugprint("sendMessageAndroidByCurl -> execute" );
		debugprint(function_exists('curl_init'));
    		$auth = $args->gcm_api_key;
		debugprint($auth);    		    		
    		$data = array(
				'registration_ids' => $args->device_id,
				'data' => array('site_name' => $args->site_name, 'title'=>$args->title, 'content'=>$args->content, 'url'=>$args->url)
    		);
		debugprint($data);
    		$headers = array(
    				"Content-Type:application/json",
    				"Authorization:key=".$auth
    		);
		debugprint($headers);

			if(is_callable('curl_init')){

				$ch = curl_init();
				curl_setopt($ch, CURLOPT_URL, "https://android.googleapis.com/gcm/send");
				curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
				curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
				curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
				curl_setopt($ch, CURLOPT_POST, true);
				curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode2($data));
				$result = curl_exec($ch);
				curl_close($ch);

				//TODO 알림 메시지 전송결과를 업데이트 해준다. (성공, 실패, 보낸 횟수, 마지막 보낸시간)
				debugprint($data);
				debugprint("GCM Sender Result ======================================= start");
				debugprint($result);
				debugprint("GCM Sender Result ======================================= end");
			}else{
				debugprint("Curl init failed");
			}

    		
    	}
    	    	
    	
    }
?>