<?php
    /**
     * @class  gigancenterAdminController
     * @author 그냥재미로
     * @brief  gigancenter 모듈의 admin controller class
     **/

    class gigancenterAdminController extends gigancenter {

        /**
         * @brief 
         * role : 초기화
         **/
        function init() 
        {
        	
        }

        /**
         * @brief 알림 서비스 대상 등록, 수정
         * target Table : gigancenter_allow
         **/
        function procGigancenterAdminInsert()
        {    
        	debugprint("procGigancenterAdminInsert");



        	// args 추출
        	$args = Context::gets('allow_srl', 'target_module', 'module','member_srl','allow_notification');

            debugprint($args);
//            stdClass Object
//        (
//            [allow_srl] => 178
//    [target_module] => 104,테스트게시판
//    [module] => gigancenter
//    [member_srl] => 107
//    [allow_notification] => Y
//)

        	$expArray = explode("," , $args->target_module);        	 
        	$args->target_module_srl = $expArray[0];
        	$args->browser_title = $expArray[1];
        	
        	if($args->allow_srl){ //업데이트		
        		$output = executeQuery('gigancenter.updateGigancenterAllow', $args);
                debugprint($output);
        		if (!$output->toBool()) return $output;
        		
        	}else{//인서트
        		$args->allow_srl = getNextSequence();
        		$output = executeQuery('gigancenter.insertGigancenterAllow', $args);
                debugprint($output);
        		if (!$output->toBool()) return $output;
        	}
        	
        	if (!$output->toBool())
        	{
        		return $output;
        	}
        	        	
        	$redirectUrl = getNotEncodedUrl('', 'module', 'admin', 'act', 'dispGigancenterAdminIndex');
        	$this->setRedirectUrl($redirectUrl);
 
        }
                
        
        /**
         * @brief
         * target Table : gigancenter_allow
         **/
        function procGigancenterAdminDelete()
        {

        	$allow_srl = Context::get('allow_srl');        	        	
        	if (!$allow_srl) return new Object(-1, 'msg_invalid_request');
        	        
        	if ($allow_srl)
        	{
        		$args->allow_srl = $allow_srl;
        		executeQuery('gigancenter.deleteGigancenterByGigancenterSrl', $args);
        	}        	
        	
        	if(version_compare(__ZBXE_VERSION__, '1.5.0', '>='))
        	{
        		$redirectUrl = getNotEncodedUrl('', 'module', 'admin', 'act', 'dispGigancenterAdminIndex');
        		$this->setRedirectUrl($redirectUrl);        		
        	}
        	else
        	{
	        	$this->add('module','gigancenter');
	        	$this->add('page',Context::get('page'));
	        	$this->setMessage('success_deleted');
        	}

        }
        
        
        /**
         * @brief
         * target Table : module_config
         **/        
        function procGigancenterAdminInsertConfig()
        {
        	
	        $oModuleController = &getController('module');

	        //args 추출
	        $args->site_name = Context::get('site_name');
	        $args->use_notification = Context::get('use_notification');
	        $args->use_message = Context::get('use_message');
	        $args->use_document = Context::get('use_document');
	        $args->use_comment = Context::get('use_comment');
	        $args->use_documentall = Context::get('use_documentall');
	        $args->use_commentall = Context::get('use_commentall');
	        $args->use_member_signup = Context::get('use_member_signup');

            $args->google_project_id = Context::get('google_project_id');
            $args->gcm_api_key = Context::get('gcm_api_key');
            $args->android_return_url = Context::get('android_return_url');


            $output = $oModuleController->updateModuleConfig('gigancenter', $args);

            // default setting end
            $this->setMessage('success_updated');

            $returnUrl = Context::get('success_return_url') ? Context::get('success_return_url') : getNotEncodedUrl('', 'module', 'admin', 'act', 'dispGigancenterAdminConfig');
            $this->setRedirectUrl($returnUrl);
        }
        

	}
?>