<?php
    /**
     * @class xelayout_weather
     * @author xelayout.com
     * @brief 날씨표시위젯
     * @version 0.1
     **/

    class xelayout_weather extends WidgetHandler {

        /**
         * @brief 위젯의 실행 부분
         *
         * ./widgets/위젯/conf/info.xml 에 선언한 extra_vars를 args로 받는다
         * 결과를 만든후 print가 아니라 return 해주어야 한다
         **/
        function proc($args) {
            // 제목
            $title = $args->title;
			$city = (int)$args->city;
			$user_city = (int)$args->user_city;
            
			// 출력될 날짜 수
            $list_count = (int)$args->list_count;
            if(!$list_count) $list_count = 1;

            // 템플릿 파일에서 사용할 변수들을 세팅
            $widget_info->title = $title;
			$widget_info->list_count = $list_count;
			$widget_info->city = $city;
			$widget_info->user_city = $user_city;

            Context::set('widget_info', $widget_info);

            // 템플릿의 스킨 경로를 지정 (skin, colorset에 따른 값을 설정)
            $tpl_path = sprintf('%sskins/%s', $this->widget_path, $args->skin);
            Context::set('colorset', $args->colorset);

            // 템플릿 파일을 지정
            $tpl_file = 'xelayout_weather';

            // 템플릿 컴파일
            $oTemplate = &TemplateHandler::getInstance();
            return $oTemplate->compile($tpl_path, $tpl_file);
        }
    }
?>
