// Copyright (C) 2014 Seather

$ = jQuery.noConflict();
var baseURL = "http://lab.syaningv.com/seather/";

if (!window.Seather)
	window.Seather = {};

Seather.forecast = function(param) {
	if (!param.cityID)
		return;
	$.ajax({
		type : 'GET',
		url : baseURL + 'forecast.jsp',
		data : {
			cityID : param.cityID
		},
		dataType : 'jsonp',
		jsonp : 'callback',
		jsonpCallback : 'forecastHandler',
		success : function(data) {
			showForecast(data, param);
		}
	});
};

function showForecast(data, param) {
	if (!param.color)
		param.color = 'white';
	if (!param.size)
		param.size = 'small';
	if (!param.days)
		param.days = 5;
	var $seather = $(param.position);
	
	
	var $forecasts = $('<ul class="forecast"></ul>');


	var d = new Date();
	var week = new Array('SUN', 'MON', 'TUE', 'WED', 'THU', 'FRI', 'SAT');

	param.days = (param.days <= 0 || param.days > 5) ? 5 : param.days;
	for ( var i = 0; i < param.days; i++) {
		var item = data.forecasts[i];
		var $img = $('<img class="ww_icon" />').attr('src',
				baseURL + 'img/' + item.code + '.png').attr('alt', item.text);

		var $ww_day = $('<span class="ww_day"></span>').text(week[d.getDay()+i]);	
		var $ww_city = $('<span class="ww_city"></span>').text(data.city);	
		
		var $city = $('<div class="city"></div>').append($ww_day).append($ww_city).append($img);	
		//도시
		var $weather = $('<div class="weather"></div>').append($city);
		
		$('.city').append("<span class='ww_icon'>" +data.city + "</span>");

		
		var $temp = $('<div class="temp"></div>').append(
				parseInt(item.low) + '<span class="ww_c"> ℃</span>'+ ' ~ ' + parseInt(item.high) + '<span class="ww_c"> ℃</span>');
		var $date = $('<div class="date"></div>').append('<span class="ww_date" >' + item.date + '</span>');
		
		var $li = $('<li></li>').append($weather).append($temp).append($date);
		$forecasts.append($li);
	}
	$seather.append($forecasts);
	$seather.addClass('seather').addClass('seather-'+param.color).addClass('seather-'+param.size).addClass('seather-'+param.size+'-'+param.days);
}

