<?php
/**
 * @author 백성찬 <baikstar@paran.com>
 * @brief 내가 읽은 최근 문서 애드온
 **/

if(!defined('__XE__')) exit();

function getMyReading($matches) {
	$document_srl = $matches[1];
	if (!$document_srl or !is_numeric($document_srl)) return $matches[0];

	$document_list = getDocumentListWithinMyReading($document_srl);
	if(!$document_list) return $matches[0];

	$output_html .= '<fieldset class="my_reading">';

	Context::loadLang('./addons/my_reading/lang');

	if($GLOBALS['_my_reading_addon_info_']->title == 'Y') {
		$logged_info = Context::get('logged_info');
		$output_html .= '<div class="title">'.$logged_info->nick_name.''.Context::getLang('my_reading_title').'</div>';
	}

	$output_html .= '<ul>';

	foreach($document_list as $document) {
		$win_open = null;
		$output_html .= '<li>';

		// 링크 타겟
		if($GLOBALS['_my_reading_addon_info_']->link_target == 'new') {
			$win_open = ' onclick="window.open(this.href);return false;"';
		}
		$output_html .= '<a href="'.$document->getPermanentUrl().'"'.$win_open.'> * '.$document->getTitleText().'</a> ';

		// 작성자
		if($GLOBALS['_my_reading_addon_info_']->print_author != 'N') {
			$output_html .= '<span class="my_reading_author"> - '.$document->getNickName().'</span> ';
		}

		$output_html .= '</li>';
	}
	$output_html .= '</ul></fieldset>';

	return $matches[0].$output_html;
}

function getDocumentListWithinMyReading($document_srl) {
	$oModuleModel = &getModel('module');
	$documentModel = &getModel('document');
	$document = $documentModel->getDocument($document_srl);
	$logged_info = Context::get('logged_info');
	$member_srl = $logged_info->member_srl;

	if($logged_info->member_srl) {
		$args->member_srl = $logged_info->member_srl;
		$args->document_srl = $document_srl;

		$output = executeQuery('document.insertDocumentReadedLog', $args);

		$regdate = date('Ymd');
		$log_expire_days = is_numeric($GLOBALS['_my_reading_addon_info_']->log_expire_days) ? $GLOBALS['_my_reading_addon_info_']->log_expire_days : 7;
		$args->regdate = date('YmdHis', strtotime("-".$log_expire_days." day"));
		$output = executeQuery('addons.my_reading.deleteExpiredLogs', $args);
	}

	if(!$member_srl) return;

	$args->document_srl = $document_srl;
	$args->member_srl = $logged_info->member_srl;
	$output = executeQueryArray('addons.my_reading.getMyReading', $args);
	if(!$output->data) return;

	$document_srl = array();
	foreach($output->data as $key) {
		++$document_srl[$key->document_srl];
	}

	$documents = array();
	$count = 0;
	$list_count = is_numeric($GLOBALS['_my_reading_addon_info_']->list_count) ? $GLOBALS['_my_reading_addon_info_']->list_count : 10;

	foreach($document_srl as $key => $val) {
		if($key == $document_srl) continue;
		$count++;
		if($count > $list_count) break;

		$documents[] = $documentModel->getDocument($key);
	}

	return $documents;
}
?>
