<?php
    /**
     * @class  gdataModel
     * @author karma(soonj@nate.com)
     * @brief  gdata 연동 모듈의 Model class
     **/

class gdataModel extends gdata {
        /**
         * @brief 초기화
         **/
	function init() {
		$clientLibraryPath = realpath('./modules/gdata');
        $oldPath = set_include_path(get_include_path() . PATH_SEPARATOR . $clientLibraryPath);
        require_once 'Zend/Loader.php';
        Zend_Loader::loadClass('Zend_Gdata');
        Zend_Loader::loadClass('Zend_Gdata_ClientLogin');
        Zend_Loader::loadClass('Zend_Gdata_AuthSub');
        Zend_Loader::loadClass('Zend_Gdata_Photos');
        Zend_Loader::loadClass('Zend_Gdata_Photos_UserQuery');
        Zend_Loader::loadClass('Zend_Gdata_Photos_AlbumQuery');
        Zend_Loader::loadClass('Zend_Gdata_Photos_PhotoQuery');
        Zend_Loader::loadClass('Zend_Gdata_App_Extension_Category');

    }

	function getClient(){
		$oModuleModel = &getModel('module');
        $config = $oModuleModel->getModuleConfig('gdata');

        $svc = Zend_Gdata_Photos::AUTH_SERVICE_NAME;
        $user = $config->user;
        $pass = $config->pass;
		if(!$user || !$pass) return new Object(-1, 'msg_module_not_configured');
		 @set_time_limit(10);
		try {   
			$client = Zend_Gdata_ClientLogin::getHttpClient($user, $pass, $svc);
		} catch (Zend_Gdata_App_AuthException $e) {   
			return new Object(-1,'LoginFailed');
		} catch (Zend_Gdata_App_HttpException $e) {
			return new Object(-1,'NetworkError');
		}
		return $client;
	}	

	function deleteThumbnail($album, $photoid) {
        $thumbnail_file = sprintf('files/cache/thumbnails/gdata/%s/%s.jpg',$album,$photoid);
//        $tmp_file = sprintf('./files/cache/tmp/gdata/%d', $photoid);
//        @unlink($tmp_file);
        @unlink($thumbnail_file);
        $thumbnail_url = 'files/cache/thumbnails/gdata/nophoto.jpg';
       return $thumbnail_url;
	}

	function getThumbnail($source_file, $album, $photoid,$width = 96) {

        if(!$source_file) return false;

        $height = $width;
        $thumbnail_type = 'crop';

        $thumbnail_file = sprintf('files/cache/thumbnails/gdata/%s/%s.jpg',$album,$photoid);
        $thumbnail_url  = Context::getRequestUri().$thumbnail_file;

        if(file_exists($thumbnail_file)) {
			list($w,$h) =@getimagesize($thumbnail_file);
            if(filesize($thumbnail_file)<1) return $source_file;
            elseif($w == $width) return $thumbnail_url;
			else unlink($thumbnail_file);
        }

		if(!preg_match('/^(http|https):\/\//i',$source_file)) $source_file = Context::getRequestUri().$source_file;
            $tmp_file = sprintf('./files/cache/tmp/gdata/%d', $photoid);
            if(!is_dir('./files/cache/tmp/gdata')) FileHandler::makeDir('./files/cache/tmp/gdata');
			$this->delOldFiles('./files/cache/tmp/gdata');

            FileHandler::getRemoteFile($source_file, $tmp_file);
            if(!file_exists($tmp_file)) return $source_file;
        else {
           	list($_w, $_h, $_t, $_a) = @getimagesize($tmp_file);
            if($_w<$width && $_h<$height) return $source_file;

            $source_file = $tmp_file;
          	$is_tmp_file = true;
		}

        $output = FileHandler::createImageFile($source_file, $thumbnail_file, $width, $height, 'jpg', $thumbnail_type);
		if($is_tmp_file) @unlink($tmp_file);
	
        // 썸네일 생성 성공시 경로 return
        if($output) return $thumbnail_url;

        return;
    }
	

	function addPhoto($client, $user, $albumId,$title,$photo,$summary='',$tag='') {
        $photos = new Zend_Gdata_Photos($client);
		$filename = FileHandler::getRealPath($photo);

		$fd = $photos->newMediaFileSource($filename);
		$fd->setContentType("image/jpeg");

		// Create a PhotoEntry
		$photoEntry = $photos->newPhotoEntry();

		$photoEntry->setMediaSource($fd);	
		if($title) $photoEntry->setTitle($photos->newTitle($title));
		$photoEntry->setSummary($photos->newSummary($summary));

		// add some tags
		$keywords = new Zend_Gdata_Media_Extension_MediaKeywords();
		$keywords->setText($tag);
		$photoEntry->mediaGroup = new Zend_Gdata_Media_Extension_MediaGroup();
		$photoEntry->mediaGroup->keywords = $keywords;

		// We use the AlbumQuery class to generate the URL for the album
		$albumQuery = $photos->newAlbumQuery();

		$albumQuery->setUser($user);
		$albumQuery->setAlbumId($albumId);

		$cache_file = sprintf("./files/cache/gdata/%s.*.cache.php", $albumId);
		foreach (glob($cache_file) as $filename) {
           unlink($filename);
        }

// We insert the photo, and the server returns the entry representing
		// that photo after it is uploaded
		$result = $photos->insertPhotoEntry($photoEntry, $albumQuery->getQueryUrl()); 
        $content = $result->mediaGroup->content;
        $temp=$content[0];
        $output->url =$temp->url;
        $output->width =$temp->width;
        $output->height=$temp->height;
        return $output;
    }

	function deletePhoto($client, $user, $albumId, $photoId) {
        $photos = new Zend_Gdata_Photos($client);

        $photoQuery = new Zend_Gdata_Photos_PhotoQuery;
        $photoQuery->setUser($user);
        $photoQuery->setAlbumId($albumId);
        $photoQuery->setPhotoId($photoId);
        $photoQuery->setType('entry');

        $entry = $photos->getPhotoEntry($photoQuery);

        $photos->deletePhotoEntry($entry, true);
		$cache_file = sprintf("./files/cache/gdata/%s.*.cache.php", $albumId);
        foreach (glob($cache_file) as $filename) {
           unlink($filename);
        }

    }

    function deleteComment($client, $user, $albumId, $photoId, $commentId) {
        $photos = new Zend_Gdata_Photos($client);

        $photoQuery = new Zend_Gdata_Photos_PhotoQuery;
        $photoQuery->setUser($user);
        $photoQuery->setAlbumId($albumId);
        $photoQuery->setPhotoId($photoId);
        $photoQuery->setType('entry');

        $path = $photoQuery->getQueryUrl() . '/commentid/' . $commentId;

        $entry = $photos->getCommentEntry($path);

        $photos->deleteCommentEntry($entry, true);
    }

	function getRecentPhoto($client,$user,$limit) {
		if(!$limit) $limit=10;
//		$photos = new Zend_Gdata_Photos($client);

		try {
        	$photos = new Zend_Gdata_Photos($client);
        } catch (Zend_Gdata_App_HttpException $e) {
            return $this->dispGdataMessage('msg_module_not_configured');
        } catch (Zend_Gdata_App_Exception $e) {
            return $this->dispGdataMessage('msg_module_not_configured');
        }

		$query = $photos->newUserQuery();
		$query->setUser($user);
		$query->setKind("photo");
		$query->setMaxResults($limit);

    	$userFeed = $photos->getUserFeed(null,$query);

    	foreach ($userFeed as $photoEntry) {
			$data=null;
			$data->photoid = $photoEntry->gphotoId->text;
			$data->album = $photoEntry->gphotoAlbumId->text;
			$timestamp= $photoEntry->gphotoTimestamp->text;
			$data->timestamp=gmstrftime("%Y-%m-%d %H:%M:%S",substr($timestamp,0,-3));

			$data->commentcount = $photoEntry->gphotoCommentCount->text;
			$media = $photoEntry->getMediaGroup();
			$data->title = $media->title->text;
			$data->summary = $media->description->text;
			$thumb = $photoEntry->getMediaGroup()->getThumbnail();
            $data->thumb = $thumb[2]->getUrl();
            $data->thumb_url = $this->getThumbnail($data->thumb, $data->album,$data->photoid,100);

			$output[]=$data;
    	}
		return $output;
	}

    function addAlbum($client, $user, $name,$public) {
        $photos = new Zend_Gdata_Photos($client);

        $entry = new Zend_Gdata_Photos_AlbumEntry();
		$entry->setGphotoAccess($photos->newAccess($public));
        $entry->setTitle($photos->newTitle($name));

        $result = $photos->insertAlbumEntry($entry);
		$cache_file = "./files/cache/gdata/gdata.*.cache.php";
        foreach (glob($cache_file) as $filename) {
           unlink($filename);
        }

    }

	function modifyAlbum($client, $user, $albumId,$name,$public) {
        $photos = new Zend_Gdata_Photos($client);

		$albumQuery = new Zend_Gdata_Photos_AlbumQuery;
        $albumQuery->setUser($user);
        $albumQuery->setAlbumId($albumId);
        $albumQuery->setType('entry');

		$entry = $photos->getAlbumEntry($albumQuery);

        $entry->setGphotoAccess($photos->newAccess($public));
        $entry->setTitle($photos->newTitle($name));
		$result = $entry->save();
		$cache_file = "./files/cache/gdata/gdata.*.cache.php";
        foreach (glob($cache_file) as $filename) {
           unlink($filename);
        }
		return $result;
    }

	function makePublicAlbum($client, $user, $albumId) {
        $photos = new Zend_Gdata_Photos($client);

        $albumQuery = new Zend_Gdata_Photos_AlbumQuery;
        $albumQuery->setUser($user);
        $albumQuery->setAlbumId($albumId);
        $albumQuery->setType('entry');

        $entry = $photos->getAlbumEntry($albumQuery);

        $entry->setGphotoAccess($photos->newAccess('public'));
        $result = $entry->save();
		$cache_file = "./files/cache/gdata/gdata.*.cache.php";
        foreach (glob($cache_file) as $filename) {
           unlink($filename);
        }
		return $result;
    }

    function deleteAlbum($client, $user, $albumId)  {
        $photos = new Zend_Gdata_Photos($client);

        $albumQuery = new Zend_Gdata_Photos_AlbumQuery;
        $albumQuery->setUser($user);
        $albumQuery->setAlbumId($albumId);
        $albumQuery->setType('entry');

        $entry = $photos->getAlbumEntry($albumQuery);
		$cache_file = "./files/cache/gdata/gdata.*.cache.php";
        foreach (glob($cache_file) as $filename) {
           unlink($filename);
        }
        return $photos->deleteAlbumEntry($entry, true);
    }

	function addComment($client, $user, $album, $photo, $comment) {
        $photos = new Zend_Gdata_Photos($client);

        $entry = new Zend_Gdata_Photos_CommentEntry();
        $entry->setContent($photos->newContent($comment));

        $photoQuery = new Zend_Gdata_Photos_PhotoQuery;
        $photoQuery->setAlbumId($album);
        $photoQuery->setPhotoId($photo);
        $photoQuery->setType('entry');

        $photoEntry = $photos->getPhotoEntry($photoQuery);
        $result = $photos->insertCommentEntry($entry, $photoEntry);

        return $result;
    }

	function addTag($client, $user, $album, $photo, $tag) {
		$photos = new Zend_Gdata_Photos($client);

        $entry = new Zend_Gdata_Photos_TagEntry();
        $entry->setTitle($photos->newTitle($tag));
        if($summary) $entry->setSummary($photos->newSummary($summary));

        $photoQuery = new Zend_Gdata_Photos_PhotoQuery;
        $photoQuery->setUser($user);
        $photoQuery->setAlbumId($album);
        $photoQuery->setPhotoId($photo);
        $photoQuery->setType('entry');

        $photoEntry = $photos->getPhotoEntry($photoQuery);

        $result = $photos->insertTagEntry($entry, $photoEntry);
		return $result;
	}

	function deleteTag($client, $user, $albumId, $photoId, $tagContent) {
	    $photos = new Zend_Gdata_Photos($client);

    	$photoQuery = new Zend_Gdata_Photos_PhotoQuery;
	    $photoQuery->setUser($user);
    	$photoQuery->setAlbumId($albumId);
	    $photoQuery->setPhotoId($photoId);
    	$query = $photoQuery->getQueryUrl() . "?kind=tag";

	    $photoFeed = $photos->getPhotoFeed($query);

    	foreach ($photoFeed as $entry) {
        	if ($entry instanceof Zend_Gdata_Photos_TagEntry) {
            	if ($entry->getContent() == $tagContent) {
                	$tagEntry = $entry;
		        }
    		}
	    }
    	$photos->deleteTagEntry($tagEntry, true);
	}

	function modifyPhoto($client, $user, $albumId,$photoId, $title, $tag, $summary){
		Zend_Loader::loadClass('Zend_Gdata_Media_Extension_MediaKeywords');
		Zend_Loader::loadClass('Zend_Gdata_Geo_Extension_GeoRssWhere');
		Zend_Loader::loadClass('Zend_Gdata_Geo_Extension_GmlPos');
		Zend_Loader::loadClass('Zend_Gdata_Geo_Extension_GmlPoint');

	 	$photos = new Zend_Gdata_Photos($client);

		$photoQuery = new Zend_Gdata_Photos_PhotoQuery;
        $photoQuery->setUser($user);
        $photoQuery->setAlbumId($albumId);
        $photoQuery->setPhotoId($photoId);
        $photoQuery->setType('entry');

		$insertedEntry = $photos->getPhotoEntry($photoQuery);

		$insertedEntry->title->text = $title;
		$insertedEntry->summary->text = $summary;

		$keywords = new Zend_Gdata_Media_Extension_MediaKeywords();
		$keywords->setText($tag);
		$insertedEntry->mediaGroup->keywords = $keywords;
    
		$where = new Zend_Gdata_Geo_Extension_GeoRssWhere();
		$position = new Zend_Gdata_Geo_Extension_GmlPos('37.0 -122.0');
		$where->point = new Zend_Gdata_Geo_Extension_GmlPoint($position);
		$insertedEntry->setGeoRssWhere($where); 

		$updatedEntry = $insertedEntry->save();
		$cache_file = sprintf("./files/cache/gdata/%s.*.cache.php", $albumId);
        foreach (glob($cache_file) as $filename) {
           unlink($filename);
        }
	}

	function getUserFeed($userFeed,$module_srl) {
		if(!count($userFeed)) return false;
		$gdata->nickname = $userFeed->getGphotoNickname();
		$gdata->title = $userFeed->getTitle();
		$gdata->total_count = $userFeed->key();
		$extension = $userFeed->extensionElements;
		$quotalimit=intval($extension[0]->text);
		$quotacurrent = intval($extension[1]->text);
		if($quotalimit && $quotacurrent) $gdata->quotaused = number_format(($quotacurrent/$quotalimit) * 100,2);
		$gdata->quotalimit = $this->getMega($quotalimit);
		$gdata->quotacurrent = $this->getMega($quotacurrent);
		foreach ($userFeed as $key=>$entry) {
                if ($entry instanceof Zend_Gdata_Photos_AlbumEntry) {
                    $data->albumid = $entry->getGphotoId()->getText();
                    $data->numphotos =  $entry->getGphotoNumPhotos()->getText();
                    $thumb = $entry->getMediaGroup()->getThumbnail();
                    $data->thumb = $thumb[0]->getUrl();
                    $data->albumtitle = $entry->getTitle();
                    $access = $entry->getGphotoAccess();
                    if($access=='public') $data->access=1;
                    else $data->access=0;
                    $tempdata[] = $data;
                    unset($data);
                }
			$gdata->entry = $tempdata;
        }
		return $gdata;
	}

	function getAlbumFeed($albumFeed) {
		$album = $albumFeed->getGphotoId()->getText();
		if(!count($albumFeed)) return false;
		$access = $albumFeed->getGphotoAccess();
		if($access=='public') $gdata->access=1;
        else $gdata->access=0;

		foreach ($albumFeed as $key=>$entry) {
            if ($entry instanceof Zend_Gdata_Photos_PhotoEntry) {
				$data=null;
                $data->photoid=$entry->getGphotoId()->getText();
                $data->regdate =$this->makegmtime($entry->published);
                $data->commentcount = $entry->gphotoCommentCount;
                $thumb = $entry->getMediaGroup()->getThumbnail();
                $data->thumb_url = $thumb[2]->url;
                $data->thumbnail = $this->getThumbnail($data->thumb_url, $album,$data->photoid,100);
                $data->title = $entry->getTitle();
				$data->link_url = $albumFeed->getLink('alternate')->getHref();
                $output[]=$data;
            }
			$gdata->entry =$output;
        }
		return $gdata;
	}

	function getPhotoFeed($photoFeed,$album,$photoid) {
		$url =$photoFeed->getMediaGroup()->content;
        $args->url=$url[0]->url;
        $args->title=$photoFeed->getTitle();

        $regtime = $photoFeed->getGphotoTimestamp();
        $args->regdate = gmstrftime("%Y%m%d%H%I%S",substr($regtime,0,-3));
        $args->summary=trim($photoFeed->getMediaGroup()->getDescription());
        $thumbs = $photoFeed->getMediaGroup()->getThumbnail();
        $args->thumburl = $thumbs[2]->url;
        $args->thumburl=$thumbs[2]->url;
		$args->link_url =$photoFeed->getLink('alternate')->getHref(); 
		$access = $photoFeed->extensionElements[0];
		$viewcount = $photoFeed->extensionElements[3];
		$exif = $photoFeed->extensionElements[4];
		$where = $photoFeed->extensionElements[5];
		$args->access=$access->text;
		$args->viewcount = $viewcount->text;
		$args->where = $where->text;
        foreach ($photoFeed as $entry) {
			$data=null;
            if ($entry instanceof Zend_Gdata_Photos_CommentEntry) {
                $data->content =  $entry->getContent();
                $data->gphotoid =$entry->getGphotoId();
                $data->regdate = $this->makegmtime($entry->getPublished());
                $gdata[]=$data;
                unset($data);
            }
        }
		$args->gdata=$gdata;

        foreach ($photoFeed as $entry) {
			$data=null;
            if ($entry instanceof Zend_Gdata_Photos_TagEntry) {
                $data->title = $entry->getTitle();
                $data->content =  $entry->getContent();
                $tag[]=$data;
				$args->tags.=$data->title;
            }
        }
		$args->tag = $tag;
		return $args;
	}

	function getAlbumList() {
        $client = $this->getClient();

//        $photos = new Zend_Gdata_Photos($client);
		try {
            $photos = new Zend_Gdata_Photos($client);
        } catch (Zend_Gdata_App_HttpException $e) {
            return $this->dispGdataMessage('msg_module_not_configured');
        } catch (Zend_Gdata_App_Exception $e) {
            return $this->dispGdataMessage('msg_module_not_configured');
        }

        $query = new Zend_Gdata_Photos_UserQuery();
        $query->setUser('default');

        $userFeed = $photos->getUserFeed(null, $query);
		foreach ($userFeed as $entry) {
                if ($entry instanceof Zend_Gdata_Photos_AlbumEntry) {
					$access = $entry->getGphotoAccess();
					$access = $entry->getGphotoAccess();
                    if($access=='public') $data->access="공개";
                    else $data->access="비공개";
//					if($access=='public') $data->access=true;
//					else $data->access=false;
					$data->album = $entry->getGphotoId()->getText();
                    $data->albumtitle = $entry->getTitle()->getText();
					$tempdata[]=$data;
                    unset($data);
                }
        }
        return $tempdata;
    }

	function makegmtime($string,$format="YmdHis") {
		$temp = explode("T",$string);
		$date=explode("-",$temp[0]);
		$time = explode(":",$temp[1]);

        $datetime = gmmktime($time[0], $time[1], $time[2], $date[1], $date[2], $date[0]);
        return date($format,$datetime);
    }

	function dispGdataMessage($msg_code) {
        $msg = Context::getLang($msg_code);
        if(!$msg) $msg = $msg_code;
        Context::set('message', $msg);
        $this->setTemplateFile('message');
    }

	function delOldFiles($path,$duration=1) {
		$ltime = mktime(0,0,0,date(m),date(j)-1,date(Y));
		foreach (glob($path) as $file) { //configure path
		    $filetime=filectime($file);
			if($filetime <$ltime) unlink($file);
		} 
	}

	function getMega($value) {
		if($value==0) return 0;
		else return number_format($value/(1024*1024),1);
	}
}
?>
