<?php
/**
 * @class  gdata class
 * @author karma (http://www.wildgreen.co.kr)
 * @brief  gdata 모듈의 클래스
 **/

class gdata extends ModuleObject {

    /**
     * @brief 설치시 추가 작업이 필요할시 구현
     **/
    function moduleInstall() {
    }

    /**
     * @brief 설치가 이상이 없는지 체크하는 method
     **/
    function checkUpdate() {
		$oModuleModel = &getModel('module');

        //설정파일
        $gdata_config = $oModuleModel->getModuleConfig('gdata');
        $module_info = $oModuleModel->getModuleInfoXml('gdata');
        if(!$gdata_config->version || ($gdata_config->version<$module_info->version)) return true;
		return false;
    }

    /**
     * @brief 업데이트 실행
     **/
    function moduleUpdate() {
		$oModuleController = &getController('module');
        $oModuleModel = &getModel('module');
        $oldconfig = $oModuleModel->getModuleConfig('gdata');

        $module_info = $oModuleModel->getModuleInfoXml('gdata');
		$gdata_config=$oldconfig;
        $gdata_config->version = $module_info->version;
        $oModuleController->insertModuleConfig('gdata', $gdata_config);

		return new Object(0, 'success_updated');
    }

    /**
     * @brief 캐시 파일 재생성
     **/
    function recompileCache() {
    }
}
?>
