<?php
/**
 * @class  gdataAdminController
 * @author karma (http://www.wildgreen.co.kr)
 * @brief gdata 모듈의 admin controller 클래스
 **/

class gdataAdminController extends gdata {

	/**
	 * @brief 초기화
	 **/
	function init() {
		$clientLibraryPath = realpath('./modules/gdata');
		$oldPath = set_include_path(get_include_path() . PATH_SEPARATOR . $clientLibraryPath);
		require_once 'Zend/Loader.php';
		Zend_Loader::loadClass('Zend_Gdata_Photos');
		Zend_Loader::loadClass('Zend_Gdata_ClientLogin');
		Zend_Loader::loadClass('Zend_Gdata_AuthSub');
	}

    function procGdataAdminInsertModule($args = null) {
        $oModuleController = &getController('module');
        $oModuleModel = &getModel('module');

        $args = Context::getRequestVars();
        $args->module = 'gdata';
        $args->mid = $args->board_name;
        unset($args->board_name);

        if($args->module_srl) {
            $module_info = $oModuleModel->getModuleInfoByModuleSrl($args->module_srl);
            if($module_info->module_srl != $args->module_srl) unset($args->module_srl);
        }

        if(!$args->module_srl) {
            $output = $oModuleController->insertModule($args);
            $msg_code = 'success_registed';
        } else {
            $output = $oModuleController->updateModule($args);
            $msg_code = 'success_updated';
        }

        if(!$output->toBool()) return $output;
        $this->setMessage($msg_code);
    }

	function procGdataAdminInsertConfig() {
		$oModuleModel = &getModel('module');
        $gdata_config = $oModuleModel->getModuleConfig('gdata');
		$oModuleController = &getController('module');

		$gdata_config->user = Context::get('user');
		$gdata_config->pass = Context::get('pass'); 
		$gdata_config->mid = Context::get('mid');

		$serviceName = Zend_Gdata_Photos::AUTH_SERVICE_NAME;

		if($gdata_config->user && $gdata_config->pass) {
			@set_time_limit(10);
			try {
				$client = Zend_Gdata_ClientLogin::getHttpClient($gdata_config->user, $gdata_config->pass, $serviceName);
	        } catch (Zend_Gdata_App_AuthException $e) {
				return new Object(-1,'LoginFailed');
			} catch (Zend_Gdata_App_HttpException $e) {
                return new Object(-1,'serverFailed');
            } catch (Zend_Http_Client_Adapter_Exception $e) {
                return new Object(-1,'SSLError');
            }
		}
		$oModuleController->insertModuleConfig('gdata', $gdata_config);
		$this->setMessage('success_updated');	
	}

	function procGdataAdminDeleteModule() {
        $module_srl = Context::get('module_srl');

        $oModuleController = &getController('module');
        $output = $oModuleController->deleteModule($module_srl);
        if(!$output->toBool()) return $output;

        $this->add('module','gdata');
        $this->setMessage('success_deleted');
    }

}
?>
