<?php
    /**
     * @class  gdataView
     * @author karma(soonj@nate.com)
     * @brief  gdata 모듈의 View class
     **/
class gdataView extends gdata {

		var $MAX_FILE_SIZE = 20971520;
//		var $MAX_FILE_SIZE = '20971';

	function init() {
//		$clientLibraryPath = realpath('./modules/gdata');
		$clientLibraryPath = realpath($this->module_path);
        $oldPath = set_include_path(get_include_path() . PATH_SEPARATOR . $clientLibraryPath);
		require_once 'Zend/Loader.php';
        Zend_Loader::loadClass('Zend_Gdata');
        Zend_Loader::loadClass('Zend_Gdata_ClientLogin');
        Zend_Loader::loadClass('Zend_Gdata_AuthSub');
        Zend_Loader::loadClass('Zend_Gdata_Photos');
        Zend_Loader::loadClass('Zend_Gdata_Photos_UserQuery');
        Zend_Loader::loadClass('Zend_Gdata_Photos_AlbumQuery');
        Zend_Loader::loadClass('Zend_Gdata_Photos_PhotoQuery');
        Zend_Loader::loadClass('Zend_Gdata_App_Extension_Category');
	
		$template_path = sprintf("%sskins/%s/",$this->module_path, $this->module_info->skin);
        if(!is_dir($template_path)||!$this->module_info->skin) {
            $this->module_info->skin = 'xe_default';
            $template_path = sprintf("%sskins/%s/",$this->module_path, $this->module_info->skin);
        }
        $this->setTemplatePath($template_path);

		if($this->module_info->album_list_count) $this->album_list_count = $this->module_info->album_list_count;
		else $this->album_list_count =20;
        if($this->module_info->photo_list_count) $this->photo_list_count = $this->module_info->photo_list_count;
		else $this->photo_list_count =20;
        if($this->module_info->page_count) $this->page_count = $this->module_info->page_count;
		else $this->page_count =10;

		$oModuleModel = &getModel('module');
		$this->config = $oModuleModel->getModuleConfig('gdata');
	}

	function dispGdataList() {
		if(!$this->grant->access || !$this->grant->list) return $this->dispGdataMessage('msg_not_permitted');
		$config = $this->config;
		$thumbsize=$config->thumbsize;
		if(!$thumbsize) $thumbsize='144c';
		$oGdataModel = &getModel('gdata');
		$client = $oGdataModel->getClient();

		try {
		$photos = new Zend_Gdata_Photos($client);
		} catch (Zend_Gdata_App_HttpException $e) {
	        return $this->dispGdataMessage('msg_module_not_configured');
    	} catch (Zend_Gdata_App_Exception $e) {
        	return $this->dispGdataMessage('msg_module_not_configured');
	    }

		$apage = Context::get('apage');
        if(!$apage) $apage=1;
        $start= $this->album_list_count * ($apage-1)+1;

	    $query = new Zend_Gdata_Photos_UserQuery();
    	$query->setUser($config->user);
		$query->setStartIndex($start);
        $query->setMaxResults($this->album_list_count);
		$query->setThumbsize($thumbsize);

	    $userFeed = $photos->getUserFeed(null, $query);

		$total_count = $userFeed->getTotalResults()->getText();

		Context::set('userFeed',$userFeed);

		$gdata = $oGdataModel->getUserFeed($userFeed,$this->module_info->module_srl);

        $total_page = ceil($total_count/$this->album_list_count);
        $page_navigation = new PageHandler($total_count, $total_page, $apage, $this->page_count);

        Context::set('total_count', $total_count);
		Context::set('total_page',$total_page);
        Context::set('apage', $apage);
        Context::set('page_navigation', $page_navigation);
		Context::set('gdata',$gdata);

    	$this->setTemplateFile('albumlist');
	}


    function dispGdataListPhoto() {
		if(!$this->grant->access || !$this->grant->photolist) return $this->dispGdataMessage('msg_not_permitted');

        $album=Context::get('album');
        $photoid =Context::get('photoid');
		$config = $this->config;
        $oGdataModel = &getModel('gdata');
        $client = $oGdataModel->getClient();

		try {
        $photos = new Zend_Gdata_Photos($client);
        } catch (Zend_Gdata_App_HttpException $e) {
            return $this->dispGdataMessage('msg_module_not_configured');
        } catch (Zend_Gdata_App_Exception $e) {
            return $this->dispGdataMessage('msg_module_not_configured');
        }

		$page = Context::get('page');
        if(!$page) $page=1;
        $start= $this->photo_list_count * ($page-1) +1;

	    $query = new Zend_Gdata_Photos_AlbumQuery();
    	$query->setUser($user);
	    $query->setAlbumId($album);
		$query->setStartIndex($start);
		$query->setMaxResults($this->photo_list_count);

    	$albumFeed = $photos->getAlbumFeed($query);
		$total_count = $albumFeed->getGphotoNumPhotos()->getText();
		Context::set('total_count', $total_count);

		Context::set('albumFeed',$albumFeed);
        Context::set('title',$albumFeed->getTitle());
        Context::set('album',$album);
		$oGdataModel = &getModel('gdata');

		$gdata = $oGdataModel->getAlbumFeed($albumFeed);

		if(!$gdata->access && !$this->grant->manager) return $this->dispGdataMessage('msg_not_permitted');

		$total_page = ceil($total_count/$this->photo_list_count);
		$page_navigation = new PageHandler($total_count, $total_page, $page, $this->page_count);
        Context::set('total_page', $total_page);
        Context::set('page', $page);
        Context::set('page_navigation', $page_navigation);
		Context::set('gdata',$gdata);
		Context::addJsFilter($this->module_path.'tpl/filter', 'upload_photo.xml');
        $this->setTemplateFile('list');
    }

	function dispGdataDeleteAlbum() {
		$album=Context::get('album');
        $photoid =Context::get('photoid');
		$config = $this->config;
        $oGdataModel = &getModel('gdata');
        $client = $oGdataModel->getClient();

        $photos = new Zend_Gdata_Photos($client);

	    $query = new Zend_Gdata_Photos_AlbumQuery();
    	$query->setUser($user);
	    $query->setAlbumId($album);

	    $albumFeed = $photos->getAlbumFeed($query);

        Context::set('title',$albumFeed->getTitle());
        Context::set('album',$album);
		Context::addJsFilter($this->module_path.'tpl/filter', 'deletealbum.xml');
		$this->setTemplateFile('deletealbum');
	}

	function dispGdataViewPhoto() {
		if(!$this->grant->access || !$this->grant->view) return $this->dispGdataMessage('msg_not_permitted');
		$album=Context::get('album');
		$photoid =Context::get('photoid');
		$config = $this->config;
        @set_time_limit(10);
        $oGdataModel = &getModel('gdata');
        $client = $oGdataModel->getClient();

		try {
        $photos = new Zend_Gdata_Photos($client);
        } catch (Zend_Gdata_App_HttpException $e) {
            return $this->dispGdataMessage('msg_module_not_configured');
        } catch (Zend_Gdata_App_Exception $e) {
            return $this->dispGdataMessage('msg_module_not_configured');
        }

	    $query = new Zend_Gdata_Photos_PhotoQuery();
    	$query->setUser($user);
	    $query->setAlbumId($album);
    	$query->setPhotoId($photoid);
	    $query = $query->getQueryUrl() . "?kind=comment,tag";

    	$photoFeed = $photos->getPhotoFeed($query);

		$access = $photoFeed->extensionElements[0];
        $access=$access->text;
		if($access == 'private' && !$this->grant->manager) return $this->dispGdataMessage('msg_not_permitted');

		$obj=$oGdataModel->getPhotoFeed($photoFeed,$album,$photoid);
	
		Context::set('gdata_photo',$obj);
		Context::set('photoFeed',$photoFeed);
		Context::set('album',$album);
		Context::set('photoid',$photoid);

		Context::addJsFilter($this->module_path.'tpl/filter', 'modify.xml');
		Context::addJsFilter($this->module_path.'tpl/filter', 'addcomment.xml');

        $this->setTemplateFile('viewphoto');
	
	}


	function dispGdataModifyPhoto() {
        if(!$this->grant->manager) return $this->dispGdataMessage('msg_not_permitted');
        $album=Context::get('album');
        $photoid =Context::get('photoid');
        $config = $this->config;
        $oGdataModel = &getModel('gdata');
        $client = $oGdataModel->getClient();

        $photos = new Zend_Gdata_Photos($client);

        $query = new Zend_Gdata_Photos_PhotoQuery();
        $query->setUser($user);
        $query->setAlbumId($album);
        $query->setPhotoId($photoid);
        $query = $query->getQueryUrl() . "?kind=tag";

        $photoFeed = $photos->getPhotoFeed($query);
		$obj=$oGdataModel->getPhotoFeed($photoFeed,$album,$photoid);
		Context::set('gdata_photo',$obj);
        Context::set('album',$album);
        Context::set('photoid',$photoid);
        Context::set('summary',$photoFeed->getMediaGroup()->getDescription());

        Context::addJsFilter($this->module_path.'tpl/filter', 'modifyphoto.xml');

        $this->setTemplateFile('modify');
    }

    function dispGdataAddAlbum() {
		 if(!$this->grant->manager) return $this->dispGdataMessage('msg_not_permitted');
		$config = $this->config;
        $oGdataModel = &getModel('gdata');
        $client = $oGdataModel->getClient();

    	$photos = new Zend_Gdata_Photos($client);

	    $query = new Zend_Gdata_Photos_UserQuery();
    	$query->setUser($user);

    	$userFeed = $photos->getUserFeed(null, $query);
        Context::set('title',$userFeed->getTitle());

		Context::addJsFilter($this->module_path.'tpl/filter', 'addalbum.xml');
        $this->setTemplateFile('addalbum');
    }

	function dispGdataModifyAlbum() {
        $album=Context::get('album');
        $config = $this->config;
        $oGdataModel = &getModel('gdata');
        $client = $oGdataModel->getClient();

        $photos = new Zend_Gdata_Photos($client);

        $query = new Zend_Gdata_Photos_AlbumQuery();
        $query->setUser($user);
        $query->setAlbumId($album);

        $albumFeed = $photos->getAlbumFeed($query);

        Context::set('title',$albumFeed->getTitle());
        Context::set('album',$album);
		Context::set('access',$albumFeed->getGphotoAccess()->getText());
        Context::addJsFilter($this->module_path.'tpl/filter', 'modifyalbum.xml');
        $this->setTemplateFile('modifyalbum');
    }

	function dispGdataAddPhoto() {
		if(!$this->grant->access || !$this->grant->write_photo) return $this->dispGdataMessage('msg_not_permitted');

		$album =Context::get('album');
		$config = $this->config;
        $oGdataModel = &getModel('gdata');
        $client = $oGdataModel->getClient();
        Context::set('album',$album);
        $this->setTemplateFile('write_form');
    }

	function dispGdataDeletePhoto() {
		if(!$this->grant->manager) return $this->dispGdataMessage('msg_not_permitted');

        $album =Context::get('album');
		$photoid =Context::get('photoid');
		$mid= Context::get('mid');
		$config = $this->config;
        $oGdataModel = &getModel('gdata');
        $client = $oGdataModel->getClient();

        $photos = new Zend_Gdata_Photos($client);

		$query = new Zend_Gdata_Photos_PhotoQuery();
	    $query->setUser($user);
    	$query->setAlbumId($album);
	    $query->setPhotoId($photoid);
    	$query = $query->getQueryUrl() . "?kind=comment,tag";

    	$photoFeed = $photos->getPhotoFeed($query);
		$obj=$oGdataModel->getPhotoFeed($photoFeed,$album,$photoid);
        Context::set('gdata_photo',$obj);
        Context::set('album',$album);
        Context::set('photoid',$photoid);
		Context::set('mid',$mid);

		Context::addJsFilter($this->module_path.'tpl/filter', 'deletephoto.xml');
        $this->setTemplateFile('deletephoto');
    }
	    
	//여기부터
	function dispGdataPhotoShow(){
            $image = Context::get('photo');
            $album = Context::get('album');

            // check uploaded image
            if(!Context::isUploaded()&&is_uploaded_file($image['tmp_name'])) return new Object(-1,'msg_invalid_request');
			if(filesize($image['tmp_name']) > $this->MAX_FILE_SIZE) return new Object(-1,'msg_too_big_size');
            list($width, $height, $type, $attrs) = @getimagesize($image['tmp_name']);
            if($width<1 || $height<1) return new Object(-1,'msg_invalid_request');
            switch($type) {
                case '1' :
                        $type = '.gif';
                    break;
                case '2' :
                        $type = '.jpg';
                    break;
                case '3' :
                        $type = '.png';
                    break;
                default :
                    return new Object(-1,'msg_invalid_request');
                break;
            }

            $path = 'files/cache/tmp/gdata/';
            $filename =$path.md5(rand(111111,999999).$album).$type;
            $_SESSION['upload_info'][$album]->title = $image['name'];
            $_SESSION['upload_info'][$album]->upload_file = $filename;

            // delete uploaded file
            FileHandler::removeFile($filename);

            // move upload file
            if(!is_dir($path)) FileHandler::makeDir($path);
            move_uploaded_file($image['tmp_name'], $filename);

            Context::set('image_file', $filename);
            Context::set('image_width', $width);
            Context::set('image_height', $height);
            $this->_print();
        }

    function _print(){
        $tpl_path = $this->module_path . 'tpl';
        $tpl_file = 'show.html';
        $oTemplate = &TemplateHandler::getInstance();
        print $oTemplate->compile($tpl_path, $tpl_file);
        Context::close();
        exit();
    }

	function dispGdataMessage($msg_code) {
        $msg = Context::getLang($msg_code);
        if(!$msg) $msg = $msg_code;
        Context::set('message', $msg);
        $this->setTemplateFile('message');
    }



}
?>
