<?php
/**
 * @class  gdataController
 * @author karma (http://www.wildgreen.co.kr)
 * @brief gdata 모듈의 controller 클래스
 **/

class gdataController extends gdata {

    /**
     * @brief 초기화
     **/
    function init() {
        $clientLibraryPath = realpath('./modules/gdata');
        $oldPath = set_include_path(get_include_path() . PATH_SEPARATOR . $clientLibraryPath);
        require_once 'Zend/Loader.php';
		Zend_Loader::loadClass('Zend_Gdata');
        Zend_Loader::loadClass('Zend_Gdata_ClientLogin');
        Zend_Loader::loadClass('Zend_Gdata_AuthSub');
        Zend_Loader::loadClass('Zend_Gdata_Photos');
        Zend_Loader::loadClass('Zend_Gdata_Photos_UserQuery');
        Zend_Loader::loadClass('Zend_Gdata_Photos_AlbumQuery');
        Zend_Loader::loadClass('Zend_Gdata_Photos_PhotoQuery');
        Zend_Loader::loadClass('Zend_Gdata_App_Extension_Category');

		$oModuleModel = &getModel('module');
        $this->config = $oModuleModel->getModuleConfig('gdata');
	}

	function procGdataUpload() {
		$filename = Context::get('image');
		$album=Context::get('album');
		$title = $_SESSION['upload_info'][$album]->title;
        $mid=Context::get('mid');
		$tag = Context::get('tag');
		$page=Context::get('page');

		if(!$album) return;
		if(!$mid) return;
		$config = $this->config;
        @set_time_limit(30);
        $oGdataModel = &getModel('gdata');
        $client = $oGdataModel->getClient();

        $summary = Context::get('summary');

		$result = $oGdataModel->addPhoto($client, $config->user, $album, $title,$filename, $summary,$tag);
		@unlink($filename);
		$this->add('mid', Context::get('mid'));
        $this->add('page', $page);
        $this->add('album', $album);
        $this->add('act','dispGdataListPhoto');

	}

	function procGdataModify() {
        $album=Context::get('album');
        $mid=Context::get('mid');
        $tag = Context::get('tag');
        $page=Context::get('page');
		$title =Context::get('title');
		$photoid =Context::get('photoid');

        if(!$album) return;
        if(!$mid) return;
		if(!$photoid) return;

        $config = $this->config;
		$oGdataModel = &getModel('gdata');
        $client = $oGdataModel->getClient();

        $summary = Context::get('summary');

        $result = $oGdataModel->modifyPhoto($client, $config->user, $album, $photoid,$title, $tag, $summary);
		$this->add('mid', Context::get('mid'));
        $this->add('photoid', $photoid);
        $this->add('album', $album);
        $this->add('act','dispGdataViewPhoto');
    }



	function procGdataAddTag() {
        $album=Context::get('album');
        $mid=Context::get('mid');
        $tag = Context::get('tag');
		$photoid =Context::get('photoid');
		$tag = implode(" ",explode(",",$tag));

        if(!$album) return;
        if(!$mid) return;
		if(!$photoid) return;
        $config = $this->config;
        $oGdataModel = &getModel('gdata');
        $client = $oGdataModel->getClient();

        $result = $oGdataModel->addTag($client, $config->user, $album, $photoid, $tag);
    	$this->add('mid', Context::get('mid'));
        $this->add('photoid', $photoid);
        $this->add('album', $album);
        $this->add('act','dispGdataViewPhoto');
	}

	function procGdataAddAlbum(){
		$name = Context::get('albumname');
		$public = Context::get('public');
		if($public) $public='public';
		else $public='private';

		$config = $this->config;
        @set_time_limit(10);
        $oGdataModel = &getModel('gdata');
        $client = $oGdataModel->getClient();

		$oGdataModel->addAlbum($client, $config->user, $name,$public);
		$this->add('mid', Context::get('mid'));
		$this->add('act','dispGdataList');
		$this->setMessage('success_registed');

	}

	function procGdataModifyAlbum(){
        $name = Context::get('albumname');
		$album = Context::get('album');
        $public = Context::get('public');
        if($publici=='Y') $public='public';
        else $public='private';

        $config = $this->config;
        @set_time_limit(10);
        $oGdataModel = &getModel('gdata');
        $client = $oGdataModel->getClient();

        $oGdataModel->modifyAlbum($client, $config->user, $album,$name,$public);
        $this->add('mid', Context::get('mid'));
        $this->add('act','dispGdataList');
        $this->setMessage('success_registed');

    }

	function procGdataMakePublic(){
        $mid = Context::get('mid');
		$album = Context::get('album');
		if(!$album) return false;

        $config = $this->config;
        $oGdataModel = &getModel('gdata');

        $client = $oGdataModel->getClient();

        $result = $oGdataModel->makePublicAlbum($client, $config->user, $album);
		unset($album);
		$loca ="/?mid=".$mid."&act=dispGdataList";
        @header('Location: '.$loca);
    }

	function procGdataAddComment(){
        $album = Context::get('album');
		$photoid = Context::get('photoid');
		$comment = Context::get('nickname') ." - ".Context::get('comment');
		$config = $this->config;
        @set_time_limit(10);
        $oGdataModel = &getModel('gdata');
        $client = $oGdataModel->getClient();

        $result = $oGdataModel->addComment($client, $config->user, $album,$photoid,$comment);
		if($result) $msg_code= 'success_registed';
		else $msg_code='failed';
        $this->add('mid', Context::get('mid'));
		$this->add('photoid', $photoid);
		$this->add('album', $album);
        $this->add('act','dispGdataViewPhoto');
        $this->setMessage($msg_code);

    }

	function procGdataDeletePhoto(){
		$photoid=Context::get('photoid');
		$album=Context::get('album');
		$config = $this->config;
        @set_time_limit(10);
        $oGdataModel = &getModel('gdata');
        $client = $oGdataModel->getClient();

        $oGdataModel->deletePhoto($client, $config->user, $album, $photoid);
		$oGdataModel->deleteThumbnail($album,$photoid);
        $this->add('mid', Context::get('mid'));
        $this->add('album', $album);
		$this->add('page', Context::get('page'));
        $this->add('act','dispGdataListPhoto');
    }

	function procGdataDeleteAlbum(){
        $album=Context::get('album');
		$config = $this->config;
        @set_time_limit(10);
        $oGdataModel = &getModel('gdata');
        $client = $oGdataModel->getClient();

		$oGdataModel->deleteAlbum($client, $config->user, $album);
		$oGdataModel->deleteThumbnail($this->module_info->module_srl,$albumid);
        $this->add('mid', Context::get('mid'));
        $this->add('act','dispGdataList');
    }
	

	function procGdataDeleteComment() {
        $photoid=Context::get('photoid');
		$commentid=Context::get('comment');
        $album=Context::get('album');
		$mid = COntext::get('mid');

		$config = $this->config;
        @set_time_limit(10);
        $oGdataModel = &getModel('gdata');
        $client = $oGdataModel->getClient();

        $oGdataModel->deleteComment($client, $config->user, $album, $photoid, $commentid);
    	$loca ="/?mid=".$mid."&act=dispGdataViewPhoto&album=".$album."&photoid=".$photoid;
        @header('Location: '.$loca);
	}
	
	function procGdataDeleteTag() {
        $photoid=Context::get('photoid');
        $tag=Context::get('tag');
        $album=Context::get('album');
		$mid =Context::get('mid');
        $config = $this->config;

        $oGdataModel = &getModel('gdata');
        $client = $oGdataModel->getClient();

        $oGdataModel->deleteTag($client,$config->user,$album, $photoid, $tag);
        $loca ="/?mid=".$mid."&act=dispGdataViewPhoto&album=".$album."&photoid=".$photoid;
        @header('Location: '.$loca);
    }

}
