<?php
    /**
     * @class  gdagaAdminView
     * @author sol (sol@ngleader.com)
     * @brief  gdaga 모듈의 admin view class
     **/

    class gdataAdminView extends gdata {

//		const SSL_CAPABILITIES_ERRORS = 'SSL Capabilities Errors';
//		const PHP_EXTENSION_ERRORS = 'PHP Extension Errors';
//		private static $REQUIRED_EXTENSIONS = array('ctype', 'dom', 'libxml', 'spl', 'standard', 'openssl');

        /**
         * @brief 초기화
         **/
        function init() {
			$clientLibraryPath = realpath($this->module_path);
	        $oldPath = set_include_path(get_include_path() . PATH_SEPARATOR . $clientLibraryPath);
    	    require_once 'Zend/Loader.php';
        	Zend_Loader::loadClass('Zend_Gdata');
	        Zend_Loader::loadClass('Zend_Gdata_ClientLogin');
    	    Zend_Loader::loadClass('Zend_Gdata_AuthSub');
        	Zend_Loader::loadClass('Zend_Gdata_Photos');
	        Zend_Loader::loadClass('Zend_Gdata_Photos_UserQuery');
    	    Zend_Loader::loadClass('Zend_Gdata_Photos_AlbumQuery');
        	Zend_Loader::loadClass('Zend_Gdata_Photos_PhotoQuery');
	        Zend_Loader::loadClass('Zend_Gdata_App_Extension_Category');

            $template_path = "./modules/gdata/tpl/";
            $this->setTemplatePath($template_path);
			$args->module = 'gdata';
			$oModuleModel = &getModel('module');
            $midlist=$oModuleModel->getMidList($args);
            if(count($midlist)) {
                foreach($midlist as $key=>$val) {
                    $module_info = $oModuleModel->getModuleInfoByModuleSrl($val->module_srl);
                }
            }
			$this->module_info=$module_info;
			$this->config = $oModuleModel->getModuleConfig('gdata');
        }

        function dispGdataAdminConfig() {
			$oModuleModel = &getModel('module');

            Context::set('module_info',$this->module_info);
            Context::set('config',$this->config);

//			if(!$this->testSSLCapabilities() || $this->validatePHPExtensions()) $this->setTemplateFile('nouse');
			if(!$this->testSSLCapabilities() || !$this->validatePHPExtensions()) return new Object(-1,'nouse');
			$this->setTemplateFile('index');
        }

		function dispGdataAdminModule() {
			$oModuleModel = &getModel('module');
			Context::set('config',$this->config);
			Context::set('module_info',$this->module_info);

			$module_category = $oModuleModel->getModuleCategories();
            Context::set('module_category', $module_category);
	
            // 스킨 목록을 구해옴
            $skin_list = $oModuleModel->getSkins($this->module_path);
            Context::set('skin_list',$skin_list);

            // 레이아웃 목록을 구해옴
            $oLayoutMode = &getModel('layout');
            $layout_list = $oLayoutMode->getLayoutList();
            Context::set('layout_list', $layout_list);

            // 템플릿 파일 지정
            $this->setTemplateFile('module_insert');

		}

        function dispGdataAdminGrantInfo() {
			$oModuleModel = &getModel('module');
            Context::set('config',$this->config);
			Context::set('module_info',$this->module_info);

            // 공통 모듈 권한 설정 페이지 호출
            $oModuleAdminModel = &getAdminModel('module');
            $grant_content = $oModuleAdminModel->getModuleGrantHTML($this->module_info->module_srl, $this->xml_info->grant);
            Context::set('grant_content', $grant_content);

            $this->setTemplateFile('grant_list');
        }

		 function dispGdataAdminDeleteModule() {
            if(!Context::get('module_srl')) return $this->dispGdataAdminModule();
            if(!in_array($this->module_info->module, array('admin', 'gdata'))) {
                return $this->alertMessage('msg_invalid_request');
            }

			Context::set('config',$this->config);

            $module_info = $this->module_info;
            Context::set('module_info',$module_info);

            // 템플릿 파일 지정
            $this->setTemplateFile('module_delete');
        }

		 /**
         * @brief 스킨 정보 보여줌
         **/
        function dispGdataAdminSkinInfo() {
			$oModuleModel = &getModel('module');
            Context::set('config',$this->config);
            Context::set('module_info',$this->module_info);

            // 공통 모듈 권한 설정 페이지 호출
            $oModuleAdminModel = &getAdminModel('module');
            $skin_content = $oModuleAdminModel->getModuleSkinHTML($this->module_info->module_srl);
            Context::set('skin_content', $skin_content);

            $this->setTemplateFile('skin_info');
        }

		 /**
     * Validate that SSL Capabilities are available.
     *
     * @return boolean False if there were errors.
     */
    private function testSSLCapabilities() {
        $sslCapabilitiesErrors = array();
        require_once 'Zend/Loader.php';
        Zend_Loader::loadClass('Zend_Http_Client');

        $httpClient = new Zend_Http_Client('https://www.google.com/accounts/AuthSubRequest');
        try{
		$response = $httpClient->request();
		} catch (Zend_Http_Client_Adapter_Exception $e) {
			return false;
		}
        return true;
	}

	private function validatePHPExtensions() {
		$REQUIRED_EXTENSIONS = array('ctype', 'dom', 'libxml', 'spl', 'standard', 'openssl');
        foreach ($REQUIRED_EXTENSIONS as $requiredExtension) {
            if (!extension_loaded($requiredExtension))  return false;
        }
        return true;
    }

		/**
         * @brief board module용 메시지 출력
         **/
        function alertMessage($message) {
            $script =  sprintf('<script type="text/javascript"> xAddEventListener(window,"load", function() { alert("%s"); } );</script>', Context::getLang($message));
            Context::addHtmlHeader( $script );
        }


    }
?>
