<?php
// Include the composer autoloader
if(!file_exists(__DIR__ . '/vendor/autoload.php'))
{
	echo "The 'vendor' folder is missing. You must run 'composer update --no-dev' to resolve application dependencies.\nPlease see the README for more information.\n";
	exit(1);
}

require __DIR__ . '/vendor/autoload.php';
require __DIR__ . '/common.php';

use PayPal\Rest\ApiContext;
use PayPal\Auth\OAuthTokenCredential;

$apiContext = getApiContext();


/**
 * Helper method for getting an APIContext for all calls
 *
 * @return PayPal\Rest\ApiContext
 */
function getApiContext()
{

	// ### Api context
	// Use an ApiContext object to authenticate 
	// API calls. The clientId and clientSecret for the 
	// OAuthTokenCredential class can be retrieved from 
	// developer.paypal.com

	$oModuleModel = getModel('module');
	$oPaypalModuleConfig = $oModuleModel->getModuleConfig('paypal');
	$apiContext = new ApiContext(new OAuthTokenCredential($oPaypalModuleConfig->client_id, $oPaypalModuleConfig->api_secret));

	$apiContext->setConfig(array('mode' => $oPaypalModuleConfig->endpoint, 'http.ConnectionTimeOut' => 30, 'log.LogEnabled' => true, 'log.FileName' => '../PayPal.log', 'log.LogLevel' => 'FINE'));

	/*
	// Register the sdk_config.ini file in current directory
	// as the configuration source.
	if(!defined("PP_CONFIG_PATH")) {
		define("PP_CONFIG_PATH", __DIR__);
	}
	*/

	return $apiContext;
}
