<?php
	class MultimediaThumb{

		function checkDocumentThumbExsits($document_srl, $content) {
			$oContext = Context::getInstance();
			$oFileModel = getModel('file');

			$attachment_list = $oFileModel->getFiles($document_srl, array(), 'file_srl', true);

			if(count($attachment_list) != '0'){
				$allow_attachment_extension = Array('jpg', 'jpeg', 'gif', 'png', 'bmp');

				foreach($attachment_list as $val){
					if( ! in_array(strtolower(pathinfo($val->uploaded_filename, PATHINFO_EXTENSION)), $allow_attachment_extension)) continue;
					if( ! file_exists($val->uploaded_filename)) continue;
					else
						$return_value = true;
					break;
				}
			} else {
				preg_match_all('/<img[^>]+src=["\']?([^>"\']+)["\'].*?rel=["\']?([^>"\']+)["\'].*?[^>]>/im', $content, $matches);

				foreach($matches as $key => $val){
					if ($val['0'] === null) continue;
					else
						$return_value = true;
				}
			}

			unset($matches);
			return ($return_value === NULL) ? false : $return_value;
		}

		function checkMultimediaThumbExists($content) {
			/*
				검사방법 - 섬네일 애드온으로 생성되었는지 확인 alt="~~~~:~~~~~~~~"포맷 생성되었다면 true 없다면 false
			*/
			preg_match_all('/<img[^>]+src=["\']?([^>"\']+)["\'].*?rel=["\']?([^>"\']+)["\'].*?[^>]>/im', $content, $matches);

			$return_value = '';

			foreach($matches['2'] as $key => $val){
				$return_value .= $val;

				if ($val == null) continue;
				else {
					$return_value = $this->checkMultimediaFormat($val);
					if($return_value === true) break;
				}
			}

			unset($matches);
			return ($return_value === NULL) ? false : $return_value;
		}

		function getMultimediaThumb($content) {
			preg_match_all('/<img[^>]+src=["\']?([^>"\']+)["\'].*?rel=["\']?([^>"\']+)["\'].*?[^>]>/im', $content, $matches);

			$return_value = array();

			foreach($matches['2'] as $key => $val){
				if($val === NULL) continue;
				else {
					array_push($return_value, $val); // format
					array_push($return_value, $matches['1'][$key]); // url
					break;
				}
			}

			if($return_value['0'] == NULL) $return_value = false;

			return $return_value;
		}

		function checkMultimediaFormat($format) {
			list($service_name, $service_id) = explode(':', $format);

			switch($service_name){
				case 'youtube':
					preg_match('/[(A-Za-z0-9-_)].*/i', $format, $result);
				break;

				case 'vimeo':
					preg_match('/[(0-9)].*/i', $format, $result);
				break;

				case 'soundcloud':
					preg_match('/[(0-9)].*/i', $format, $result);
				break;

				default:
				break;
			}

			if($result['0'] == $format){
				$return_value = true;
			} else {
				$return_value = false;
			}

			unset($result);
			return $return_value;
		}

		function getMultimediaList($content) {
			preg_match_all('/<(?=embed|iframe)[^>]+src=["\']?([^>"\']+)["\'].*?[^>]>/i', $content, $matches);
			$Multimedia_list = array();

			return $matches['1'];
		}

		function getMultimediaFormat($url) {
			//youtube
			preg_match('/youtube(?:|-nocookie).com\/(?:(?:v|embed)\/)?([a-zA-Z0-9-_]+)/i', $url, $youtube);
			//vimeo
			preg_match('/player.vimeo.com\/video\/?([0-9]+)/i', $url, $vimeo);
			//soundcloud
			preg_match('/api.soundcloud.com\/tracks\/?([0-9]+)/i', $url, $soundcloud);

			if($youtube['0'] !== NULL)    $return_value = 'youtube:'    . $youtube['1'];
			if($vimeo['0'] !== NULL)      $return_value = 'vimeo:'      . $vimeo['1'];
			if($soundcloud['0'] !== NULL) $return_value = 'soundcloud:' . $soundcloud['1'];

			unset($youtube);
			unset($vimeo);
			unset($soundcloud);

			return ($return_value === NULL) ? false : $return_value;
		}

		function makeMultimediaThumb($format) {
			list($service_name, $service_id) = explode(':', $format);
			switch($service_name){
				case 'youtube':
					$thumbnail_url = 'http://i1.ytimg.com/vi/' . $service_id . '/maxresdefault.jpg';
				break;

				case 'vimeo':
					$json = json_decode(FileHandler::getRemoteResource('http://vimeo.com/api/v2/video/' . $service_id . '.json', null, null, 'GET', 'application/json'));
					$thumbnail_url = $json['0']->thumbnail_large;
				break;

				case 'soundcloud':
					$json = json_decode(FileHandler::getRemoteResource('http://api.soundcloud.com/tracks/' . $service_id . '.json?client_id=2f426cafc5cec317628b1db5224fc7a1', null, null, 'GET', 'application/json'));
					$thumbnail_url = str_replace('large', 't500x500', $json->artwork_url);
					$thumbnail_url = substr($thumbnail_url, 0, strpos($thumbnail_url, '?'));
				break;

				default:
					$thumbnail_url = false;
				break;
			}
			$json = '';
			unset($json);

			return ($thumbnail_url !== false) ? '<img src="' . $thumbnail_url . '" style="width:0;height:0;overflow:hidden;display:none;" rel="' . $format . '" />' . "\n" : false;
		}

		function removeMultimediaThumb($content) {
			$content = preg_replace('/<img[^>]+src=["\']?([^>"\']+)["\'].*?rel=["\']?([^>"\']+)["\'].*?[^>]>/im', '', $content);

			return $content;
		}
	}